/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui2.mainframe.device;

import com.huawei.ism.common.Framework;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.swing.URLLinkLabel;
import com.huawei.ism.ui.swing.plaf.IsmFontFactory;
import com.huawei.ism.ui.swing.text.IsmTextArea;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ColorUIResource;

public class AboutPane
extends JPanel {
    private static final long serialVersionUID = 4831404823607953382L;
    private ImageTopPanel topPanel = null;
    private ImageCenterPanel centerPanel = null;
    private ImageBottomPanel bottomPanel = null;

    public AboutPane() {
        this.doLayOutUI();
    }

    private void doLayOutUI() {
        this.createComponents();
        this.layoutComponents();
    }

    private void createComponents() {
        this.topPanel = new ImageTopPanel();
        this.topPanel.setPreferredSize(new Dimension(457, 97));
        this.centerPanel = new ImageCenterPanel();
        this.centerPanel.setPreferredSize(new Dimension(457, 180));
        this.bottomPanel = new ImageBottomPanel();
        this.bottomPanel.setPreferredSize(new Dimension(457, 39));
    }

    private void layoutComponents() {
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.topPanel, "North");
        this.add((Component)this.centerPanel, "Center");
        this.add((Component)this.bottomPanel, "South");
    }

    private static class ImageBottomPanel
    extends JPanel {
        private static final long serialVersionUID = -3697214954213546105L;
        private final ImageIcon leftBg = ResourceManager.getImage("aboutBottomLeftBg.png");
        private final ImageIcon rightBg = ResourceManager.getImage("aboutBottomRightBg.png");
        private final ImageIcon centerBg = ResourceManager.getImage("aboutBottomCenterBg.png");

        public ImageBottomPanel() {
            this.setLayout(new BorderLayout());
            this.add((Component)new JLabel(ResourceManager.getString("COMPANY.COPYRIGHT"), 0), "Center");
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            graphics.drawImage(this.leftBg.getImage(), 0, 0, this.leftBg.getIconWidth(), this.leftBg.getIconHeight(), this);
            graphics.drawImage(this.centerBg.getImage(), this.leftBg.getIconWidth(), 0, 441, this.centerBg.getIconHeight(), this);
            graphics.drawImage(this.rightBg.getImage(), this.leftBg.getIconWidth() + 441, 0, this.rightBg.getIconWidth(), this.rightBg.getIconHeight(), this);
        }
    }

    private static class ImageCenterPanel
    extends JPanel {
        private static final long serialVersionUID = -4681559079429145110L;

        public ImageCenterPanel() {
            JLabel inteSmLabel = new JLabel("Integrated Storage Manager");
            inteSmLabel.setFont(IsmFontFactory.getDialogPlain());
            JLabel versionLabel = new JLabel(Framework.getInstance().getIsmVersion());
            JLabel websetLabel = new JLabel(ResourceManager.getStringWithColon("WEBSITE") + " ");
            String website = ResourceManager.getOEMString("COMPANY_HTTP_WEBSITE");
            URLLinkLabel websiteL = new URLLinkLabel(website, website);
            IsmTextArea warningArea = UCD.createTextArea(ResourceManager.getString("ABOUTDIALOG_VERSION_WARNING"));
            Box inteSmBox = UCD.buildHBoxLeft(inteSmLabel);
            Box versionBox = UCD.buildHBoxLeft(versionLabel);
            Box websetBox = UCD.buildHBoxLeft(0, websetLabel, websiteL);
            Box warningBox = UCD.buildHBoxLeft(warningArea);
            Box vBox = UCD.buildVBoxTop(5, inteSmBox, versionBox, websetBox, warningBox);
            vBox.setBorder(new EmptyBorder(0, 12, 0, 12));
            UCD.setJComponentSize(vBox, new Dimension(428, 165));
            this.add(vBox);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            graphics.setColor(new ColorUIResource(0x888888));
            graphics.fillRect(0, 0, 1, this.getHeight());
            graphics.fillRect(this.getWidth() - 1, 0, 1, this.getHeight());
            graphics.setColor(Color.WHITE);
            graphics.fillRect(1, 0, this.getWidth() - 2, this.getHeight());
        }
    }

    private static class ImageTopPanel
    extends JPanel {
        private static final long serialVersionUID = -121550576801418149L;
        private final ImageIcon leftBg = ResourceManager.getImage("aboutLeftBg.png");
        private final ImageIcon rightBg = ResourceManager.getImage("aboutRightBg.png");
        private final ImageIcon centerBg = ResourceManager.getImage("aboutCenterBg.png");
        private final ImageIcon loginLogo = ResourceManager.getImage("logo_about.png");

        public ImageTopPanel() {
            this.setLayout(new BorderLayout());
            this.add((Component)new JLabel(this.loginLogo), "Center");
        }

        @Override
        protected void paintComponent(Graphics grap) {
            grap.drawImage(this.leftBg.getImage(), 0, 0, this.leftBg.getIconWidth(), this.leftBg.getIconHeight(), this);
            grap.drawImage(this.centerBg.getImage(), this.leftBg.getIconWidth(), 0, 395, this.centerBg.getIconHeight(), this);
            grap.drawImage(this.rightBg.getImage(), this.leftBg.getIconWidth() + 395, 0, this.rightBg.getIconWidth(), this.rightBg.getIconHeight(), this);
        }
    }
}

