/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui2.mainframe.device;

import com.huawei.ism.common.Framework;
import com.huawei.ism.common.bean.DeviceType;
import com.huawei.ism.common.bean.User;
import com.huawei.ism.common.resourcemanager.CustomResourceManager;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.swing.dialog.MyLayoutFocusTraversalPolicy;
import com.huawei.ism.ui.swing.plaf.IsmFontFactory;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.ui.swing.text.IsmPasswordField;
import com.huawei.ism.ui.swing.text.IsmTextField;
import com.huawei.ism.ui2.mainframe.device.PopupAdapter;
import com.huawei.ism.util.CommonUtil;
import com.huawei.ism.util.Pair;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import com.huawei.ism.util.Utils;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;

public class NewLoginPane
extends JPanel
implements ActionListener {
    private static Locale locale;
    private static final String HISTORY_USERNAME_LIST = "HISTORY_USERNAME_LIST";
    private static final ImageIcon CENTER_BGICON;
    private static final long serialVersionUID = 2235516159050596090L;
    private JButton confirmButton;
    private JButton helpButton;
    private JButton advancedButton;
    private JComboBox languageComboBox;
    private JComboBox authenticationComboBox;
    private Map<Integer, Locale> languageMap = new HashMap<Integer, Locale>(0);
    private JLabel lanuageLabel = new JLabel();
    private JLabel authenticationLabel = new JLabel();
    private JLabel userNameLabel = new JLabel();
    private JLabel passwordLabel = new JLabel();
    private IsmTextField usernameTextField = null;
    private IsmPasswordField passwordTextField = null;
    private transient List<Pair<Component, Component>> pairs;
    private transient Pair<Component, Component> authPair;
    private transient Pair<Component, Component> lanuagePair;
    private transient Pair<Component, Component> buttonPair;
    private transient Pair<Component, Component> struts1Pair;
    private transient Pair<Component, Component> struts2Pair;
    private JPanel userPane;
    private JPanel operationPane;
    private JPanel contentPane;
    private boolean isShowAdvance = false;
    private float alpha = 0.1f;
    private JApplet jApplet;
    private Timer timer = new Timer(80, this);
    private transient PopupAdapter popupAdapter = null;

    public NewLoginPane(JApplet jApplet) {
        this.jApplet = jApplet;
        this.setOpaque(true);
        this.setBackground(new ColorUIResource(0xE9E8E8));
        this.setPreferredSize(new Dimension(800, 600));
        this.initComponents();
        this.doLayoutUI();
        this.addHandler();
        SwingUtil.setName(this);
        this.timer.start();
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new MyLayoutFocusTraversalPolicy());
    }

    private void initComponents() {
        this.authenticationComboBox = new JComboBox();
        this.languageComboBox = new JComboBox();
        this.confirmButton = UCD.createButton(ResourceManager.getString("SYSTEM_LOGIN_DESCRIPTION"));
        this.helpButton = new JButton();
        this.advancedButton = new JButton(ResourceManager.getString("ADVANCED"), ResourceManager.getImage("advanced_openout.png"));
        this.advancedButton.setHorizontalTextPosition(2);
        this.usernameTextField = IsmTextField.getNameTextField("[^?\"]*", "", 64, 0);
        this.popupAdapter = new PopupAdapter(this.usernameTextField, HISTORY_USERNAME_LIST);
        this.passwordTextField = new IsmPasswordField(0, 6, 32);
        this.passwordTextField.getPasswordPopupInfo().removeAllInform();
        this.passwordTextField.getPasswordPopupInfo().addCapsLockInform();
        Dimension dimension = new Dimension(90, 25);
        UCD.setJComponentSize(this.confirmButton, dimension);
        UCD.setJComponentSize(this.advancedButton, dimension);
        this.advancedButton.setMargin(new Insets(0, 2, 0, 2));
        dimension = new Dimension(200, 23);
        UCD.setJComponentSize(this.usernameTextField, dimension);
        UCD.setJComponentSize(this.languageComboBox, dimension);
        UCD.setJComponentSize(this.authenticationComboBox, dimension);
        UCD.setJComponentSize(this.passwordTextField, dimension);
        if (DeviceType.N8000.equals((Object)DeviceType.valueOf(Framework.getInstance().getStrProperty("-devicetype")))) {
            this.languageComboBox.setEnabled(false);
        }
    }

    private void doLayoutUI() {
        this.removeAll();
        JPanel loginContentPane = this.getContentPane();
        JPanel mainPane = UCD.createTransparentPane(new BorderLayout());
        ImageTopPanel imageTopPanel = new ImageTopPanel();
        imageTopPanel.setOpaque(true);
        imageTopPanel.setPreferredSize(new Dimension(514, 103));
        JLabel bottomLabel = new JLabel(ResourceManager.getString("COMPANY.COPYRIGHT"), 0);
        if (Locale.getDefault().getLanguage().equalsIgnoreCase("zh")) {
            bottomLabel.setFont(new FontUIResource("Dialog", 0, 12));
        } else {
            bottomLabel.setFont(new FontUIResource("Dialog", 0, 10));
        }
        bottomLabel.setPreferredSize(new Dimension(bottomLabel.getPreferredSize().width, 18));
        bottomLabel.setForeground(Color.GRAY);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setOpaque(false);
        bottomPanel.setLayout(new BorderLayout());
        bottomPanel.add(Box.createVerticalStrut(0), "North");
        bottomPanel.add((Component)bottomLabel, "North");
        Box topBox = UCD.buildVBoxTop(Box.createVerticalStrut(30), imageTopPanel);
        loginContentPane.setPreferredSize(new Dimension(300, 210));
        mainPane.add((Component)topBox, "North");
        mainPane.add((Component)UCD.buildVBoxTop(0, loginContentPane, bottomPanel, Box.createVerticalStrut(120)), "Center");
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 0;
        this.add((Component)mainPane, gridBagConstraints);
    }

    private void addHandler() {
        this.languageComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewLoginPane.this.languageChanged(actionEvent);
                NewLoginPane.this.passwordTextField.setMinValidRestrict(NewLoginPane.this.passwordTextField.getMinValidRestrict());
                NewLoginPane.this.passwordTextField.setMaxValidRestrict(NewLoginPane.this.passwordTextField.getMaxValidRestrict());
                NewLoginPane.this.passwordTextField.getPasswordPopupInfo().hideInform();
            }
        });
        this.authenticationComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewLoginPane.this.usernameTextField.setError(false);
                NewLoginPane.this.passwordTextField.setError(false);
                NewLoginPane.this.usernameTextField.requestFocus();
                NewLoginPane.this.passwordTextField.getPasswordPopupInfo().hideInform();
                if (NewLoginPane.this.authenticationComboBox.getSelectedIndex() == 0) {
                    NewLoginPane.this.passwordTextField.setMinValidRestrict(6);
                    NewLoginPane.this.passwordTextField.setMaxValidRestrict(32);
                } else {
                    NewLoginPane.this.passwordTextField.setMinValidRestrict(0);
                    NewLoginPane.this.passwordTextField.setMaxValidRestrict(256);
                }
            }
        });
        this.advancedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewLoginPane.this.showHidePane();
            }
        });
    }

    private void showHidePane() {
        this.operationPane.remove(this.userPane);
        if (!this.isShowAdvance) {
            this.pairs.remove(this.buttonPair);
            this.pairs.remove(this.struts1Pair);
            this.pairs.remove(this.struts2Pair);
            this.pairs.add(this.authPair);
            this.pairs.add(this.lanuagePair);
            this.pairs.add(this.buttonPair);
        } else {
            this.pairs.remove(this.authPair);
            this.pairs.remove(this.lanuagePair);
            this.pairs.remove(this.buttonPair);
            this.pairs.add(this.buttonPair);
            this.pairs.add(this.struts1Pair);
            this.pairs.add(this.struts2Pair);
        }
        this.userPane = UCD.createKVPane(8, this.pairs);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        this.operationPane.add((Component)this.userPane, gridBagConstraints);
        this.operationPane.revalidate();
        this.operationPane.repaint();
        boolean bl = this.isShowAdvance = !this.isShowAdvance;
        if (this.isShowAdvance) {
            this.advancedButton.setIcon(ResourceManager.getImage("advanced_openin.png"));
        } else {
            this.advancedButton.setIcon(ResourceManager.getImage("advanced_openout.png"));
        }
        this.jApplet.getRootPane().setDefaultButton(this.confirmButton);
    }

    private void createUserPane(boolean isShowUserAdvance) {
        JComponent btnBox = UCD.buildHorizotalBox(null, 6, Box.createHorizontalStrut(1), this.confirmButton, this.advancedButton);
        this.pairs = new ArrayList<Pair<Component, Component>>(0);
        this.pairs.add(new Pair<Box, Box>(UCD.buildHBoxRight(this.userNameLabel), UCD.buildHBoxLeft(this.usernameTextField)));
        this.pairs.add(new Pair<Box, Box>(UCD.buildHBoxRight(this.passwordLabel), UCD.buildHBoxLeft(this.passwordTextField)));
        this.authPair = new Pair<Box, Box>(UCD.buildHBoxRight(this.authenticationLabel), UCD.buildHBoxLeft(this.authenticationComboBox));
        this.lanuagePair = new Pair<Box, Box>(UCD.buildHBoxRight(this.lanuageLabel), UCD.buildHBoxLeft(this.languageComboBox));
        this.buttonPair = new Pair<Component, JComponent>(Box.createHorizontalStrut(10), btnBox);
        this.struts1Pair = new Pair<Component, Component>(Box.createHorizontalStrut(22), Box.createVerticalStrut(22));
        this.struts2Pair = new Pair<Component, Component>(Box.createVerticalStrut(25), Box.createVerticalStrut(25));
        if (isShowUserAdvance) {
            this.pairs.add(this.authPair);
            this.pairs.add(this.lanuagePair);
            this.pairs.add(this.buttonPair);
        } else {
            this.pairs.add(this.buttonPair);
            this.pairs.add(this.struts1Pair);
            this.pairs.add(this.struts2Pair);
        }
        this.userPane = UCD.createKVPane(8, this.pairs);
    }

    private JPanel getContentPane() {
        this.userNameLabel.setFont(IsmFontFactory.getBold12Font());
        this.passwordLabel.setFont(IsmFontFactory.getBold12Font());
        this.lanuageLabel.setFont(IsmFontFactory.getBold12Font());
        this.authenticationLabel.setFont(IsmFontFactory.getBold12Font());
        this.update();
        this.lanuageLabel.setText(ResourceManager.getString("LOGIN_DIALOG_LANGUAGE"));
        this.authenticationLabel.setText(ResourceManager.getString("LOGIN_DIALOG_AUTENTICATION"));
        this.userNameLabel.setText("      " + ResourceManager.getString("LOGIN_DIALOG_USER_NAME"));
        this.passwordLabel.setText(ResourceManager.getString("LOGIN_DIALOG_PASSWORD"));
        this.createUserPane(this.isShowAdvance);
        this.operationPane = UCD.createTransparentPane(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        this.operationPane.add((Component)this.userPane, gridBagConstraints);
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new BorderLayout());
        if (this.alpha >= 1.0f) {
            this.contentPane.add((Component)this.operationPane, "Center");
        }
        this.contentPane.setOpaque(false);
        this.contentPane.setBorder(UCD.createEmptyBorder(20));
        return this.contentPane;
    }

    public void update() {
        this.languageComboBox.removeAllItems();
        List<Locale> languages = CustomResourceManager.getInstance().getLanguages();
        Locale localeLanguage = null;
        String language = null;
        for (int i = 0; i < languages.size(); ++i) {
            localeLanguage = languages.get(i);
            language = localeLanguage.getDisplayLanguage(languages.get(i));
            this.languageComboBox.addItem(language);
            this.languageMap.put(i, languages.get(i));
            if (!localeLanguage.equals(ResourceManager.getLocale())) continue;
            this.languageComboBox.setSelectedItem(language);
            Locale.setDefault(localeLanguage);
            JComponent.setDefaultLocale(localeLanguage);
        }
        this.authenticationComboBox.removeAllItems();
        this.authenticationComboBox.addItem(ResourceManager.getString("login.local.array"));
        this.authenticationComboBox.addItem(ResourceManager.getString("ldap.domain"));
        this.userNameLabel.setText("      " + ResourceManager.getString("LOGIN_DIALOG_USER_NAME"));
        this.passwordLabel.setText(ResourceManager.getString("LOGIN_DIALOG_PASSWORD"));
        this.lanuageLabel.setText(ResourceManager.getString("LOGIN_DIALOG_LANGUAGE"));
        this.authenticationLabel.setText(ResourceManager.getString("LOGIN_DIALOG_AUTENTICATION"));
        this.updateButton();
    }

    public User.USER_SCOPE getUserScope() {
        int selected = this.authenticationComboBox.getSelectedIndex();
        if (selected == 0) {
            return User.USER_SCOPE.LOCAL;
        }
        return User.USER_SCOPE.LDAP;
    }

    private void updateButton() {
        this.confirmButton.setText(ResourceManager.getString("SYSTEM_LOGIN_DESCRIPTION"));
        this.advancedButton.setText(ResourceManager.getString("ADVANCED"));
        this.helpButton.setText(ResourceManager.getString("COMMON.TXT.HELP"));
    }

    private void languageChanged(ActionEvent actionEvent) {
        JComboBox comboBox = (JComboBox)actionEvent.getSource();
        int selected = comboBox.getSelectedIndex();
        locale = this.languageMap.get(selected);
        Locale.setDefault(locale);
        JComponent.setDefaultLocale(locale);
        ResourceManager.setLocale(locale);
        IsmPlafUtils.setLocale(locale);
        this.doLayoutUI();
        this.revalidate();
        this.repaint();
        this.getRootPane().setDefaultButton(this.confirmButton);
        this.usernameTextField.requestFocus();
    }

    public String getUserName() {
        return this.usernameTextField.getText();
    }

    public String getPassword() {
        return Utils.getStringValueOfPassordFiled(this.passwordTextField);
    }

    public void resetPane() {
        this.usernameTextField.setText("");
        this.passwordTextField.setText("");
        this.popupAdapter.resetMenuItem(HISTORY_USERNAME_LIST);
    }

    public boolean validateInput() {
        String userName = this.getUserName();
        String password = this.getPassword();
        boolean isSuccess = true;
        int selected = this.authenticationComboBox.getSelectedIndex();
        if (selected == 0 && !this.passwordTextField.checkLength()) {
            isSuccess = false;
        }
        if (password.isEmpty()) {
            this.passwordTextField.setErrorToolTip(ResourceManager.getString("PASSWORD_NULL"));
            this.passwordTextField.requestFocus();
            isSuccess = false;
        }
        if (selected == 0 && (userName.length() < 4 || userName.length() > 32)) {
            this.usernameTextField.setErrorToolTip(ResourceManager.getString("new.out.of.range"));
            this.usernameTextField.requestFocus();
            isSuccess = false;
        }
        if (userName.isEmpty()) {
            this.usernameTextField.setErrorToolTip(ResourceManager.getString("NAME_NULL_PLEASE_INPUT"));
            this.usernameTextField.requestFocus();
            isSuccess = false;
        }
        return isSuccess;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.alpha = (float)((double)this.alpha + 0.1);
        if (this.alpha >= 1.0f) {
            this.alpha = 1.0f;
            this.contentPane.add((Component)this.operationPane, "Center");
            this.usernameTextField.requestFocus();
            this.revalidate();
            this.repaint();
            this.timer.stop();
        }
        this.repaint();
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D g2d = CommonUtil.convertObject(graphics, Graphics2D.class);
        g2d.setComposite(AlphaComposite.getInstance(3, this.alpha));
        super.paint(g2d);
    }

    public JButton getLoginButton() {
        return this.confirmButton;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        int width = this.getWidth();
        int height = this.getHeight();
        int centerH = (height - CENTER_BGICON.getIconHeight()) / 2 + 1;
        graphics.setColor(new ColorUIResource(0xF0F0F1));
        graphics.fillRect(0, 0, width, centerH);
        graphics.drawImage(CENTER_BGICON.getImage(), 0, centerH - 60, width, CENTER_BGICON.getIconHeight(), this);
        graphics.setColor(new ColorUIResource(0xFCFCFC));
        graphics.fillRect(0, centerH + CENTER_BGICON.getIconHeight() - 60, width, centerH + 60);
    }

    void add2History(String value) {
        String history = CustomResourceManager.getInstance().getString(HISTORY_USERNAME_LIST);
        if (history == null) {
            CustomResourceManager.getInstance().setString(HISTORY_USERNAME_LIST, value);
            return;
        }
        String[] list = history.split(",");
        StringBuilder sb = new StringBuilder(value);
        HashSet<String> tmpSet = new HashSet<String>(0);
        tmpSet.add(value);
        for (int i = 0; i < 9 && i < list.length; ++i) {
            if (tmpSet.contains(list[i])) continue;
            sb.append("," + list[i]);
            tmpSet.add(list[i]);
        }
        CustomResourceManager.getInstance().setString(HISTORY_USERNAME_LIST, sb.toString());
    }

    static {
        CENTER_BGICON = ResourceManager.getImage("newloginpane.center.png");
    }

    private static class ImageTopPanel
    extends JPanel {
        private static final long serialVersionUID = -6570966568305261107L;
        private final ImageIcon leftBg = ResourceManager.getImage("leftBg.png");
        private final ImageIcon rightBg = ResourceManager.getImage("rightBg.png");
        private final ImageIcon centerBg = ResourceManager.getImage("centerBg.png");
        private final ImageIcon loginLogo = ResourceManager.getImage("login.log.png");

        public ImageTopPanel() {
            this.setLayout(new BorderLayout());
            this.add((Component)new JLabel(this.loginLogo), "Center");
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            graphics.drawImage(this.leftBg.getImage(), 0, 0, this.leftBg.getIconWidth(), this.leftBg.getIconHeight(), this);
            graphics.drawImage(this.centerBg.getImage(), this.leftBg.getIconWidth(), 0, 248, this.centerBg.getIconHeight(), this);
            graphics.drawImage(this.rightBg.getImage(), this.leftBg.getIconWidth() + 248, 0, this.rightBg.getIconWidth(), this.rightBg.getIconHeight(), this);
        }
    }
}

