/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui2.perfstat;

import com.huawei.ism.common.bean.impl.IDataTypeEnum;
import com.huawei.ism.common.bean.impl.IObjectTypeEnum;
import com.huawei.ism.common.bean.impl.IPerfStatObject;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.module.perfhis.TimeSeriesChart;
import com.huawei.ism.ui.swing.LayoutConstants;
import com.huawei.ism.ui.swing.plaf.IsmFontFactory;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.ui2.perfstat.PerfStatNormalPanel;
import com.huawei.ism.ui2.perfstat.util.PerfStatUtil;
import com.huawei.ism.ui2.perfstat.util.TickableTree;
import com.huawei.ism.ui2.perfstat.util.TickableTreeNode;
import com.huawei.ism.util.CommonUtil;
import com.huawei.ism.util.Pair;
import com.huawei.ism.util.UCD;
import com.huawei.ism.util.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jfree.chart.event.ChartProgressEvent;
import org.jfree.chart.event.ChartProgressListener;
import org.jfree.data.Range;
import org.jfree.data.time.TimeSeries;

public class PerfStatRealTimeLayout
extends JPanel {
    private static final long serialVersionUID = -3861238856080647457L;
    private static final double AXIS_Y_UPPER_VALUE = 100.000001;
    private static final double AXIS_Y_LOWER_VALUE = -1.0E-6;
    private static final float NORMAL_DATATYPEAREA_HEGHT_RATIO = 0.3f;
    private static final int WIDTH_WESTBOX = 333;
    private static final int HEIGHT_NORTHBOX = 55;
    private static final int HEIGHT_NORMAL_DATATYPETREE = 30;
    private static final int HEIGHT_NORMAL_OBJECTTOPAREA = 60;
    private static final int GAP = 12;
    private static final int NORMAL_OBJECTTREE_HEIGHT = 458;
    private static final int[] ADVANCE_DATATYPES = new int[]{80, 81, 82, 83, 85, 87, 88, 89, 90, 91, 92, 94, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109};
    private static final int[] IO_GRANULARITYDISTRIBUTION_DATATYPES = new int[]{30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181};
    private static final int[] IO_TIME_DATATYPES = new int[]{199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216};
    private static final ImageIcon OPENICON = ResourceManager.getImage("expand.png");
    private static final ImageIcon HIDEICON = ResourceManager.getImage("unexpand.png");
    private static final ImageIcon NORMAL_UNSELECTICON = ResourceManager.getImage("perfstat_normal_unselect.png");
    private static final ImageIcon NORMAL_SELECTICON = ResourceManager.getImage("perfstat_normal_select.png");
    private static final ImageIcon ADVANCE_UNSELECTICON = ResourceManager.getImage("perfstat_advance_unselect.png");
    private static final ImageIcon ADVANCE_SELECTICON = ResourceManager.getImage("perfstat_advance_select.png");
    private JEditorPane jEditorPane;
    private JComboBox deviceComboBox;
    private TimeSeriesChart advanceTimeSeriesChart;
    private JLabel periodValueLabel;
    private DefaultTableModel tableMode;
    private IsmTable scaleTable;
    private JLabel deviceNameLabel;
    private JLabel deviceNameValueLabel;
    private JPanel viewPanelContainer;
    private JLabel periodNameLabel;
    private JLabel maxObjectsDescLabel;
    private TableScrollPane scrollPane;
    private transient Map<IObjectTypeEnum, int[]> objectToAdvancedDataTypesMap;
    private boolean isNormal = true;
    private boolean dataTypeIsHide = true;
    private JButton normalBtn;
    private JButton advanceBtn;
    private JButton showDataTypeBtn;
    private JComponent normalObjectTypeArea;
    private JComponent normalDataTypeArea;
    private Box advanceWestBox;
    private Box normalWestBox;
    private Box advancePanel;
    private Box normalPanel;
    private PerfStatNormalPanel normalPerfStatPanel;
    private JLabel advanceObjectTypeLabel;
    private JComboBox advanceObjectTypeComboBox;
    private TickableTree advanceObjectsTree;
    private JScrollPane advanceObjectsScrollPane;
    private JLabel normalObjectTypeLabel;
    private JComboBox normalObjectTypeComboBox;
    private TickableTree normalObjectsTree;
    private JScrollPane normalObjectsScrollPane;
    private String normalDesc;
    private String advanceDesc;
    private JLabel advanceDataTypeLabel;
    private JComboBox advanceDataTypeComboBox;
    private TickableTree advanceDataTypeTree;
    private JScrollPane advanceDataTypeScrollPane;
    private TickableTree normalDataTypeTree;
    private JScrollPane normalDataTypeScrollPane;
    private transient IObjectTypeEnum advanceSelectedObjectType;
    private transient IObjectTypeEnum normalSelectedObjectType;
    private Box normalCenterBox;
    private Box advanceCenterBox;
    private JPanel descBox;
    private Frame frame;
    private String fromPane;

    public PerfStatRealTimeLayout(Frame frame, String fromPaneValue) {
        this.frame = frame;
        this.fromPane = fromPaneValue;
        this.doLayoutUI();
        this.solveCannotDisplayTooltips();
    }

    private void doLayoutUI() {
        this.createComponents();
        this.layoutComponents();
        this.initListener();
    }

    private void createComponents() {
        this.buildDescBox();
        this.buildNormalWestPanel();
        this.buildAdvanceWestPanel();
        this.deviceNameLabel = new JLabel(Utils.transferStringToLower(ResourceManager.getString("DEVICE_NAME")));
        this.deviceNameLabel.setFont(IsmFontFactory.getBold12Font());
        this.deviceComboBox = new JComboBox();
        UCD.setJComponentWidth(this.deviceComboBox, 200);
        this.deviceNameValueLabel = new JLabel();
        this.periodNameLabel = new JLabel(Utils.transferStringToLower(ResourceManager.getStringWithColon("SAMPLE_INTERVAL")));
        this.periodNameLabel.setFont(IsmFontFactory.getBold12Font());
        this.periodValueLabel = new JLabel();
        this.advanceTimeSeriesChart = new TimeSeriesChart(false, true, false, false, true, false, true, true);
        this.viewPanelContainer = new JPanel(new BorderLayout());
        this.viewPanelContainer.add((Component)this.advanceTimeSeriesChart, "Center");
        this.maxObjectsDescLabel = new JLabel(ResourceManager.getString("perfstat.realtime.maxObject.desc"));
        this.tableMode = new DefaultTableModel(PerfStatUtil.getScaleTableColNames(), new int[0]);
        this.scaleTable = new IsmTable((TableModel)this.tableMode, true);
        this.scrollPane = TableScrollPane.createTablePane(this.scaleTable, false, TableScrollPane.CountArea.TABLE_LEFT_DOWN, TableScrollPane.FilterArea.TABLE_RIGHT_UP, TableScrollPane.ButtonArea.NONE);
        this.scrollPane.setPreferredSize(new Dimension(400, 380));
        this.normalBtn = new JButton(NORMAL_SELECTICON);
        this.normalBtn.setName("JButton_1");
        this.normalBtn.setPreferredSize(new Dimension(this.normalBtn.getIcon().getIconWidth(), this.normalBtn.getIcon().getIconHeight()));
        this.normalBtn.setToolTipText(ResourceManager.getString("PERFSTAT_NORMALPANEL_TITLE_TOOLTIPS_DESC"));
        this.normalBtn.setBorderPainted(false);
        this.advanceBtn = new JButton(ADVANCE_UNSELECTICON);
        this.advanceBtn.setName("JButton_2");
        this.advanceBtn.setPreferredSize(new Dimension(this.advanceBtn.getIcon().getIconWidth(), this.advanceBtn.getIcon().getIconHeight()));
        this.advanceBtn.setToolTipText(ResourceManager.getString("PERFSTAT_ADVANCEPANEL_TITLE_TOOLTIPS_DESC"));
        this.advanceBtn.setBorderPainted(false);
    }

    private void layoutComponents() {
        JPanel devicePane = UCD.createTransparentPane(new BorderLayout());
        Box btnBox = Box.createHorizontalBox();
        btnBox.add(Box.createHorizontalStrut(4));
        btnBox.add(this.normalBtn);
        btnBox.add(Box.createHorizontalStrut(2));
        btnBox.add(this.advanceBtn);
        JPanel deviceNameValuePane = UCD.createTransparentPane(new BorderLayout());
        deviceNameValuePane.add(UCD.buildHBoxLeft(0, this.deviceNameValueLabel, this.deviceComboBox));
        devicePane.add((Component)UCD.buildHBoxLeft(Box.createHorizontalStrut(2), this.deviceNameLabel, deviceNameValuePane, this.deviceComboBox, btnBox), "West");
        devicePane.add((Component)UCD.buildHBoxRight(this.periodNameLabel, this.periodValueLabel, Box.createHorizontalStrut(30)), "East");
        Box northBox = UCD.buildVBoxTop(LayoutConstants.LINE_MARGIN_PIXEL, UCD.buildHBoxLeft(this.descBox), devicePane, Box.createVerticalStrut(5));
        this.buildAdvancePanel();
        this.buildNormalPanel();
        this.normalCenterBox = UCD.buildHBoxCentert(this.normalWestBox, this.normalPanel);
        this.advanceCenterBox = UCD.buildHBoxCentert(this.advanceWestBox, this.advancePanel);
        this.setLayout(new BorderLayout());
        this.add((Component)northBox, "North");
        this.add((Component)this.normalCenterBox, "Center");
    }

    private void buildAdvancePanel() {
        Box chartBox = UCD.buildVBoxTop(this.viewPanelContainer);
        chartBox.setBorder(UCD.createNoTitledBorder(10));
        Box tableBox = UCD.buildVBoxTop(0, UCD.buildHBoxLeft(this.maxObjectsDescLabel), this.scrollPane);
        this.advancePanel = UCD.buildVBoxTop(chartBox, tableBox);
    }

    private void buildNormalPanel() {
        this.normalPerfStatPanel = new PerfStatNormalPanel(this.frame, this.fromPane);
        this.normalPanel = UCD.buildVBoxTop(this.normalPerfStatPanel);
        this.normalPanel.setBorder(UCD.createNoTitledBorder(10));
    }

    private void buildAdvanceWestPanel() {
        this.advanceObjectTypeLabel = new JLabel(CommonUtil.addColon(ResourceManager.getString("PERFORMANCE_STATISTIC_OBJECT_PANEL_STYLE")));
        this.advanceObjectTypeLabel.setFont(IsmFontFactory.getBold12Font());
        this.advanceObjectTypeComboBox = new JComboBox();
        UCD.setJComponentSize(this.advanceObjectTypeComboBox, this.getObjectTypeComboBoxWidth(), this.advanceObjectTypeComboBox.getPreferredSize().height);
        this.advanceObjectsTree = new TickableTree(true, false);
        this.advanceObjectsTree.setRootVisible(false);
        this.advanceObjectsTree.setDisplayLine(false);
        this.advanceObjectsScrollPane = new JScrollPane(this.advanceObjectsTree);
        this.advanceDataTypeLabel = new JLabel(CommonUtil.addColon(ResourceManager.getString("PERFORMANCE_STATISTIC_PARAMETERS_PANEL_DATA_TYPE")));
        this.advanceDataTypeLabel.setFont(IsmFontFactory.getBold12Font());
        this.advanceDataTypeComboBox = new JComboBox();
        UCD.setJComponentSize(this.advanceDataTypeComboBox, this.getDataTypeComboBoxWidth(), this.advanceDataTypeComboBox.getPreferredSize().height);
        this.advanceDataTypeTree = new TickableTree(true, false);
        this.advanceDataTypeTree.setRootVisible(false);
        this.advanceDataTypeTree.setDisplayLine(false);
        this.advanceDataTypeScrollPane = new JScrollPane(this.advanceDataTypeTree);
        Box objectTypesBox = UCD.buildVBoxTop(UCD.buildHBoxLeft(this.advanceObjectTypeLabel, this.advanceObjectTypeComboBox), this.advanceObjectsScrollPane);
        objectTypesBox.setBorder(UCD.createTextTitleBorder(ResourceManager.getString("perfstat.addLegend.statisticalObject")));
        objectTypesBox.setPreferredSize(new Dimension(345, 1000));
        Box dataTypesBox = UCD.buildVBoxTop(UCD.buildHBoxLeft(this.advanceDataTypeLabel, this.advanceDataTypeComboBox), this.advanceDataTypeScrollPane);
        dataTypesBox.setBorder(UCD.createTextTitleBorder(ResourceManager.getString("perf.his.ui.datatype")));
        dataTypesBox.setPreferredSize(new Dimension(345, 1000));
        this.advanceWestBox = UCD.buildVBoxTop(objectTypesBox, dataTypesBox);
    }

    private void buildDescBox() {
        this.jEditorPane = new JEditorPane();
        this.jEditorPane.setEditable(false);
        this.jEditorPane.setFocusable(false);
        this.jEditorPane.setOpaque(false);
        this.jEditorPane.setContentType("text/html");
        this.descBox = new JPanel();
        this.descBox.setBorder(new EmptyBorder(0, 11, 0, 11));
        this.descBox.setLayout(new BoxLayout(this.descBox, 0));
        this.descBox.add(this.jEditorPane);
        this.descBox.setOpaque(false);
    }

    private void buildNormalWestPanel() {
        this.normalObjectTypeLabel = new JLabel(CommonUtil.addColon(ResourceManager.getString("PERFORMANCE_STATISTIC_OBJECT_PANEL_STYLE")));
        this.normalObjectTypeLabel.setFont(IsmFontFactory.getBold12Font());
        this.normalObjectTypeComboBox = new JComboBox();
        UCD.setJComponentSize(this.normalObjectTypeComboBox, this.getObjectTypeComboBoxWidth(), this.normalObjectTypeComboBox.getPreferredSize().height);
        this.normalObjectsTree = new TickableTree(true, false, true);
        this.normalObjectsTree.setRootVisible(false);
        this.normalObjectsTree.setDisplayLine(false);
        this.normalObjectsScrollPane = new JScrollPane(this.normalObjectsTree);
        JLabel label = new JLabel(ResourceManager.getString("perf.his.ui.datatype"));
        this.showDataTypeBtn = new JButton(OPENICON);
        this.showDataTypeBtn.setBorderPainted(false);
        this.showDataTypeBtn.setPreferredSize(new Dimension(OPENICON.getIconWidth(), OPENICON.getIconHeight() - 10));
        this.normalDataTypeTree = new TickableTree(true, false);
        this.normalDataTypeTree.setRootVisible(false);
        this.normalDataTypeTree.setDisplayLine(false);
        this.normalDataTypeScrollPane = new JScrollPane(this.normalDataTypeTree);
        this.normalObjectTypeArea = UCD.buildVBoxTop(UCD.buildHBoxLeft(this.normalObjectTypeLabel, this.normalObjectTypeComboBox), this.normalObjectsScrollPane);
        this.normalObjectTypeArea.setBorder(UCD.createTextTitleBorder(ResourceManager.getString("perfstat.addLegend.statisticalObject")));
        this.normalObjectTypeArea.setPreferredSize(new Dimension(345, 458));
        this.normalDataTypeArea = UCD.buildVBoxTop(UCD.buildHBoxLeft(label, this.showDataTypeBtn), this.normalDataTypeScrollPane);
        this.normalDataTypeArea.setBorder(UCD.createNoTitledBorder(10));
        this.normalDataTypeArea.setPreferredSize(new Dimension(333, 30));
        this.normalWestBox = UCD.buildVBoxTop(this.normalObjectTypeArea, this.normalDataTypeArea);
    }

    private void initListener() {
        this.normalButtonListener();
        this.advanceBtnListener();
        this.showDataTypeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PerfStatRealTimeLayout.this.setDataTypeIsHide(!PerfStatRealTimeLayout.this.dataTypeIsHide);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (PerfStatRealTimeLayout.this.isNormal) {
                    PerfStatRealTimeLayout.this.setDataTypeIsHide(PerfStatRealTimeLayout.this.dataTypeIsHide);
                }
            }

            @Override
            public void componentShown(ComponentEvent e) {
                if (PerfStatRealTimeLayout.this.isNormal) {
                    PerfStatRealTimeLayout.this.setDataTypeIsHide(PerfStatRealTimeLayout.this.dataTypeIsHide);
                }
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                if (PerfStatRealTimeLayout.this.isNormal) {
                    PerfStatRealTimeLayout.this.setDataTypeIsHide(PerfStatRealTimeLayout.this.dataTypeIsHide);
                }
            }
        });
    }

    private void advanceBtnListener() {
        this.advanceBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PerfStatRealTimeLayout.this.isNormal) {
                    PerfStatRealTimeLayout.this.isNormal = false;
                    PerfStatRealTimeLayout.this.setPanelToAdvance();
                }
            }
        });
        this.advanceBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                PerfStatRealTimeLayout.this.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                PerfStatRealTimeLayout.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
    }

    private void normalButtonListener() {
        this.normalBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!PerfStatRealTimeLayout.this.isNormal) {
                    PerfStatRealTimeLayout.this.isNormal = true;
                    PerfStatRealTimeLayout.this.setPanelToNormal();
                }
            }
        });
        this.normalBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                PerfStatRealTimeLayout.this.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                PerfStatRealTimeLayout.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
    }

    public void setDeviceNames(List<Pair<String, String>> deviceIDNames) {
        if (deviceIDNames.size() > 1) {
            this.deviceComboBox.removeAllItems();
            for (Pair<String, String> deviceIDNamePair : deviceIDNames) {
                this.deviceComboBox.addItem(deviceIDNamePair);
            }
            this.deviceComboBox.setVisible(true);
            this.deviceNameValueLabel.setVisible(false);
        } else {
            this.deviceNameValueLabel.setText(deviceIDNames.get(0).getValue());
            this.deviceNameValueLabel.setName(deviceIDNames.get(0).getKey());
            this.deviceComboBox.setVisible(false);
            this.deviceNameValueLabel.setVisible(true);
        }
    }

    private void setPanelToNormal() {
        this.refreshNormalDataTypes();
        this.remove(this.advanceCenterBox);
        this.add((Component)this.normalCenterBox, "Center");
        this.setDataTypeIsHide(true);
        this.normalBtn.setIcon(NORMAL_SELECTICON);
        this.advanceBtn.setIcon(ADVANCE_UNSELECTICON);
        this.jEditorPane.setText(this.normalDesc);
        this.jEditorPane.validate();
        this.jEditorPane.repaint();
        this.validate();
        this.repaint();
    }

    private void setPanelToAdvance() {
        this.remove(this.normalCenterBox);
        this.add((Component)this.advanceCenterBox, "Center");
        this.normalBtn.setIcon(NORMAL_UNSELECTICON);
        this.advanceBtn.setIcon(ADVANCE_SELECTICON);
        this.jEditorPane.setText(this.advanceDesc);
        this.jEditorPane.validate();
        this.jEditorPane.repaint();
        this.validate();
        this.repaint();
    }

    public void setAdvanceObjectTypes(List<IObjectTypeEnum> objectTypesEnumList) {
        this.advanceObjectTypeComboBox.removeAllItems();
        this.sortObjectTypes(objectTypesEnumList);
        Pair<IObjectTypeEnum, String> objectTypePair = null;
        for (IObjectTypeEnum objectType : objectTypesEnumList) {
            objectTypePair = new Pair<IObjectTypeEnum, String>(objectType, objectType.getDescription());
            this.advanceObjectTypeComboBox.addItem(objectTypePair);
        }
    }

    public void setNormalObjectTypes(List<IObjectTypeEnum> objectTypesEnumList) {
        this.normalObjectTypeComboBox.removeAllItems();
        this.sortObjectTypes(objectTypesEnumList);
        Pair<IObjectTypeEnum, String> objectTypePair = null;
        for (IObjectTypeEnum objectType : objectTypesEnumList) {
            objectTypePair = new Pair<IObjectTypeEnum, String>(objectType, objectType.getDescription());
            this.normalObjectTypeComboBox.addItem(objectTypePair);
        }
    }

    public void setAdvanceDataTypes(DefaultMutableTreeNode dataTypesNode, IObjectTypeEnum objectTypeEnum) {
        this.advanceDataTypeTree.setRoot(dataTypesNode);
        this.advanceSelectedObjectType = objectTypeEnum;
        this.refreshAdvanceDataTypes();
    }

    public void setNormalDataTypes(DefaultMutableTreeNode dataTypesNode, IObjectTypeEnum objectTypeEnum) {
        this.normalDataTypeTree.setRoot(dataTypesNode);
        this.normalSelectedObjectType = objectTypeEnum;
        this.refreshNormalDataTypes();
    }

    private void sortObjectTypes(List<IObjectTypeEnum> objectTypes) {
        Collections.sort(objectTypes, new ObjectTypeComparator());
    }

    public IPerfStatObject getAdvanceSelectedPerfStatObjectInTree() {
        List<DefaultMutableTreeNode> selectedNodes = this.advanceObjectsTree.getSelectedTreeNodes();
        if (!selectedNodes.isEmpty()) {
            Object obj = selectedNodes.get(0).getUserObject();
            if (obj instanceof Pair) {
                Pair pair = (Pair)obj;
                return (IPerfStatObject)pair.getKey();
            }
            return null;
        }
        return null;
    }

    public IPerfStatObject getNormalSelectedPerfStatObjectInTree() {
        List<DefaultMutableTreeNode> selectedNodes = this.normalObjectsTree.getSelectedTreeNodes();
        if (!selectedNodes.isEmpty()) {
            Object object = selectedNodes.get(0).getUserObject();
            if (object instanceof Pair) {
                Pair pair = (Pair)object;
                return (IPerfStatObject)pair.getKey();
            }
            return null;
        }
        return null;
    }

    public IObjectTypeEnum getAdvanceSelectedObjectType() {
        Pair objectTypePair = (Pair)this.advanceObjectTypeComboBox.getSelectedItem();
        return (IObjectTypeEnum)objectTypePair.getKey();
    }

    public IObjectTypeEnum getNormalSelectedObjectType() {
        Pair objectTypePair = (Pair)this.normalObjectTypeComboBox.getSelectedItem();
        return (IObjectTypeEnum)objectTypePair.getKey();
    }

    public void refreshAdvanceDataTypes() {
        Pair categoryPair = (Pair)this.advanceDataTypeComboBox.getSelectedItem();
        if (categoryPair == null) {
            this.setAllNodeHide(this.advanceDataTypeTree.getRoot(), true);
        } else {
            String category = (String)categoryPair.getKey();
            this.setAllNodeHide(this.advanceDataTypeTree.getRoot(), true);
            if ("basicDataTypes".equals(category)) {
                this.displayBasicDataTypes();
            } else if ("davancedDataTypes".equals(category)) {
                this.displayAdvancedDataTypes();
            } else if ("ioDistributionDataTypes".equals(category)) {
                this.displayIOGranularityDistributionDataTypes();
            } else if ("iotTimeDataTypes".equals(category)) {
                this.displayIOTimeDataTypes();
            } else {
                this.setAllNodeHide(this.advanceDataTypeTree.getRoot(), false);
            }
        }
        this.advanceDataTypeTree.reload();
    }

    private void refreshNormalDataTypes() {
        this.displayNormalDataTypes();
    }

    private void displayNormalDataTypes() {
        this.setAllNodeHide(this.normalDataTypeTree.getRoot(), true);
        Enumeration<TreeNode> allNodes = this.normalDataTypeTree.getRoot().children();
        while (allNodes.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)allNodes.nextElement();
            if (!(node instanceof TickableTreeNode)) continue;
            TickableTreeNode tickableTreeNode = (TickableTreeNode)node;
            IDataTypeEnum dataType = (IDataTypeEnum)((Pair)tickableTreeNode.getUserObject()).getKey();
            if (Arrays.binarySearch(this.getAdvancedDataTypeIDs(this.normalSelectedObjectType), dataType.getValue()) >= 0 || Arrays.binarySearch(IO_GRANULARITYDISTRIBUTION_DATATYPES, dataType.getValue()) >= 0) continue;
            tickableTreeNode.setHide(false);
        }
        this.normalDataTypeTree.reload();
    }

    private void displayBasicDataTypes() {
        this.setAllNodeHide(this.advanceDataTypeTree.getRoot(), true);
        Enumeration<TreeNode> allNodes = this.advanceDataTypeTree.getRoot().children();
        DefaultMutableTreeNode node = null;
        TickableTreeNode tickableTreeNode = null;
        IDataTypeEnum dataType = null;
        while (allNodes.hasMoreElements()) {
            node = (DefaultMutableTreeNode)allNodes.nextElement();
            if (!(node instanceof TickableTreeNode)) continue;
            tickableTreeNode = (TickableTreeNode)node;
            dataType = (IDataTypeEnum)((Pair)tickableTreeNode.getUserObject()).getKey();
            if (Arrays.binarySearch(this.getAdvancedDataTypeIDs(this.advanceSelectedObjectType), dataType.getValue()) >= 0 || Arrays.binarySearch(IO_GRANULARITYDISTRIBUTION_DATATYPES, dataType.getValue()) >= 0 || Arrays.binarySearch(IO_TIME_DATATYPES, dataType.getValue()) >= 0) continue;
            tickableTreeNode.setHide(false);
        }
    }

    public boolean isBasicDataType(IDataTypeEnum dataType, IObjectTypeEnum objectType) {
        return Arrays.binarySearch(this.getAdvancedDataTypeIDs(objectType), dataType.getValue()) < 0 && Arrays.binarySearch(IO_GRANULARITYDISTRIBUTION_DATATYPES, dataType.getValue()) < 0;
    }

    private void displayAdvancedDataTypes() {
        Enumeration<TreeNode> allNodes = this.advanceDataTypeTree.getRoot().children();
        TickableTreeNode tickableTreeNode = null;
        IDataTypeEnum dataType = null;
        while (allNodes.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)allNodes.nextElement();
            if (!(node instanceof TickableTreeNode)) continue;
            tickableTreeNode = (TickableTreeNode)node;
            dataType = (IDataTypeEnum)((Pair)tickableTreeNode.getUserObject()).getKey();
            if (Arrays.binarySearch(this.getAdvancedDataTypeIDs(this.advanceSelectedObjectType), dataType.getValue()) < 0) continue;
            tickableTreeNode.setHide(false);
        }
    }

    private void displayIOGranularityDistributionDataTypes() {
        Enumeration<TreeNode> allNodes = this.advanceDataTypeTree.getRoot().children();
        TickableTreeNode tickableTreeNode = null;
        IDataTypeEnum dataType = null;
        while (allNodes.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)allNodes.nextElement();
            if (!(node instanceof TickableTreeNode) || Arrays.binarySearch(IO_GRANULARITYDISTRIBUTION_DATATYPES, (dataType = (IDataTypeEnum)((Pair)(tickableTreeNode = (TickableTreeNode)node).getUserObject()).getKey()).getValue()) < 0) continue;
            tickableTreeNode.setHide(false);
        }
    }

    private void displayIOTimeDataTypes() {
        Enumeration<TreeNode> allNodes = this.advanceDataTypeTree.getRoot().children();
        TickableTreeNode tickableTreeNode = null;
        IDataTypeEnum dataType = null;
        while (allNodes.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)allNodes.nextElement();
            if (!(node instanceof TickableTreeNode) || Arrays.binarySearch(IO_TIME_DATATYPES, (dataType = (IDataTypeEnum)((Pair)(tickableTreeNode = (TickableTreeNode)node).getUserObject()).getKey()).getValue()) < 0) continue;
            tickableTreeNode.setHide(false);
        }
    }

    private void setAllNodeHide(DefaultMutableTreeNode parentNode, boolean isHide) {
        Enumeration<TreeNode> allNodes = parentNode.breadthFirstEnumeration();
        while (allNodes.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)allNodes.nextElement();
            if (!(node instanceof TickableTreeNode)) continue;
            TickableTreeNode tickableTreeNode = (TickableTreeNode)node;
            tickableTreeNode.setHide(isHide);
        }
    }

    public void setAdvanceObjects(DefaultMutableTreeNode root) {
        this.advanceObjectsTree.setRoot(root);
        List<TickableTreeNode> treeNodes = this.advanceObjectsTree.getTickedTreeNodes();
        if (!treeNodes.isEmpty()) {
            TickableTreeNode node = treeNodes.get(0);
            TreePath treePath = new TreePath(node.getPath());
            this.advanceObjectsTree.setSelectionPath(treePath);
            this.advanceObjectsTree.expandPath(treePath);
        }
    }

    public void setNormalObjects(DefaultMutableTreeNode root) {
        this.normalObjectsTree.setRoot(root);
    }

    private void solveCannotDisplayTooltips() {
        Range range = new Range(-1.0E-6, 100.000001);
        this.advanceTimeSeriesChart.getAxisY().setRange(range);
        this.advanceTimeSeriesChart.getAxisY().setAutoRangeMinimumSize(100.0, true);
        this.advanceTimeSeriesChart.getChart().addProgressListener((ChartProgressListener)new PerfStatChartProgressListener(range));
        this.advanceTimeSeriesChart.setAutoPopulateSeriesShape(false);
    }

    private long getLastTimePoint(TimeSeriesChart viewPanelChart) {
        long lastTimePoint = 0L;
        List<TimeSeries> allTimeSeries = viewPanelChart.getAllSeries();
        for (TimeSeries timeSeries : allTimeSeries) {
            long timePoint;
            if (timeSeries.getItemCount() <= 0 || (timePoint = timeSeries.getTimePeriod(timeSeries.getItemCount() - 1).getLastMillisecond()) <= lastTimePoint) continue;
            lastTimePoint = timePoint;
        }
        return lastTimePoint;
    }

    public String getCurrentDeviceID() {
        if (this.deviceNameValueLabel.isVisible()) {
            return this.deviceNameValueLabel.getName();
        }
        Pair selectedPair = (Pair)this.deviceComboBox.getSelectedItem();
        return (String)selectedPair.getKey();
    }

    private int getObjectTypeComboBoxWidth() {
        if ("en".equals(ResourceManager.getLocale().getLanguage())) {
            return 160;
        }
        return 150;
    }

    private int getDataTypeComboBoxWidth() {
        if ("en".equals(ResourceManager.getLocale().getLanguage())) {
            return 150;
        }
        return 110;
    }

    private int[] getAdvancedDataTypeIDs(IObjectTypeEnum selectObjectType) {
        if (this.objectToAdvancedDataTypesMap == null) {
            return ADVANCE_DATATYPES;
        }
        int[] dataTypes = this.objectToAdvancedDataTypesMap.get(selectObjectType);
        if (dataTypes == null) {
            return ADVANCE_DATATYPES;
        }
        return dataTypes;
    }

    private void setDataTypeIsHide(boolean dataTypeIsHide) {
        this.dataTypeIsHide = dataTypeIsHide;
        if (dataTypeIsHide) {
            this.hideDataTypeTree();
        } else {
            this.showDataTypeTree();
        }
    }

    private void hideDataTypeTree() {
        Dimension dimension = this.getSize();
        int frameHight = (int)dimension.getHeight() - 55;
        int heightNormalDatatypetree = 30;
        this.normalDataTypeArea.setPreferredSize(new Dimension(333, heightNormalDatatypetree));
        this.normalDataTypeScrollPane.setVisible(false);
        this.normalObjectTypeArea.setPreferredSize(new Dimension(333, frameHight - heightNormalDatatypetree - 12));
        this.normalObjectsScrollPane.setPreferredSize(new Dimension(333, frameHight - heightNormalDatatypetree - 12 - 60));
        this.showDataTypeBtn.setIcon(OPENICON);
        this.normalWestBox.validate();
        this.normalWestBox.repaint();
        this.dataTypeIsHide = true;
    }

    private void showDataTypeTree() {
        Dimension dimension = this.getSize();
        int frameHight = (int)dimension.getHeight() - 55;
        int hh = (int)((float)frameHight * 0.3f);
        this.normalDataTypeArea.setPreferredSize(new Dimension(333, hh));
        this.normalDataTypeScrollPane.setPreferredSize(new Dimension(333, hh - 30));
        this.normalDataTypeScrollPane.setSize(new Dimension(333, hh - 30));
        this.normalDataTypeScrollPane.setVisible(true);
        this.normalObjectTypeArea.setPreferredSize(new Dimension(333, frameHight - hh - 12));
        this.normalObjectsScrollPane.setPreferredSize(new Dimension(333, frameHight - hh - 12 - 60));
        this.showDataTypeBtn.setIcon(HIDEICON);
        this.normalWestBox.validate();
        this.normalWestBox.repaint();
        this.dataTypeIsHide = false;
    }

    public JComboBox getAdvanceDataTypeComboBox() {
        return this.advanceDataTypeComboBox;
    }

    public JEditorPane getJEditorPane() {
        return this.jEditorPane;
    }

    public JComboBox getDeviceComboBox() {
        return this.deviceComboBox;
    }

    public TimeSeriesChart getStatViewPanel() {
        return this.advanceTimeSeriesChart;
    }

    public JLabel getPeriodValueLabel() {
        return this.periodValueLabel;
    }

    public DefaultTableModel getTableMode() {
        return this.tableMode;
    }

    public IsmTable getScaleTable() {
        return this.scaleTable;
    }

    public void setObjectToAdvancedDataTypesMap(Map<IObjectTypeEnum, int[]> objectToAdvancedDataTypesMap) {
        this.objectToAdvancedDataTypesMap = objectToAdvancedDataTypesMap;
    }

    public JComboBox getAdvanceObjectTypeComboBox() {
        return this.advanceObjectTypeComboBox;
    }

    public TickableTree getAdvanceObjectsTree() {
        return this.advanceObjectsTree;
    }

    public JComboBox getNormalObjectTypeComboBox() {
        return this.normalObjectTypeComboBox;
    }

    public TickableTree getNormalObjectsTree() {
        return this.normalObjectsTree;
    }

    public TickableTree getAdvanceDataTypeTree() {
        return this.advanceDataTypeTree;
    }

    public TickableTree getNormalDataTypeTree() {
        return this.normalDataTypeTree;
    }

    public PerfStatNormalPanel getNormalPerfStatPanel() {
        return this.normalPerfStatPanel;
    }

    public void setNormalDesc(String normalDescValue) {
        this.normalDesc = normalDescValue;
        if (this.isNormal) {
            this.jEditorPane.setText(normalDescValue);
            this.jEditorPane.validate();
            this.jEditorPane.repaint();
            this.validate();
            this.repaint();
        }
    }

    public void setAdvanceDesc(String advanceDescValue) {
        this.advanceDesc = advanceDescValue;
        if (!this.isNormal) {
            this.jEditorPane.setText(advanceDescValue);
            this.jEditorPane.validate();
            this.jEditorPane.repaint();
            this.validate();
            this.repaint();
        }
    }

    private class PerfStatChartProgressListener
    implements ChartProgressListener {
        private Range range;

        public PerfStatChartProgressListener(Range range) {
            this.range = range;
        }

        public void chartProgress(ChartProgressEvent e) {
            double lower;
            double upper = PerfStatRealTimeLayout.this.advanceTimeSeriesChart.getAxisY().getRange().getUpperBound();
            if (upper > 100.000001) {
                PerfStatRealTimeLayout.this.advanceTimeSeriesChart.getAxisY().setRange(this.range);
            }
            long xDuper = PerfStatRealTimeLayout.this.advanceTimeSeriesChart.getAxisX().getMaximumDate().getTime();
            long lastTimePoint = PerfStatRealTimeLayout.this.getLastTimePoint(PerfStatRealTimeLayout.this.advanceTimeSeriesChart);
            if (lastTimePoint == xDuper) {
                PerfStatRealTimeLayout.this.advanceTimeSeriesChart.getAxisX().setMaximumDate(new Date(lastTimePoint + 1L));
            }
            if ((lower = PerfStatRealTimeLayout.this.advanceTimeSeriesChart.getAxisY().getRange().getLowerBound()) == 0.0) {
                PerfStatRealTimeLayout.this.advanceTimeSeriesChart.getAxisY().setLowerBound(-1.0E-6);
            }
        }
    }

    private static class ObjectTypeComparator
    implements Comparator<IObjectTypeEnum>,
    Serializable {
        private static final long serialVersionUID = 1923583709951998259L;

        private ObjectTypeComparator() {
        }

        @Override
        public int compare(IObjectTypeEnum item1, IObjectTypeEnum item2) {
            int item2SortValue;
            int item1SortValue = item1.getSortValue();
            if (item1SortValue > (item2SortValue = item2.getSortValue())) {
                return 1;
            }
            if (item1SortValue == item2SortValue) {
                return 0;
            }
            return -1;
        }
    }
}

