/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.util;

import java.util.ArrayList;
import java.util.List;

public final class ByteUtil {
    private ByteUtil() {
    }

    public static byte[] int2Byte(int intValue) {
        byte[] b = new byte[4];
        for (int i = 0; i < 4; ++i) {
            b[i] = (byte)(intValue >> 8 * (3 - i) & 0xFF);
        }
        return b;
    }

    public static int byte2Int(byte[] b) {
        int intValue = 0;
        for (int i = 0; i < b.length; ++i) {
            intValue += (b[i] & 0xFF) << 8 * (3 - i);
        }
        return intValue;
    }

    public static long bytes2long(byte[] b) {
        int mask = 255;
        int temp = 0;
        int res = 0;
        for (int i = 0; i < 8; ++i) {
            res <<= 8;
            temp = b[i] & mask;
            res |= temp;
        }
        return res;
    }

    public static byte[] long2bytes(long num) {
        byte[] b = new byte[8];
        for (int i = 0; i < 8; ++i) {
            b[i] = (byte)(num >>> 56 - i * 8);
        }
        return b;
    }

    public static int bytes2int(byte[] b, boolean isHighFirst) {
        return (int)ByteUtil.bytes2long(b, isHighFirst);
    }

    public static long bytes2long(byte[] bytes, boolean isHighFirst) {
        long result;
        block4: {
            result = 0L;
            if (bytes == null || bytes.length > 8) break block4;
            if (isHighFirst) {
                int i = bytes.length - 1;
                int j = 0;
                while (i >= 0) {
                    long value = bytes[i] & 0xFF;
                    result += value << (j << 3);
                    --i;
                    ++j;
                }
            } else {
                int i = 0;
                int j = 0;
                while (i < bytes.length - 1) {
                    long value = bytes[i] & 0xFF;
                    result += value << (j << 3);
                    ++i;
                    ++j;
                }
            }
        }
        return result;
    }

    public static byte[] getByteArrayByLength(int len, byte value) {
        byte[] rt = new byte[len];
        for (int i = 0; i < len; ++i) {
            rt[i] = value;
        }
        return rt;
    }

    public static long reverseLong(long val) {
        return Long.reverseBytes(val);
    }

    public static int reverseInt(int val) {
        return Integer.reverseBytes(val);
    }

    public static List<String> getTypeIntgers(String inStr) {
        ArrayList<String> retList = new ArrayList<String>(0);
        int pos = inStr.indexOf("\"Map\":{");
        String[] tokens = inStr.substring(pos + "\"Map\":{".length()).split("\\{");
        String token = null;
        for (int i = 0; i < tokens.length - 1; ++i) {
            token = tokens[i];
            token = token.substring(0, token.length() - 2);
            pos = token.lastIndexOf("\"");
            token = token.substring(pos + "\"".length());
            retList.add(token);
        }
        return retList;
    }
}

