/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.util.parser;

import com.huawei.ism.exception.IsmException;
import com.huawei.ism.tool.base.utils.XmlUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class XmlWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlWriter.class);
    private static volatile DocumentBuilder documentBuilder = null;
    private Document document = null;
    private static final Lock lock = new ReentrantLock();
    private File xmlFile = null;

    public XmlWriter(String filePath, boolean createIfNotExist) throws IsmException {
        DocumentBuilder documentBuilderTemp = XmlWriter.getDocumentBuilder();
        try {
            File file;
            this.xmlFile = file = new File(filePath);
            if (createIfNotExist && !file.exists()) {
                File parent = file.getParentFile();
                if (parent.mkdirs()) {
                    LOGGER.info("mkdirs finished.");
                }
                this.document = documentBuilderTemp.newDocument();
                this.document.setXmlVersion("1.0");
            } else {
                this.document = documentBuilderTemp.parse(file);
            }
        }
        catch (SAXException e) {
            throw new IsmException("Can't create document", (Throwable)e);
        }
        catch (IOException e) {
            throw new IsmException("Can't create document", (Throwable)e);
        }
    }

    public void write(String nodePath, String nodeValue) throws IsmException {
        Element element = this.searchNode(nodePath, true);
        if (null != element) {
            element.setTextContent(nodeValue);
            this.writeDomToXmlFile();
        }
    }

    public void write(String nodePath, String attributeName, String attributeValue) throws IsmException {
        Element element = this.searchNode(nodePath, true);
        if (null != element) {
            element.setAttribute(attributeName, attributeValue);
            this.writeDomToXmlFile();
        }
    }

    private Element searchNode(String nodePath, boolean creatIfNotExist) {
        String[] nodeName = nodePath.split("/");
        List<String> tagNames = this.deleteBlank(nodeName);
        if (tagNames.size() < 1) {
            return null;
        }
        Element rootNode = this.document.getDocumentElement();
        if (null == rootNode) {
            String rootNodeName = tagNames.get(0);
            rootNode = this.document.createElement(this.parseChildName(rootNodeName));
            rootNode.appendChild(this.document.createTextNode("\n"));
            this.document.appendChild(rootNode);
        }
        Element parentNode = rootNode;
        String tagName = null;
        String childNodeName = null;
        int childNodeIndex = 0;
        Element child = null;
        Text enter = null;
        int n = tagNames.size();
        for (int i = 1; i < n; ++i) {
            tagName = tagNames.get(i);
            childNodeName = this.parseChildName(tagName);
            child = this.searchChild(parentNode, childNodeName, childNodeIndex = this.parseChildIndex(tagName));
            if (null == child) {
                if (creatIfNotExist) {
                    child = this.document.createElement(childNodeName);
                    enter = this.document.createTextNode("\n");
                    child.appendChild(enter);
                    parentNode.appendChild(child);
                    parentNode.appendChild(enter);
                } else {
                    return null;
                }
            }
            parentNode = child;
        }
        return parentNode;
    }

    private List<String> deleteBlank(String[] strings) {
        ArrayList<String> stringList = new ArrayList<String>(0);
        for (String string : strings) {
            if ("".equals(string)) continue;
            stringList.add(string);
        }
        return stringList;
    }

    private int parseChildIndex(String childNodeName) {
        int childIndex = 0;
        if (childNodeName.endsWith("]")) {
            int begin = childNodeName.indexOf("[");
            int end = childNodeName.indexOf("]");
            String sIndex = childNodeName.substring(begin + 1, end);
            childIndex = Integer.valueOf(sIndex);
            return childIndex;
        }
        return childIndex;
    }

    private String parseChildName(String nodeName) {
        int index = nodeName.indexOf("[");
        if (-1 == index) {
            return nodeName;
        }
        return nodeName.substring(0, index);
    }

    private Element searchChild(Element parent, String childNodeName, int index) {
        NodeList nodeList = parent.getChildNodes();
        if (null == nodeList) {
            return null;
        }
        int childIndex = 0;
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element childNode;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !(childNode = (Element)node).getTagName().equals(childNodeName)) continue;
            if (childIndex == index) {
                return childNode;
            }
            ++childIndex;
        }
        return null;
    }

    private void writeDomToXmlFile() throws IsmException {
        FileOutputStream fileOutputStream = null;
        try {
            Transformer transformer = XmlUtils.newTransformer();
            fileOutputStream = new FileOutputStream(this.xmlFile);
            transformer.transform(new DOMSource(this.document), new StreamResult(fileOutputStream));
        }
        catch (TransformerConfigurationException e) {
            throw new IsmException("Wirte to xml file \"" + this.xmlFile.getName() + "\" erro:", (Throwable)e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new IsmException("Wirte to xml file \"" + this.xmlFile.getName() + "\" erro:", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            LOGGER.error("File not found:" + this.xmlFile.getName());
            throw new IsmException("Wirte to xml file \"" + this.xmlFile.getName() + "\"");
        }
        catch (TransformerException e) {
            throw new IsmException("Wirte to xml file \"" + this.xmlFile.getName() + "\" erro:", (Throwable)e);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    LOGGER.error("", (Throwable)e);
                }
            }
        }
    }

    private static DocumentBuilder getDocumentBuilder() throws IsmException {
        if (null == documentBuilder) {
            try {
                lock.lock();
                if (null != documentBuilder) {
                    DocumentBuilder documentBuilder = XmlWriter.documentBuilder;
                    return documentBuilder;
                }
                documentBuilder = XmlUtils.getIgnoreWhitespaceDocBuilderFactory().newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new IsmException("Can't create DocumentBuilder", (Throwable)e);
            }
            finally {
                lock.unlock();
            }
        }
        return documentBuilder;
    }

    public static Document getNewDocument(String filePath) throws IsmException {
        Document doc = null;
        DocumentBuilder documentBuilderTemp = XmlWriter.getDocumentBuilder();
        File file = new File(filePath);
        File parent = file.getParentFile();
        if (parent.mkdirs()) {
            LOGGER.info("mkdirs finished.");
        }
        doc = documentBuilderTemp.newDocument();
        doc.setXmlVersion("1.0");
        return doc;
    }

    public static void writeDomToXmlFile(Document doc, File xmlFile) throws IsmException {
        FileOutputStream fileOutputStream = null;
        try {
            Transformer transformer = XmlUtils.newTransformer();
            DOMSource domSource = new DOMSource(doc);
            fileOutputStream = new FileOutputStream(xmlFile);
            StreamResult sr = new StreamResult(fileOutputStream);
            transformer.transform(domSource, sr);
        }
        catch (TransformerConfigurationException e) {
            throw new IsmException("Wirte to xml file \"\" erro:", (Throwable)e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new IsmException("Wirte to xml file \"\" erro:", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            LOGGER.error("File not found:" + xmlFile.getName());
            throw new IsmException("Wirte to xml file \"\"");
        }
        catch (TransformerException e) {
            throw new IsmException("Wirte to xml file \"\" erro:", (Throwable)e);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    LOGGER.error("", (Throwable)e);
                }
            }
        }
    }
}

