/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.checkengine.bean;

import com.huawei.security.checkengine.bean.IdentifierSequence;
import com.huawei.security.checkengine.bean.TreeNode;
import java.io.Serializable;

public final class TrieTree
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final TreeNode rootNode;

    public TrieTree(IdentifierSequence countingID) {
        this.rootNode = TreeNode.createEmptyNode(null, countingID);
    }

    public static TrieTree createTrie(String[] words) {
        IdentifierSequence countingID = new IdentifierSequence();
        TrieTree trie = new TrieTree(countingID);
        for (String word : words) {
            trie.addString(word, countingID);
        }
        return trie;
    }

    public TreeNode getRootNode() {
        return this.rootNode;
    }

    public void addString(String str, IdentifierSequence countingID) {
        this.addString(this.rootNode.getFirstChild(), str, str.length(), 0, countingID);
    }

    private void addString(TreeNode ptrFirstChild, String str, int strLen, int index, IdentifierSequence countingID) {
        TreeNode treeNode = null;
        treeNode = ptrFirstChild;
        while (!treeNode.isEmptyChar()) {
            if (treeNode.getChar() == str.charAt(index)) {
                if (index == strLen - 1) {
                    treeNode.mark();
                    return;
                }
                this.addString(treeNode.getFirstChild(), str, strLen, index + 1, countingID);
                return;
            }
            treeNode = treeNode.getBrother();
        }
        treeNode.setChar(str.charAt(index));
        treeNode.setBrother(TreeNode.createEmptyNode(treeNode.getParent(), countingID));
        treeNode.setFirstChild(TreeNode.createEmptyNode(treeNode, countingID));
        if (index == strLen - 1) {
            treeNode.mark();
        } else {
            this.addString(treeNode.getFirstChild(), str, strLen, index + 1, countingID);
        }
    }
}

