/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.checkengine.bean;

import com.huawei.security.checkengine.bean.TrieTree;
import com.huawei.security.checkengine.util.WordMatchingTools;
import java.io.Serializable;
import java.util.Collection;

public final class WordDictionaryClass
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int minLength;
    private final TrieTree trie;
    private final String[] wordsArray;

    public WordDictionaryClass(Collection<String> wordsOriginalUntrimmed) {
        this(wordsOriginalUntrimmed.toArray(new String[0]));
    }

    public WordDictionaryClass(String whitespaceOrCommaSeparatedWords) {
        this(WordMatchingTools.split(whitespaceOrCommaSeparatedWords));
    }

    public WordDictionaryClass(String[] wordsOriginalUntrimmed) {
        this.wordsArray = WordMatchingTools.trimLowerCaseAndDeduplicate(wordsOriginalUntrimmed);
        this.minLength = WordMatchingTools.determineMinimumLength(this.wordsArray);
        this.trie = TrieTree.createTrie(this.wordsArray);
    }

    public static WordDictionaryClass createInstance(String whitespaceOrCommaSeparatedWords) {
        WordDictionaryClass wordDictionaryClass = null;
        if (whitespaceOrCommaSeparatedWords != null) {
            wordDictionaryClass = new WordDictionaryClass(whitespaceOrCommaSeparatedWords);
        }
        return wordDictionaryClass;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public TrieTree getTrie() {
        return this.trie;
    }

    public String[] getWords() {
        if (this.wordsArray == null) {
            return new String[0];
        }
        String[] tempWords = new String[this.wordsArray.length];
        System.arraycopy(this.wordsArray, 0, tempWords, 0, this.wordsArray.length);
        return tempWords;
    }

    public int size() {
        return this.wordsArray.length;
    }
}

