/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.checkengine.engine;

import com.huawei.security.checkengine.bean.BadRequestDefinition;
import com.huawei.security.checkengine.bean.BaseDefinitionClass;
import com.huawei.security.checkengine.bean.CheckInputDetail;
import com.huawei.security.checkengine.bean.WordDictionaryClass;
import com.huawei.security.checkengine.engine.AbstractEngine;
import com.huawei.security.checkengine.exception.BadRequestCheckException;
import com.huawei.security.checkengine.exception.CheckEngineException;
import com.huawei.security.checkengine.exception.NotCheckContentException;
import com.huawei.security.checkengine.exception.RuleLoadingException;
import com.huawei.security.checkengine.util.CheckTypeEnum;
import com.huawei.security.checkengine.util.EmptyUtils;
import com.huawei.security.checkengine.util.ServerUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BadInputCheckAttack
extends AbstractEngine {
    private static final Logger LOG = LoggerFactory.getLogger(BadInputCheckAttack.class);
    private CheckTypeEnum[] checkType;

    @Override
    public void init(CheckTypeEnum[] checkType) throws RuleLoadingException {
        this.checkHandle(checkType);
        this.loadRule();
    }

    private void checkHandle(CheckTypeEnum[] checkType) {
        if (checkType != null) {
            this.checkType = new CheckTypeEnum[checkType.length];
            System.arraycopy(checkType, 0, this.checkType, 0, checkType.length);
        }
    }

    @Override
    public void check(Object input, CheckTypeEnum[] checkTypeList, Object object, Properties overrideProps) throws CheckEngineException {
        if (!(input instanceof CheckInputDetail)) {
            throw new BadRequestCheckException("Input is not the exactly type: CheckInputDetail.");
        }
        CheckInputDetail badInput = (CheckInputDetail)input;
        if (checkTypeList != null) {
            this.checkBadRequest(checkTypeList, badInput);
        } else if (this.checkType != null) {
            this.checkBadRequest(this.checkType, badInput);
        } else {
            this.checkBadRequestByAllRules(badInput);
        }
    }

    private void checkBadRequestByAllRules(CheckInputDetail badInput) throws BadRequestCheckException {
        for (Map.Entry requestEntry : this.definitionMap.entrySet()) {
            String definitionName = (String)requestEntry.getKey();
            BaseDefinitionClass definitionClass = (BaseDefinitionClass)requestEntry.getValue();
            if (!(definitionClass instanceof BadRequestDefinition)) {
                throw new BadRequestCheckException("[WSF-CheckEngine] Request definition is null, rule file name:" + definitionName);
            }
            BadRequestDefinition requestDefinition = (BadRequestDefinition)definitionClass;
            if (!requestDefinition.isEnabled()) continue;
            LOG.info("[WSF-CheckEngine] {} begin check.", (Object)definitionName);
            this.checkQueryString(requestDefinition, badInput, definitionName);
            this.checkParamValues(requestDefinition, badInput, definitionName);
            this.checkHeadValues(requestDefinition, badInput, definitionName);
            this.checkCookieValues(requestDefinition, badInput, definitionName);
            this.checkServletValues(requestDefinition, badInput, definitionName);
            LOG.info("[WSF-CheckEngine] {} end check.", (Object)definitionName);
        }
    }

    private void checkBadRequest(CheckTypeEnum[] badRequestCheckType, CheckInputDetail badInput) throws CheckEngineException {
        block7: for (CheckTypeEnum checkTypeEnum : badRequestCheckType) {
            if (checkTypeEnum == null) continue;
            switch (checkTypeEnum) {
                case SQL_INJECTION: {
                    this.sqlInjectionCheck(badInput);
                    continue block7;
                }
                case XSS: {
                    this.xssCheck(badInput);
                    continue block7;
                }
                case COMMAND_INJECTION: {
                    this.commandInjectionCheck(badInput);
                    continue block7;
                }
                case LDAP_INJECTION: {
                    this.ldapInjectionCheck(badInput);
                    continue block7;
                }
                case DIRECTORY_TRAVERSAL: {
                    this.directoryTraversal(badInput);
                    continue block7;
                }
                default: {
                    LOG.error("[WSF-CheckEngine] Do not support check type, check type is {}.", (Object)checkTypeEnum.getCheckTypeName());
                    throw new NotCheckContentException("[WSF-CheckEngine] Can't check inputStream content, please set correct check type.");
                }
            }
        }
    }

    private void checkQueryString(BadRequestDefinition requestDefinition, CheckInputDetail badInput, String entry) throws BadRequestCheckException {
        Map<String, String[]> queryStringMap = badInput.getQueryStringMap();
        Pattern queryStringPattern = requestDefinition.getQueryStringPattern();
        WordDictionaryClass queryStringFilter = requestDefinition.getQueryStringPrefilter();
        this.checkValueProcess(queryStringMap, queryStringFilter, queryStringPattern, entry, requestDefinition);
    }

    private void checkParamValues(BadRequestDefinition requestDefinition, CheckInputDetail badInput, String entry) throws BadRequestCheckException {
        Map<String, String[]> parameterMap = badInput.getParameterMap();
        Pattern parameterValuePattern = requestDefinition.getRequestParamValuePattern();
        WordDictionaryClass queryStringFilter = requestDefinition.getRequestParamValuePrefilter();
        this.checkValueProcess(parameterMap, queryStringFilter, parameterValuePattern, entry, requestDefinition);
    }

    private void checkHeadValues(BadRequestDefinition requestDefinition, CheckInputDetail badInput, String entry) throws BadRequestCheckException {
        Map<String, String[]> headerMap = badInput.getHeaderMap();
        Pattern headValuePattern = requestDefinition.getHeaderValuePattern();
        WordDictionaryClass queryStringFilter = requestDefinition.getHeaderValuePrefilter();
        this.checkValueProcess(headerMap, queryStringFilter, headValuePattern, entry, requestDefinition);
    }

    private void checkCookieValues(BadRequestDefinition requestDefinition, CheckInputDetail badInput, String entry) throws BadRequestCheckException {
        Map<String, String[]> cookieMap = badInput.getCookieMap();
        Pattern cookiePattern = requestDefinition.getCookieValuePattern();
        WordDictionaryClass queryStringFilter = requestDefinition.getCookieValuePrefilter();
        this.checkValueProcess(cookieMap, queryStringFilter, cookiePattern, entry, requestDefinition);
    }

    private void checkServletValues(BadRequestDefinition requestDefinition, CheckInputDetail badInput, String entry) throws BadRequestCheckException {
        Pattern servletPathPattern = requestDefinition.getServletPathPattern();
        WordDictionaryClass queryStringFilter = requestDefinition.getServletPathPrefilter();
        HashMap<String, String[]> serverPathMap = new HashMap<String, String[]>(1);
        String[] array = new String[]{badInput.getServletPath()};
        serverPathMap.put("", array);
        this.checkValueProcess(serverPathMap, queryStringFilter, servletPathPattern, entry, requestDefinition);
    }

    private void checkValueProcess(Map<String, String[]> map, WordDictionaryClass preFilter, Pattern pattern, String mapKey, BadRequestDefinition definition) throws BadRequestCheckException {
        if (ServerUtil.isVariantMatching(map, preFilter, pattern)) {
            LOG.error("[WSF-CheckEngine] {}, check rule file name: {}.", (Object)definition.getDescription(), (Object)mapKey);
            throw new BadRequestCheckException("Input exists attack risk");
        }
        LOG.debug("[WSF-CheckEngine] Supplemental rules check.");
        Map<String, Pattern> supplementalRulesMap = definition.getSupplementalRulesMap();
        if (EmptyUtils.isEmpty(supplementalRulesMap)) {
            LOG.debug("[WSF-CheckEngine] Supplemental rules is not need.");
            return;
        }
        for (Map.Entry<String, Pattern> entry : supplementalRulesMap.entrySet()) {
            if (!ServerUtil.isVariantMatching(map, null, entry.getValue())) continue;
            LOG.error("[WSF-CheckEngine] {} rule check, exist attack risk.", (Object)entry.getKey());
            throw new BadRequestCheckException("Input exists attack risk");
        }
    }

    private void sqlInjectionCheck(CheckInputDetail badInput) throws CheckEngineException {
        String checkDefinitionName = null;
        if (!EmptyUtils.isEmpty(badInput.getQueryStringMap())) {
            LOG.debug("[WSF-CheckEngine] 1A0_SQL-Injection-URL.ce rule begin check.");
            checkDefinitionName = "1A0_SQL-Injection-URL.ce";
            this.checkQueryString(this.getDefinition(checkDefinitionName), badInput, checkDefinitionName);
            LOG.debug("[WSF-CheckEngine] 1A1_SQL-Injection-URL.ce rule begin check.");
            checkDefinitionName = "1A1_SQL-Injection-URL.ce";
            this.checkQueryString(this.getDefinition(checkDefinitionName), badInput, checkDefinitionName);
        }
        if (!EmptyUtils.isEmpty(badInput.getParameterMap())) {
            LOG.debug("[WSF-CheckEngine] 1B0_SQL-Injection-Param.ce rule begin check.");
            checkDefinitionName = "1B0_SQL-Injection-Param.ce";
            this.checkParamValues(this.getDefinition(checkDefinitionName), badInput, checkDefinitionName);
            LOG.debug("[WSF-CheckEngine] 1B1_SQL-Injection-Param.ce rule begin check.");
            checkDefinitionName = "1B1_SQL-Injection-Param.ce";
            this.checkParamValues(this.getDefinition(checkDefinitionName), badInput, checkDefinitionName);
        }
    }

    private void xssCheck(CheckInputDetail badInput) throws CheckEngineException {
        String checkDefinitionName = null;
        if (!EmptyUtils.isEmpty(badInput.getQueryStringMap())) {
            LOG.debug("[WSF-CheckEngine] 2A0_XSS-URL.ce rule begin check.");
            checkDefinitionName = "2A0_XSS-URL.ce";
            this.checkQueryString(this.getDefinition(checkDefinitionName), badInput, checkDefinitionName);
            LOG.debug("[WSF-CheckEngine] 2A1_XSS-URL.ce rule begin check.");
            checkDefinitionName = "2A1_XSS-URL.ce";
            this.checkQueryString(this.getDefinition(checkDefinitionName), badInput, checkDefinitionName);
        }
        if (!EmptyUtils.isEmpty(badInput.getParameterMap())) {
            LOG.debug("[WSF-CheckEngine] 2B0_XSS-Param.ce rule begin check.");
            checkDefinitionName = "2B0_XSS-Param.ce";
            this.checkParamValues(this.getDefinition(checkDefinitionName), badInput, checkDefinitionName);
            LOG.debug("[WSF-CheckEngine] 2B1_XSS-Param.ce rule begin check.");
            checkDefinitionName = "2B1_XSS-Param.ce";
            this.checkParamValues(this.getDefinition(checkDefinitionName), badInput, checkDefinitionName);
        }
        if (!EmptyUtils.isEmpty(badInput.getHeaderMap())) {
            LOG.debug("[WSF-CheckEngine] 2C0_XSS-Header.ce rule begin check.");
            checkDefinitionName = "2C0_XSS-Header.ce";
            this.checkHeadValues(this.getDefinition(checkDefinitionName), badInput, checkDefinitionName);
            LOG.debug("[WSF-CheckEngine] 2C1_XSS-Header.ce rule begin check.");
            checkDefinitionName = "2C1_XSS-Header.ce";
            this.checkHeadValues(this.getDefinition(checkDefinitionName), badInput, checkDefinitionName);
        }
        if (!EmptyUtils.isEmpty(badInput.getCookieMap())) {
            LOG.debug("[WSF-CheckEngine] 2D0_XSS-Cookie.ce rule begin check.");
            checkDefinitionName = "2D0_XSS-Cookie.ce";
            this.checkCookieValues(this.getDefinition(checkDefinitionName), badInput, checkDefinitionName);
            LOG.debug("[WSF-CheckEngine] 2D1_XSS-Cookie.ce rule begin check.");
            checkDefinitionName = "2D1_XSS-Cookie.ce";
            this.checkCookieValues(this.getDefinition(checkDefinitionName), badInput, checkDefinitionName);
        }
    }

    private void commandInjectionCheck(CheckInputDetail badInput) throws CheckEngineException {
        String checkDefinitionName = null;
        if (!EmptyUtils.isEmpty(badInput.getServletPath())) {
            LOG.debug("[WSF-CheckEngine] 3A_Command-Direct.ce rule begin check.");
            checkDefinitionName = "3A_Command-Direct.ce";
            this.checkServletValues(this.getDefinition(checkDefinitionName), badInput, checkDefinitionName);
        }
        if (!EmptyUtils.isEmpty(badInput.getQueryStringMap())) {
            LOG.debug("[WSF-CheckEngine] 3B_Command-URL.ce rule begin check.");
            checkDefinitionName = "3B_Command-URL.ce";
            this.checkQueryString(this.getDefinition(checkDefinitionName), badInput, checkDefinitionName);
        }
        if (!EmptyUtils.isEmpty(badInput.getParameterMap())) {
            LOG.debug("[WSF-CheckEngine] 3C_Command-Param.ce rule begin check.");
            checkDefinitionName = "3C_Command-Param.ce";
            this.checkParamValues(this.getDefinition(checkDefinitionName), badInput, checkDefinitionName);
        }
        if (!EmptyUtils.isEmpty(badInput.getHeaderMap())) {
            LOG.debug("[WSF-CheckEngine] 3D_Command-Header.ce rule begin check.");
            checkDefinitionName = "3D_Command-Header.ce";
            this.checkHeadValues(this.getDefinition(checkDefinitionName), badInput, checkDefinitionName);
        }
        if (!EmptyUtils.isEmpty(badInput.getCookieMap())) {
            LOG.debug("[WSF-CheckEngine] 3E_Command-Cookie.ce rule begin check.");
            checkDefinitionName = "3E_Command-Cookie.ce";
            this.checkCookieValues(this.getDefinition(checkDefinitionName), badInput, checkDefinitionName);
        }
    }

    private void ldapInjectionCheck(CheckInputDetail badInput) throws CheckEngineException {
        String checkDefinitionName = null;
        if (!EmptyUtils.isEmpty(badInput.getQueryStringMap())) {
            LOG.debug("[WSF-CheckEngine] 4A_LDAP-Injection-URL.ce rule begin check.");
            checkDefinitionName = "4A_LDAP-Injection-URL.ce";
            this.checkQueryString(this.getDefinition(checkDefinitionName), badInput, checkDefinitionName);
        }
        if (!EmptyUtils.isEmpty(badInput.getParameterMap())) {
            LOG.debug("[WSF-CheckEngine] 4B_LDAP-Injection-Param.ce rule begin check.");
            checkDefinitionName = "4B_LDAP-Injection-Param.ce";
            this.checkParamValues(this.getDefinition(checkDefinitionName), badInput, checkDefinitionName);
        }
    }

    private void directoryTraversal(CheckInputDetail badInput) throws CheckEngineException {
        String checkDefinitionName = null;
        if (!EmptyUtils.isEmpty(badInput.getServletPath())) {
            LOG.debug("[WSF-CheckEngine] 5A_DirectoryTraversal-Direct.ce rule begin check.");
            checkDefinitionName = "5A_DirectoryTraversal-Direct.ce";
            this.checkServletValues(this.getDefinition(checkDefinitionName), badInput, checkDefinitionName);
        }
        if (!EmptyUtils.isEmpty(badInput.getQueryStringMap())) {
            LOG.debug("[WSF-CheckEngine] 5B_DirectoryTraversal-URL.ce rule begin check.");
            checkDefinitionName = "5B_DirectoryTraversal-URL.ce";
            this.checkQueryString(this.getDefinition(checkDefinitionName), badInput, checkDefinitionName);
        }
        if (!EmptyUtils.isEmpty(badInput.getParameterMap())) {
            LOG.debug("[WSF-CheckEngine] 5C_DirectoryTraversal-Param.ce rule begin check.");
            checkDefinitionName = "5C_DirectoryTraversal-Param.ce";
            this.checkParamValues(this.getDefinition(checkDefinitionName), badInput, checkDefinitionName);
        }
    }
}

