/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.checkengine.engine;

import com.huawei.security.checkengine.engine.AbstractEngine;
import com.huawei.security.checkengine.engine.BadInputCheckAttack;
import com.huawei.security.checkengine.engine.FileContentCheckAttack;
import com.huawei.security.checkengine.exception.RuleLoadingException;
import com.huawei.security.checkengine.filecontent.EngineSaxRead;
import com.huawei.security.checkengine.util.CheckTypeEnum;
import com.huawei.security.checkengine.util.EmptyUtils;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EngineFactory {
    public static final String CONFIG_FILE_PATH = "ruleengineconfig.xml";
    private static final Object ENGINE_LOCK = new Object();
    private static final Logger LOG = LoggerFactory.getLogger(EngineFactory.class);
    private static final Object BAD_INPUT_LOCK = new Object();
    private static final Object FILE_CONTENT_LOCK = new Object();
    private static volatile EngineFactory singletonInstance;
    private volatile BadInputCheckAttack badInputCheckAttack;
    private volatile FileContentCheckAttack fileContentCheckAttack;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EngineFactory getInstance() throws RuleLoadingException {
        if (singletonInstance == null) {
            Object object = ENGINE_LOCK;
            synchronized (object) {
                if (singletonInstance == null) {
                    EngineFactory instance = new EngineFactory();
                    instance.init();
                    singletonInstance = instance;
                }
            }
        }
        return singletonInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BadInputCheckAttack getBadInputCheckInstance() throws RuleLoadingException {
        if (this.badInputCheckAttack == null) {
            Object object = BAD_INPUT_LOCK;
            synchronized (object) {
                if (this.badInputCheckAttack == null) {
                    BadInputCheckAttack instance = new BadInputCheckAttack();
                    instance.init(null);
                    this.badInputCheckAttack = instance;
                }
            }
        }
        return this.badInputCheckAttack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileContentCheckAttack getFileContentCheckInstance() throws RuleLoadingException {
        if (this.fileContentCheckAttack == null) {
            Object object = FILE_CONTENT_LOCK;
            synchronized (object) {
                if (this.fileContentCheckAttack == null) {
                    FileContentCheckAttack instance = new FileContentCheckAttack();
                    instance.init(null);
                    this.fileContentCheckAttack = instance;
                }
            }
        }
        return this.fileContentCheckAttack;
    }

    public void init() throws RuleLoadingException {
        URL url = ClassLoader.getSystemResource(CONFIG_FILE_PATH);
        if (url == null && this.getClass().getClassLoader() != null) {
            url = this.getClass().getClassLoader().getResource(CONFIG_FILE_PATH);
        }
        if (url != null) {
            try {
                EngineSaxRead reader = new EngineSaxRead();
                Document document = reader.read(url);
                this.parseConfigXMLAndCreateInstance(document);
            }
            catch (DocumentException e) {
                LOG.error("[WSF-CheckEngine] Parse ruleengineconfig.xml file fail.");
                throw new RuleLoadingException(e);
            }
        } else {
            LOG.info("[WSF-CheckEngine] Ruleengineconfig.xml file is not exist, can't load.");
        }
    }

    private void addCheckType(Element element, List<CheckTypeEnum> dataList, CheckTypeEnum type) {
        Attribute attribute;
        if (element != null && (attribute = element.attribute("enabled")) != null && attribute.getValue() != null && "true".equalsIgnoreCase(attribute.getValue().trim())) {
            dataList.add(type);
        }
    }

    private void badInputCheck(Element badInputElement) throws RuleLoadingException {
        if (badInputElement != null) {
            this.badInputCheckAttack = new BadInputCheckAttack();
            ArrayList<CheckTypeEnum> dataList = new ArrayList<CheckTypeEnum>();
            Element sqlInjectionElement = badInputElement.element("SQL-Injection");
            this.addCheckType(sqlInjectionElement, dataList, CheckTypeEnum.SQL_INJECTION);
            Element xssElement = badInputElement.element("XSS");
            this.addCheckType(xssElement, dataList, CheckTypeEnum.XSS);
            Element commandElement = badInputElement.element("Command-Injection");
            this.addCheckType(commandElement, dataList, CheckTypeEnum.COMMAND_INJECTION);
            Element ldapElement = badInputElement.element("LDAP-Injection");
            this.addCheckType(ldapElement, dataList, CheckTypeEnum.LDAP_INJECTION);
            Element directoryTraversalElement = badInputElement.element("DirectoryTraversal");
            this.addCheckType(directoryTraversalElement, dataList, CheckTypeEnum.DIRECTORY_TRAVERSAL);
            this.badInputCheckAttack.init(dataList.toArray(new CheckTypeEnum[8]));
        }
    }

    private void fileContentCheck(Element fileContentCheckElement) throws RuleLoadingException {
        if (fileContentCheckElement != null) {
            this.fileContentCheckAttack = new FileContentCheckAttack();
            ArrayList<CheckTypeEnum> dataList = new ArrayList<CheckTypeEnum>();
            Element zipElement = fileContentCheckElement.element("Zip");
            this.addCheckType(zipElement, dataList, CheckTypeEnum.ZIP);
            Element xxeElement = fileContentCheckElement.element("XXE");
            this.addCheckType(xxeElement, dataList, CheckTypeEnum.XML);
            Element rarElement = fileContentCheckElement.element("Rar");
            this.addCheckType(rarElement, dataList, CheckTypeEnum.RAR);
            Element tarElement = fileContentCheckElement.element("Tar");
            this.addCheckType(tarElement, dataList, CheckTypeEnum.TAR);
            Element tarGzElement = fileContentCheckElement.element("Targz");
            this.addCheckType(tarGzElement, dataList, CheckTypeEnum.TARGZ);
            Element gzElement = fileContentCheckElement.element("Gz");
            this.addCheckType(gzElement, dataList, CheckTypeEnum.GZ);
            Element tarBz2Element = fileContentCheckElement.element("Tarbz2");
            this.addCheckType(tarBz2Element, dataList, CheckTypeEnum.TARBZ2);
            this.fileContentCheckAttack.init(dataList.toArray(new CheckTypeEnum[8]));
        }
    }

    private void parseConfigXMLAndCreateInstance(Document document) throws RuleLoadingException {
        Attribute attribute;
        Element rootElement = document.getRootElement();
        if (rootElement == null) {
            return;
        }
        boolean classLoadRuleFileType = true;
        String ruleFilePath = "";
        Element ruleClassPathElement = rootElement.element("RuleFilesClasspathReference");
        if (ruleClassPathElement != null && (attribute = ruleClassPathElement.attribute("path")) != null && EmptyUtils.hasText(attribute.getValue())) {
            ruleFilePath = attribute.getValue();
        }
        if (!EmptyUtils.hasText(ruleFilePath)) {
            Attribute attribute2;
            Element ruleFileElement = rootElement.element("RuleFilesBasePath");
            Attribute attribute3 = attribute2 = ruleFileElement == null ? null : ruleFileElement.attribute("path");
            if (attribute2 != null && EmptyUtils.hasText(attribute2.getValue())) {
                classLoadRuleFileType = false;
                ruleFilePath = attribute2.getValue();
            }
        }
        AbstractEngine.setRuleFileInfo(classLoadRuleFileType, ruleFilePath);
        Element badInputElement = rootElement.element("BadInputCheckAttack");
        this.badInputCheck(badInputElement);
        Element fileContentCheckElement = rootElement.element("FileContentCheckAttack");
        this.fileContentCheck(fileContentCheckElement);
    }
}

