/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.checkengine.filecontent;

import com.github.junrar.Archive;
import com.github.junrar.exception.RarException;
import com.github.junrar.exception.UnsupportedRarV5Exception;
import com.github.junrar.rarfile.FileHeader;
import com.huawei.security.checkengine.bean.BadRequestDefinition;
import com.huawei.security.checkengine.exception.MultipartCheckException;
import com.huawei.security.checkengine.exception.NotCheckContentException;
import com.huawei.security.checkengine.filecontent.FileContentCheckInterface;
import com.huawei.security.checkengine.util.FileContentCheckUtil;
import com.huawei.security.checkengine.util.ZipCheckParameter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RarContentCheck
implements FileContentCheckInterface {
    private static final Logger LOG = LoggerFactory.getLogger(RarContentCheck.class);
    private static final String START_PATH = FileContentCheckUtil.getStartPath();
    private static final String MISSED_RAR_V5 = "missedRarV5";

    @Override
    public void checkFileContent(InputStream fileContent, BadRequestDefinition checkRule, boolean closeInputStream, Properties overrideProps) throws MultipartCheckException, NotCheckContentException {
        if (checkRule == null) {
            throw new MultipartCheckException("Failed to parse check rules.");
        }
        String filename = FileContentCheckUtil.saveAsFile(fileContent);
        try (InputStream rarAsStream = Files.newInputStream(Paths.get(filename, new String[0]), new OpenOption[0]);
             Archive archive = new Archive(rarAsStream);){
            FileHeader fileHeader = this.checkFileHeader(archive);
            ZipCheckParameter checkParameter = new ZipCheckParameter(overrideProps, checkRule);
            int fileNum = 0;
            long totalSize = 0L;
            while (fileHeader != null) {
                boolean isDir = fileHeader.isDirectory();
                this.checkFileName(fileHeader, checkParameter, isDir);
                if (!isDir) {
                    if (++fileNum > checkParameter.getMaxFileNum()) {
                        LOG.error("[WSF-CheckEngine] Too many files to unrar, the max file number is " + checkParameter.getMaxFileNum());
                        throw new MultipartCheckException("Checking rar file numbers failed.");
                    }
                    totalSize = this.checkFileTotalSize(checkParameter.getMaxSize(), totalSize, archive, fileHeader);
                }
                fileHeader = archive.nextFileHeader();
            }
        }
        catch (UnsupportedRarV5Exception ex) {
            if (!Boolean.parseBoolean(overrideProps.getProperty(MISSED_RAR_V5))) {
                throw new NotCheckContentException("rar file version is Not supported.", ex);
            }
            LOG.warn("[WSF-CheckEngine] rar file version is Not supported.");
        }
        catch (RarException | IOException ex) {
            LOG.error("[WSF-CheckEngine] Failed to read the rar file for checking.");
            throw new NotCheckContentException("Reading rar file failed.", ex);
        }
        finally {
            this.closeInputStream(fileContent, closeInputStream, filename);
        }
    }

    private FileHeader checkFileHeader(Archive archive) throws NotCheckContentException {
        if (archive.getFileHeaders().isEmpty()) {
            LOG.error("[WSF-CheckEngine] Failed to read the file, the rar file is empty.");
            throw new NotCheckContentException("Reading rar file content failed.");
        }
        FileHeader fileHeader = archive.nextFileHeader();
        if (fileHeader != null && fileHeader.isEncrypted()) {
            LOG.error("[WSF-CheckEngine] Can't read entry's content, it's encrypted.");
            throw new NotCheckContentException("Reading rar file content failed.");
        }
        return fileHeader;
    }

    private void checkFileName(FileHeader fileHeader, ZipCheckParameter checkParameter, boolean isDir) throws IOException, MultipartCheckException {
        String entryPath = fileHeader.isUnicode() ? fileHeader.getFileNameW().trim() : fileHeader.getFileNameString().trim();
        FileContentCheckUtil.checkFileName(entryPath, isDir, START_PATH, true, checkParameter);
    }

    private long checkFileTotalSize(long maxSize, long totalSize, Archive archive, FileHeader fileHeader) throws MultipartCheckException {
        long result = totalSize;
        long availableSpace = maxSize - totalSize;
        if (availableSpace <= 0L) {
            LOG.error("[WSF-CheckEngine] File being unrared is too big, the max size is: " + maxSize);
            throw new MultipartCheckException("Checking rar file size failed.");
        }
        try (AvailableSpaceOutputStream asOutputStream = new AvailableSpaceOutputStream(availableSpace);){
            archive.extractFile(fileHeader, (OutputStream)asOutputStream);
            if ((result += asOutputStream.getSize()) > maxSize) {
                LOG.error("[WSF-CheckEngine] File being unrared is too big, the max size is: " + maxSize);
                throw new MultipartCheckException("Checking rar file size failed.");
            }
        }
        catch (RarException e) {
            LOG.error("[WSF-CheckEngine] Fail to extract the file from rar stream.");
            throw new MultipartCheckException("Checking rar file size failed.", e);
        }
        return result;
    }

    private void closeInputStream(InputStream fileContent, boolean closeInputStream, String filename) {
        if (closeInputStream) {
            try {
                fileContent.close();
            }
            catch (IOException e) {
                LOG.error("[WSF-CheckEngine] Failed to close the input stream.");
            }
        }
        FileContentCheckUtil.deleteFile(filename);
    }

    static class AvailableSpaceOutputStream
    extends OutputStream {
        private long count = 0L;
        private long maxLength = 0L;

        AvailableSpaceOutputStream(long length) {
            this.maxLength = length;
            this.count = 0L;
        }

        @Override
        public void close() {
            this.count = 0L;
        }

        @Override
        public void flush() {
        }

        public long getSize() {
            return this.count;
        }

        @Override
        public void write(byte[] data) throws IOException {
            this.write(data, 0, data.length);
        }

        @Override
        public void write(byte[] bytes, int off, int len) throws IOException {
            this.count += (long)len;
            if (this.count > this.maxLength) {
                throw new IOException("Have more than max length.");
            }
        }

        @Override
        public void write(int byt) throws IOException {
            ++this.count;
            if (this.count > this.maxLength) {
                throw new IOException("Have more than max length.");
            }
        }
    }
}

