/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.checkengine.rulefile;

import com.huawei.security.checkengine.bean.BadRequestDefinition;
import com.huawei.security.checkengine.bean.BaseDefinitionClass;
import com.huawei.security.checkengine.bean.RequestDefinition;
import com.huawei.security.checkengine.bean.WordDictionaryClass;
import com.huawei.security.checkengine.exception.RuleDefinitionIllegalException;
import com.huawei.security.checkengine.exception.RuleLoadingException;
import com.huawei.security.checkengine.rulefile.BaseDefinitionContainer;
import com.huawei.security.checkengine.rulefile.RuleFile;
import com.huawei.security.checkengine.rulefile.RuleFileLoader;
import com.huawei.security.checkengine.util.LogUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestDefinitionContainer
extends BaseDefinitionContainer {
    public static final String KEY_ZIPBOMB_THRESHOLD_FILE_COUNT = "zipBombThresholdFileCount";
    public static final String KEY_ZIPBOMB_THRESHOLD_TOTAL_SIZE = "zipBombThresholdTotalSize";
    public static final String KEY_ZIPCONTENT_FILENAME_MAX_LEN = "zippedFilenameMaxLen";
    public static final String KEY_ZIPCONTENT_PATH_MAX_DEPTH = "zippedPathMaxDepth";
    public static final String KEY_ZIPCONTENT_PATH_MAX_LEN = "zippedPathMaxLen";
    public static final String KEY_ZIPCONTENT_VALID_FILENAME = "zippedValidFileName";
    public static final String KEY_ZIPCONTENT_VALID_FOLDER_NAME = "zippedValidFolderName";
    protected static final String KEY_COOKIE_NAME_ANY = "cookie";
    protected static final String KEY_COOKIE_NAME_ANY_PREFILTER = "cookie@prefilter";
    protected static final String KEY_HEADER_NAME_ANY = "header";
    protected static final String KEY_HEADER_NAME_ANY_PREFILTER = "header@prefilter";
    protected static final String KEY_PARAM_NAME_ANY = "requestParam";
    protected static final String KEY_PARAM_NAME_ANY_PREFILTER = "requestParam@prefilter";
    protected static final String KEY_QUERY_STRING = "queryString";
    protected static final String KEY_QUERY_STRING_PREFILTER = "queryString@prefilter";
    protected static final String KEY_SERVLET_PATH = "servletPath";
    protected static final String KEY_SERVLET_PATH_PREFILTER = "servletPath@prefilter";
    protected static final String PERMISSION_DTD = "permissionDTD";
    protected static final String SUPPLEMENTAL_CHECK_RULES = "supplementalRules";
    private static final Logger LOG = LoggerFactory.getLogger(RequestDefinitionContainer.class);

    public RequestDefinitionContainer(RuleFileLoader ruleFileLoader) {
        super(ruleFileLoader);
    }

    public static int parsePositiveInt(String stringValue) throws NumberFormatException {
        int value = Integer.parseInt(stringValue);
        if (value <= 0) {
            throw new NumberFormatException("Input is not an positive int.");
        }
        return value;
    }

    public static int parseUnsignedInt(String stringValue) throws NumberFormatException {
        int value = Integer.parseInt(stringValue);
        if (value < 0) {
            throw new NumberFormatException("Input is not an unsigned int.");
        }
        return value;
    }

    public static long parseUnsignedLong(String stringValue) throws NumberFormatException {
        long value = Long.parseLong(stringValue);
        if (value < 0L) {
            throw new NumberFormatException("input is not an unsigned int.");
        }
        return value;
    }

    public static long parsePositiveLong(String stringValue) throws NumberFormatException {
        long value = Long.parseLong(stringValue);
        if (value <= 0L) {
            throw new NumberFormatException("input is not an unsigned int.");
        }
        return value;
    }

    @Override
    public final void parseDefinitions() throws RuleLoadingException {
        RuleFile[] ruleFiles = this.ruleFileLoader.loadRuleFiles();
        LOG.info("[WSF-CheckEngine] Begin parse rule files.");
        for (RuleFile ruleFile : ruleFiles) {
            this.parseruleFile(ruleFile);
        }
        LOG.info("[WSF-CheckEngine] End parse rule files.");
    }

    private void parseruleFile(RuleFile ruleFile) throws RuleDefinitionIllegalException {
        String propertyName = null;
        String property = null;
        try {
            RequestDefinition requestDefinition = this.checkRuleFile(ruleFile);
            HashMap<String, Pattern> supplementalRulesMap = new HashMap<String, Pattern>(16);
            requestDefinition.setSupplementalRulesMap(supplementalRulesMap);
            Properties properties = ruleFile.getProperties();
            Set<String> propertyNames = properties.stringPropertyNames();
            for (String name : propertyNames) {
                propertyName = name;
                if (!this.setPattern(ruleFile, propertyName, property = properties.getProperty(propertyName), requestDefinition, supplementalRulesMap)) continue;
            }
        }
        catch (PatternSyntaxException e) {
            LOG.error("[WSF-CheckEngine] Invalid regex syntax {} in rule file: {}.", (Object)LogUtils.cleanLog(property), (Object)ruleFile);
            throw new RuleDefinitionIllegalException("Invalid regex syntax in rule file.", e);
        }
        catch (NumberFormatException e) {
            LOG.error("[WSF-CheckEngine] The property {} is configured wrong value {} in rule file: {}.", new Object[]{propertyName, LogUtils.cleanLog(property), ruleFile});
            throw new RuleDefinitionIllegalException("Property (" + propertyName + ") config error in rule file: " + ruleFile, e);
        }
    }

    private boolean setPattern(RuleFile ruleFile, String propertyName, String property, RequestDefinition requestDefinition, Map<String, Pattern> supplementalRulesMap) throws RuleDefinitionIllegalException {
        if (KEY_SERVLET_PATH.equals(propertyName)) {
            requestDefinition.setServletPathPattern(Pattern.compile(property));
        } else if (KEY_COOKIE_NAME_ANY.equals(propertyName)) {
            requestDefinition.setCookieValuePattern(Pattern.compile(property));
        } else if (KEY_QUERY_STRING.equals(propertyName)) {
            requestDefinition.setQueryStringPattern(Pattern.compile(property));
        } else if (KEY_PARAM_NAME_ANY.equals(propertyName)) {
            requestDefinition.setRequestParamValuePattern(Pattern.compile(property));
        } else if (KEY_HEADER_NAME_ANY.equals(propertyName)) {
            requestDefinition.setHeaderValuePattern(Pattern.compile(property));
        } else {
            return this.setParamPattern(ruleFile, propertyName, property, requestDefinition, supplementalRulesMap);
        }
        return false;
    }

    private boolean setParamPattern(RuleFile ruleFile, String propertyName, String property, RequestDefinition requestDefinition, Map<String, Pattern> supplementalRulesMap) throws RuleDefinitionIllegalException {
        boolean checkParam;
        boolean bl = checkParam = this.parsePrefilter(propertyName, property, requestDefinition) || this.parseZipBombThreshold(propertyName, property, requestDefinition, ruleFile) || this.parseZipContent(propertyName, property, requestDefinition);
        if (checkParam) {
            return true;
        }
        if (PERMISSION_DTD.equals(propertyName)) {
            requestDefinition.setPermissionDTD(Boolean.parseBoolean(property.trim()));
        } else if (propertyName.startsWith(SUPPLEMENTAL_CHECK_RULES)) {
            supplementalRulesMap.put(propertyName, Pattern.compile(property));
        } else {
            LOG.debug("[WSF-CheckEngine] Unknown property name, property name is {} in the rule file: {}.", (Object)propertyName, (Object)ruleFile.getName());
        }
        return false;
    }

    private boolean parsePrefilter(String propertyName, String property, RequestDefinition requestDefinition) {
        if (KEY_SERVLET_PATH_PREFILTER.equals(propertyName)) {
            requestDefinition.setServletPathPrefilter(WordDictionaryClass.createInstance(property));
            return true;
        }
        if (KEY_QUERY_STRING_PREFILTER.equals(propertyName)) {
            requestDefinition.setQueryStringPrefilter(WordDictionaryClass.createInstance(property));
            return true;
        }
        if (KEY_HEADER_NAME_ANY_PREFILTER.equals(propertyName)) {
            requestDefinition.setHeaderValuePrefilter(WordDictionaryClass.createInstance(property));
            return true;
        }
        if (KEY_COOKIE_NAME_ANY_PREFILTER.equals(propertyName)) {
            requestDefinition.setCookieValuePrefilter(WordDictionaryClass.createInstance(property));
            return true;
        }
        if (KEY_PARAM_NAME_ANY_PREFILTER.equals(propertyName)) {
            requestDefinition.setRequestParamValuePrefilter(WordDictionaryClass.createInstance(property));
            return true;
        }
        return false;
    }

    private boolean parseZipBombThreshold(String propertyName, String property, RequestDefinition requestDefinition, RuleFile ruleFile) throws RuleDefinitionIllegalException {
        if (KEY_ZIPBOMB_THRESHOLD_TOTAL_SIZE.equals(propertyName)) {
            requestDefinition.setZipBombThresholdTotalSize(RequestDefinitionContainer.parsePositiveLong(property));
            if (requestDefinition.getZipBombThresholdTotalSize() > 0x7FFFFFFFFFFL) {
                LOG.error("[WSF-CheckEngine] The property {} is configured wrong value {} in rule file: {}.", new Object[]{propertyName, LogUtils.cleanLog(property), ruleFile});
                throw new RuleDefinitionIllegalException("Property (" + propertyName + ") config error in rule file: " + ruleFile);
            }
            return true;
        }
        if (KEY_ZIPBOMB_THRESHOLD_FILE_COUNT.equals(propertyName)) {
            requestDefinition.setZipBombThresholdFileCount(RequestDefinitionContainer.parsePositiveInt(property));
            return true;
        }
        return false;
    }

    private boolean parseZipContent(String propertyName, String property, RequestDefinition requestDefinition) {
        if (KEY_ZIPCONTENT_FILENAME_MAX_LEN.equals(propertyName)) {
            requestDefinition.setZippedFilenameMaxLen(RequestDefinitionContainer.parsePositiveInt(property));
            return true;
        }
        if (KEY_ZIPCONTENT_PATH_MAX_LEN.equals(propertyName)) {
            requestDefinition.setZippedFilenameMaxLen(RequestDefinitionContainer.parsePositiveInt(property));
            return true;
        }
        if (KEY_ZIPCONTENT_PATH_MAX_DEPTH.equals(propertyName)) {
            requestDefinition.setZippedFilenameMaxLen(RequestDefinitionContainer.parsePositiveInt(property));
            return true;
        }
        if (KEY_ZIPCONTENT_VALID_FILENAME.equals(propertyName)) {
            requestDefinition.setZippedFileNamePattern(Pattern.compile(property));
            return true;
        }
        if (KEY_ZIPCONTENT_VALID_FOLDER_NAME.equals(propertyName)) {
            requestDefinition.setZippedFolderNamePattern(Pattern.compile(property));
            return true;
        }
        return false;
    }

    public Map<String, BaseDefinitionClass> getDefinitionMap() {
        return this.definitionMap;
    }

    protected RequestDefinition createRequestDefinition(boolean enabled, String identification, String description) {
        return new BadRequestDefinition(enabled, identification, description);
    }

    private RequestDefinition checkRuleFile(RuleFile ruleFile) throws RuleDefinitionIllegalException {
        Properties properties = ruleFile.getProperties();
        String fileName = ruleFile.getName();
        boolean enabled = "true".equalsIgnoreCase(properties.getProperty("enabled", "true").trim());
        String description = properties.getProperty("description");
        if (description == null) {
            throw new RuleDefinitionIllegalException("Description property (description) not found in rule file: " + ruleFile);
        }
        BadRequestDefinition requestDefinition = new BadRequestDefinition(enabled, fileName, description);
        if (fileName.lastIndexOf(47) != -1) {
            fileName = fileName.substring(fileName.lastIndexOf(47) + 1);
        } else if (fileName.lastIndexOf(92) != -1) {
            fileName = fileName.substring(fileName.lastIndexOf(92) + 1);
        } else {
            throw new RuleDefinitionIllegalException("The name of Rule files are not right.");
        }
        this.definitionMap.put(fileName, requestDefinition);
        return requestDefinition;
    }
}

