/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.protocol.rest;

import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.protocol.rest.entity.RequestInfo;
import com.huawei.ism.tool.protocol.rest.entity.UrlFormatException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostRequest
extends RequestInfo {
    private static final Logger log = LoggerFactory.getLogger(PostRequest.class);
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(PostRequest.class);

    public PostRequest(String url) {
        super(url);
    }

    public PostRequest(String url, String encoding) {
        super(url, encoding);
    }

    @Override
    public HttpUriRequestBase getHttpUriRequest(String encoding) throws UrlFormatException {
        HttpPost httpPost;
        try {
            httpPost = new HttpPost(this.normalizeUrl(this.getURL()));
        }
        catch (IllegalArgumentException | URISyntaxException e) {
            log.error("Invalid url is: {} ", (Object)this.getURL());
            throw new UrlFormatException(e);
        }
        try {
            String param = this.constructReqJsonParam();
            httpPost.setEntity((HttpEntity)new StringEntity(param, Charset.forName(encoding)));
        }
        catch (Exception e) {
            LOGGER.error("Url encoded form entity error.", (Throwable)e);
        }
        return httpPost;
    }

    private String constructReqJsonParam() {
        if (StringUtils.isNotBlank((CharSequence)this.getParamStr())) {
            return this.getParamStr();
        }
        return this.generateJson(this.getParams()).toString();
    }
}

