/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.protocol.rest.entity;

import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.protocol.rest.entity.UrlFormatException;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONException;
import com.huawei.json.JSONObject;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RequestInfo {
    private static final Logger log = LoggerFactory.getLogger(RequestInfo.class);
    protected static final String DEFAULT_ENCODING = "UTF-8";
    private Map<String, Object> params = new HashMap<String, Object>();
    private String url;
    private String encoding;
    private Map<String, String> headers = new HashMap<String, String>();
    private String locationPath = "";
    private String paramStr;
    private List<String> sensitiveHeaderKwords = Arrays.asList("password", "x-auth-token", "x_csrf_token", "ibasetoken", "storageauth");

    public RequestInfo(String url) {
        this(url, DEFAULT_ENCODING);
    }

    public RequestInfo(String url, String encoding) {
        this.url = url;
        this.encoding = encoding;
    }

    public String getURL() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void addParams(Map<String, String> paramss) {
        if (paramss != null) {
            for (Map.Entry<String, String> keyVal : paramss.entrySet()) {
                this.addParam(keyVal.getKey(), keyVal.getValue());
            }
        }
    }

    public void addParam(String name, Object value) {
        this.params.put(name, value);
    }

    public HttpUriRequestBase toHttpUriRequest() throws UrlFormatException {
        return this.toHttpUriRequest(this.encoding);
    }

    public HttpUriRequestBase toHttpUriRequest(String theEncoding) throws UrlFormatException {
        String supportedEncoding = null;
        try {
            URLEncoder.encode("", theEncoding);
            supportedEncoding = theEncoding;
        }
        catch (UnsupportedEncodingException e) {
            supportedEncoding = DEFAULT_ENCODING;
        }
        HttpUriRequestBase req = this.getHttpUriRequest(supportedEncoding);
        for (Map.Entry<String, String> header : this.headers.entrySet()) {
            BasicHeader h = new BasicHeader(header.getKey(), (Object)header.getValue());
            req.addHeader((Header)h);
        }
        return req;
    }

    public void setHeader(String name, String value) {
        this.headers.put(name, value);
    }

    protected abstract HttpUriRequestBase getHttpUriRequest(String var1) throws UrlFormatException;

    public Map<String, Object> getParams() {
        return this.params;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getParaString() {
        StringBuilder sb = new StringBuilder();
        if (!this.params.isEmpty()) {
            for (String key : this.params.keySet()) {
                String paraVal = this.params.getOrDefault(key, "--").toString();
                if (this.isSensitiveParas(key)) {
                    paraVal = "******";
                }
                sb.append(key + "->" + paraVal + ";");
            }
        }
        return sb.toString();
    }

    public String getHeaderString() {
        StringBuilder sb = new StringBuilder();
        for (String name : this.headers.keySet()) {
            String headerVal = this.isSensitiveParas(name) ? "******" : this.headers.getOrDefault(name, "--");
            sb.append(name).append(":").append(headerVal).append(";");
        }
        return sb.toString();
    }

    private boolean isSensitiveParas(String headerName) {
        if (StringUtils.isNULLStr(headerName)) {
            return false;
        }
        return this.sensitiveHeaderKwords.stream().anyMatch(keyword -> headerName.toLowerCase(Locale.ENGLISH).contains((CharSequence)keyword));
    }

    public JSONObject generateJson(Map<String, Object> para) {
        JSONObject json = new JSONObject();
        for (String key : para.keySet()) {
            Object val = para.get(key);
            if (val instanceof String) {
                this.handleStringValue(json, key, (String)val);
                continue;
            }
            if (val instanceof Integer) {
                json.put(key, ((Integer)val).intValue());
                continue;
            }
            if (val instanceof Long) {
                json.put(key, ((Long)val).longValue());
                continue;
            }
            json.put(key, val);
        }
        return json;
    }

    private void handleStringValue(JSONObject json, String key, String valStr) {
        json.put(key, (Object)valStr);
        if ("password".equalsIgnoreCase(key)) {
            return;
        }
        try {
            if (valStr.startsWith("[") && valStr.endsWith("]")) {
                json.put(key, (Object)new JSONArray(valStr));
            } else if (valStr.startsWith("{") && valStr.endsWith("}")) {
                json.put(key, (Object)new JSONObject(valStr));
            }
        }
        catch (JSONException e) {
            log.warn("parse string to json fail :", (Throwable)e);
        }
    }

    public String normalizeUrl(String url) throws URISyntaxException {
        return new URI(url).normalize().toString();
    }

    public String getLocationPath() {
        return this.locationPath;
    }

    public void setLocationPath(String locationPath) {
        this.locationPath = locationPath;
    }

    public String getParamStr() {
        return this.paramStr;
    }

    public void setParamStr(String paramStr) {
        this.paramStr = paramStr;
    }
}

