/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.protocol.tlv.impl;

import com.huawei.ism.common.bean.User;
import com.huawei.ism.tlv.TLV;
import com.huawei.ism.tlv.TLVUtils;
import com.huawei.ism.tlv.bean.Param;
import com.huawei.ism.tlv.bean.Record;
import com.huawei.ism.tlv.docoder.ParamType;
import com.huawei.ism.tlv.lang.IsmInteger;
import com.huawei.ism.tlv.lang.SignedInt32;
import com.huawei.ism.tlv.lang.UnsignedInt32;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.protocol.exception.UserStatusException;
import com.huawei.ism.tool.protocol.tlv.ShakeHandRunable;
import com.huawei.ism.tool.protocol.tlv.TLVConnectionImpl;
import com.huawei.ism.tool.protocol.tlv.exception.TLVException;
import com.huawei.ism.tool.protocol.tlv.impl.AbstractConnection;
import com.huawei.ism.util.NetUtil;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InnerIpTlvConnection
extends AbstractConnection {
    private static final Logger log = LoggerFactory.getLogger(InnerIpTlvConnection.class);
    public static final long OM_OPCODE_USER_LOGOUT = 55847813122L;
    public static final long OM_OPCODE_USER_LOGIN = 55847813121L;
    private DevNode devNode;
    private User userInfo;
    private String connectedIp;
    private String loginUser;
    private String userId;
    private boolean enableSSL = true;
    private boolean connected = false;
    private boolean passExpiringStop = true;

    public InnerIpTlvConnection(DevNode devNode, boolean enableSSL) {
        this.devNode = devNode;
        this.enableSSL = enableSSL;
        this.loginUser = devNode.getLoginUser().getUserName();
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    public boolean isSocketConnected() {
        TLVConnectionImpl impl = this.getOmConn();
        return impl != null && impl.isConnected();
    }

    @Override
    public void connect() throws TLVException {
        Properties prop = new Properties();
        prop.put("USER_NAME", this.loginUser);
        String pwd = this.devNode.getLoginUser().getPassword();
        prop.put("USER_WORD", pwd);
        prop.put("PORT", "8080");
        prop.put("TIME_OUT_PROPERTY", "30");
        if (this.enableSSL) {
            prop.put("CONN_PROTOCOL", "1");
        }
        boolean isAuthenticate = false;
        for (String ip : this.devNode.getIpList()) {
            if (!this.authenticate(prop, ip)) continue;
            isAuthenticate = true;
            this.connectedIp = ip;
            this.devNode.setActiveIp(ip);
            break;
        }
        if (!isAuthenticate) {
            throw new TLVException("authenticate error.");
        }
        this.connected = true;
        Thread shakeHand = new Thread(new ShakeHandRunable(this, 55847813125L));
        shakeHand.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                log.error("{}:{}", (Object)thread.getName(), (Object)throwable.getMessage());
            }
        });
        shakeHand.setName("tlv-shakeHandThread-->" + this.connectedIp);
        shakeHand.start();
    }

    private boolean authenticate(Properties prop, String ip) throws TLVException {
        String loginPass;
        prop.put("IP_OR_NAME", ip);
        log.info("create tlv connection ,cur props is: ip:{}", (Object)ip);
        this.setOmConn(new TLVConnectionImpl());
        if (null != this.devNode) {
            this.getOmConn().setSocks5Proxy(this.devNode.getSocks5Proxy());
            this.getOmConn().setSshForwardNodes(this.devNode.getSshForwardList());
        }
        this.getOmConn().setSessionKey(0L);
        try {
            this.getOmConn().init(prop);
        }
        catch (TLVException e) {
            log.error("create tlv connection to" + ip + "failed", (Throwable)e);
            return false;
        }
        boolean authSuccess = false;
        if (!this.enableSSL && null != this.devNode) {
            loginPass = this.devNode.getLoginUser().getPassword();
            authSuccess = this.authenticate(loginPass, prop);
            log.info("create tlv connection to {} by no encrypt and not ssl:{} ", (Object)ip, (Object)authSuccess);
        }
        if ((this.enableSSL || !authSuccess) && null != this.devNode) {
            prop.put("CONN_PROTOCOL", "1");
            loginPass = this.devNode.getLoginUser().getPassword();
            authSuccess = this.authenticate(loginPass, prop);
            log.info("create tlv connection to {} by no encrypt and ssl: {}", (Object)ip, (Object)authSuccess);
            loginPass = null;
            if (authSuccess && !this.enableSSL) {
                this.enableSSL = true;
            }
        }
        return authSuccess;
    }

    public void reConnect() throws TLVException {
        try {
            this.passExpiringStop = false;
            this.connect();
        }
        catch (TLVException e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("reconnect to dev " + this.connectedIp + "error", (Throwable)e);
            throw e;
        }
    }

    private boolean authenticate(String encryptPass, Properties prop) throws TLVException {
        ToolLoggerFactory.getLogger(this.getClass()).info("Begin connect to device by TLV.");
        try {
            String localIP = NetUtil.queryLocalIP((String)prop.getProperty("IP_OR_NAME"));
            Param paramLoginUser = new Param(2, ParamType.STRING, this.loginUser);
            Param paramPwd = new Param(65, ParamType.STRING, encryptPass);
            Param paramLocalIp = new Param(67, ParamType.STRING, localIP);
            Param paramScope = new Param(71, ParamType.ENUM, (IsmInteger)new UnsignedInt32(0));
            List params = TLVUtils.paramList((Param[])new Param[]{paramLoginUser, paramPwd, paramLocalIp, paramScope});
            Record record = this.getOmConn().invoke(55847813121L, params);
            if (record == null) {
                log.error("Connect to device by TLV failed. record is null.");
                return false;
            }
            this.createUserInfo(record);
            this.isUserStatusNormal(record);
            this.userId = record.getParamStrValue(1);
            long sessionKey = ((IsmInteger)record.getParamValue(68)).longValue();
            this.getOmConn().setSessionKey(sessionKey);
        }
        catch (UserStatusException e1) {
            this.close();
            throw e1;
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("TLV authenticate exception.", (Throwable)e);
            return false;
        }
        ToolLoggerFactory.getLogger(this.getClass()).info("Connect to device by TLV success.");
        return true;
    }

    private void isUserStatusNormal(Record record) throws UserStatusException {
        IsmInteger accountStatus = record.getParamIntValue(76);
        if (null == accountStatus) {
            ToolLoggerFactory.getLogger(this.getClass()).error("HVSC99 do not have this interface.");
            return;
        }
        int accountStatusInt = record.getParamIntValue(76).intValue();
        ToolLoggerFactory.getLogger(this.getClass()).error("User Status is:" + accountStatus);
        if (accountStatusInt == User.Status.Pwd_expired.ordinal()) {
            throw new UserStatusException("conn.userdatus.pwd.expired");
        }
        if (this.passExpiringStop && accountStatusInt == User.Status.Pwd_expiring.ordinal()) {
            throw new UserStatusException("conn.userdatus.pwd.expiring");
        }
        if (accountStatusInt == User.Status.Pwd_initial.ordinal()) {
            throw new UserStatusException("conn.userdatus.pwd.initial");
        }
    }

    private User createUserInfo(Record record) {
        this.userInfo = new User(this.loginUser);
        this.userInfo.setLevel(User.Level.valueOf((int)record.getParamIntValue(TLV.USER.LEVEL.getParamIndex()).intValue()));
        this.userInfo.setID(record.getParamStrValue(TLV.USER.ID.getParamIndex()));
        int userState = record.getParamIntValue(TLV.USER.ACCOUNTSTATE.getParamIndex(), (IsmInteger)new SignedInt32(User.Status.Online.getValue())).intValue();
        this.userInfo.setStatus(User.Status.valueOf((int)userState));
        return this.userInfo;
    }

    public User getLoginUser() {
        return this.userInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        try {
            if (this.getOmConn() == null || !this.isConnected()) {
                return;
            }
            Param paramUserId = new Param(1, ParamType.STRING, this.userId);
            Param paramScope = new Param(71, ParamType.ENUM, (IsmInteger)new UnsignedInt32(0));
            List paramList = TLVUtils.paramList((Param[])new Param[]{paramUserId, paramScope});
            this.getOmConn().invoke(55847813122L, paramList);
            ToolLoggerFactory.getLogger(this.getClass()).info("OM_OPCODE_USER_LOGOUT cmd in" + this.connectedIp + " finished");
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("close connection error", (Throwable)e);
        }
        finally {
            this.connected = false;
            if (null != this.getOmConn()) {
                this.getOmConn().close();
                this.setOmConn(null);
            }
        }
    }
}

