/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.service.collect.dstorage.entity;

import com.huawei.ism.tool.service.collect.dstorage.entity.CollectConf;
import com.huawei.ism.tool.service.collect.dstorage.entity.CollectItem;
import com.huawei.ism.tool.service.collect.dstorage.entity.ModuleTaskDetail;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observer;
import java.util.stream.Collectors;

public class CollectModule {
    private static final Map<String, Mode> MODE_ROUTE = new HashMap<String, Mode>(){
        {
            this.put("log", Mode.POLL);
        }
    };
    private final List<CollectItem> items;
    private final String resultDir;
    private final ModuleTaskDetail detail;
    private final long startTime;
    private final long endTime;
    private final String id;
    private final Mode mode;

    public String getId() {
        return this.id;
    }

    CollectModule(List<CollectItem> items, String resultDir, long startTime, long endTime) {
        this.items = items;
        this.mode = MODE_ROUTE.get(items.get(0).getCollectModeId());
        this.id = items.get(0).getCollectModeId();
        this.resultDir = Paths.get(resultDir, this.id).toString();
        this.startTime = startTime;
        this.endTime = endTime;
        this.detail = new ModuleTaskDetail();
    }

    public Map<String, List<String>> buildMicroServe2ItemsIdMap() {
        return this.items.stream().filter(CollectItem::isSelect).collect(Collectors.groupingBy(CollectItem::getMicroservice, Collectors.mapping(CollectItem::getId, Collectors.toList())));
    }

    public static List<CollectModule> buildModule(List<CollectConf> configs, String resultDir, Observer obs, long startTime, long endTime) {
        return configs.stream().collect(Collectors.groupingBy(CollectConf::getClazz)).values().stream().map(confList -> confList.stream().map(CollectItem::new).collect(Collectors.toList())).map(items -> new CollectModule((List<CollectItem>)items, resultDir, startTime, endTime)).peek(module -> module.getDetail().addObserver(obs)).collect(Collectors.toList());
    }

    public boolean collectByTime() {
        return this.startTime != 0L && this.endTime != 0L;
    }

    public List<CollectItem> getItems() {
        return this.items;
    }

    public String getResultDir() {
        return this.resultDir;
    }

    public ModuleTaskDetail getDetail() {
        return this.detail;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public Mode getMode() {
        return this.mode;
    }

    public static enum Mode {
        POLL("poll");

        private final String key;

        private Mode(String key) {
            this.key = key;
        }

        public static Mode of(String srcKey) {
            return Arrays.stream(Mode.values()).filter(mode -> mode.key.equals(srcKey)).findFirst().orElse(POLL);
        }
    }
}

