/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.service.common.entity;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.service.common.entity.TaskDetail;
import com.huawei.ism.tool.service.rest.model.enumz.Status;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.stream.Collectors;

public class AggregationTaskDetail
extends TaskDetail {
    protected List<? extends TaskDetail> subTasks = new ArrayList<TaskDetail>();

    @Override
    public void update(Observable o, Object arg) {
        this.updateDetail();
    }

    @Override
    public void updateDetail() {
        this.updatePro();
        this.updateStatus();
        this.updateDescription();
        this.update();
    }

    public void setSubTasks(List<? extends TaskDetail> subTasks) {
        this.subTasks = subTasks;
    }

    protected void updateStatus() {
        if (this.subTasks.stream().allMatch(TaskDetail::isFinished)) {
            this.status = this.subTasks.stream().allMatch(TaskDetail::isSuccess) ? Status.SUCCESS : (this.subTasks.stream().allMatch(TaskDetail::isFailed) ? Status.FAILED : Status.PART_SUCCESS);
            this.changed = true;
            return;
        }
        if (this.subTasks.stream().anyMatch(TaskDetail::isRunning)) {
            this.status = Status.RUNNING;
        }
    }

    protected void updatePro() {
        int old = this.pro;
        this.pro = this.subTasks.stream().mapToInt(TaskDetail::getProgress).sum() / Math.max(this.subTasks.size(), 1);
        if (old == this.pro) {
            return;
        }
        this.changed = true;
    }

    protected void updateDescription() {
        if (!this.isFinished() || this.isSuccess()) {
            return;
        }
        List descriptions = this.subTasks.stream().map(TaskDetail::getDescription).filter(subTaskDetailDescription -> !StringUtils.isNULLStr((String)subTaskDetailDescription)).collect(Collectors.toList());
        if (descriptions.isEmpty()) {
            return;
        }
        this.description = String.join((CharSequence)";", descriptions);
        this.changed = true;
    }

    public void fail(String desc) {
        this.status = Status.FAILED;
        this.pro = 100;
        this.description = desc;
        this.changed = true;
        this.update();
    }
}

