/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.service.rest.service.device;

import com.huawei.ism.tool.obase.connection.MultiRouteNode;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.Base64EncodeUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.service.rest.common.DeviceObs;
import com.huawei.ism.tool.service.rest.model.Either;
import com.huawei.ism.tool.service.rest.model.entity.AuthClusterNode;
import com.huawei.ism.tool.service.rest.model.entity.vo.BatchAuthInfoVO;
import com.huawei.ism.tool.service.rest.model.enumz.Status;
import com.huawei.ism.tool.service.rest.service.device.RedfishConnectionManager;
import com.huawei.ism.tool.service.rest.service.device.SshProxyConfigService;
import com.huawei.ism.tool.service.rest.util.BusinessDeviceUtil;
import com.huawei.ism.util.Pair;
import com.huawei.uMate.common.rest.RedfishConnestion;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterAuthServer {
    private static final Logger log = LoggerFactory.getLogger(ClusterAuthServer.class);
    private static int maxAuthThreadNum = 20;
    public static final ClusterAuthServer INS;
    private final ExecutorService executor = Executors.newFixedThreadPool(maxAuthThreadNum);

    public synchronized boolean batchBmcAuth(BatchAuthInfoVO info) {
        try {
            BusinessDeviceUtil.INS.findBusinessDev(info.getDeviceSn()).get().getDevNode().getClusterNodes().stream().filter(info::isContainsTargetClusterNode).map(Either.lift(node -> this.buildBmcNodePairByClusterNode((ClusterNode)node, info))).filter(Either::isRight).map(Either::getRight).map(Optional::get).peek(nodePair -> ((AuthClusterNode)nodePair.getKey()).initBmcAuth()).forEach(cluster2DevPair -> this.submitTask((Pair<AuthClusterNode, DevNode>)cluster2DevPair, this::bmcAuth, this::syncBmcAuthResult2AuthClusterNode));
        }
        catch (Exception e) {
            log.error("Start batch bmc auth failed.");
            return false;
        }
        return true;
    }

    public synchronized boolean batchOsAuth(BatchAuthInfoVO info) {
        try {
            BusinessDeviceUtil.INS.findBusinessDev(info.getDeviceSn()).get().getDevNode().getClusterNodes().stream().filter(info::isContainsTargetClusterNode).map(Either.lift(node -> this.buildOsNodePairByClusterNode((ClusterNode)node, info))).filter(Either::isRight).map(Either::getRight).map(Optional::get).peek(nodePair -> ((AuthClusterNode)nodePair.getKey()).initOsAuth()).forEach(cluster2DevPair -> this.submitTask((Pair<AuthClusterNode, DevNode>)cluster2DevPair, this::osAuth, this::syncOsAuthResult2AuthClusterNode));
        }
        catch (Exception e) {
            log.error("Start batch os auth failed.", (Throwable)e);
            return false;
        }
        return true;
    }

    private CompletableFuture<Void> submitTask(Pair<AuthClusterNode, DevNode> nodePair, Function<Pair<AuthClusterNode, DevNode>, TaskResult> function, BiConsumer<TaskResult, AuthClusterNode> after) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> (TaskResult)function.apply(nodePair), this.executor).exceptionally(exception -> this.buildAuthFailedResult((Throwable)exception, (DevNode)nodePair.getValue()))).thenAccept(result -> after.accept((TaskResult)result, (AuthClusterNode)nodePair.getKey()));
    }

    private void syncOsAuthResult2AuthClusterNode(TaskResult result, AuthClusterNode authClusterNode) {
        DevNode clusterNode = (DevNode)result.getResultObject();
        authClusterNode.setOsUser(clusterNode.getLoginUser());
        authClusterNode.setOsRootUser(clusterNode.getRootUser());
        Status authStatus = Status.SUCCESS;
        String description = "";
        if (result.getResult() == TaskResult.Result.FAILED) {
            authStatus = Status.FAILED;
            description = result.getErrorLocaleDescription();
        }
        authClusterNode.setSshPort(clusterNode.getPort());
        authClusterNode.updateOsAuthStatus(authStatus, description);
    }

    private void syncBmcAuthResult2AuthClusterNode(TaskResult result, AuthClusterNode authClusterNode) {
        DevNode clusterNode = (DevNode)result.getResultObject();
        authClusterNode.setBmcUser(clusterNode.getLoginUser());
        Status authStatus = Status.SUCCESS;
        String description = "";
        if (result.getResult() == TaskResult.Result.FAILED) {
            authStatus = Status.FAILED;
            description = result.getErrorLocaleDescription();
        } else {
            authClusterNode.getNode().setBmcIp(clusterNode.getIp());
        }
        authClusterNode.setRedfishPort(clusterNode.getPort());
        authClusterNode.updateBmcAuthStatus(authStatus, description);
    }

    private TaskResult buildAuthFailedResult(Throwable throwable, DevNode node) {
        log.error("Cluster node {} auth exception", (Object)node.getIp(), (Object)throwable);
        TaskResult authResult = new TaskResult();
        authResult.setResult(TaskResult.Result.FAILED);
        authResult.setResultObject(node);
        authResult.setErrorLocaleDescription(ResourceUtil.getStringWithParams("device.cluster.auth.failed", node.getIp()));
        return authResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaskResult bmcAuth(Pair<AuthClusterNode, DevNode> pair) {
        TaskResult taskResult = new TaskResult();
        taskResult.setResultObject(pair.getValue());
        DevNode devNode = (DevNode)pair.getValue();
        ((AuthClusterNode)pair.getKey()).updateBmcAuthStatus(Status.RUNNING, "");
        try {
            this.buildRedfishConn(devNode);
            taskResult.setResult(TaskResult.Result.SUCCESS);
        }
        catch (Exception e) {
            log.error("Cluster node {} auth failed.", (Object)devNode.getIp(), (Object)e);
            taskResult.setResult(TaskResult.Result.FAILED);
            taskResult.setErrorLocaleDescription(ResourceUtil.getStringWithParams("device.cluster.auth.failed", devNode.getIp()));
        }
        finally {
            RedfishConnectionManager.INS.releaseConn(devNode);
        }
        return taskResult;
    }

    RedfishConnestion buildRedfishConn(DevNode devNode) throws ToolException {
        return RedfishConnectionManager.INS.getRedFishConnection(devNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaskResult osAuth(Pair<AuthClusterNode, DevNode> nodePair) {
        TaskResult taskResult = new TaskResult();
        AuthClusterNode authClusterNode = (AuthClusterNode)nodePair.getKey();
        DevNode node = (DevNode)nodePair.getValue();
        taskResult.setResultObject(node);
        ((AuthClusterNode)nodePair.getKey()).updateOsAuthStatus(Status.RUNNING, "");
        try {
            this.connOs(node);
            authClusterNode.setMinisystem(node.isMiniSystem());
            taskResult.setResult(TaskResult.Result.SUCCESS);
        }
        catch (ToolException e) {
            log.error("Cluster node {} auth failed.", (Object)node.getIp(), (Object)e);
            taskResult.setResult(TaskResult.Result.FAILED);
            taskResult.setErrorLocaleDescription(e.getErrorLocaleDescription());
        }
        finally {
            SshConnectionManager.releaseConnection(node);
        }
        return taskResult;
    }

    void connOs(DevNode node) throws ToolException {
        SshConnectionManager.getSshConnection(node);
    }

    private Pair<AuthClusterNode, DevNode> buildOsNodePairByClusterNode(ClusterNode clusterNode, BatchAuthInfoVO info) throws ToolException {
        Optional<AuthClusterNode> authClusterNode = BusinessDeviceUtil.INS.findClusterNodeByIp(info.getDeviceSn(), clusterNode.getManagementIp());
        if (!authClusterNode.isPresent()) {
            throw new ToolException("Can not find clusterNode", false);
        }
        return new Pair((Object)authClusterNode.get(), (Object)this.buildOsDevNode(clusterNode, info));
    }

    private Pair<AuthClusterNode, DevNode> buildBmcNodePairByClusterNode(ClusterNode clusterNode, BatchAuthInfoVO info) throws ToolException {
        Optional<AuthClusterNode> authClusterNode = BusinessDeviceUtil.INS.findClusterNodeByIp(info.getDeviceSn(), clusterNode.getManagementIp());
        if (!authClusterNode.isPresent()) {
            throw new ToolException("Can not find clusterNode", false);
        }
        return new Pair((Object)authClusterNode.get(), (Object)this.buildBmcDevNode(clusterNode, info));
    }

    private DevNode buildOsDevNode(ClusterNode clusterNode, BatchAuthInfoVO info) {
        DevNode devNode = new DevNode();
        devNode.setIp(clusterNode.getManagementIp());
        devNode.setDeviceSerialNumber(clusterNode.getSerialNumber());
        devNode.setLoginUser(info.getUser());
        if (info.getRootUser() != null) {
            devNode.setRootUser(new User(info.getRootUser().getUserName(), Base64EncodeUtils.encode(info.getRootUser().getPassword())));
        }
        if (-1 != info.getPort()) {
            devNode.setPort(info.getPort());
        }
        if (!StringUtils.isNULLStr(info.getProxyNodeId()) && !info.getProxyNodeId().equals("none")) {
            List<MultiRouteNode> sshForwardList = SshProxyConfigService.INS.getSSHRouteList(info.getProxyNodeId());
            clusterNode.setSshForwardList(sshForwardList);
            devNode.setSshForwardList(sshForwardList);
        }
        return devNode;
    }

    private DevNode buildBmcDevNode(ClusterNode clusterNode, BatchAuthInfoVO info) {
        DevNode devNode = new DevNode();
        if (StringUtils.isNULLStr(clusterNode.getBmcIp())) {
            int id = clusterNode.getId();
            info.getNodeList().stream().filter(nodeInfo -> nodeInfo.getId() == id).findFirst().ifPresent(nodeInfo -> devNode.setIp(nodeInfo.getIp()));
        } else {
            devNode.setIp(clusterNode.getBmcIp());
        }
        devNode.setDeviceSerialNumber(clusterNode.getSerialNumber());
        devNode.setLoginUser(info.getUser());
        if (-1 != info.getPort()) {
            devNode.setPort(info.getPort());
        }
        return devNode;
    }

    private ClusterAuthServer() {
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    static {
        try {
            String maxNum = DeviceObs.INS.getConfig().getString("cluster.auth.thread.num");
            maxAuthThreadNum = Integer.parseInt(maxNum);
        }
        catch (Exception e) {
            log.error("Init max auth thread num error,use default.");
        }
        log.info("Current max auth thread num {} .", (Object)maxAuthThreadNum);
        INS = new ClusterAuthServer();
    }
}

