/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.service.sanbox;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.enums.SandboxStatus;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.tool.protocol.utils.RestUtil;
import com.huawei.ism.tool.service.sanbox.ISandBoxService;
import com.huawei.json.JSONException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SandBoxService
implements ISandBoxService {
    private static final Logger log = LoggerFactory.getLogger(SandBoxService.class);
    private static final String SANDBOX_URL = "/api/v2/cluster/sandbox";
    private static final String SERVERS_URL = "/api/v2/cluster/servers";
    private static final int SUPPORT_DISABLE_CODE = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean querySupportDisabledSandbox(DevNode devNode) {
        try {
            ResponseInfo res = this.getRestConn(devNode).execGet(RestUtil.getDstorageUrlHead((DevNode)devNode) + SANDBOX_URL);
            this.checkResponseSuccess(res);
            boolean bl = JSON.parseObject((String)res.getContent()).getJSONObject("data").getIntValue("support_disable_sandbox") == 0;
            return bl;
        }
        catch (ToolException | JSONException e) {
            log.error("query cluster is support disable sandbox failed", e);
        }
        finally {
            RestConnectionManager.releaseConn((DevNode)devNode);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> batchOpenSandBox(DevNode devNode, List<String> nodeIps) {
        try {
            RestConnection restConn = this.getRestConn(devNode);
            ResponseInfo res = restConn.execPost(RestUtil.getDstorageUrlHead((DevNode)devNode) + SANDBOX_URL, this.buildOpenSandBoxParam(nodeIps));
            this.checkResponseValid(res);
            if (!res.isSuccess()) {
                restConn.reLogin();
                res = restConn.execPost(RestUtil.getDstorageUrlHead((DevNode)devNode) + SANDBOX_URL, this.buildOpenSandBoxParam(nodeIps));
            }
            this.checkResponseSuccess(res);
            List<String> list = this.parseSandboxResponse(res);
            return list;
        }
        catch (ToolException | JSONException e) {
            log.error("open sandbox failed.", e);
        }
        finally {
            RestConnectionManager.releaseConn((DevNode)devNode);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> batchCloseSandBox(DevNode devNode, List<String> nodeIps, String pass) {
        try {
            ResponseInfo res = this.getRestConn(devNode).execPost(RestUtil.getDstorageUrlHead((DevNode)devNode) + SANDBOX_URL, this.buildCloseSandBoxParam(devNode, nodeIps, pass));
            this.checkResponseSuccess(res);
            List<String> list = this.parseSandboxResponse(res);
            return list;
        }
        catch (ToolException | JSONException e) {
            log.error("close sandbox failed.", e);
        }
        finally {
            RestConnectionManager.releaseConn((DevNode)devNode);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, SandboxStatus> queryServersSandboxStatus(DevNode devNode) {
        try {
            ResponseInfo res = this.getRestConn(devNode).execGet(RestUtil.getDstorageUrlHead((DevNode)devNode) + SERVERS_URL);
            this.checkResponseSuccess(res);
            Map<String, SandboxStatus> map = this.parseServersResponse(res);
            return map;
        }
        catch (Exception e) {
            log.error("query servers sandbox status failed.", (Throwable)e);
        }
        finally {
            RestConnectionManager.releaseConn((DevNode)devNode);
        }
        return Collections.emptyMap();
    }

    @Override
    public void refreshClusterNodeSandbox(DevNode devNode) {
        Map<String, SandboxStatus> sandboxStatusMap = this.queryServersSandboxStatus(devNode);
        for (ClusterNode clusterNode : devNode.getClusterNodes()) {
            clusterNode.setSandboxStatus(sandboxStatusMap.getOrDefault(clusterNode.getManagementIp(), SandboxStatus.UNSUPPORTED));
        }
    }

    private RestConnection getRestConn(DevNode devNode) throws ToolException {
        RestConnection rest = RestConnectionManager.getRestConnection((DevNode)devNode);
        if (rest == null || !rest.isLogin()) {
            throw new ToolException("sandbox get rest failed.", false);
        }
        return rest;
    }

    private void checkResponseValid(ResponseInfo responseInfo) throws ToolException {
        if (responseInfo == null || MapUtils.isEmpty((Map)responseInfo.getContentMap()) && StringUtils.isNULLStr(responseInfo.getContent())) {
            throw new ToolException("device.cluster.auth.failed", false);
        }
    }

    private void checkResponseSuccess(ResponseInfo responseInfo) throws ToolException {
        if (!responseInfo.isSuccess()) {
            throw new ToolException("sandbox check response failed.", false);
        }
    }

    private List<String> parseSandboxResponse(ResponseInfo responseInfo) {
        JSONArray jsonArray = JSON.parseObject((String)responseInfo.getContent()).getJSONArray("data");
        ArrayList<String> successIps = new ArrayList<String>();
        for (Object nodeRes : jsonArray) {
            JSONObject nodeObject = JSON.parseObject((String)JSON.toJSONString(nodeRes));
            if (nodeObject.getIntValue("code") != 0) continue;
            successIps.add(nodeObject.getString("management_ip"));
        }
        return successIps;
    }

    private Map<String, SandboxStatus> parseServersResponse(ResponseInfo responseInfo) {
        JSONArray jsonArray = JSON.parseObject((String)responseInfo.getContent()).getJSONArray("data");
        HashMap<String, SandboxStatus> sandboxStatusMap = new HashMap<String, SandboxStatus>();
        for (Object nodeRes : jsonArray) {
            JSONObject nodeObject = JSON.parseObject((String)JSON.toJSONString(nodeRes));
            String manageIp = nodeObject.getString("management_ip");
            if (nodeObject.containsKey((Object)"sandbox_status")) {
                sandboxStatusMap.put(manageIp, SandboxStatus.getStatusByCode(nodeObject.getIntValue("sandbox_status")));
                continue;
            }
            sandboxStatusMap.put(manageIp, SandboxStatus.UNSUPPORTED);
        }
        return sandboxStatusMap;
    }

    private Map<String, Map<String, List<String>>> buildOpenSandBoxParam(List<String> nodeIps) {
        HashMap<String, Map<String, List<String>>> param = new HashMap<String, Map<String, List<String>>>();
        HashMap nodeIpsMap = new HashMap();
        nodeIpsMap.put("node_ips", nodeIps.stream().distinct().collect(Collectors.toList()));
        param.put("start", nodeIpsMap);
        return param;
    }

    private Map<String, Map<String, Object>> buildCloseSandBoxParam(DevNode devNode, List<String> nodeIps, String password) {
        HashMap<String, Map<String, Object>> param = new HashMap<String, Map<String, Object>>();
        HashMap<String, Object> detailMap = new HashMap<String, Object>();
        detailMap.put("node_ips", nodeIps);
        detailMap.put("root_password", password);
        detailMap.put("admin_password", devNode.getLoginUser().getPassword());
        param.put("stop", detailMap);
        return param;
    }
}

