/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.service.task.state.based.construct;

import com.huawei.ism.tool.service.task.state.based.Action;
import com.huawei.ism.tool.service.task.state.based.Condition;
import com.huawei.ism.tool.service.task.state.based.DefaultTaskExecutorFactory;
import com.huawei.ism.tool.service.task.state.based.TaskExecutorFactory;
import com.huawei.ism.tool.service.task.state.based.construct.BuilderHelper;
import com.huawei.ism.tool.service.task.state.based.construct.TaskExecutorFactoryBuilder;
import com.huawei.ism.tool.service.task.state.based.construct.TransitionErrPolicy;
import com.huawei.ism.tool.service.task.state.based.construct.TransitionStepHelper;
import com.huawei.ism.tool.service.task.state.based.exception.TaskExecutorBuilderException;
import com.huawei.ism.tool.service.task.state.based.transition.ChoicesTransitionPath;
import com.huawei.ism.tool.service.task.state.based.transition.SingleTransitionPath;
import com.huawei.ism.tool.service.task.state.based.transition.TransitionPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultTaskExecutorFactoryBuilder<S extends Enum<S>, E extends Enum<E>>
implements TaskExecutorFactoryBuilder<S, E>,
TaskExecutorFactoryBuilder.StateTypeStep<S, E>,
TaskExecutorFactoryBuilder.AvailableStatesStep<S, E>,
TaskExecutorFactoryBuilder.EventTypeStep<S, E>,
TaskExecutorFactoryBuilder.AvailableEventsStep<S, E>,
TaskExecutorFactoryBuilder.InitialOrTransitionsStep<S, E>,
TaskExecutorFactoryBuilder.AndStep<S, E>,
TaskExecutorFactoryBuilder.NewTransitionOrDefaultErrOrBuildStep<S, E> {
    private static final Logger log = LoggerFactory.getLogger(DefaultTaskExecutorFactoryBuilder.class);
    private String name;
    private Class<S> stateType;
    private Set<S> availableStates;
    private Class<E> eventType;
    private Set<E> availableEvents;
    private S defaultInitialState;
    private Map<S, Action<S, E>> initialActions;
    @Nullable
    private S defaultErrState;
    @Nullable
    private E defaultErrEvent;
    @Nullable
    private Condition<S, E> defaultErrCondition;
    @Nullable
    private Action<S, E> defaultErrAction;
    private Map<S, Map<E, List<TransitionStepHelper<S, E>>>> transitionHelpers;
    private Map<S, Map<E, TransitionPath<S, E>>> transitions;
    private Set<S> allTransitionStates;
    private Set<E> allTransitionEvents;
    private Set<S> allTransitionTargetStates;
    private final AtomicInteger transitionIdGenerator = new AtomicInteger(0);

    @Override
    public TaskExecutorFactoryBuilder.StateTypeStep<S, E> name(@NotNull String name) {
        this.checkFieldNotSet(this.name, "name");
        this.name = name;
        return this;
    }

    @Override
    public TaskExecutorFactoryBuilder.AvailableStatesStep<S, E> stateType(@NotNull Class<S> stateType) {
        this.checkFieldNotSet(this.stateType, "state type");
        this.stateType = stateType;
        this.initialActions = new EnumMap<S, Action<S, E>>(this.stateType);
        this.transitionHelpers = new EnumMap<S, Map<E, List<TransitionStepHelper<S, E>>>>(this.stateType);
        return this;
    }

    @Override
    public TaskExecutorFactoryBuilder.EventTypeStep<S, E> availableStates(@NotNull Set<S> states) {
        this.checkFieldNotSet(this.availableStates, "available states");
        this.availableStates = EnumSet.copyOf(states);
        return this;
    }

    @Override
    public TaskExecutorFactoryBuilder.EventTypeStep<S, E> allStateValuesAreAvailable() {
        this.checkFieldNotSet(this.availableStates, "available states");
        this.availableStates = EnumSet.allOf(this.stateType);
        return this;
    }

    @Override
    public TaskExecutorFactoryBuilder.AvailableEventsStep<S, E> eventType(@NotNull Class<E> eventType) {
        this.checkFieldNotSet(this.eventType, "event type");
        this.eventType = eventType;
        return this;
    }

    @Override
    public TaskExecutorFactoryBuilder.InitialStep<S, E> availableEvents(@NotNull Set<E> states) {
        this.checkFieldNotSet(this.availableEvents, "available events");
        this.availableEvents = EnumSet.copyOf(states);
        return this;
    }

    @Override
    public TaskExecutorFactoryBuilder.InitialStep<S, E> allEventValuesAreAvailable() {
        this.checkFieldNotSet(this.availableEvents, "available events");
        this.availableEvents = EnumSet.allOf(this.eventType);
        return this;
    }

    @Override
    public TaskExecutorFactoryBuilder.InitialOrTransitionsStep<S, E> initial(@NotNull S initialState, Action<S, E> initialAction) {
        this.checkStateAvailable(initialState);
        if (this.defaultInitialState == null) {
            this.defaultInitialState = initialState;
            this.initialActions.put(initialState, initialAction);
        } else {
            if (this.initialActions.containsKey(initialState)) {
                throw new TaskExecutorBuilderException("state [" + initialState + "] is already initial state");
            }
            this.initialActions.put(initialState, initialAction);
        }
        return this;
    }

    @Override
    public TaskExecutorFactoryBuilder.TransitionSourceStateStep<S, E> addTransitions() {
        return new TransitionStepHelper(this.transitionIdGenerator.incrementAndGet(), this);
    }

    @Override
    public TaskExecutorFactoryBuilder.TransitionTargetStateStep<S, E> from(@NotNull S source) {
        return this.addTransitions().from(source);
    }

    @Override
    public TaskExecutorFactoryBuilder.NewTransitionOrDefaultErrOrBuildStep<S, E> and() {
        return this;
    }

    @Override
    public TaskExecutorFactoryBuilder.DefaultTransitionErrStateStep<S, E> ifAnyTransitionErr() {
        return new DefaultErrTransitionHelper();
    }

    @Override
    public TaskExecutorFactory<S, E> build() {
        this.standardizeTransitions();
        this.checkStatesAndTransitionMatch();
        this.checkEventsAndTransitionMatch();
        DefaultTaskExecutorFactory<S, E> factory = new DefaultTaskExecutorFactory<S, E>(this.name, this.stateType, this.eventType, this.defaultInitialState, this.initialActions, this.transitions);
        log.info("build task executor factory: {}", factory);
        return factory;
    }

    private void standardizeTransitions() {
        this.transitions = new EnumMap<S, Map<E, TransitionPath<S, E>>>(this.stateType);
        this.allTransitionStates = EnumSet.noneOf(this.stateType);
        this.allTransitionEvents = EnumSet.noneOf(this.eventType);
        this.allTransitionTargetStates = EnumSet.noneOf(this.stateType);
        this.buildErrTransitions();
        this.transitionHelpers.forEach(this::standardizeEventTransitions);
    }

    private void buildErrTransitions() {
        this.transitionHelpers.values().stream().map(Map::values).flatMap(Collection::stream).flatMap(Collection::stream).filter(this::needErrTransition).map(this::buildErrTransition).forEach(this::addTransition);
    }

    private boolean needErrTransition(TransitionStepHelper<S, E> helper) {
        return helper.action != null && (helper.errPolicy == TransitionErrPolicy.RE_TRANSIT || this.defaultErrState != null && helper.errPolicy == TransitionErrPolicy.USE_DEFAULT_ERR_POLICY);
    }

    private TransitionStepHelper<S, E> buildErrTransition(TransitionStepHelper<S, E> helper) {
        if (helper.errPolicy == TransitionErrPolicy.RE_TRANSIT) {
            return new TransitionStepHelper<Object, Object>(helper.source, helper.errState, helper.errEvent, BuilderHelper.composeErrTransitCondition(helper.id, helper.errCondition), helper.errAction, null, null, null, null, TransitionErrPolicy.THROW_EXCEPTION, this.transitionIdGenerator.incrementAndGet(), this);
        }
        return new TransitionStepHelper<Object, Object>(helper.source, this.defaultErrState, this.defaultErrEvent, (Condition<Object, Object>)BuilderHelper.composeErrTransitCondition(helper.id, this.defaultErrCondition), (Action<Object, Object>)this.defaultErrAction, null, null, null, null, TransitionErrPolicy.THROW_EXCEPTION, this.transitionIdGenerator.incrementAndGet(), this);
    }

    private void standardizeEventTransitions(S source, Map<E, List<TransitionStepHelper<S, E>>> eventTransitions) {
        EnumMap sourceTransitions = new EnumMap(this.eventType);
        this.transitions.put(source, sourceTransitions);
        this.allTransitionStates.add(source);
        eventTransitions.forEach((event, transitions) -> this.standardize(source, (E)event, (List<TransitionStepHelper<S, E>>)transitions, sourceTransitions));
    }

    private void standardize(S source, E event, List<TransitionStepHelper<S, E>> transitions, EnumMap<E, TransitionPath<S, E>> sourceTransitions) {
        if (transitions.size() == 1) {
            TransitionStepHelper<S, E> transition = transitions.get(0);
            this.allTransitionStates.add(transition.target);
            this.allTransitionTargetStates.add(transition.target);
            this.allTransitionEvents.add(transition.event);
            sourceTransitions.put(event, new SingleTransitionPath<S, E>(transition.id, source, transition.target, event, transition.condition, transition.action, this.getTransitionErrEvent(transition)));
        } else {
            TransitionStepHelper<S, E> broadTransition = null;
            ArrayList choices = new ArrayList();
            for (TransitionStepHelper<S, E> transition : transitions) {
                if (broadTransition != null) {
                    throw new TaskExecutorBuilderException("unreachable transition (" + transition + ") found after a broad transition (" + broadTransition + ")");
                }
                if (transition.condition == null) {
                    broadTransition = transition;
                }
                this.allTransitionStates.add(transition.target);
                this.allTransitionTargetStates.add(transition.target);
                this.allTransitionEvents.add(transition.event);
                choices.add(new ChoicesTransitionPath.Choice(transition.id, transition.target, transition.condition, transition.action, this.getTransitionErrEvent(transition)));
            }
            sourceTransitions.put(event, new ChoicesTransitionPath<S, E>(source, event, choices));
        }
    }

    private E getTransitionErrEvent(TransitionStepHelper<S, E> transition) {
        switch (transition.errPolicy) {
            case RE_TRANSIT: {
                return transition.errEvent;
            }
            case USE_DEFAULT_ERR_POLICY: {
                return this.defaultErrEvent;
            }
        }
        return null;
    }

    private void checkStatesAndTransitionMatch() {
        EnumSet<S> delta = EnumSet.copyOf(this.availableStates);
        delta.removeAll(this.allTransitionStates);
        if (!delta.isEmpty()) {
            throw new TaskExecutorBuilderException("some available states are not bound in any transition: " + delta);
        }
        if (!this.transitions.containsKey(this.defaultInitialState)) {
            throw new TaskExecutorBuilderException("no transitions transit from initial state");
        }
        delta.addAll(this.availableStates);
        delta.removeAll(this.initialActions.keySet());
        delta.removeAll(this.allTransitionTargetStates);
        if (!delta.isEmpty()) {
            throw new TaskExecutorBuilderException("some non-initial states are not reachable by any transition: " + delta);
        }
    }

    private void checkEventsAndTransitionMatch() {
        EnumSet<E> delta = EnumSet.copyOf(this.availableEvents);
        delta.removeAll(this.allTransitionEvents);
        if (!delta.isEmpty()) {
            throw new TaskExecutorBuilderException("some available events are not bound in any transition: " + delta);
        }
    }

    void addTransition(TransitionStepHelper<S, E> transition) {
        this.transitionHelpers.computeIfAbsent(transition.source, ignoredSource -> new EnumMap(this.eventType)).computeIfAbsent(transition.event, ignoredEvent -> new ArrayList()).add(transition);
    }

    void checkFieldNotSet(Object fieldValue, String name) {
        this.checkFieldNotSet(fieldValue == null, name);
    }

    void checkFieldNotSet(boolean checkPass, String name) {
        if (!checkPass) {
            throw new TaskExecutorBuilderException("setting [" + name + "] is already set");
        }
    }

    void checkStateAvailable(S state) {
        if (!this.availableStates.contains(state)) {
            throw new TaskExecutorBuilderException("state [" + state + "] is not available");
        }
    }

    void checkEventAvailable(E event) {
        if (!this.availableEvents.contains(event)) {
            throw new TaskExecutorBuilderException("event [" + event + "] is not available");
        }
    }

    private class DefaultErrTransitionHelper
    implements TaskExecutorFactoryBuilder.DefaultTransitionErrStateStep<S, E>,
    TaskExecutorFactoryBuilder.DefaultTransitionErrEventStep<S, E>,
    TaskExecutorFactoryBuilder.DefaultErrTransitionConditionOrActionOrBuildStep<S, E>,
    TaskExecutorFactoryBuilder.DefaultErrTransitionActionOrBuildStep<S, E> {
        private DefaultErrTransitionHelper() {
        }

        @Override
        public TaskExecutorFactoryBuilder.DefaultTransitionErrEventStep<S, E> transitTo(@NotNull S errState) {
            DefaultTaskExecutorFactoryBuilder.this.checkFieldNotSet(DefaultTaskExecutorFactoryBuilder.this.defaultErrState, "default error state");
            DefaultTaskExecutorFactoryBuilder.this.checkStateAvailable(errState);
            DefaultTaskExecutorFactoryBuilder.this.defaultErrState = errState;
            return this;
        }

        @Override
        public TaskExecutorFactoryBuilder.DefaultErrTransitionConditionOrActionOrBuildStep<S, E> by(@NotNull E errEvent) {
            DefaultTaskExecutorFactoryBuilder.this.checkFieldNotSet(DefaultTaskExecutorFactoryBuilder.this.defaultErrEvent, "default error event");
            DefaultTaskExecutorFactoryBuilder.this.checkEventAvailable(errEvent);
            DefaultTaskExecutorFactoryBuilder.this.defaultErrEvent = errEvent;
            return this;
        }

        @Override
        public TaskExecutorFactoryBuilder.DefaultErrTransitionActionOrBuildStep<S, E> when(Condition<S, E> condition) {
            DefaultTaskExecutorFactoryBuilder.this.checkFieldNotSet(DefaultTaskExecutorFactoryBuilder.this.defaultErrCondition, "default error condition");
            DefaultTaskExecutorFactoryBuilder.this.defaultErrCondition = condition;
            return this;
        }

        @Override
        public TaskExecutorFactoryBuilder.BuildStep<S, E> exec(Action<S, E> action) {
            DefaultTaskExecutorFactoryBuilder.this.checkFieldNotSet(DefaultTaskExecutorFactoryBuilder.this.defaultErrAction, "default error action");
            DefaultTaskExecutorFactoryBuilder.this.defaultErrAction = action;
            return this;
        }

        @Override
        public TaskExecutorFactory<S, E> build() {
            return DefaultTaskExecutorFactoryBuilder.this.build();
        }
    }
}

