/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.its;

import java.io.IOException;
import java.io.OutputStream;
import org.python.bouncycastle.asn1.ASN1Encodable;
import org.python.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.python.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.python.bouncycastle.asn1.sec.SECObjectIdentifiers;
import org.python.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import org.python.bouncycastle.its.ITSCertificate;
import org.python.bouncycastle.its.ITSCertificateBuilder;
import org.python.bouncycastle.its.ITSPublicEncryptionKey;
import org.python.bouncycastle.its.ITSPublicVerificationKey;
import org.python.bouncycastle.its.operator.ECDSAEncoder;
import org.python.bouncycastle.its.operator.ITSContentSigner;
import org.python.bouncycastle.oer.OERDefinition;
import org.python.bouncycastle.oer.OEREncoder;
import org.python.bouncycastle.oer.its.Certificate;
import org.python.bouncycastle.oer.its.CertificateBase;
import org.python.bouncycastle.oer.its.CertificateId;
import org.python.bouncycastle.oer.its.CertificateType;
import org.python.bouncycastle.oer.its.HashAlgorithm;
import org.python.bouncycastle.oer.its.HashedId;
import org.python.bouncycastle.oer.its.IssuerIdentifier;
import org.python.bouncycastle.oer.its.Signature;
import org.python.bouncycastle.oer.its.ToBeSignedCertificate;
import org.python.bouncycastle.oer.its.VerificationKeyIndicator;
import org.python.bouncycastle.oer.its.template.IEEE1609dot2;
import org.python.bouncycastle.util.Arrays;

public class ITSExplicitCertificateBuilder
extends ITSCertificateBuilder {
    private final ITSContentSigner signer;

    public ITSExplicitCertificateBuilder(ITSContentSigner iTSContentSigner, ToBeSignedCertificate.Builder builder) {
        super(builder);
        this.signer = iTSContentSigner;
    }

    public ITSCertificate build(CertificateId certificateId, ITSPublicVerificationKey iTSPublicVerificationKey) {
        return this.build(certificateId, iTSPublicVerificationKey, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ITSCertificate build(CertificateId certificateId, ITSPublicVerificationKey iTSPublicVerificationKey, ITSPublicEncryptionKey iTSPublicEncryptionKey) {
        VerificationKeyIndicator verificationKeyIndicator;
        ToBeSignedCertificate.Builder builder = new ToBeSignedCertificate.Builder(this.tbsCertificateBuilder);
        builder.setCertificateId(certificateId);
        if (iTSPublicEncryptionKey != null) {
            builder.setEncryptionKey(iTSPublicEncryptionKey.toASN1Structure());
        }
        builder.setVerificationKeyIndicator(VerificationKeyIndicator.builder().publicVerificationKey(iTSPublicVerificationKey.toASN1Structure()).createVerificationKeyIndicator());
        ToBeSignedCertificate toBeSignedCertificate = builder.createToBeSignedCertificate();
        ToBeSignedCertificate toBeSignedCertificate2 = null;
        if (this.signer.isForSelfSigning()) {
            verificationKeyIndicator = toBeSignedCertificate.getVerificationKeyIndicator();
        } else {
            toBeSignedCertificate2 = this.signer.getAssociatedCertificate().toASN1Structure().getCertificateBase().getToBeSignedCertificate();
            verificationKeyIndicator = toBeSignedCertificate2.getVerificationKeyIndicator();
        }
        OutputStream outputStream = this.signer.getOutputStream();
        try {
            outputStream.write(OEREncoder.toByteArray((ASN1Encodable)toBeSignedCertificate, (OERDefinition.Element)IEEE1609dot2.tbsCertificate));
            outputStream.close();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("cannot produce certificate signature");
        }
        Signature signature = null;
        switch (verificationKeyIndicator.getChoice()) {
            case 0: {
                signature = ECDSAEncoder.toITS(SECObjectIdentifiers.secp256r1, this.signer.getSignature());
                break;
            }
            case 1: {
                signature = ECDSAEncoder.toITS(TeleTrusTObjectIdentifiers.brainpoolP256r1, this.signer.getSignature());
                break;
            }
            case 3: {
                signature = ECDSAEncoder.toITS(TeleTrusTObjectIdentifiers.brainpoolP384r1, this.signer.getSignature());
                break;
            }
            default: {
                throw new IllegalStateException("unknown key type");
            }
        }
        CertificateBase.Builder builder2 = new CertificateBase.Builder();
        IssuerIdentifier.Builder builder3 = IssuerIdentifier.builder();
        ASN1ObjectIdentifier aSN1ObjectIdentifier = this.signer.getDigestAlgorithm().getAlgorithm();
        if (this.signer.isForSelfSigning()) {
            if (aSN1ObjectIdentifier.equals(NISTObjectIdentifiers.id_sha256)) {
                builder3.self(HashAlgorithm.sha256);
            } else {
                if (!aSN1ObjectIdentifier.equals(NISTObjectIdentifiers.id_sha384)) throw new IllegalStateException("unknown digest");
                builder3.self(HashAlgorithm.sha384);
            }
        } else {
            byte[] byArray = this.signer.getAssociatedCertificateDigest();
            HashedId.HashedId8 hashedId8 = new HashedId.HashedId8(Arrays.copyOfRange(byArray, byArray.length - 8, byArray.length));
            if (aSN1ObjectIdentifier.equals(NISTObjectIdentifiers.id_sha256)) {
                builder3.sha256AndDigest((HashedId)hashedId8);
            } else {
                if (!aSN1ObjectIdentifier.equals(NISTObjectIdentifiers.id_sha384)) throw new IllegalStateException("unknown digest");
                builder3.sha384AndDigest((HashedId)hashedId8);
            }
        }
        builder2.setVersion(this.version);
        builder2.setType(CertificateType.Explicit);
        builder2.setIssuer(builder3.createIssuerIdentifier());
        builder2.setToBeSignedCertificate(toBeSignedCertificate);
        builder2.setSignature(signature);
        Certificate.Builder builder4 = new Certificate.Builder();
        builder4.setCertificateBase(builder2.createCertificateBase());
        return new ITSCertificate(builder4.createCertificate());
    }
}

