/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.api.Error;
import io.nats.client.support.ApiConstants;
import io.nats.client.support.JsonUtils;
import java.time.Duration;

abstract class SourceInfoBase {
    private final String name;
    private final long lag;
    private final Duration active;
    private final Error error;
    private final String objectName;

    SourceInfoBase(String json, String objectName) {
        this.name = JsonUtils.readString(json, ApiConstants.NAME_RE);
        this.lag = JsonUtils.readLong(json, ApiConstants.LAG_RE, 0L);
        this.active = JsonUtils.readNanos(json, ApiConstants.ACTIVE_RE, Duration.ZERO);
        this.error = Error.optionalInstance(json);
        this.objectName = JsonUtils.normalize(objectName);
    }

    public String getName() {
        return this.name;
    }

    public long getLag() {
        return this.lag;
    }

    public Duration getActive() {
        return this.active;
    }

    public Error getError() {
        return this.error;
    }

    public String toString() {
        return this.objectName + "{name='" + this.name + '\'' + ", lag=" + this.lag + ", active=" + this.active + ", " + JsonUtils.objectString("error", this.error) + '}';
    }
}

