/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.support.ByteArrayBuilder;
import io.nats.client.support.NatsConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;

public class Headers {
    private static final String KEY_CANNOT_BE_EMPTY_OR_NULL = "Header key cannot be null.";
    private static final String KEY_INVALID_CHARACTER = "Header key has invalid character: ";
    private static final String VALUE_INVALID_CHARACTERS = "Header value has invalid character: ";
    private final Map<String, List<String>> valuesMap = new HashMap<String, List<String>>();
    private final Map<String, Integer> lengthMap = new HashMap<String, Integer>();
    private byte[] serialized;
    private int dataLength;
    private static final int NON_DATA_BYTES = NatsConstants.HEADER_VERSION_BYTES_PLUS_CRLF.length + 2;

    public Headers() {
    }

    public Headers(Headers headers) {
        this();
        if (headers != null) {
            this.valuesMap.putAll(headers.valuesMap);
            this.lengthMap.putAll(headers.lengthMap);
            this.dataLength = headers.dataLength;
            this.serialized = null;
        }
    }

    public Headers add(String key, String ... values) {
        if (values != null) {
            this._add(key, Arrays.asList(values));
        }
        return this;
    }

    public Headers add(String key, Collection<String> values) {
        this._add(key, values);
        return this;
    }

    private void _add(String key, Collection<String> values) {
        Checker checked;
        if (values != null && (checked = new Checker(key, values)).hasValues()) {
            List currentSet = this.valuesMap.computeIfAbsent(key, k -> new ArrayList());
            currentSet.addAll(checked.list);
            this.dataLength += checked.len;
            int oldLen = this.lengthMap.getOrDefault(key, 0);
            this.lengthMap.put(key, oldLen + checked.len);
            this.serialized = null;
        }
    }

    public Headers put(String key, String ... values) {
        if (values != null) {
            this._put(key, Arrays.asList(values));
        }
        return this;
    }

    public Headers put(String key, Collection<String> values) {
        this._put(key, values);
        return this;
    }

    private void _put(String key, Collection<String> values) {
        Checker checked;
        if (key == null || key.length() == 0) {
            throw new IllegalArgumentException("Key cannot be null or empty.");
        }
        if (values != null && (checked = new Checker(key, values)).hasValues()) {
            this.dataLength = this.dataLength - this.lengthMap.getOrDefault(key, 0) + checked.len;
            this.valuesMap.put(key, checked.list);
            this.lengthMap.put(key, checked.len);
            this.serialized = null;
        }
    }

    public void remove(String ... keys) {
        for (String key : keys) {
            this._remove(key);
        }
        this.serialized = null;
    }

    public void remove(Collection<String> keys) {
        for (String key : keys) {
            this._remove(key);
        }
        this.serialized = null;
    }

    private void _remove(String key) {
        if (this.valuesMap.remove(key) != null) {
            this.dataLength -= this.lengthMap.remove(key).intValue();
        }
    }

    public int size() {
        return this.valuesMap.size();
    }

    public boolean isEmpty() {
        return this.valuesMap.isEmpty();
    }

    public void clear() {
        this.valuesMap.clear();
        this.lengthMap.clear();
        this.dataLength = 0;
        this.serialized = null;
    }

    public boolean containsKey(String key) {
        return this.valuesMap.containsKey(key);
    }

    public boolean containsKeyIgnoreCase(String key) {
        for (String k : this.valuesMap.keySet()) {
            if (!k.equalsIgnoreCase(key)) continue;
            return true;
        }
        return false;
    }

    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.valuesMap.keySet());
    }

    public Set<String> keySetIgnoreCase() {
        HashSet<String> set = new HashSet<String>();
        for (String k : this.valuesMap.keySet()) {
            set.add(k.toLowerCase());
        }
        return Collections.unmodifiableSet(set);
    }

    public List<String> get(String key) {
        List<String> values = this.valuesMap.get(key);
        return values == null ? null : Collections.unmodifiableList(values);
    }

    public String getFirst(String key) {
        List<String> values = this.valuesMap.get(key);
        return values == null ? null : values.get(0);
    }

    public List<String> getIgnoreCase(String key) {
        ArrayList values = new ArrayList();
        for (String k : this.valuesMap.keySet()) {
            if (!k.equalsIgnoreCase(key)) continue;
            values.addAll(this.valuesMap.get(k));
        }
        return values.size() == 0 ? null : Collections.unmodifiableList(values);
    }

    public void forEach(BiConsumer<String, List<String>> action) {
        Collections.unmodifiableMap(this.valuesMap).forEach(action);
    }

    public Set<Map.Entry<String, List<String>>> entrySet() {
        return Collections.unmodifiableSet(this.valuesMap.entrySet());
    }

    public boolean isDirty() {
        return this.serialized == null;
    }

    public int serializedLength() {
        return this.dataLength + NON_DATA_BYTES;
    }

    public byte[] getSerialized() {
        if (this.serialized == null) {
            this.serialized = this.appendSerialized(new ByteArrayBuilder(this.dataLength + NON_DATA_BYTES)).toByteArray();
        }
        return this.serialized;
    }

    public ByteArrayBuilder appendSerialized(ByteArrayBuilder bab) {
        bab.append(NatsConstants.HEADER_VERSION_BYTES_PLUS_CRLF);
        for (String key : this.valuesMap.keySet()) {
            for (String value : this.valuesMap.get(key)) {
                bab.append(key);
                bab.append(NatsConstants.COLON_BYTES);
                bab.append(value);
                bab.append(NatsConstants.CRLF_BYTES);
            }
        }
        bab.append(NatsConstants.CRLF_BYTES);
        return bab;
    }

    private void checkKey(String key) {
        if (key == null || key.length() == 0) {
            throw new IllegalArgumentException(KEY_CANNOT_BE_EMPTY_OR_NULL);
        }
        int len = key.length();
        for (int idx = 0; idx < len; ++idx) {
            char c = key.charAt(idx);
            if (c >= '!' && c <= '~' && c != ':') continue;
            throw new IllegalArgumentException("Header key has invalid character: '" + c + "'");
        }
    }

    private void checkValue(String val) {
        val.chars().forEach((int c) -> {
            if (c < 32 && c != 9 || c > 126) {
                throw new IllegalArgumentException(VALUE_INVALID_CHARACTERS + c);
            }
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Headers headers = (Headers)o;
        return Objects.equals(this.valuesMap, headers.valuesMap);
    }

    public int hashCode() {
        return Objects.hash(this.valuesMap);
    }

    private class Checker {
        List<String> list = new ArrayList<String>();
        int len = 0;

        Checker(String key, Collection<String> values) {
            Headers.this.checkKey(key);
            if (!values.isEmpty()) {
                for (String val : values) {
                    if (val == null) continue;
                    if (val.isEmpty()) {
                        this.list.add(val);
                        this.len += key.length() + 3;
                        continue;
                    }
                    Headers.this.checkValue(val);
                    this.list.add(val);
                    this.len += key.length() + val.length() + 3;
                }
            }
        }

        boolean hasValues() {
            return this.list.size() > 0;
        }
    }
}

