/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.drop.util.file;

import com.huawei.ism.tool.certbase.integrity.CheckFileIntegrityUtils;
import com.huawei.smartkit.drop.util.file.FilePathUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileIntegrityUtils {
    private static final Logger log = LoggerFactory.getLogger(FileIntegrityUtils.class);

    public static synchronized boolean checkFileByCms(String caPath, String sourcePath, String signPath) {
        String caNormalPath = FilePathUtils.getCanonicalPath(caPath).orElse("");
        String sourceNormalPath = FilePathUtils.getCanonicalPath(sourcePath).orElse("");
        String signNormalPath = FilePathUtils.getCanonicalPath(signPath).orElse("");
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{caNormalPath, sourceNormalPath, signNormalPath})) {
            log.error("to verify file,sign and cert not exists");
            return false;
        }
        return CheckFileIntegrityUtils.checkFileReleaseSignByCms((String)signNormalPath, (String)sourceNormalPath, (String)caNormalPath);
    }

    private FileIntegrityUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

