/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.crypto;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.owasp.esapi.crypto.CryptoHelper;

public final class PlainText
implements Serializable {
    private static final long serialVersionUID = 20090921L;
    private static Logger logger = ESAPI.getLogger("PlainText");
    private byte[] rawBytes = null;

    public PlainText(String str) {
        try {
            if (str == null) {
                throw new IllegalArgumentException("String for plaintext may not be null!");
            }
            this.rawBytes = str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error(Logger.EVENT_FAILURE, "PlainText(String) CTOR failed: Can't find UTF-8 byte-encoding!", e);
        }
    }

    public PlainText(byte[] b) {
        if (b == null) {
            throw new IllegalArgumentException("Byte array representing plaintext cannot be null.");
        }
        this.rawBytes = new byte[b.length];
        System.arraycopy(b, 0, this.rawBytes, 0, b.length);
    }

    public String toString() {
        try {
            return new String(this.rawBytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error(Logger.EVENT_FAILURE, "PlainText.toString() failed: Can't find UTF-8 byte-encoding!", e);
            return "";
        }
    }

    public byte[] asBytes() {
        byte[] bytes = new byte[this.rawBytes.length];
        System.arraycopy(this.rawBytes, 0, bytes, 0, this.rawBytes.length);
        return bytes;
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject == null) {
            return false;
        }
        boolean result = false;
        if (anObject instanceof PlainText) {
            PlainText that = (PlainText)anObject;
            result = that.canEqual(this) && this.toString().equals(that.toString());
        }
        return result;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public int length() {
        return this.rawBytes.length;
    }

    public void overwrite() {
        CryptoHelper.overwrite(this.rawBytes);
    }

    protected boolean canEqual(Object other) {
        return other instanceof PlainText;
    }
}

