/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.reference;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.PropNames;
import org.owasp.esapi.SecurityConfiguration;
import org.owasp.esapi.configuration.EsapiPropertyManager;
import org.owasp.esapi.errors.ConfigurationException;
import org.owasp.esapi.util.CsvString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSecurityConfiguration
implements SecurityConfiguration {
    private static volatile SecurityConfiguration instance = null;
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSecurityConfiguration.class);
    @Deprecated
    public static final String HIS_LOGIC = "Encryptor.UseHistoryLogic";
    private Properties properties = new Properties();
    private String cipherXformFromESAPIProp = null;
    private String cipherXformCurrent = null;
    @Deprecated
    public static final String DEFAULT_RESOURCE_FILE = "ESAPI.properties";
    @Deprecated
    public static final String REMEMBER_TOKEN_DURATION = "Authenticator.RememberTokenDuration";
    @Deprecated
    public static final String IDLE_TIMEOUT_DURATION = "Authenticator.IdleTimeoutDuration";
    @Deprecated
    public static final String ABSOLUTE_TIMEOUT_DURATION = "Authenticator.AbsoluteTimeoutDuration";
    @Deprecated
    public static final String ALLOWED_LOGIN_ATTEMPTS = "Authenticator.AllowedLoginAttempts";
    @Deprecated
    public static final String USERNAME_PARAMETER_NAME = "Authenticator.UsernameParameterName";
    @Deprecated
    public static final String PASSWORD_PARAMETER_NAME = "Authenticator.PasswordParameterName";
    @Deprecated
    public static final String MAX_OLD_PASSWORD_HASHES = "Authenticator.MaxOldPasswordHashes";
    @Deprecated
    public static final String ALLOW_MULTIPLE_ENCODING = "Encoder.AllowMultipleEncoding";
    @Deprecated
    public static final String ALLOW_MIXED_ENCODING = "Encoder.AllowMixedEncoding";
    @Deprecated
    public static final String CANONICALIZATION_CODECS = "Encoder.DefaultCodecList";
    @Deprecated
    public static final String DISABLE_INTRUSION_DETECTION = "IntrusionDetector.Disable";
    @Deprecated
    public static final String MASTER_KEY = "Encryptor.MasterKey";
    @Deprecated
    public static final String MASTER_SALT = "Encryptor.MasterSalt";
    @Deprecated
    public static final String KEY_LENGTH = "Encryptor.EncryptionKeyLength";
    @Deprecated
    public static final String ENCRYPTION_ALGORITHM = "Encryptor.EncryptionAlgorithm";
    @Deprecated
    public static final String HASH_ALGORITHM = "Encryptor.HashAlgorithm";
    @Deprecated
    public static final String HASH_ITERATIONS = "Encryptor.HashIterations";
    @Deprecated
    public static final String CHARACTER_ENCODING = "Encryptor.CharacterEncoding";
    @Deprecated
    public static final String RANDOM_ALGORITHM = "Encryptor.RandomAlgorithm";
    @Deprecated
    public static final String DIGITAL_SIGNATURE_ALGORITHM = "Encryptor.DigitalSignatureAlgorithm";
    @Deprecated
    public static final String DIGITAL_SIGNATURE_KEY_LENGTH = "Encryptor.DigitalSignatureKeyLength";
    @Deprecated
    public static final String PREFERRED_JCE_PROVIDER = "Encryptor.PreferredJCEProvider";
    @Deprecated
    public static final String CIPHER_TRANSFORMATION_IMPLEMENTATION = "Encryptor.CipherTransformation";
    @Deprecated
    public static final String CIPHERTEXT_USE_MAC = "Encryptor.CipherText.useMAC";
    @Deprecated
    public static final String PLAINTEXT_OVERWRITE = "Encryptor.PlainText.overwrite";
    @Deprecated
    public static final String IV_TYPE = "Encryptor.ChooseIVMethod";
    @Deprecated
    public static final String COMBINED_CIPHER_MODES = "Encryptor.cipher_modes.combined_modes";
    @Deprecated
    public static final String ADDITIONAL_ALLOWED_CIPHER_MODES = "Encryptor.cipher_modes.additional_allowed";
    public static final String RANDOM_GENERATOR = "Encryptor.random.generator";
    @Deprecated
    public static final String KDF_PRF_ALG = "Encryptor.KDF.PRF";
    @Deprecated
    public static final String PRINT_PROPERTIES_WHEN_LOADED = "ESAPI.printProperties";
    @Deprecated
    public static final String WORKING_DIRECTORY = "Executor.WorkingDirectory";
    @Deprecated
    public static final String APPROVED_EXECUTABLES = "Executor.ApprovedExecutables";
    @Deprecated
    public static final String FORCE_HTTPONLYSESSION = "HttpUtilities.ForceHttpOnlySession";
    @Deprecated
    public static final String FORCE_SECURESESSION = "HttpUtilities.SecureSession";
    @Deprecated
    public static final String FORCE_HTTPONLYCOOKIES = "HttpUtilities.ForceHttpOnlyCookies";
    @Deprecated
    public static final String FORCE_SECURECOOKIES = "HttpUtilities.ForceSecureCookies";
    @Deprecated
    public static final String MAX_HTTP_HEADER_SIZE = "HttpUtilities.MaxHeaderSize";
    @Deprecated
    public static final String UPLOAD_DIRECTORY = "HttpUtilities.UploadDir";
    @Deprecated
    public static final String UPLOAD_TEMP_DIRECTORY = "HttpUtilities.UploadTempDir";
    @Deprecated
    public static final String APPROVED_UPLOAD_EXTENSIONS = "HttpUtilities.ApprovedUploadExtensions";
    @Deprecated
    public static final String MAX_UPLOAD_FILE_BYTES = "HttpUtilities.MaxUploadFileBytes";
    @Deprecated
    public static final String RESPONSE_CONTENT_TYPE = "HttpUtilities.ResponseContentType";
    @Deprecated
    public static final String HTTP_SESSION_ID_NAME = "HttpUtilities.HttpSessionIdName";
    @Deprecated
    public static final String APPLICATION_NAME = "Logger.ApplicationName";
    @Deprecated
    public static final String LOG_ENCODING_REQUIRED = "Logger.LogEncodingRequired";
    @Deprecated
    public static final String LOG_APPLICATION_NAME = "Logger.LogApplicationName";
    @Deprecated
    public static final String LOG_SERVER_IP = "Logger.LogServerIP";
    @Deprecated
    public static final String LOG_USER_INFO = "Logger.UserInfo";
    @Deprecated
    public static final String LOG_CLIENT_INFO = "Logger.ClientInfo";
    @Deprecated
    public static final String VALIDATION_PROPERTIES = "Validator.ConfigurationFile";
    @Deprecated
    public static final String VALIDATION_PROPERTIES_MULTIVALUED = "Validator.ConfigurationFile.MultiValued";
    @Deprecated
    public static final String ACCEPT_LENIENT_DATES = "Validator.AcceptLenientDates";
    @Deprecated
    public static final String VALIDATOR_HTML_VALIDATION_ACTION = "Validator.HtmlValidationAction";
    @Deprecated
    public static final String VALIDATOR_HTML_VALIDATION_CONFIGURATION_FILE = "Validator.HtmlValidationConfigurationFile";
    @Deprecated
    public static final String DISCARD_LOGSPECIAL = "org.owasp.esapi.logSpecial.discard";
    @Deprecated
    private static final String logSpecialValue = System.getProperty("org.owasp.esapi.logSpecial.discard", "false");
    protected final int MAX_REDIRECT_LOCATION = 1000;
    @Deprecated
    public static final String LOG_IMPLEMENTATION = "ESAPI.Logger";
    @Deprecated
    public static final String AUTHENTICATION_IMPLEMENTATION = "ESAPI.Authenticator";
    @Deprecated
    public static final String ENCODER_IMPLEMENTATION = "ESAPI.Encoder";
    @Deprecated
    public static final String ACCESS_CONTROL_IMPLEMENTATION = "ESAPI.AccessControl";
    @Deprecated
    public static final String ENCRYPTION_IMPLEMENTATION = "ESAPI.Encryptor";
    @Deprecated
    public static final String INTRUSION_DETECTION_IMPLEMENTATION = "ESAPI.IntrusionDetector";
    @Deprecated
    public static final String RANDOMIZER_IMPLEMENTATION = "ESAPI.Randomizer";
    @Deprecated
    public static final String EXECUTOR_IMPLEMENTATION = "ESAPI.Executor";
    @Deprecated
    public static final String VALIDATOR_IMPLEMENTATION = "ESAPI.Validator";
    @Deprecated
    public static final String HTTP_UTILITIES_IMPLEMENTATION = "ESAPI.HTTPUtilities";
    public static final String USER_ADAPTER = "ESAPI.UserAdapter";
    @Deprecated
    public static final String DEFAULT_LOG_IMPLEMENTATION = "org.owasp.esapi.logging.java.JavaLogFactory";
    @Deprecated
    public static final String DEFAULT_AUTHENTICATION_IMPLEMENTATION = "org.owasp.esapi.reference.FileBasedAuthenticator";
    @Deprecated
    public static final String DEFAULT_ENCODER_IMPLEMENTATION = "org.owasp.esapi.reference.DefaultEncoder";
    @Deprecated
    public static final String DEFAULT_ACCESS_CONTROL_IMPLEMENTATION = "org.owasp.esapi.reference.DefaultAccessController";
    @Deprecated
    public static final String DEFAULT_ENCRYPTION_IMPLEMENTATION = "org.owasp.esapi.reference.crypto.JavaEncryptor";
    @Deprecated
    public static final String DEFAULT_INTRUSION_DETECTION_IMPLEMENTATION = "org.owasp.esapi.reference.DefaultIntrusionDetector";
    @Deprecated
    public static final String DEFAULT_RANDOMIZER_IMPLEMENTATION = "org.owasp.esapi.reference.DefaultRandomizer";
    @Deprecated
    public static final String DEFAULT_EXECUTOR_IMPLEMENTATION = "org.owasp.esapi.reference.DefaultExecutor";
    @Deprecated
    public static final String DEFAULT_HTTP_UTILITIES_IMPLEMENTATION = "org.owasp.esapi.reference.DefaultHTTPUtilities";
    @Deprecated
    public static final String DEFAULT_VALIDATOR_IMPLEMENTATION = "org.owasp.esapi.reference.DefaultValidator";
    private static final Map<String, Pattern> patternCache = new HashMap<String, Pattern>();
    private static String userHome = System.getProperty("user.home");
    private static String customDirectory = System.getProperty("org.owasp.esapi.resources");
    private String resourceDirectory = ".esapi";
    private final String resourceFile;
    private EsapiPropertyManager esapiPropertyManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SecurityConfiguration getInstance() {
        if (instance != null) return instance;
        Class<DefaultSecurityConfiguration> clazz = DefaultSecurityConfiguration.class;
        synchronized (DefaultSecurityConfiguration.class) {
            if (instance != null) return instance;
            instance = new DefaultSecurityConfiguration();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    DefaultSecurityConfiguration(String resourceFile) {
        this.resourceFile = resourceFile;
        try {
            this.esapiPropertyManager = new EsapiPropertyManager();
            customDirectory = customDirectory == null ? System.getProperty("org.owasp.esapi.resources") : customDirectory;
            userHome = userHome == null ? System.getProperty("user.home") : userHome;
            this.loadConfiguration();
            this.setCipherXProperties();
        }
        catch (IOException e) {
            this.logSpecial("Failed to load security configuration", e);
            throw new ConfigurationException("Failed to load security configuration", e);
        }
    }

    public DefaultSecurityConfiguration(Properties properties) {
        this.resourceFile = DEFAULT_RESOURCE_FILE;
        try {
            this.esapiPropertyManager = new EsapiPropertyManager();
        }
        catch (IOException e) {
            this.logSpecial("Failed to load security configuration", e);
            throw new ConfigurationException("Failed to load security configuration", e);
        }
        this.properties = properties;
        this.setCipherXProperties();
    }

    public DefaultSecurityConfiguration() {
        this(DEFAULT_RESOURCE_FILE);
    }

    private void setCipherXProperties() {
        this.cipherXformCurrent = this.cipherXformFromESAPIProp = this.getESAPIProperty(CIPHER_TRANSFORMATION_IMPLEMENTATION, "AES/GCM/NoPadding");
    }

    @Override
    public String getApplicationName() {
        return this.getESAPIProperty(APPLICATION_NAME, "DefaultName");
    }

    @Override
    public String getLogImplementation() {
        String esapiProperty = this.getESAPIProperty(LOG_IMPLEMENTATION, DEFAULT_LOG_IMPLEMENTATION);
        if (!"org.owasp.esapi.logging.slf4j.Slf4JLogFactory".equals(esapiProperty) && !DEFAULT_LOG_IMPLEMENTATION.equals(esapiProperty)) {
            this.logSpecial("Invalid class path, use default.");
            esapiProperty = DEFAULT_LOG_IMPLEMENTATION;
        }
        return esapiProperty;
    }

    @Override
    public String getAuthenticationImplementation() {
        return this.getESAPIProperty(AUTHENTICATION_IMPLEMENTATION, DEFAULT_AUTHENTICATION_IMPLEMENTATION);
    }

    @Override
    public String getEncoderImplementation() {
        return this.getESAPIProperty(ENCODER_IMPLEMENTATION, DEFAULT_ENCODER_IMPLEMENTATION);
    }

    @Override
    public String getAccessControlImplementation() {
        return this.getESAPIProperty(ACCESS_CONTROL_IMPLEMENTATION, DEFAULT_ACCESS_CONTROL_IMPLEMENTATION);
    }

    @Override
    public String getEncryptionImplementation() {
        return this.getESAPIProperty(ENCRYPTION_IMPLEMENTATION, DEFAULT_ENCRYPTION_IMPLEMENTATION);
    }

    @Override
    public String getIntrusionDetectionImplementation() {
        return this.getESAPIProperty(INTRUSION_DETECTION_IMPLEMENTATION, DEFAULT_INTRUSION_DETECTION_IMPLEMENTATION);
    }

    @Override
    public String getRandomizerImplementation() {
        return this.getESAPIProperty(RANDOMIZER_IMPLEMENTATION, DEFAULT_RANDOMIZER_IMPLEMENTATION);
    }

    @Override
    public String getExecutorImplementation() {
        return this.getESAPIProperty(EXECUTOR_IMPLEMENTATION, DEFAULT_EXECUTOR_IMPLEMENTATION);
    }

    @Override
    public String getHTTPUtilitiesImplementation() {
        return this.getESAPIProperty(HTTP_UTILITIES_IMPLEMENTATION, DEFAULT_HTTP_UTILITIES_IMPLEMENTATION);
    }

    @Override
    public String getValidationImplementation() {
        return this.getESAPIProperty(VALIDATOR_IMPLEMENTATION, DEFAULT_VALIDATOR_IMPLEMENTATION);
    }

    @Override
    public byte[] getMasterKey() {
        byte[] key = this.getESAPIPropertyEncoded(MASTER_KEY, null);
        return key;
    }

    @Override
    public void setResourceDirectory(String dir) {
        this.resourceDirectory = dir;
        this.logSpecial("Reset resource directory to: " + dir, null);
        try {
            this.loadConfiguration();
        }
        catch (IOException e) {
            this.logSpecial("Failed to load security configuration from " + dir, e);
        }
    }

    @Override
    public int getEncryptionKeyLength() {
        return this.getESAPIProperty(KEY_LENGTH, 256);
    }

    @Override
    public byte[] getMasterSalt() {
        byte[] salt = this.getESAPIPropertyEncoded(MASTER_SALT, null);
        return salt;
    }

    @Override
    public List<String> getAllowedExecutables() {
        String def = "";
        String[] exList = this.getESAPIProperty(APPROVED_EXECUTABLES, def).split(",");
        return Arrays.asList(exList);
    }

    @Override
    public List<String> getAllowedFileExtensions() {
        String def = ".pdf,.txt,.jpg,.png";
        String[] extList = this.getESAPIProperty(APPROVED_UPLOAD_EXTENSIONS, def).split(",");
        return Arrays.asList(extList);
    }

    @Override
    public int getAllowedFileUploadSize() {
        return this.getESAPIProperty(MAX_UPLOAD_FILE_BYTES, 5000000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadPropertiesFromStream(InputStream is, String name) throws IOException {
        Properties config = new Properties();
        try {
            config.load(is);
            this.checkDeprecatedConfigurations(config);
            this.logSpecial("Loaded '" + name + "' properties file", null);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return config;
    }

    private void checkDeprecatedConfigurations(Properties config) {
        String useHistoryLogic = config.getProperty(HIS_LOGIC);
        if ("true".equalsIgnoreCase(useHistoryLogic) || "yes".equalsIgnoreCase(useHistoryLogic)) {
            LOG.warn("[ESAPI] The old algorithm is insecure, please use the new derived key algorithm as soon as possible.");
        }
    }

    protected void loadConfiguration() throws IOException {
        try {
            this.logSpecial("Attempting to load " + this.resourceFile + " via file I/O.");
            this.properties = this.loadPropertiesFromStream(this.getResourceStream(this.resourceFile), this.resourceFile);
        }
        catch (Exception iae) {
            this.logSpecial("Loading " + this.resourceFile + " via file I/O failed. Exception was: " + iae);
            this.logSpecial("Attempting to load " + this.resourceFile + " via the classpath.");
            try {
                this.properties = this.loadConfigurationFromClasspath(this.resourceFile);
            }
            catch (Exception e) {
                this.logSpecial(this.resourceFile + " could not be loaded by any means. Fail.", e);
            }
        }
        if (this.properties != null) {
            boolean multivalued = this.getESAPIProperty(VALIDATION_PROPERTIES_MULTIVALUED, false);
            String validationPropValue = this.getESAPIProperty(VALIDATION_PROPERTIES, "validation.properties");
            CsvString csvString = new CsvString();
            Iterator<String> validationPropFileNames = multivalued ? csvString.getCsvStringList(validationPropValue).iterator() : Collections.singletonList(validationPropValue).iterator();
            patternCache.clear();
            while (validationPropFileNames.hasNext()) {
                String validationPropFileName = validationPropFileNames.next();
                Properties validationProperties = null;
                try {
                    this.logSpecial("Attempting to load " + validationPropFileName + " via file I/O.");
                    validationProperties = this.loadPropertiesFromStream(this.getResourceStream(validationPropFileName), validationPropFileName);
                }
                catch (Exception iae) {
                    this.logSpecial("Loading " + validationPropFileName + " via file I/O failed.");
                    this.logSpecial("Attempting to load " + validationPropFileName + " via the classpath.");
                    try {
                        validationProperties = this.loadConfigurationFromClasspath(validationPropFileName);
                    }
                    catch (Exception exception) {
                        this.logSpecial(validationPropFileName + " could not be loaded by any means. fail.", exception);
                    }
                }
                if (validationProperties != null) {
                    for (String string : validationProperties.keySet()) {
                        String value = validationProperties.getProperty(string);
                        this.properties.setProperty(string, value);
                    }
                }
                if (!this.shouldPrintProperties()) continue;
                this.logSpecial("DefaultSecurityConfiguration: The code to print all the properties is currently commented out");
            }
        }
    }

    @Override
    public InputStream getResourceStream(String filename) throws IOException {
        if (filename == null) {
            return null;
        }
        try {
            File f = this.getResourceFile(filename);
            if (f != null && f.exists()) {
                return new FileInputStream(f);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new FileNotFoundException();
    }

    @Override
    public File getResourceFile(String filename) {
        File f1;
        this.logSpecial("Attempting to load " + filename + " as resource file via file I/O.");
        if (filename == null) {
            this.logSpecial("Failed to load properties via FileIO. Filename is null.");
            return null;
        }
        File f = null;
        f = new File(customDirectory, filename);
        if (customDirectory != null && f.canRead()) {
            this.logSpecial("Found in 'org.owasp.esapi.resources' directory: " + f.getAbsolutePath());
            return f;
        }
        this.logSpecial("Not found in 'org.owasp.esapi.resources' directory or file not readable: " + f.getAbsolutePath());
        URL fileUrl = ClassLoader.getSystemResource(this.resourceDirectory + "/" + filename);
        if (fileUrl == null) {
            fileUrl = ClassLoader.getSystemResource("esapi/" + filename);
        }
        if (fileUrl == null) {
            fileUrl = this.getClass().getClassLoader().getResource("esapi/" + filename);
        }
        if ((f1 = this.getFileLocation(filename, fileUrl)) != null && f1.canRead()) {
            return f1;
        }
        String homeDir = userHome;
        if (homeDir == null) {
            homeDir = "";
        }
        if ((f = new File(homeDir + "/.esapi", filename)).canRead()) {
            this.logSpecial("[Compatibility] Found in 'user.home' directory: " + f.getAbsolutePath());
            return f;
        }
        f = new File(homeDir + "/esapi", filename);
        if (f.canRead()) {
            this.logSpecial("Found in 'user.home' directory: " + f.getAbsolutePath());
            return f;
        }
        this.logSpecial("Not found in 'user.home' (" + homeDir + ") directory: " + f.getAbsolutePath());
        return null;
    }

    private File getFileLocation(String filename, URL fileUrl) {
        File file = null;
        if (fileUrl != null) {
            try {
                String fileLocation = fileUrl.toURI().getPath();
                if (fileLocation == null) {
                    fileLocation = fileUrl.getFile();
                }
                if ((file = new File(fileLocation)).exists()) {
                    this.logSpecial("Found in SystemResource Directory/resourceDirectory: " + file.getAbsolutePath());
                    return file;
                }
                file = new File(fileLocation.replaceAll("%20", " "));
                if (file.exists()) {
                    this.logSpecial("Found in SystemResource Directory/resourceDirectory: " + file.getAbsolutePath());
                    return file;
                }
                this.logSpecial("Not found in SystemResource Directory/resourceDirectory (this should never happen): " + file.getAbsolutePath());
            }
            catch (URISyntaxException e) {
                this.logSpecial("Error while converting URL " + fileUrl + " to file path: " + e.getMessage());
            }
        } else {
            this.logSpecial("Not found in SystemResource Directory/resourceDirectory: " + this.resourceDirectory + File.separator + filename);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadConfigurationFromClasspath(String fileName) throws IllegalArgumentException {
        Properties result = null;
        InputStream in = null;
        ClassLoader[] loaders = new ClassLoader[]{Thread.currentThread().getContextClassLoader(), ClassLoader.getSystemClassLoader(), this.getClass().getClassLoader()};
        String[] classLoaderNames = new String[]{"current thread context class loader", "system class loader", "class loader for DefaultSecurityConfiguration class"};
        ClassLoader currentLoader = null;
        for (int i = 0; i < loaders.length; ++i) {
            if (loaders[i] == null) continue;
            currentLoader = loaders[i];
            try {
                String currentClasspathSearchLocation = "/ (root)";
                in = loaders[i].getResourceAsStream(PropNames.DefaultSearchPath.ROOT.value() + fileName);
                if (in == null) {
                    currentClasspathSearchLocation = this.resourceDirectory + "/";
                    in = currentLoader.getResourceAsStream(PropNames.DefaultSearchPath.RESOURCE_DIRECTORY.value() + fileName);
                }
                if (in == null) {
                    currentClasspathSearchLocation = ".esapi/";
                    in = currentLoader.getResourceAsStream(PropNames.DefaultSearchPath.DOT_ESAPI.value() + fileName);
                }
                if (in == null) {
                    currentClasspathSearchLocation = "esapi/";
                    in = currentLoader.getResourceAsStream(PropNames.DefaultSearchPath.ESAPI.value() + fileName);
                }
                if (in == null) {
                    currentClasspathSearchLocation = "resources/";
                    in = currentLoader.getResourceAsStream(PropNames.DefaultSearchPath.RESOURCES.value() + fileName);
                }
                if (in == null) {
                    currentClasspathSearchLocation = "src/main/resources/";
                    in = currentLoader.getResourceAsStream(PropNames.DefaultSearchPath.SRC_MAIN_RESOURCES.value() + fileName);
                }
                if (in == null) continue;
                result = new Properties();
                result.load(in);
                this.logSpecial("SUCCESSFULLY LOADED " + fileName + " via the CLASSPATH from '" + currentClasspathSearchLocation + "' using " + classLoaderNames[i] + "!");
                break;
            }
            catch (Exception e) {
                result = null;
                continue;
            }
            finally {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        if (result == null) {
            throw new IllegalArgumentException("Failed to load " + this.resourceFile + " as a classloader resource.");
        }
        return result;
    }

    public static final synchronized void logToStdout(String msg, Throwable t) {
        boolean discard = logSpecialValue.trim().equalsIgnoreCase("true");
        if (discard) {
            return;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.SSS");
        String dateFormat = simpleDateFormat.format(new Date(System.currentTimeMillis()));
        if (t == null) {
            System.out.println(dateFormat + " ESAPI: " + msg);
        } else {
            System.out.println(dateFormat + " ESAPI: " + msg + ". Caught " + t.getClass().getName() + "; exception message was: " + t);
        }
    }

    private void logSpecial(String message, Throwable e) {
        DefaultSecurityConfiguration.logToStdout(message, e);
    }

    private void logSpecial(String message) {
        DefaultSecurityConfiguration.logToStdout(message, null);
    }

    @Override
    public String getPasswordParameterName() {
        return this.getESAPIProperty(PASSWORD_PARAMETER_NAME, "password");
    }

    @Override
    public String getUsernameParameterName() {
        return this.getESAPIProperty(USERNAME_PARAMETER_NAME, "username");
    }

    @Override
    public String getEncryptionAlgorithm() {
        return this.getESAPIProperty(ENCRYPTION_ALGORITHM, "AES");
    }

    @Override
    public String getCipherTransformation() {
        assert (this.cipherXformCurrent != null) : "Current cipher transformation is null";
        return this.cipherXformCurrent;
    }

    @Override
    public String setCipherTransformation(String cipherXform) {
        String previous = this.getCipherTransformation();
        if (cipherXform == null) {
            this.cipherXformCurrent = this.cipherXformFromESAPIProp;
        } else {
            if (cipherXform.trim().equals("")) {
                throw new ConfigurationException("Cipher transformation cannot be just white space or empty string");
            }
            this.cipherXformCurrent = cipherXform;
        }
        return previous;
    }

    @Override
    public boolean useMACforCipherText() {
        return this.getESAPIProperty(CIPHERTEXT_USE_MAC, true);
    }

    @Override
    public boolean overwritePlainText() {
        return this.getESAPIProperty(PLAINTEXT_OVERWRITE, true);
    }

    @Override
    @Deprecated
    public String getIVType() {
        String value = this.getESAPIProperty(IV_TYPE, "random");
        if (value.equalsIgnoreCase("random")) {
            return value;
        }
        if (value.equalsIgnoreCase("fixed")) {
            this.logSpecial("WARNING: Property 'Encryptor.ChooseIVMethod=fixed' is no longer supported AT ALL!!! It had been deprecated since 2.2.0.0 and back then, was announced it would be removed in release 2.3.0.0. It was originally intended to support legacy applications, but is inherently insecure, especially with any streaming mode.");
            throw new ConfigurationException("'Encryptor.ChooseIVMethod=fixed' is no longer supported AT ALL. It has been deprecated since release 2.2 and has been removed since 2.3.");
        }
        if (value.equalsIgnoreCase("specified")) {
            throw new ConfigurationException("Contrary to previous internal comments, 'Encryptor.ChooseIVMethod=specified' is not going to be supported -- ever.");
        }
        this.logSpecial("WARNING: '" + value + "' is illegal value for " + IV_TYPE + ". Using 'random' for the IV type.");
        return "random";
    }

    @Override
    public String getHashAlgorithm() {
        return this.getESAPIProperty(HASH_ALGORITHM, "SHA-512");
    }

    @Override
    public int getHashIterations() {
        return this.getESAPIProperty(HASH_ITERATIONS, 10000);
    }

    @Override
    public boolean isUseHistoryLogic() {
        return this.getESAPIProperty(HIS_LOGIC, false);
    }

    @Override
    public String getRandomGenerator() {
        return this.getESAPIProperty(RANDOM_GENERATOR, "StrongRandomizer");
    }

    @Override
    public String getKDFPseudoRandomFunction() {
        return this.getESAPIProperty(KDF_PRF_ALG, "HmacSHA256");
    }

    @Override
    public String getCharacterEncoding() {
        return this.getESAPIProperty(CHARACTER_ENCODING, "UTF-8");
    }

    @Override
    public boolean getAllowMultipleEncoding() {
        return this.getESAPIProperty(ALLOW_MULTIPLE_ENCODING, false);
    }

    @Override
    public boolean getAllowMixedEncoding() {
        return this.getESAPIProperty(ALLOW_MIXED_ENCODING, false);
    }

    @Override
    public List<String> getDefaultCanonicalizationCodecs() {
        ArrayList<String> def = new ArrayList<String>();
        def.add("org.owasp.esapi.codecs.HTMLEntityCodec");
        def.add("org.owasp.esapi.codecs.PercentCodec");
        def.add("org.owasp.esapi.codecs.JavaScriptCodec");
        return this.getESAPIProperty(CANONICALIZATION_CODECS, def);
    }

    @Override
    public String getDigitalSignatureAlgorithm() {
        return this.getESAPIProperty(DIGITAL_SIGNATURE_ALGORITHM, "SHA256withRSA");
    }

    @Override
    public int getDigitalSignatureKeyLength() {
        return this.getESAPIProperty(DIGITAL_SIGNATURE_KEY_LENGTH, 3072);
    }

    @Override
    public String getRandomAlgorithm() {
        return this.getESAPIProperty(RANDOM_ALGORITHM, "SHA1PRNG");
    }

    @Override
    public int getAllowedLoginAttempts() {
        return this.getESAPIProperty(ALLOWED_LOGIN_ATTEMPTS, 5);
    }

    @Override
    public int getMaxOldPasswordHashes() {
        return this.getESAPIProperty(MAX_OLD_PASSWORD_HASHES, 12);
    }

    @Override
    public File getUploadDirectory() {
        String dir = this.getESAPIProperty(UPLOAD_DIRECTORY, "UploadDir");
        return new File(dir);
    }

    @Override
    public File getUploadTempDirectory() {
        String dir = this.getESAPIProperty(UPLOAD_TEMP_DIRECTORY, System.getProperty("java.io.tmpdir", "UploadTempDir"));
        return new File(dir);
    }

    @Override
    public boolean getDisableIntrusionDetection() {
        String value = this.properties.getProperty(DISABLE_INTRUSION_DETECTION);
        return "true".equalsIgnoreCase(value);
    }

    @Override
    public SecurityConfiguration.Threshold getQuota(String eventName) {
        int count = this.getESAPIProperty("IntrusionDetector." + eventName + ".count", 0);
        int interval = this.getESAPIProperty("IntrusionDetector." + eventName + ".interval", 0);
        ArrayList<String> actions = new ArrayList();
        String actionString = this.getESAPIProperty("IntrusionDetector." + eventName + ".actions", "");
        if (actionString != null) {
            String[] actionList = actionString.split(",");
            actions = Arrays.asList(actionList);
        }
        if (count > 0 && interval > 0 && actions.size() > 0) {
            return new SecurityConfiguration.Threshold(eventName, count, interval, actions);
        }
        return null;
    }

    @Override
    public boolean getLogEncodingRequired() {
        return this.getESAPIProperty(LOG_ENCODING_REQUIRED, false);
    }

    @Override
    public boolean getLogApplicationName() {
        return this.getESAPIProperty(LOG_APPLICATION_NAME, true);
    }

    @Override
    public boolean getLogServerIP() {
        return this.getESAPIProperty(LOG_SERVER_IP, true);
    }

    @Override
    public boolean getForceHttpOnlySession() {
        return this.getESAPIProperty(FORCE_HTTPONLYSESSION, true);
    }

    @Override
    public boolean getForceSecureSession() {
        return this.getESAPIProperty(FORCE_SECURESESSION, true);
    }

    @Override
    public boolean getForceHttpOnlyCookies() {
        return this.getESAPIProperty(FORCE_HTTPONLYCOOKIES, true);
    }

    @Override
    public boolean getForceSecureCookies() {
        return this.getESAPIProperty(FORCE_SECURECOOKIES, true);
    }

    @Override
    public int getMaxHttpHeaderSize() {
        return this.getESAPIProperty(MAX_HTTP_HEADER_SIZE, 4096);
    }

    @Override
    public String getResponseContentType() {
        return this.getESAPIProperty(RESPONSE_CONTENT_TYPE, "text/html; charset=UTF-8");
    }

    @Override
    public String getHttpSessionIdName() {
        return this.getESAPIProperty(HTTP_SESSION_ID_NAME, "JSESSIONID");
    }

    @Override
    public long getRememberTokenDuration() {
        int days = this.getESAPIProperty(REMEMBER_TOKEN_DURATION, 14);
        return 86400000 * days;
    }

    @Override
    public int getSessionIdleTimeoutLength() {
        int minutes = this.getESAPIProperty(IDLE_TIMEOUT_DURATION, 20);
        return 60000 * minutes;
    }

    @Override
    public int getSessionAbsoluteTimeoutLength() {
        int minutes = this.getESAPIProperty(ABSOLUTE_TIMEOUT_DURATION, 20);
        return 60000 * minutes;
    }

    @Override
    public Pattern getValidationPattern(String key) {
        String value = this.getESAPIProperty("Validator." + key, "");
        Pattern p = patternCache.get(value);
        if (p != null) {
            return p;
        }
        if (value == null || value.equals("")) {
            return null;
        }
        try {
            Pattern q = Pattern.compile(value);
            patternCache.put(value, q);
            return q;
        }
        catch (PatternSyntaxException e) {
            this.logSpecial("SecurityConfiguration for " + key + " not a valid regex in ESAPI.properties. Returning null", null);
            return null;
        }
    }

    @Override
    public File getWorkingDirectory() {
        String dir = this.getESAPIProperty(WORKING_DIRECTORY, System.getProperty("user.dir"));
        if (dir != null) {
            return new File(dir);
        }
        return null;
    }

    @Override
    public String getPreferredJCEProvider() {
        return this.properties.getProperty(PREFERRED_JCE_PROVIDER);
    }

    @Override
    public List<String> getCombinedCipherModes() {
        String defaultValues = "CCM";
        List<String> values = Arrays.asList(defaultValues.split(","));
        return this.getESAPIProperty(COMBINED_CIPHER_MODES, values);
    }

    @Override
    public List<String> getAdditionalAllowedCipherModes() {
        ArrayList<String> defaultCipher = new ArrayList<String>();
        defaultCipher.add("GCM");
        defaultCipher.add("CBC");
        return this.getESAPIProperty(ADDITIONAL_ALLOWED_CIPHER_MODES, defaultCipher);
    }

    @Override
    public String getESAPIPropertyFormLogger(String key, String def) {
        String value = this.properties.getProperty(key);
        if (value == null) {
            this.logSpecial("SecurityConfiguration for " + key + " not found in ESAPI.properties. Using default: " + def, null);
            return def;
        }
        return value;
    }

    @Override
    public boolean getESAPIPropertyFormLogger(String key, boolean def) {
        String property = this.properties.getProperty(key);
        if (property == null) {
            this.logSpecial("SecurityConfiguration for " + key + " not found in ESAPI.properties. Using default: " + def, null);
            return def;
        }
        if (property.equalsIgnoreCase("true") || property.equalsIgnoreCase("yes")) {
            return true;
        }
        if (property.equalsIgnoreCase("false") || property.equalsIgnoreCase("no")) {
            return false;
        }
        this.logSpecial("SecurityConfiguration for " + key + " not either \"true\" or \"false\" in ESAPI.properties. Using default: " + def, null);
        return def;
    }

    @Override
    public boolean getLenientDatesAccepted() {
        return this.getESAPIProperty(ACCEPT_LENIENT_DATES, false);
    }

    protected String getESAPIProperty(String key, String def) {
        String value = this.properties.getProperty(key);
        if (value == null) {
            this.logSpecial("SecurityConfiguration for " + key + " not found in ESAPI.properties. Using default: " + def, null);
            return def;
        }
        return value;
    }

    @Override
    public String getPropertyValue(String key) {
        return this.getESAPIProperty(key, "");
    }

    @Override
    public String getUserAdapterImplementation() {
        return this.getESAPIProperty(USER_ADAPTER, "org.owasp.esapi.reference.DefaultUserAdapter");
    }

    protected boolean getESAPIProperty(String key, boolean def) {
        String property = this.properties.getProperty(key);
        if (property == null) {
            this.logSpecial("SecurityConfiguration for " + key + " not found in ESAPI.properties. Using default: " + def, null);
            return def;
        }
        if (property.equalsIgnoreCase("true") || property.equalsIgnoreCase("yes")) {
            return true;
        }
        if (property.equalsIgnoreCase("false") || property.equalsIgnoreCase("no")) {
            return false;
        }
        this.logSpecial("SecurityConfiguration for " + key + " not either \"true\" or \"false\" in ESAPI.properties. Using default: " + def, null);
        return def;
    }

    protected byte[] getESAPIPropertyEncoded(String key, byte[] def) {
        String property = this.properties.getProperty(key);
        if (property == null) {
            this.logSpecial("SecurityConfiguration for " + key + " not found in ESAPI.properties. Using default: " + def, null);
            return def;
        }
        try {
            return ESAPI.encoder().decodeFromBase64(property);
        }
        catch (IOException e) {
            this.logSpecial("SecurityConfiguration for " + key + " not properly Base64 encoded in ESAPI.properties. Using default: " + def, null);
            return new byte[0];
        }
    }

    protected int getESAPIProperty(String key, int def) {
        String property = this.properties.getProperty(key);
        if (property == null) {
            this.logSpecial("SecurityConfiguration for " + key + " not found in ESAPI.properties. Using default: " + def, null);
            return def;
        }
        try {
            return Integer.parseInt(property);
        }
        catch (NumberFormatException e) {
            this.logSpecial("SecurityConfiguration for " + key + " not an integer in ESAPI.properties. Using default: " + def, null);
            return def;
        }
    }

    protected List<String> getESAPIProperty(String key, List<String> def) {
        String property = this.properties.getProperty(key);
        if (property == null) {
            this.logSpecial("SecurityConfiguration for " + key + " not found in ESAPI.properties. Using default: " + def, null);
            return def;
        }
        String[] parts = property.split(",");
        return Arrays.asList(parts);
    }

    @Override
    public int getIntProp(String propertyName) throws ConfigurationException {
        try {
            return this.esapiPropertyManager.getIntProp(propertyName);
        }
        catch (ConfigurationException ex) {
            String property = this.properties.getProperty(propertyName);
            try {
                return Integer.parseInt(property);
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException("SecurityConfiguration for " + propertyName + " has incorrect type");
            }
        }
    }

    @Override
    public byte[] getByteArrayProp(String propertyName) throws ConfigurationException {
        try {
            return this.esapiPropertyManager.getByteArrayProp(propertyName);
        }
        catch (ConfigurationException ex) {
            String property = this.properties.getProperty(propertyName);
            if (property == null) {
                throw new ConfigurationException("SecurityConfiguration for " + propertyName + " not found in ESAPI.properties");
            }
            try {
                return ESAPI.encoder().decodeFromBase64(property);
            }
            catch (IOException e) {
                throw new ConfigurationException("SecurityConfiguration for " + propertyName + " has incorrect type");
            }
        }
    }

    @Override
    public Boolean getBooleanProp(String propertyName) throws ConfigurationException {
        try {
            return this.esapiPropertyManager.getBooleanProp(propertyName);
        }
        catch (ConfigurationException ex) {
            String property = this.properties.getProperty(propertyName);
            if (property == null) {
                throw new ConfigurationException("SecurityConfiguration for " + propertyName + " not found in ESAPI.properties");
            }
            if (property.equalsIgnoreCase("true") || property.equalsIgnoreCase("yes")) {
                return true;
            }
            if (property.equalsIgnoreCase("false") || property.equalsIgnoreCase("no")) {
                return false;
            }
            throw new ConfigurationException("SecurityConfiguration for " + propertyName + " has incorrect type");
        }
    }

    @Override
    public String getStringProp(String propertyName) throws ConfigurationException {
        try {
            return this.esapiPropertyManager.getStringProp(propertyName);
        }
        catch (ConfigurationException ex) {
            String property = this.properties.getProperty(propertyName);
            if (property == null) {
                throw new ConfigurationException("SecurityConfiguration for " + propertyName + " not found in ESAPI.properties");
            }
            return property;
        }
    }

    protected boolean shouldPrintProperties() {
        return this.getESAPIProperty(PRINT_PROPERTIES_WHEN_LOADED, false);
    }

    protected Properties getESAPIProperties() {
        return this.properties;
    }
}

