/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.reference.crypto;

import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Base64;
import java.util.Date;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.EncoderConstants;
import org.owasp.esapi.Encryptor;
import org.owasp.esapi.Logger;
import org.owasp.esapi.crypto.CipherSpec;
import org.owasp.esapi.crypto.CipherText;
import org.owasp.esapi.crypto.CryptoHelper;
import org.owasp.esapi.crypto.HashSpec;
import org.owasp.esapi.crypto.KeyDerivationFunction;
import org.owasp.esapi.crypto.PlainText;
import org.owasp.esapi.crypto.SealSpec;
import org.owasp.esapi.crypto.SecurityProviderLoader;
import org.owasp.esapi.crypto.VerifySignatureSpec;
import org.owasp.esapi.errors.ConfigurationException;
import org.owasp.esapi.errors.EncryptionException;
import org.owasp.esapi.errors.IntegrityException;
import org.owasp.esapi.util.RandomUtil;

public final class JavaEncryptor
implements Encryptor {
    private static volatile Encryptor singletonInstance;
    private static boolean initialized;
    private static SecretKeySpec secretKeySpec;
    private static String encryptAlgorithm;
    private static String encoding;
    private static int encryptionKeyLength;
    private static PrivateKey privateKey;
    private static PublicKey publicKey;
    private static String signatureAlgorithm;
    private static String randomAlgorithm;
    private static int signatureKeyLength;
    private static String hashAlgorithm;
    private static int hashIterations;
    private static Logger logger;
    private static int encryptCounter;
    private static int decryptCounter;
    private static final int logEveryNthUse = 25;
    private static final String DECRYPTION_FAILED = "Decryption failed; see logs for details.";
    private static int N_SECS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Encryptor getInstance() throws EncryptionException {
        if (singletonInstance != null) return singletonInstance;
        Class<JavaEncryptor> clazz = JavaEncryptor.class;
        synchronized (JavaEncryptor.class) {
            if (singletonInstance != null) return singletonInstance;
            singletonInstance = new JavaEncryptor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singletonInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JavaEncryptor() throws EncryptionException {
        byte[] salt = ESAPI.securityConfiguration().getMasterSalt();
        byte[] skey = ESAPI.securityConfiguration().getMasterKey();
        Class<JavaEncryptor> clazz = JavaEncryptor.class;
        synchronized (JavaEncryptor.class) {
            if (!initialized) {
                if (skey != null && skey.length > 0) {
                    secretKeySpec = new SecretKeySpec(skey, encryptAlgorithm);
                }
                if (skey == null || skey.length == 0 || salt == null || salt.length == 0) {
                    initialized = true;
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
                try {
                    String randomGenerator = ESAPI.securityConfiguration().getRandomGenerator();
                    SecureRandom prng = "Randomizer".equals(randomGenerator) ? RandomUtil.getRandom(randomAlgorithm) : ("BcStrongRandomizer".equals(randomGenerator) ? RandomUtil.getBcStrongRandom() : RandomUtil.getStrongRandom());
                    byte[] seed = this.hash(new String(skey, encoding), new String(salt, encoding)).getBytes(encoding);
                    prng.setSeed(seed);
                    JavaEncryptor.initKeyPair(prng);
                }
                catch (Exception e) {
                    throw new EncryptionException("Encryption failure", "Error creating Encryptor", e);
                }
                initialized = true;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    public String hash(String plaintext, String salt) throws EncryptionException {
        return this.hash(plaintext, salt, hashIterations);
    }

    @Override
    public String hash(String plaintext, String salt, int iterations) throws EncryptionException {
        return this.hash(plaintext, salt, hashAlgorithm, iterations);
    }

    @Override
    public byte[] hash(HashSpec hashSpec) throws EncryptionException {
        if (hashSpec == null) {
            throw new EncryptionException("Internal error", "param is null");
        }
        String algorithm = hashSpec.getAlgorithm();
        byte[] salt = hashSpec.getSalt();
        byte[] plaintext = hashSpec.getPlaintext();
        int iterations = hashSpec.getIterations();
        if (algorithm == null || "".equals(algorithm)) {
            algorithm = hashAlgorithm;
        }
        if (iterations == 0) {
            iterations = hashIterations;
        }
        byte[] bytes = null;
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            digest.reset();
            if (salt != null) {
                digest.update(salt);
            }
            digest.update(salt);
            digest.update(plaintext);
            bytes = digest.digest();
            for (int i = 0; i < iterations; ++i) {
                digest.reset();
                bytes = digest.digest(bytes);
            }
            return Base64.getEncoder().encode(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptionException("Internal error", "Can't find hash algorithm " + hashAlgorithm, e);
        }
    }

    @Override
    public String hash(String plaintext, String salt, String algorithm, int iterations) throws EncryptionException {
        byte[] bytes = null;
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            digest.reset();
            if (salt != null) {
                digest.update(salt.getBytes(encoding));
            }
            digest.update(salt.getBytes(encoding));
            digest.update(plaintext.getBytes(encoding));
            bytes = digest.digest();
            for (int i = 0; i < iterations; ++i) {
                digest.reset();
                bytes = digest.digest(bytes);
            }
            String encoded = ESAPI.encoder().encodeForBase64(bytes, false);
            return encoded;
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptionException("Internal error", "Can't find hash algorithm " + hashAlgorithm, e);
        }
        catch (UnsupportedEncodingException ex) {
            throw new EncryptionException("Internal error", "Can't find encoding for " + encoding, ex);
        }
    }

    @Override
    public CipherText encrypt(PlainText plaintext) throws EncryptionException {
        return this.encrypt(secretKeySpec, plaintext);
    }

    @Override
    public CipherText encrypt(SecretKey key, PlainText plain) throws EncryptionException {
        return this.encrypt(key, plain, ESAPI.securityConfiguration().getCipherTransformation());
    }

    @Override
    public CipherText encrypt(SecretKey key, PlainText plain, String xform) throws EncryptionException {
        if (key == null) {
            throw new IllegalArgumentException("(Master) encryption key arg may not be null. Is Encryptor.MasterKey set?");
        }
        if (plain == null) {
            throw new IllegalArgumentException("PlainText may arg not be null");
        }
        byte[] plaintext = plain.asBytes();
        boolean overwritePlaintext = ESAPI.securityConfiguration().overwritePlainText();
        boolean success = false;
        int keySize = key.getEncoded().length * 8;
        try {
            String skeyAlg;
            String[] parts = xform.split("/");
            if (parts.length != 3) {
                throw new ConfigurationException("Malformed cipher transformation: " + xform + ". Should have format of cipher_alg/cipher_mode/padding_scheme.");
            }
            String cipherMode = parts[1];
            if (!CryptoHelper.isAllowedCipherMode(cipherMode)) {
                throw new EncryptionException("Encryption failure: invalid cipher mode ( " + cipherMode + ") for encryption", "Encryption failure: Cipher transformation " + xform + " specifies invalid cipher mode " + cipherMode);
            }
            Cipher encrypter = Cipher.getInstance(xform);
            String cipherAlg = encrypter.getAlgorithm();
            int keyLen = ESAPI.securityConfiguration().getEncryptionKeyLength();
            if (keySize != keyLen) {
                logger.warning(Logger.SECURITY_FAILURE, "Encryption key length mismatch. ESAPI.EncryptionKeyLength is " + keyLen + " bits, but length of actual encryption key is " + keySize + " bits.  Did you remember to regenerate your master key (if that is what you are using)???");
            }
            if (keySize < keyLen) {
                logger.warning(Logger.SECURITY_FAILURE, "Actual key size of " + keySize + " bits SMALLER THAN specified encryption key length (ESAPI.EncryptionKeyLength) of " + keyLen + " bits with cipher algorithm " + cipherAlg);
            }
            if (keySize < 112) {
                logger.warning(Logger.SECURITY_FAILURE, "Potentially insecure encryption. Key size of " + keySize + "bits not sufficiently long for " + cipherAlg + ". Should use appropriate algorithm with key size of *at least* 112 bits except when required by legacy apps. See NIST Special Pub 800-57.");
            }
            if (!cipherAlg.startsWith((skeyAlg = key.getAlgorithm()) + '/') && !cipherAlg.equals(skeyAlg)) {
                logger.warning(Logger.SECURITY_FAILURE, "Encryption mismatch between cipher algorithm (" + cipherAlg + ") and SecretKey algorithm (" + skeyAlg + "). Cipher will use algorithm " + cipherAlg);
            }
            byte[] ivBytes = null;
            CipherSpec cipherSpec = new CipherSpec(encrypter, keySize);
            boolean preferredCipherMode = CryptoHelper.isCombinedCipherMode(cipherMode);
            SecretKey encKey = null;
            encKey = preferredCipherMode ? key : this.computeDerivedKey(20130830, this.getDefaultPRF(), key, keySize, "encryption");
            if (cipherSpec.requiresIV()) {
                String ivType = ESAPI.securityConfiguration().getIVType();
                AlgorithmParameterSpec ivSpec = null;
                if (!ivType.equalsIgnoreCase("random")) {
                    throw new ConfigurationException("Property Encryptor.ChooseIVMethod must be set to 'random'.");
                }
                ivBytes = ESAPI.randomizer().getRandomBytes(encrypter.getBlockSize());
                ivSpec = "GCM".equalsIgnoreCase(cipherSpec.getCipherMode()) ? new GCMParameterSpec(128, ivBytes, 0, encrypter.getBlockSize()) : new IvParameterSpec(ivBytes);
                cipherSpec.setIV(ivBytes);
                encrypter.init(1, (Key)encKey, ivSpec);
            } else {
                encrypter.init(1, encKey);
            }
            logger.debug(Logger.EVENT_SUCCESS, "Encrypting with " + cipherSpec);
            byte[] raw = encrypter.doFinal(plaintext);
            CipherText ciphertext = new CipherText(cipherSpec, raw);
            if (!preferredCipherMode) {
                SecretKey authKey = this.computeDerivedKey(20130830, this.getDefaultPRF(), key, keySize, "authenticity");
                ciphertext.computeAndStoreMAC(authKey);
            }
            logger.debug(Logger.EVENT_SUCCESS, "JavaEncryptor.encrypt(SecretKey,byte[],boolean,boolean) -- success!");
            success = true;
            CipherText cipherText = ciphertext;
            return cipherText;
        }
        catch (InvalidKeyException ike) {
            throw new EncryptionException("Encryption failure: Invalid key exception.", "Requested key size: " + keySize + "bits greater than 128 bits. Must install unlimited strength crypto extension from Sun: " + ike.getMessage(), ike);
        }
        catch (ConfigurationException cex) {
            throw new EncryptionException("Encryption failure: Configuration error. Details in log.", "Key size mismatch or unsupported IV method. Check encryption key size vs. ESAPI.EncryptionKeyLength or Encryptor.ChooseIVMethod property.", cex);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new EncryptionException("Encryption failure (invalid IV)", "Encryption problem: Invalid IV spec: " + e.getMessage(), e);
        }
        catch (IllegalBlockSizeException e) {
            throw new EncryptionException("Encryption failure (no padding used; invalid input size)", "Encryption problem: Invalid input size without padding (" + xform + "). " + e.getMessage(), e);
        }
        catch (BadPaddingException e) {
            throw new EncryptionException("Encryption failure", "[Note: Should NEVER happen in encryption mode.] Encryption problem: " + e.getMessage(), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptionException("Encryption failure (unavailable cipher requested)", "Encryption problem: specified algorithm in cipher xform " + xform + " not available: " + e.getMessage(), e);
        }
        catch (NoSuchPaddingException e) {
            throw new EncryptionException("Encryption failure (unavailable padding scheme requested)", "Encryption problem: specified padding scheme in cipher xform " + xform + " not available: " + e.getMessage(), e);
        }
        finally {
            if (success && overwritePlaintext) {
                plain.overwrite();
            }
        }
    }

    @Override
    public PlainText decrypt(CipherText ciphertext) throws EncryptionException {
        return this.decrypt(secretKeySpec, ciphertext);
    }

    @Override
    public PlainText decrypt(SecretKey key, CipherText ciphertext) throws EncryptionException, IllegalArgumentException {
        long start = System.nanoTime();
        if (key == null) {
            throw new IllegalArgumentException("SecretKey arg may not be null");
        }
        if (ciphertext == null) {
            throw new IllegalArgumentException("Ciphertext may arg not be null");
        }
        if (!CryptoHelper.isAllowedCipherMode(ciphertext.getCipherMode())) {
            throw new EncryptionException(DECRYPTION_FAILED, "Invalid cipher mode " + ciphertext.getCipherMode() + " not permitted for decryption or encryption operations.");
        }
        logger.debug(Logger.EVENT_SUCCESS, "Args valid for JavaEncryptor.decrypt(SecretKey,CipherText): " + ciphertext);
        PlainText plaintext = null;
        boolean caughtException = false;
        int progressMark = 0;
        try {
            boolean valid = CryptoHelper.isCipherTextMACvalid(key, ciphertext);
            if (!valid) {
                try {
                    this.handleDecryption(key, ciphertext);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new EncryptionException(DECRYPTION_FAILED, "Decryption failed because MAC invalid for " + ciphertext);
            }
            ++progressMark;
            plaintext = this.handleDecryption(key, ciphertext);
            ++progressMark;
        }
        catch (EncryptionException ex) {
            caughtException = true;
            String logMsg = null;
            switch (progressMark) {
                case 1: {
                    logMsg = "Decryption failed because MAC invalid. See logged exception for details.";
                    break;
                }
                case 2: {
                    logMsg = "Decryption failed because handleDecryption() failed. See logged exception for details.";
                    break;
                }
                default: {
                    logMsg = "Programming error: unexpected progress mark == " + progressMark;
                }
            }
            logger.error(Logger.SECURITY_FAILURE, logMsg);
            throw ex;
        }
        finally {
            if (caughtException) {
                long now = System.nanoTime();
                long elapsed = now - start;
                long NANOSECS_IN_SEC = 1000000000L;
                long nSecs = (long)N_SECS * 1000000000L;
                if (elapsed < nSecs) {
                    long extraSleep = nSecs - elapsed;
                    long millis = extraSleep / 1000000L;
                    long nanos = extraSleep - millis * 1000000L;
                    assert (nanos >= 0L && nanos <= Integer.MAX_VALUE) : "Nanosecs out of bounds; nanos = " + nanos;
                    try {
                        Thread.sleep(millis, (int)nanos);
                    }
                    catch (InterruptedException ex) {
                        logger.error(Logger.SECURITY_FAILURE, ex.getMessage());
                    }
                }
            }
        }
        return plaintext;
    }

    private PlainText handleDecryption(SecretKey key, CipherText ciphertext) throws EncryptionException {
        int keySize = 0;
        try {
            Cipher decrypter = Cipher.getInstance(ciphertext.getCipherTransformation());
            keySize = key.getEncoded().length * 8;
            boolean preferredCipherMode = CryptoHelper.isCombinedCipherMode(ciphertext.getCipherMode());
            SecretKey encKey = null;
            encKey = preferredCipherMode ? key : this.computeDerivedKey(ciphertext.getKDFVersion(), ciphertext.getKDF_PRF(), key, keySize, "encryption");
            this.handleCiphertext(ciphertext, decrypter, encKey);
            byte[] output = decrypter.doFinal(ciphertext.getRawCipherText());
            return new PlainText(output);
        }
        catch (InvalidKeyException ike) {
            throw new EncryptionException(DECRYPTION_FAILED, "Must install JCE Unlimited Strength Jurisdiction Policy Files from Sun", ike);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptionException(DECRYPTION_FAILED, "Invalid algorithm for available JCE providers - " + ciphertext.getCipherTransformation() + ": " + e.getMessage(), e);
        }
        catch (NoSuchPaddingException e) {
            throw new EncryptionException(DECRYPTION_FAILED, "Invalid padding scheme (" + ciphertext.getPaddingScheme() + ") for cipher transformation " + ciphertext.getCipherTransformation() + ": " + e.getMessage(), e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new EncryptionException(DECRYPTION_FAILED, "Decryption problem: " + e.getMessage(), e);
        }
        catch (IllegalBlockSizeException e) {
            throw new EncryptionException(DECRYPTION_FAILED, "Decryption problem: " + e.getMessage(), e);
        }
        catch (BadPaddingException e) {
            SecretKey authKey;
            try {
                authKey = this.computeDerivedKey(ciphertext.getKDFVersion(), ciphertext.getKDF_PRF(), key, keySize, "authenticity");
            }
            catch (Exception e1) {
                throw new EncryptionException(DECRYPTION_FAILED, "Decryption problem -- failed to compute derived key for authenticity: " + e1.getMessage(), e1);
            }
            boolean success = ciphertext.validateMAC(authKey);
            if (success) {
                throw new EncryptionException(DECRYPTION_FAILED, "Decryption problem: " + e.getMessage(), e);
            }
            throw new EncryptionException(DECRYPTION_FAILED, "Decryption problem: WARNING: Adversary may have tampered with CipherText object orCipherText object mangled in transit: " + e.getMessage(), e);
        }
    }

    private void handleCiphertext(CipherText ciphertext, Cipher decrypter, SecretKey encKey) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (ciphertext.requiresIV()) {
            AlgorithmParameterSpec iv = null;
            iv = "GCM".equalsIgnoreCase(ciphertext.getCipherMode()) ? new GCMParameterSpec(128, ciphertext.getIV(), 0, ciphertext.getIV().length) : new IvParameterSpec(ciphertext.getIV());
            decrypter.init(2, (Key)encKey, iv);
        } else {
            decrypter.init(2, encKey);
        }
    }

    @Override
    public String sign(String data, PrivateKey prvKey) throws EncryptionException {
        return this.sign(data, prvKey, signatureAlgorithm);
    }

    @Override
    public String sign(String data, PrivateKey prvKey, String signAlgorithm) throws EncryptionException {
        try {
            Signature signer = Signature.getInstance(signAlgorithm);
            signer.initSign(prvKey);
            signer.update(data.getBytes(encoding));
            byte[] bytes = signer.sign();
            return ESAPI.encoder().encodeForBase64(bytes, false);
        }
        catch (InvalidKeyException ike) {
            throw new EncryptionException("Encryption failure", "Must install unlimited strength crypto extension from Sun", ike);
        }
        catch (Exception e) {
            throw new EncryptionException("Signature failure", "Can't find signature algorithm " + signatureAlgorithm, e);
        }
    }

    @Override
    public byte[] sign(byte[] data, PrivateKey prvKey) throws EncryptionException {
        return this.sign(data, prvKey, signatureAlgorithm);
    }

    @Override
    public byte[] sign(byte[] data, PrivateKey prvKey, String signAlgorithm) throws EncryptionException {
        try {
            Signature signer = Signature.getInstance(signAlgorithm);
            signer.initSign(prvKey);
            signer.update(data);
            byte[] bytes = signer.sign();
            return Base64.getEncoder().encode(bytes);
        }
        catch (InvalidKeyException ike) {
            throw new EncryptionException("Encryption failure", "Must install unlimited strength crypto extension from Sun", ike);
        }
        catch (Exception e) {
            throw new EncryptionException("Signature failure", "Can't find signature algorithm " + signatureAlgorithm, e);
        }
    }

    @Override
    public boolean verifySignature(String signature, String data, PublicKey pubKey) {
        return this.verifySignature(signature, data, pubKey, signatureAlgorithm);
    }

    @Override
    public boolean verifySignature(String signature, String data, PublicKey pubKey, String signAlgorithm) {
        try {
            byte[] bytes = ESAPI.encoder().decodeFromBase64(signature);
            Signature signer = Signature.getInstance(signAlgorithm);
            signer.initVerify(pubKey);
            signer.update(data.getBytes(encoding));
            return signer.verify(bytes);
        }
        catch (Exception e) {
            new EncryptionException("Invalid signature", "Problem verifying signature: " + e.getMessage(), e);
            return false;
        }
    }

    @Override
    public boolean verifySignature(VerifySignatureSpec verifySignatureSpec) {
        try {
            if (verifySignatureSpec == null) {
                throw new EncryptionException("Internal error", "verifySignaturePojo is null");
            }
            String signAlgorithm = verifySignatureSpec.getSignAlgorithm();
            if (signAlgorithm == null || signAlgorithm.equals("")) {
                signAlgorithm = signatureAlgorithm;
            }
            byte[] signature = verifySignatureSpec.getSignature();
            byte[] decode = Base64.getDecoder().decode(signature);
            Signature signer = Signature.getInstance(signAlgorithm);
            signer.initVerify(verifySignatureSpec.getPubKey());
            signer.update(verifySignatureSpec.getData());
            return signer.verify(decode);
        }
        catch (Exception e) {
            new EncryptionException("Invalid signature", "Problem verifying signature: " + e.getMessage(), e);
            return false;
        }
    }

    @Override
    public String seal(String data, long expiration, PrivateKey prvKey, SecretKey key) throws IntegrityException {
        if (data == null) {
            throw new IllegalArgumentException("Data to be sealed may not be null.");
        }
        try {
            String b64data = null;
            try {
                b64data = ESAPI.encoder().encodeForBase64(data.getBytes("UTF-8"), false);
            }
            catch (UnsupportedEncodingException e) {
                logger.error(Logger.EVENT_FAILURE, e.getMessage());
            }
            String nonce = ESAPI.randomizer().getRandomString(10, EncoderConstants.CHAR_ALPHANUMERICS);
            String plaintext = expiration + ":" + nonce + ":" + b64data;
            String sig = this.sign(plaintext, prvKey);
            CipherText ciphertext = this.encrypt(key, new PlainText(plaintext + ":" + sig));
            String sealedData = ESAPI.encoder().encodeForBase64(ciphertext.asPortableSerializedByteArray(), false);
            return sealedData;
        }
        catch (EncryptionException e) {
            throw new IntegrityException(e.getUserMessage(), e.getLogMessage(), e);
        }
    }

    @Override
    public byte[] seal(SealSpec sealSpec) throws IntegrityException {
        if (sealSpec == null || sealSpec.getData() == null) {
            throw new IllegalArgumentException("Data to be sealed may not be null.");
        }
        try {
            String b64data = null;
            b64data = ESAPI.encoder().encodeForBase64(sealSpec.getData(), false);
            String nonce = ESAPI.randomizer().getRandomString(10, EncoderConstants.CHAR_ALPHANUMERICS);
            String plaintext = sealSpec.getTimestamp() + ":" + nonce + ":" + b64data;
            String sig = this.sign(plaintext, sealSpec.getPrvKey());
            CipherText ciphertext = this.encrypt(sealSpec.getKey(), new PlainText(plaintext + ":" + sig));
            byte[] bytes = ciphertext.asPortableSerializedByteArray();
            return Base64.getEncoder().encode(bytes);
        }
        catch (EncryptionException e) {
            throw new IntegrityException(e.getUserMessage(), e.getLogMessage(), e);
        }
    }

    @Override
    public String unseal(String seal, PublicKey pubKey, SecretKey key) throws EncryptionException {
        PlainText plaintext = null;
        try {
            long expiration;
            byte[] encryptedBytes = ESAPI.encoder().decodeFromBase64(seal);
            CipherText cipherText = null;
            try {
                cipherText = CipherText.fromPortableSerializedBytes(encryptedBytes);
            }
            catch (AssertionError e) {
                throw new EncryptionException("Invalid seal", "Seal passed garbarge data resulting in AssertionError: " + e);
            }
            plaintext = this.decrypt(key, cipherText);
            String[] parts = plaintext.toString().split(":");
            if (parts.length != 4) {
                throw new EncryptionException("Invalid seal", "Seal was not formatted properly.");
            }
            String timestring = parts[0];
            long now = new Date().getTime();
            if (now > (expiration = Long.parseLong(timestring))) {
                throw new EncryptionException("Invalid seal", "Seal expiration date of " + new Date(expiration) + " has past.");
            }
            String nonce = parts[1];
            String b64data = parts[2];
            String sig = parts[3];
            if (!this.verifySignature(sig, timestring + ":" + nonce + ":" + b64data, pubKey)) {
                throw new EncryptionException("Invalid seal", "Seal integrity check failed");
            }
            return new String(ESAPI.encoder().decodeFromBase64(b64data), "UTF-8");
        }
        catch (EncryptionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EncryptionException("Invalid seal", "Invalid seal:" + e.getMessage(), e);
        }
    }

    @Override
    public byte[] unseal(byte[] seal, PublicKey pubKey, SecretKey key) throws EncryptionException {
        PlainText plaintext = null;
        try {
            long expiration;
            byte[] encryptedBytes = Base64.getDecoder().decode(seal);
            CipherText cipherText = null;
            try {
                cipherText = CipherText.fromPortableSerializedBytes(encryptedBytes);
            }
            catch (AssertionError e) {
                throw new EncryptionException("Invalid seal", "Seal passed garbarge data resulting in AssertionError: " + e);
            }
            plaintext = this.decrypt(key, cipherText);
            String[] parts = plaintext.toString().split(":");
            if (parts.length != 4) {
                throw new EncryptionException("Invalid seal", "Seal was not formatted properly.");
            }
            String timestring = parts[0];
            long now = new Date().getTime();
            if (now > (expiration = Long.parseLong(timestring))) {
                throw new EncryptionException("Invalid seal", "Seal expiration date of " + new Date(expiration) + " has past.");
            }
            String nonce = parts[1];
            String b64data = parts[2];
            String sig = parts[3];
            if (!this.verifySignature(sig, timestring + ":" + nonce + ":" + b64data, pubKey)) {
                throw new EncryptionException("Invalid seal", "Seal integrity check failed");
            }
            return ESAPI.encoder().decodeFromBase64(b64data);
        }
        catch (EncryptionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EncryptionException("Invalid seal", "Invalid seal:" + e.getMessage(), e);
        }
    }

    @Override
    public boolean verifySeal(String seal, PublicKey pubKey, SecretKey key) {
        try {
            this.unseal(seal, pubKey, key);
            return true;
        }
        catch (EncryptionException e) {
            return false;
        }
    }

    @Override
    public boolean verifySeal(byte[] seal, PublicKey pubKey, SecretKey key) {
        try {
            this.unseal(seal, pubKey, key);
            return true;
        }
        catch (EncryptionException e) {
            return false;
        }
    }

    @Override
    public long getTimeStamp() {
        return new Date().getTime();
    }

    @Override
    public long getRelativeTimeStamp(long offset) {
        return new Date().getTime() + offset;
    }

    private void logWarning(String where, String msg) {
        int counter = 0;
        if (where.equals("encrypt")) {
            counter = encryptCounter++;
            where = "JavaEncryptor.encrypt(): [count=" + counter + "]";
        } else if (where.equals("decrypt")) {
            counter = decryptCounter++;
            where = "JavaEncryptor.decrypt(): [count=" + counter + "]";
        } else {
            where = "JavaEncryptor: Unknown method: ";
        }
        if (counter % 25 == 0) {
            logger.warning(Logger.SECURITY_FAILURE, where + msg);
        }
    }

    private KeyDerivationFunction.PRF_ALGORITHMS getPRF(String name) {
        String prfName = null;
        prfName = name == null ? ESAPI.securityConfiguration().getKDFPseudoRandomFunction() : name;
        KeyDerivationFunction.PRF_ALGORITHMS prf = KeyDerivationFunction.convertNameToPRF(prfName);
        return prf;
    }

    private KeyDerivationFunction.PRF_ALGORITHMS getDefaultPRF() {
        String prfName = ESAPI.securityConfiguration().getKDFPseudoRandomFunction();
        return this.getPRF(prfName);
    }

    private SecretKey computeDerivedKey(int kdfVersion, KeyDerivationFunction.PRF_ALGORITHMS prf, SecretKey kdk, int keySize, String purpose) throws NoSuchAlgorithmException, InvalidKeyException, EncryptionException {
        assert (prf != null) : "Pseudo Random Function for KDF cannot be null";
        assert (kdk != null) : "Key derivation key cannot be null.";
        assert (keySize >= 56) : "Key has size of " + keySize + ", which is less than absolute minimum of 56-bits.";
        assert (keySize % 8 == 0) : "Key size (" + keySize + ") must be a even multiple of 8-bits.";
        if (!purpose.equals("encryption") && !purpose.equals("authenticity")) {
            String exMsg = "Programming error in ESAPI?? 'purpose' for computeDerivedKey() must be \"encryption\" or \"authenticity\".";
            throw new EncryptionException(exMsg, exMsg);
        }
        KeyDerivationFunction kdf = new KeyDerivationFunction(prf);
        if (kdfVersion != 0) {
            kdf.setVersion(kdfVersion);
        }
        return kdf.computeDerivedKey(kdk, keySize, purpose);
    }

    private static void setupAlgorithms() {
        encryptAlgorithm = ESAPI.securityConfiguration().getEncryptionAlgorithm();
        signatureAlgorithm = ESAPI.securityConfiguration().getDigitalSignatureAlgorithm();
        randomAlgorithm = ESAPI.securityConfiguration().getRandomAlgorithm();
        hashAlgorithm = ESAPI.securityConfiguration().getHashAlgorithm();
        hashIterations = ESAPI.securityConfiguration().getHashIterations();
        encoding = ESAPI.securityConfiguration().getCharacterEncoding();
        encryptionKeyLength = ESAPI.securityConfiguration().getEncryptionKeyLength();
        signatureKeyLength = ESAPI.securityConfiguration().getDigitalSignatureKeyLength();
    }

    private static void initKeyPair(SecureRandom prng) throws NoSuchAlgorithmException {
        String sigAlg = signatureAlgorithm.toLowerCase();
        if (sigAlg.contains("withdsa")) {
            sigAlg = "DSA";
        } else if (sigAlg.contains("withrsa")) {
            sigAlg = "RSA";
        }
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance(sigAlg);
        keyGen.initialize(signatureKeyLength, prng);
        KeyPair pair = keyGen.generateKeyPair();
        privateKey = pair.getPrivate();
        publicKey = pair.getPublic();
    }

    @Override
    public String unseal(String seal) throws EncryptionException {
        PlainText plaintext = null;
        try {
            long expiration;
            byte[] encryptedBytes = ESAPI.encoder().decodeFromBase64(seal);
            CipherText cipherText = null;
            try {
                cipherText = CipherText.fromPortableSerializedBytes(encryptedBytes);
            }
            catch (AssertionError e) {
                throw new EncryptionException("Invalid seal", "Seal passed garbarge data resulting in AssertionError: " + e);
            }
            plaintext = this.decrypt(cipherText);
            String[] parts = plaintext.toString().split(":");
            if (parts.length != 4) {
                throw new EncryptionException("Invalid seal", "Seal was not formatted properly.");
            }
            String timestring = parts[0];
            long now = new Date().getTime();
            if (now > (expiration = Long.parseLong(timestring))) {
                throw new EncryptionException("Invalid seal", "Seal expiration date of " + new Date(expiration) + " has past.");
            }
            String nonce = parts[1];
            String b64data = parts[2];
            String sig = parts[3];
            if (!this.verifySignature(sig, timestring + ":" + nonce + ":" + b64data)) {
                throw new EncryptionException("Invalid seal", "Seal integrity check failed");
            }
            return new String(ESAPI.encoder().decodeFromBase64(b64data), "UTF-8");
        }
        catch (EncryptionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EncryptionException("Invalid seal", "Invalid seal:" + e.getMessage(), e);
        }
    }

    public boolean verifySignature(String signature, String data) {
        try {
            byte[] bytes = ESAPI.encoder().decodeFromBase64(signature);
            Signature signer = Signature.getInstance(signatureAlgorithm);
            signer.initVerify(publicKey);
            signer.update(data.getBytes(encoding));
            return signer.verify(bytes);
        }
        catch (Exception e) {
            new EncryptionException("Invalid signature", "Problem verifying signature: " + e.getMessage(), e);
            return false;
        }
    }

    static {
        initialized = false;
        secretKeySpec = null;
        encryptAlgorithm = "AES";
        encoding = "UTF-8";
        encryptionKeyLength = 128;
        privateKey = null;
        publicKey = null;
        signatureAlgorithm = "SHA256withRSA";
        randomAlgorithm = "SHA1PRNG";
        signatureKeyLength = 1024;
        hashAlgorithm = "SHA-512";
        hashIterations = 1024;
        logger = ESAPI.getLogger("JavaEncryptor");
        encryptCounter = 0;
        decryptCounter = 0;
        N_SECS = 2;
        try {
            SecurityProviderLoader.loadESAPIPreferredJCEProvider();
        }
        catch (NoSuchProviderException ex) {
            logger.fatal(Logger.SECURITY_FAILURE, "JavaEncryptor failed to load preferred JCE provider.", ex);
            throw new ExceptionInInitializerError(ex);
        }
        JavaEncryptor.setupAlgorithms();
    }
}

