/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.drop.protocol.rest.entity;

import com.huawei.baize.base.string.StringFormatUtils;
import com.huawei.smartkit.drop.protocol.rest.Constants;
import com.huawei.smartkit.drop.protocol.rest.entity.Method;
import com.huawei.smartkit.drop.util.JsonUtils;
import com.huawei.smartkit.drop.util.UrlUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class Request {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Request.class);
    @NotNull
    private final String uri;
    @NotNull
    private final Method method;
    private final Map<String, String> headers;
    private final Map<String, String> params;
    private final Object body;

    public okhttp3.Request toOkhttpRequest(String baseUrl) {
        return new Request.Builder().url(StringFormatUtils.format((String)"{}{}?{}", (Object[])new Object[]{baseUrl, this.uri, this.paramString()})).method(this.method.name(), this.requestBody()).headers(Headers.of(CollectionUtils.isEmpty(this.headers) ? new HashMap() : this.headers)).build();
    }

    @Nullable
    private RequestBody requestBody() {
        return this.body == null ? null : RequestBody.create((String)this.bodyString(), (MediaType)Constants.MEDIA_TYPE_JSON);
    }

    private String bodyString() {
        return this.body instanceof String ? (String)this.body : JsonUtils.toJson((Object)this.body);
    }

    private String paramString() {
        if (CollectionUtils.isEmpty(this.params)) {
            return "";
        }
        return this.params.entrySet().stream().map(entry -> StringFormatUtils.format((String)"{}={}", (Object[])new Object[]{entry.getKey(), UrlUtils.encode((String)((String)entry.getValue()))})).collect(Collectors.joining("&"));
    }

    @Generated
    private static Method $default$method() {
        return Method.GET;
    }

    @Generated
    Request(@NotNull String uri, @NotNull Method method, Map<String, String> headers, Map<String, String> params, Object body) {
        if (uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        this.uri = uri;
        this.method = method;
        this.headers = headers;
        this.params = params;
        this.body = body;
    }

    @Generated
    public static RequestBuilder builder() {
        return new RequestBuilder();
    }

    @NotNull
    @Generated
    public String getUri() {
        return this.uri;
    }

    @NotNull
    @Generated
    public Method getMethod() {
        return this.method;
    }

    @Generated
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Generated
    public Map<String, String> getParams() {
        return this.params;
    }

    @Generated
    public Object getBody() {
        return this.body;
    }

    @Generated
    public static class RequestBuilder {
        @Generated
        private String uri;
        @Generated
        private boolean method$set;
        @Generated
        private Method method$value;
        @Generated
        private Map<String, String> headers;
        @Generated
        private Map<String, String> params;
        @Generated
        private Object body;

        @Generated
        RequestBuilder() {
        }

        @Generated
        public RequestBuilder uri(@NotNull String uri) {
            this.uri = uri;
            return this;
        }

        @Generated
        public RequestBuilder method(@NotNull Method method) {
            this.method$value = method;
            this.method$set = true;
            return this;
        }

        @Generated
        public RequestBuilder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        @Generated
        public RequestBuilder params(Map<String, String> params) {
            this.params = params;
            return this;
        }

        @Generated
        public RequestBuilder body(Object body) {
            this.body = body;
            return this;
        }

        @Generated
        public Request build() {
            Method method$value = this.method$value;
            if (!this.method$set) {
                method$value = Request.$default$method();
            }
            return new Request(this.uri, method$value, this.headers, this.params, this.body);
        }

        @Generated
        public String toString() {
            return "Request.RequestBuilder(uri=" + this.uri + ", method$value=" + (Object)((Object)this.method$value) + ", headers=" + this.headers + ", params=" + this.params + ", body=" + this.body + ")";
        }
    }
}

