/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.drop.protocol.rest.entity;

import com.huawei.baize.base.string.StringFormatUtils;
import com.huawei.smartkit.drop.util.JsonUtils;
import java.io.IOException;
import lombok.Generated;
import okhttp3.Headers;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Response {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Response.class);
    @NotNull
    private final okhttp3.Response rawResponse;
    private final String body;

    public Response(@NotNull okhttp3.Response rawResponse) {
        this.rawResponse = rawResponse;
        this.body = this.bodyString();
    }

    public String message() {
        return StringFormatUtils.format((String)"Response code: {}, message: {}", (Object[])new Object[]{this.rawResponse.code(), this.rawResponse.message()});
    }

    @NotNull
    public Headers headers() {
        return this.rawResponse.headers();
    }

    public boolean isSuccessful() {
        return this.rawResponse.isSuccessful();
    }

    @Nullable
    public <T> T body(@NotNull Class<T> type) {
        return (T)JsonUtils.toObject((String)this.body, type);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String bodyString() {
        if (this.rawResponse.body() == null) {
            return "";
        }
        try (ResponseBody responseBody = this.rawResponse.body();){
            String string = responseBody.string();
            return string;
        }
        catch (IOException e) {
            log.error("get body from response error", (Throwable)e);
            return "";
        }
    }

    @Generated
    public String getBody() {
        return this.body;
    }
}

