/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.drop.protocol.rest.service;

import com.huawei.smartkit.drop.protocol.rest.entity.RestException;
import com.huawei.smartkit.drop.protocol.rest.service.RestConnection;
import com.huawei.smartkit.drop.protocol.rest.service.cmd.RestConnectionCmd;
import com.huawei.smartkit.drop.protocol.rest.service.impl.RestConnectionImpl;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import lombok.Generated;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ConnectionManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConnectionManager.class);
    private static final int DEFAULT_POOL_SIZE = 100;
    private static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(30L);
    private final X509TrustManager x509TrustManager = new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    };
    private final Map<String, RestConnection> connectionPoolMap = new LinkedHashMap<String, RestConnection>(100){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, RestConnection> eldest) {
            return this.size() > 100;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public RestConnection getConnection(@NotNull RestConnectionCmd cmd) {
        String baseUrl = cmd.toUrl();
        RestConnection connection = this.connectionPoolMap.get(baseUrl);
        if (connection != null) {
            return connection;
        }
        Map<String, RestConnection> map = this.connectionPoolMap;
        synchronized (map) {
            connection = new RestConnectionImpl(baseUrl, this.getOkHttpClient());
            this.connectionPoolMap.put(baseUrl, connection);
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(@NotNull RestConnectionCmd cmd) {
        String baseUrl = cmd.toUrl();
        RestConnection connection = this.connectionPoolMap.get(baseUrl);
        if (connection == null) {
            return;
        }
        Map<String, RestConnection> map = this.connectionPoolMap;
        synchronized (map) {
            this.connectionPoolMap.remove(baseUrl);
        }
    }

    public int getPoolSize() {
        return this.connectionPoolMap.size();
    }

    private OkHttpClient getOkHttpClient() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(null, new TrustManager[]{this.x509TrustManager}, new SecureRandom());
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            return new OkHttpClient.Builder().sslSocketFactory(sslSocketFactory, this.x509TrustManager).hostnameVerifier((hostname, session) -> true).connectTimeout(DEFAULT_TIMEOUT).readTimeout(DEFAULT_TIMEOUT).writeTimeout(DEFAULT_TIMEOUT).build();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            log.error("getOkHttpClient failed.", (Throwable)e);
            throw new RestException("getOkHttpClient failed");
        }
    }
}

