/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.drop.protocol.rest.service.impl;

import com.huawei.smartkit.drop.protocol.rest.Constants;
import com.huawei.smartkit.drop.protocol.rest.entity.Request;
import com.huawei.smartkit.drop.protocol.rest.service.RestConnection;
import com.huawei.smartkit.drop.util.sensitive.SensitiveClearable;
import java.io.IOException;
import lombok.Generated;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestConnectionImpl
implements RestConnection {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RestConnectionImpl.class);
    @NotNull
    private final String baseUrl;
    @NotNull
    private final OkHttpClient client;

    @Override
    @NotNull
    public com.huawei.smartkit.drop.protocol.rest.entity.Response execute(@NotNull Request request) {
        Call call = this.client.newCall(request.toOkhttpRequest(this.baseUrl));
        try {
            Response response = call.execute();
            if (request.getBody() instanceof SensitiveClearable) {
                ((SensitiveClearable)request.getBody()).clear();
            }
            return new com.huawei.smartkit.drop.protocol.rest.entity.Response(response);
        }
        catch (IOException e) {
            log.error("error executing request", (Throwable)e);
            return Constants.FAIL_RESPONSE;
        }
    }

    @Generated
    public RestConnectionImpl(@NotNull String baseUrl, @NotNull OkHttpClient client) {
        if (baseUrl == null) {
            throw new NullPointerException("baseUrl is marked non-null but is null");
        }
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        this.baseUrl = baseUrl;
        this.client = client;
    }
}

