/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.context;

import com.huawei.ism.tool.base.utils.VerifyUtil;
import com.huawei.ism.tool.devicecenter.entity.AbstractDevice;
import com.huawei.ism.tool.devicecenter.service.IImportListener;
import com.huawei.ism.tool.devicecenter.ui.dialog.ServerManagerDialog;
import com.huawei.ism.tool.devicecenter.ui.dialog.ServerManagerPanel;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.pubservice.PublicServiceManage;
import com.huawei.ism.tool.framework.pubservice.common.IDeviceCenterManage;
import com.huawei.ism.tool.framework.pubservice.listener.INodeNumberObserver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.JFrame;

public class DeviceCenterContext {
    private static DeviceCenterContext instance = new DeviceCenterContext();
    public static final String MARK_QUOTATION = "\"";
    public static final int SERVER_REDFISH_PWD_MAX_LEN = 64;
    public static final int SERVER_REDFISH_USER_NAME_MAX_LEN = 16;
    private static int serverPwdMaxLen = 30;
    private static int serverPwdMinLen = 6;
    private static int serverUserNameMaxLen = 20;
    private static boolean enableWhiteList = false;
    private static final String TASK_FILE_DELETE_FLAG_YES = "true";
    private List<AbstractDevice> envirDeviceList = new ArrayList<AbstractDevice>();
    private final List<AbstractDevice> ibmcHmmOsDevs = new ArrayList<AbstractDevice>();
    private Map<String, List<IImportListener>> deviceTables = new HashMap<String, List<IImportListener>>();
    private Map<String, List<IImportListener>> sceneDeviceTables = new HashMap<String, List<IImportListener>>();
    private Map<String, ServerManagerDialog> serverAddDialog = new HashMap<String, ServerManagerDialog>();
    private final List<AbstractDevice> hasedDevicesBeforeRefresh = new ArrayList<AbstractDevice>(20);
    private JFrame parentFrame;
    private boolean batchisCancel = false;
    private ServerManagerPanel serverManagePanel = null;

    private DeviceCenterContext() {
    }

    public boolean isBatchisCancel() {
        return this.batchisCancel;
    }

    public void setBatchisCancel(boolean batchisCancel) {
        this.batchisCancel = batchisCancel;
    }

    public static DeviceCenterContext getInstance() {
        return instance;
    }

    public void setParent(JFrame parent) {
        this.parentFrame = parent;
    }

    public JFrame getParent() {
        return this.parentFrame;
    }

    public List<AbstractDevice> getEnvirDeviceList() {
        return this.envirDeviceList;
    }

    public void setEnvirDeviceList(List<AbstractDevice> envirDeviceList) {
        this.envirDeviceList = envirDeviceList;
    }

    public List<AbstractDevice> getIbmcHmmOsDevs() {
        return this.ibmcHmmOsDevs;
    }

    public Map<String, List<IImportListener>> getDeviceTables() {
        return this.deviceTables;
    }

    public void setDeviceTables(Map<String, List<IImportListener>> deviceTables) {
        this.deviceTables = deviceTables;
    }

    public void setIbmcHmmOsDevs(List<AbstractDevice> devs) {
        ArrayList<AbstractDevice> tempList = new ArrayList<AbstractDevice>();
        tempList.addAll(devs);
        this.ibmcHmmOsDevs.removeAll(tempList);
        this.ibmcHmmOsDevs.addAll(tempList);
    }

    public Map<String, List<IImportListener>> getSceneDeviceTables() {
        return this.sceneDeviceTables;
    }

    public void setSceneDeviceTables(Map<String, List<IImportListener>> sceneDeviceTables) {
        this.sceneDeviceTables = sceneDeviceTables;
    }

    public void notifyDeviceObserver() {
        IDeviceCenterManage deviceCenterManage = (IDeviceCenterManage)PublicServiceManage.getInstance().getService(IDeviceCenterManage.class);
        if (!VerifyUtil.isEmpty((Object)deviceCenterManage)) {
            List allNodeNumberObsers = deviceCenterManage.getAllNodeNumberObsers();
            for (INodeNumberObserver observer : allNodeNumberObsers) {
                observer.fireDeviceNumberChange(this.ibmcHmmOsDevs.size());
            }
        }
    }

    public ServerManagerPanel getServerManagePanel() {
        return this.serverManagePanel;
    }

    public void setServerManagePanel(ServerManagerPanel serverManagePanel) {
        this.serverManagePanel = serverManagePanel;
    }

    public Map<String, ServerManagerDialog> getServerAddDialog() {
        return this.serverAddDialog;
    }

    public void setServerAddDialog(Map<String, ServerManagerDialog> serverAddDialog) {
        this.serverAddDialog = serverAddDialog;
    }

    public static boolean shouldDeleteTaskFile() {
        return TASK_FILE_DELETE_FLAG_YES.equals(ApplicationContext.getInstance().getAppConfigNoExcept("app.data.exchange.file.delete.flag.task.file"));
    }

    public List<AbstractDevice> getHasedDevicesBeforeRefresh() {
        return this.hasedDevicesBeforeRefresh;
    }

    public ServerManagerDialog getSelectServerManagerDialog() {
        return DeviceCenterContext.getInstance().getServerAddDialog().get("serverAddDialog");
    }

    private static void initFieldLenMaxValue() {
        String serverUserNameMaxLenValue;
        String serverPwdMinLenValue;
        String serverPwdMaxLenValue = ApplicationContext.getInstance().getAppConfigNoExcept("app.devicecenter.layout.pwd.max.len");
        if (!VerifyUtil.isEmpty((String)serverPwdMaxLenValue) && Pattern.matches("^\\d+$", serverPwdMaxLenValue)) {
            serverPwdMaxLen = Integer.parseInt(serverPwdMaxLenValue.trim());
        }
        if (!VerifyUtil.isEmpty((String)(serverPwdMinLenValue = ApplicationContext.getInstance().getAppConfigNoExcept("app.devicecenter.layout.pwd.min.len"))) && Pattern.matches("^\\d+$", serverPwdMinLenValue)) {
            serverPwdMinLen = Integer.parseInt(serverPwdMinLenValue.trim());
        }
        if (!VerifyUtil.isEmpty((String)(serverUserNameMaxLenValue = ApplicationContext.getInstance().getAppConfigNoExcept("app.devicecenter.layout.user.name.max.len"))) && Pattern.matches("^\\d+$", serverUserNameMaxLenValue)) {
            serverUserNameMaxLen = Integer.parseInt(serverUserNameMaxLenValue.trim());
        }
    }

    public static int getServerPwdMaxLen() {
        return serverPwdMaxLen;
    }

    public static int getServerPwdMinLen() {
        return serverPwdMinLen;
    }

    public static int getServerUserNameMaxLen() {
        return serverUserNameMaxLen;
    }

    public static boolean isEnableWhiteList() {
        return enableWhiteList;
    }

    public static void setEnableWhiteList(boolean enableWhiteList) {
        DeviceCenterContext.enableWhiteList = enableWhiteList;
    }

    static {
        DeviceCenterContext.initFieldLenMaxValue();
    }
}

