/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.context;

import com.huawei.ism.tool.base.utils.DateUtil;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.devicecenter.driver.model.DeviceProgress;
import com.huawei.ism.tool.devicecenter.driver.model.DeviceResult;
import com.huawei.ism.tool.devicecenter.driver.model.DriverResult;
import com.huawei.ism.tool.devicecenter.driver.model.ITDeviceType;
import com.huawei.ism.tool.devicecenter.driver.model.TaskType;
import com.huawei.ism.tool.devicecenter.driver.model.TotalDriverResult;
import com.huawei.ism.tool.obase.connection.MultiRouteNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.json.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SshForwardContext {
    private static volatile SshForwardContext instance;
    private Map<String, TotalDriverResult> totalDriverResultMap = new ConcurrentHashMap<String, TotalDriverResult>();
    private Map<String, List<MultiRouteNode>> sshRouteMap = new ConcurrentHashMap<String, List<MultiRouteNode>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SshForwardContext getInstance() {
        if (instance != null) return instance;
        Class<SshForwardContext> clazz = SshForwardContext.class;
        synchronized (SshForwardContext.class) {
            if (instance != null) return instance;
            instance = new SshForwardContext();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public String generateTaskID() {
        StringBuffer taskIdGenerator = new StringBuffer();
        taskIdGenerator.append(TaskType.DEV_ADD.getName()).append(DateUtil.getDateTime((String)"yyyyMMddHHmmss", (Date)new Date()));
        return taskIdGenerator.toString();
    }

    public TotalDriverResult getTotalDriverResult(String taskId) {
        return this.totalDriverResultMap.getOrDefault(taskId, new TotalDriverResult());
    }

    public void initTotalDriverResult(String taskId, DriverResult serverResult) {
        TotalDriverResult totalDriverResult = new TotalDriverResult();
        totalDriverResult.getTotalDriverResultMap().put(ITDeviceType.SERVER_IBMC, serverResult);
        this.totalDriverResultMap.put(taskId, totalDriverResult);
    }

    public synchronized void updateDriverResult(String taskId, DevNode devNode, boolean isSuccess, String fingerPrint, String hostKey) {
        DriverResult driverResult = this.getDriverResult(taskId);
        List<DeviceProgress> deviceProgressList = driverResult.getDeviceProgressList();
        for (int i = 0; i < deviceProgressList.size(); ++i) {
            DeviceProgress deviceProgress = deviceProgressList.get(i);
            if (!deviceProgress.getIp().equalsIgnoreCase(devNode.getIp())) continue;
            this.updateDeviceProgress(deviceProgress, devNode, isSuccess, fingerPrint, hostKey);
            this.updateTotalDriverResult(taskId);
            driverResult.refreshProgress();
            return;
        }
    }

    public synchronized void updateErrorMsg(String taskId, DevNode devNode, boolean isSuccess, String fingerPrint, String hostKey) {
        DriverResult driverResult = this.getDriverResult(taskId);
        List<DeviceProgress> deviceProgressList = driverResult.getDeviceProgressList();
        deviceProgressList.forEach(progress -> {
            if (progress.getIp().equalsIgnoreCase(devNode.getIp())) {
                progress.setPortUsage(true);
                this.updateDeviceProgress((DeviceProgress)progress, devNode, isSuccess, fingerPrint, hostKey);
                progress.setErrMsg(ResourceUtil.getString((String)"help.ocuments.hyperlink"));
                return;
            }
        });
    }

    private DeviceProgress updateDeviceProgress(DeviceProgress deviceProgress, DevNode devNode, boolean isSuccess, String fingerPrint, String hostKey) {
        deviceProgress.setSerialNo(devNode.getDeviceSerialNumber());
        deviceProgress.setErrMsg("");
        deviceProgress.setResult(isSuccess ? DeviceResult.SUCCESS : DeviceResult.FAILED);
        deviceProgress.setUpdateTime(new Date(System.currentTimeMillis()));
        JSONObject externalResultObject = new JSONObject();
        externalResultObject.put("deviceType", (Object)"os");
        deviceProgress.setExternalResult(externalResultObject);
        if (isSuccess) {
            deviceProgress.setFingerPrint(fingerPrint);
            deviceProgress.setSshHostKey(hostKey);
        }
        deviceProgress.updateToFinish();
        return deviceProgress;
    }

    public synchronized void updateTotalDriverResult(String taskId) {
        this.getTotalDriverResult(taskId).update();
    }

    public DriverResult getDriverResult(String taskId) {
        return this.getTotalDriverResult(taskId).getTotalDriverResultMap().getOrDefault((Object)ITDeviceType.SERVER_IBMC, new DriverResult());
    }

    public void saveSshRoute(String ip, List<MultiRouteNode> sshList) {
        this.sshRouteMap.put(ip, sshList);
    }

    public List<MultiRouteNode> getSshListByIp(String ip) {
        return this.sshRouteMap.getOrDefault(ip, new ArrayList());
    }

    private SshForwardContext() {
    }
}

