/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.driver.cmd;

import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.devicecenter.driver.cmd.CMDProccess;
import com.huawei.ism.tool.devicecenter.driver.cmd.Proccessor;
import com.huawei.ism.tool.devicecenter.driver.utils.DriverUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.security.SecureRandom;
import org.slf4j.Logger;

public class BATProcessor
extends Proccessor {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(BATProcessor.class);
    private static final String TEMP_PATH = ApplicationContext.getInstance().getTmpPath() + File.separator + "cmd" + File.separator;
    private String cmd = null;
    private String name = "";

    public BATProcessor(String name, String cmd) {
        this.name = name;
        this.cmd = cmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File generateBat() {
        if (this.cmd == null) {
            return null;
        }
        File file = DriverUtils.getCanonicalFile(TEMP_PATH);
        if (file == null || !file.exists()) {
            FileUtils.createDir((File)file);
        }
        String canonicalPath = "";
        if (null != file) {
            try {
                canonicalPath = file.getCanonicalPath();
            }
            catch (IOException e) {
                LOGGER.error("Failed to get canonical path.");
            }
        }
        SecureRandom random = new SecureRandom();
        long rand = random.nextLong();
        String filepath = canonicalPath + File.separator + "toolkit_dc" + rand + ".bat";
        File canonicalFile = DriverUtils.getCanonicalFile(filepath);
        DriverUtils.createFile(DriverUtils.getCanonicalFilePath(canonicalFile));
        BufferedWriter writer = null;
        FileOutputStream canonicalFileStream = null;
        OutputStreamWriter fileWriter = null;
        try {
            canonicalFileStream = new FileOutputStream(canonicalFile);
            fileWriter = new OutputStreamWriter((OutputStream)canonicalFileStream, "UTF-8");
            writer = new BufferedWriter(fileWriter);
            writer.write(this.cmd);
            writer.newLine();
        }
        catch (Exception e) {
            try {
                LOGGER.error("Failed to write bat", (Throwable)e);
            }
            catch (Throwable throwable) {
                StreamUtils.closeResource(writer, writer);
                StreamUtils.closeResource(fileWriter, fileWriter);
                StreamUtils.closeResource((Flushable)canonicalFileStream, (Closeable)canonicalFileStream);
                throw throwable;
            }
            StreamUtils.closeResource(writer, writer);
            StreamUtils.closeResource((Flushable)fileWriter, (Closeable)fileWriter);
            StreamUtils.closeResource((Flushable)canonicalFileStream, (Closeable)canonicalFileStream);
        }
        StreamUtils.closeResource((Flushable)writer, (Closeable)writer);
        StreamUtils.closeResource((Flushable)fileWriter, (Closeable)fileWriter);
        StreamUtils.closeResource((Flushable)canonicalFileStream, (Closeable)canonicalFileStream);
        return canonicalFile;
    }

    @Override
    public CMDProccess getProcess() throws IOException {
        File file = this.generateBat();
        if (file == null) {
            return null;
        }
        String cpath = file.getCanonicalPath();
        Process process = super.exec("\"" + cpath + "\"");
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("exec bat " + this.name + ' ' + cpath);
        }
        CMDProccess cp = new CMDProccess();
        cp.setProcess(process);
        cp.setFile(file);
        return cp;
    }
}

