/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.driver.cmd;

import com.huawei.ism.tool.base.utils.OSCmdUtils;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.ThreadPool;
import com.huawei.ism.tool.devicecenter.driver.cmd.CMDProccess;
import com.huawei.ism.tool.devicecenter.driver.manager.CmdManager;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.InputStream;
import java.text.Normalizer;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class CmdExcutor {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(CmdExcutor.class);

    public static boolean executeCmd(String cmd) {
        return CmdExcutor.executeCmd(cmd, 120000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean executeCmd(String cmd, int overTime) {
        if (StringUtils.isNULLStr(cmd)) {
            return false;
        }
        String normalizedCmd = Normalizer.normalize(cmd, Normalizer.Form.NFKC);
        InputStream inputStream = null;
        boolean result = false;
        CMDProccess proccess = null;
        try {
            proccess = CmdManager.getProcess(normalizedCmd);
            if (proccess != null) {
                OSCmdUtils.ProcessStreamClearCall streamClear = new OSCmdUtils.ProcessStreamClearCall(proccess.getProcess(), true, false);
                Future future = ThreadPool.getInstance().submit((Callable)streamClear);
                future.get(overTime, TimeUnit.SECONDS);
                result = true;
                LOGGER.info(" -------- streamClear.getBuff() beging -------- ");
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("streamClear.getBuff() = " + streamClear.getBuff());
                }
                LOGGER.info("-------- streamClear.getBuff()  end ------------");
            } else {
                LOGGER.error("Failed to exec cmd:" + normalizedCmd);
            }
        }
        catch (InterruptedException e1) {
            LOGGER.error("Clear InterruptedException output stream error :", (Throwable)e1);
        }
        catch (Exception e1) {
            LOGGER.error("Clear Exception output stream error :", (Throwable)e1);
        }
        finally {
            StreamUtils.closeStream(null, inputStream);
            if (proccess != null) {
                proccess.close();
            }
        }
        return result;
    }
}

