/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.driver.manager;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.devicecenter.driver.model.ThirdPartyTool;
import com.huawei.ism.tool.devicecenter.driver.utils.DriverContext;
import com.huawei.ism.tool.devicecenter.driver.utils.DriverUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThirdPartyToolManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThirdPartyToolManager.class);
    private static ThirdPartyToolManager instance = new ThirdPartyToolManager();
    private List<ThirdPartyTool> thirdPartyTools = new ArrayList<ThirdPartyTool>();

    private ThirdPartyToolManager() {
        this.searchTool();
    }

    public static ThirdPartyToolManager getInstance() {
        if (null == instance) {
            instance = new ThirdPartyToolManager();
        }
        return instance;
    }

    private void searchTool() {
        List<String> toolConfigFilePathList = this.scanToolFolder(DriverContext.TOOL_ROOT_PATH);
        if (toolConfigFilePathList.isEmpty()) {
            LOGGER.info("Can not find any avilable tools.");
            return;
        }
        for (String toolConfigFilePath : toolConfigFilePathList) {
            File toolConfigFile = new File(toolConfigFilePath);
            String tooliniFilePath = toolConfigFile.getParent() + File.separator + "tool.ini";
            File tooliniFile = new File(tooliniFilePath);
            ThirdPartyTool tool = DriverUtils.parseToolIni(tooliniFile);
            tool.getToolServiceParams().addAll(DriverUtils.parseServiceConfig(toolConfigFile));
            this.thirdPartyTools.add(tool);
        }
    }

    private List<String> scanToolFolder(String path) {
        ArrayList<String> thirdPartyToolConfigFilePath = new ArrayList<String>();
        File file = new File(FilePathUtils.filterPath((String)path));
        if (!file.exists()) {
            return thirdPartyToolConfigFilePath;
        }
        File[] files = file.listFiles();
        if (files == null) {
            return thirdPartyToolConfigFilePath;
        }
        for (File toolfile : files) {
            if (!toolfile.isDirectory()) continue;
            File serviceConfigFile = new File(path + File.separator + toolfile.getName() + File.separator + "serviceConf.xml");
            File toolIniFile = new File(path + File.separator + toolfile.getName() + File.separator + "tool.ini");
            if (!serviceConfigFile.exists() || !toolIniFile.exists()) continue;
            try {
                thirdPartyToolConfigFilePath.add(serviceConfigFile.getCanonicalPath());
            }
            catch (IOException e) {
                LOGGER.error("Search tool failed with IO error.");
            }
        }
        return thirdPartyToolConfigFilePath;
    }

    public void addTool(ThirdPartyTool tool) {
        if (!this.thirdPartyTools.contains(tool)) {
            this.thirdPartyTools.add(tool);
        }
    }

    public List<ThirdPartyTool> getThirdPartTools() {
        return this.thirdPartyTools;
    }

    public void setThirdPartTools(List<ThirdPartyTool> pThirdPartyTools) {
        this.thirdPartyTools = pThirdPartyTools;
    }

    public void reSearchTools() {
        this.thirdPartyTools.clear();
        this.searchTool();
    }
}

