/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.driver.model;

import com.huawei.ism.tool.base.utils.VerifyUtil;
import com.huawei.ism.tool.devicecenter.driver.model.CommonStatus;
import com.huawei.ism.tool.devicecenter.driver.model.DeviceResult;
import com.huawei.ism.tool.devicecenter.driver.model.PortsCheckResult;
import com.huawei.json.JSONException;
import com.huawei.json.JSONObject;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceProgress {
    private static final Logger log = LoggerFactory.getLogger(DeviceProgress.class);
    private String ip;
    private String staticIp;
    private String httpsPort;
    private String serialNo;
    private String nodeName;
    private String nodeType;
    private CommonStatus status;
    private int progress = 0;
    private Date updateTime = new Date();
    private DeviceResult result;
    private String errMsg;
    private boolean isPortUsage;
    private boolean isConnectError;
    private JSONObject retData = new JSONObject();
    private int nodeId;
    private String nodeIp;
    private int passRate = 0;
    private boolean snRepeatFlag;
    private String fingerPrint;
    private String sshHostKey;
    private PortsCheckResult devPortsCheckResult;

    public DeviceProgress() {
    }

    public DeviceProgress(String ipParam) {
        this.ip = ipParam;
    }

    public DeviceProgress(String nodeName, String nodeType) {
        this.nodeName = nodeName;
        this.nodeType = nodeType;
    }

    public DeviceProgress(int nodeId, String nodeIp) {
        this.nodeId = nodeId;
        this.nodeIp = nodeIp;
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof DeviceProgress) {
            DeviceProgress objProgress = (DeviceProgress)obj;
            String objProgressSerialNo = objProgress.getSerialNo();
            String thisProgressSerialNo = this.getSerialNo();
            String objType = this.getDevType(objProgress.getExternalResult());
            String thisType = this.getDevType(this.getExternalResult());
            try {
                if (this.isAllOsType(thisType, objType)) {
                    return (this.getIp() + thisProgressSerialNo).equals(objProgress.getIp() + objProgressSerialNo);
                }
            }
            catch (JSONException e) {
                log.error("get dev type error.");
                return false;
            }
            if (!VerifyUtil.isEmpty((String)this.getIp()) && this.getIp().equals(objProgress.getIp())) {
                return true;
            }
            if (this.shoudJudgeSn(objProgressSerialNo, thisProgressSerialNo, objType)) {
                return objType.equals(thisType) && thisProgressSerialNo.equals(objProgressSerialNo);
            }
            return false;
        }
        return false;
    }

    private boolean shoudJudgeSn(String objSn, String thisSn, String objType) {
        return !this.isEmptySn(objSn) && !this.isEmptySn(thisSn) && !VerifyUtil.isEmpty((String)objType);
    }

    private boolean isAllOsType(String ... types) {
        for (String type : types) {
            if ("os".equalsIgnoreCase(type)) continue;
            return false;
        }
        return true;
    }

    private String getDevType(JSONObject jsonObject) {
        return jsonObject.has("deviceType") ? jsonObject.getString("deviceType") : "";
    }

    private boolean isEmptySn(String serialNo) {
        return VerifyUtil.isEmpty((String)serialNo) || "--".equals(serialNo);
    }

    public int hashCode() {
        String ipAddr = this.ip;
        char[] chars = ipAddr.toCharArray();
        int hashTemp = 0;
        for (char c : chars) {
            hashTemp += c;
        }
        String thisSn = this.getSerialNo();
        return super.hashCode() + hashTemp + thisSn.hashCode();
    }

    public CommonStatus getStatus() {
        return this.status;
    }

    public void setStatus(CommonStatus status) {
        this.status = status;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public Date getUpdateTime() {
        return (Date)this.updateTime.clone();
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = (Date)updateTime.clone();
    }

    public DeviceResult getResult() {
        return this.result;
    }

    public void setResult(DeviceResult result) {
        this.result = result;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public String getSerialNo() {
        return this.serialNo;
    }

    public void setSerialNo(String serialNo) {
        this.serialNo = serialNo;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public JSONObject getExternalResult() {
        return this.retData;
    }

    public void setExternalResult(JSONObject externalResult) {
        this.retData = externalResult;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(String nodeType) {
        this.nodeType = nodeType;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public String getNodeIp() {
        return this.nodeIp;
    }

    public void setNodeId(int nodeId) {
        this.nodeId = nodeId;
    }

    public void setNodeIp(String nodeIp) {
        this.nodeIp = nodeIp;
    }

    public int getPassRate() {
        return this.passRate;
    }

    public void setPassRate(int passRate) {
        this.passRate = passRate;
    }

    public void updateToFinish() {
        this.passRate = 100;
        this.progress = 100;
        this.status = CommonStatus.FINISHED;
    }

    public void setStaticIp(String staticIp) {
        this.staticIp = staticIp;
    }

    public String getStaticIp() {
        return this.staticIp;
    }

    public void setHttpsPort(String httpsPort) {
        this.httpsPort = httpsPort;
    }

    public String getHttpsPort() {
        return this.httpsPort;
    }

    public boolean isPortUsage() {
        return this.isPortUsage;
    }

    public void setPortUsage(boolean isPortUsage) {
        this.isPortUsage = isPortUsage;
    }

    public boolean isConnectError() {
        return this.isConnectError;
    }

    public void setConnectError(boolean isConnectError) {
        this.isConnectError = isConnectError;
    }

    public void setSnRepeatFlag(boolean snRepeatFlag) {
        this.snRepeatFlag = snRepeatFlag;
    }

    public boolean isSnRepeatFlag() {
        return this.snRepeatFlag;
    }

    public void setFingerPrint(String fingerPrint) {
        this.fingerPrint = fingerPrint;
    }

    public String getFingerPrint() {
        return this.fingerPrint;
    }

    public void setSshHostKey(String sshHostKey) {
        this.sshHostKey = sshHostKey;
    }

    public String getSshHostKey() {
        return this.sshHostKey;
    }

    public PortsCheckResult getDevPortsCheckResult() {
        return this.devPortsCheckResult;
    }

    public void setDevPortsCheckResult(PortsCheckResult devPortsCheckResult) {
        this.devPortsCheckResult = devPortsCheckResult;
    }
}

