/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.driver.model;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import java.util.Locale;

public enum ITDeviceType {
    SERVER_HMM("E9000Server", "device.import.e9000server.name", "T_DC_DEVICE_SERVER_E9000"),
    SERVER_IBMC("server", "device.import.server.name", "T_DC_DEVICE_SERVER"),
    SERVER_OS("serverOs", "device.import.osServer.name", ""),
    SWITCH("switch", "device.import.switch.name", ""),
    SERVER_CMC("cmc", "", ""),
    IES("ies", "", ""),
    TCE("tce", "", "");

    private String name;
    private String title;
    private String tableName;

    private ITDeviceType() {
    }

    private ITDeviceType(String name, String title, String tableName) {
        this.name = name;
        this.title = title;
        this.tableName = tableName;
    }

    public String getDeviceTypeJsonKey() {
        return ResourceUtil.getString((String)("device.json.type.key." + this.name), (Locale)Locale.CHINESE);
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return ResourceUtil.getString((String)this.title);
    }

    public String getTableName() {
        return this.tableName;
    }

    public static ITDeviceType findDeviceType(String name) {
        ITDeviceType[] deviceTypeValue;
        for (ITDeviceType d : deviceTypeValue = ITDeviceType.values()) {
            if (!d.getName().equals(name)) continue;
            return d;
        }
        return null;
    }
}

