/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.driver.model;

import com.huawei.ism.tool.base.utils.KeyValue;
import com.huawei.ism.tool.devicecenter.driver.model.CommonStatus;
import com.huawei.ism.tool.devicecenter.driver.model.DeviceProgress;
import com.huawei.ism.tool.devicecenter.driver.model.DeviceResult;
import com.huawei.ism.tool.devicecenter.driver.model.DriverResult;
import com.huawei.ism.tool.devicecenter.driver.model.ITDeviceType;
import com.huawei.ism.tool.devicecenter.driver.model.TaskResult;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TotalDriverResult {
    private Map<ITDeviceType, DriverResult> totalDriverResultMap = new HashMap<ITDeviceType, DriverResult>();
    private Map<ITDeviceType, KeyValue<Integer, Integer>> totalProgressMap = new HashMap<ITDeviceType, KeyValue<Integer, Integer>>();
    private Map<ITDeviceType, CommonStatus> totalStatusMap = new HashMap<ITDeviceType, CommonStatus>();
    private Map<ITDeviceType, TaskResult> totalResultMap = new HashMap<ITDeviceType, TaskResult>();

    public void update() {
        this.updateTotalProgress();
        this.updateTotalStatus();
        this.updateTotalResult();
    }

    private void updateTotalStatus() {
        for (ITDeviceType deviceType : this.totalDriverResultMap.keySet()) {
            DriverResult driverResult = this.totalDriverResultMap.get((Object)deviceType);
            if (null == driverResult) continue;
            this.totalStatusMap.put(deviceType, this.getTotalTaskStatus(driverResult));
        }
    }

    private CommonStatus getTotalTaskStatus(DriverResult driverResult) {
        CommonStatus status = CommonStatus.WAITING;
        List<DeviceProgress> progressList = driverResult.getDeviceProgressList();
        int waitNum = 0;
        int finishNum = 0;
        if (null != progressList && !progressList.isEmpty()) {
            for (DeviceProgress deviceProgress : progressList) {
                if (CommonStatus.RUNNING == deviceProgress.getStatus()) {
                    status = CommonStatus.RUNNING;
                    break;
                }
                if (CommonStatus.WAITING == deviceProgress.getStatus()) {
                    ++waitNum;
                    continue;
                }
                ++finishNum;
            }
            if (progressList.size() == waitNum) {
                status = CommonStatus.WAITING;
            }
            if (progressList.size() == finishNum) {
                status = CommonStatus.FINISHED;
            }
        }
        return status;
    }

    private void updateTotalProgress() {
        for (ITDeviceType deviceType : this.totalDriverResultMap.keySet()) {
            this.totalProgressMap.put(deviceType, this.getTotalTaskProgress(this.totalDriverResultMap.get((Object)deviceType)));
        }
    }

    private KeyValue<Integer, Integer> getTotalTaskProgress(DriverResult driverResult) {
        KeyValue progress = new KeyValue((Object)0, (Object)0);
        if (null == driverResult) {
            return progress;
        }
        List<DeviceProgress> progressList = driverResult.getDeviceProgressList();
        if (null != progressList) {
            progress.setValue((Object)progressList.size());
            int successNum = 0;
            for (DeviceProgress deviceProgress : progressList) {
                if (null == deviceProgress.getResult() || CommonStatus.FINISHED != deviceProgress.getStatus() || DeviceResult.SUCCESS != deviceProgress.getResult() && !DeviceResult.PART_SUCCESS.equals((Object)deviceProgress.getResult())) continue;
                ++successNum;
            }
            progress.setKey((Object)successNum);
        }
        return progress;
    }

    private void updateTotalResult() {
        for (ITDeviceType deviceType : this.totalDriverResultMap.keySet()) {
            this.totalResultMap.put(deviceType, this.getTotalTaskResult(deviceType));
        }
    }

    private TaskResult getTotalTaskResult(ITDeviceType deviceType) {
        TaskResult result = TaskResult.ALL_SUCCESS;
        if (this.totalStatusMap.get((Object)deviceType) == CommonStatus.FINISHED) {
            DriverResult driverResult;
            result = ITDeviceType.SERVER_HMM.equals((Object)deviceType) ? (null == (driverResult = this.totalDriverResultMap.get((Object)deviceType)) ? this.getResultFromProgressMap(deviceType) : this.getServerResult(deviceType, driverResult)) : this.getResultFromProgressMap(deviceType);
        }
        return result;
    }

    private TaskResult getServerResult(ITDeviceType deviceType, DriverResult driverResult) {
        TaskResult result;
        List<DeviceProgress> progressList = driverResult.getDeviceProgressList();
        HashMap<DeviceResult, Integer> resultMap = new HashMap<DeviceResult, Integer>();
        resultMap.put(DeviceResult.SUCCESS, 0);
        resultMap.put(DeviceResult.FAILED, 0);
        resultMap.put(DeviceResult.PART_SUCCESS, 0);
        resultMap.put(DeviceResult.UNSUPPORTED, 0);
        if (null != progressList) {
            for (DeviceProgress deviceProgress : progressList) {
                if (null == deviceProgress.getResult()) continue;
                int value = (Integer)resultMap.get((Object)deviceProgress.getResult());
                resultMap.put(deviceProgress.getResult(), ++value);
            }
            result = ((Integer)resultMap.get((Object)DeviceResult.SUCCESS)).intValue() == progressList.size() ? TaskResult.ALL_SUCCESS : (((Integer)resultMap.get((Object)DeviceResult.FAILED)).intValue() == progressList.size() ? TaskResult.ALL_FAILED : TaskResult.PART_SUCCESS);
        } else {
            result = this.getResultFromProgressMap(deviceType);
        }
        return result;
    }

    private TaskResult getResultFromProgressMap(ITDeviceType deviceType) {
        TaskResult result = this.totalProgressMap.get((Object)deviceType).getKey() == this.totalProgressMap.get((Object)deviceType).getValue() ? TaskResult.ALL_SUCCESS : ((Integer)this.totalProgressMap.get((Object)deviceType).getKey() == 0 ? TaskResult.ALL_FAILED : TaskResult.PART_SUCCESS);
        return result;
    }

    public DriverResult getDriverResultByDeviceType(ITDeviceType deviceType) {
        return this.getTotalDriverResultMap().get((Object)deviceType);
    }

    public Map<ITDeviceType, DriverResult> getTotalDriverResultMap() {
        return this.totalDriverResultMap;
    }

    public void setTotalDriverResultMap(Map<ITDeviceType, DriverResult> totalDriverResultMap) {
        this.totalDriverResultMap = totalDriverResultMap;
    }

    public Map<ITDeviceType, KeyValue<Integer, Integer>> getTotalProgressMap() {
        return this.totalProgressMap;
    }

    public void setTotalProgressMap(Map<ITDeviceType, KeyValue<Integer, Integer>> totalProgressMap) {
        this.totalProgressMap = totalProgressMap;
    }

    public Map<ITDeviceType, CommonStatus> getTotalStatusMap() {
        return this.totalStatusMap;
    }

    public void setTotalStatusMap(Map<ITDeviceType, CommonStatus> totalStatusMap) {
        this.totalStatusMap = totalStatusMap;
    }

    public Map<ITDeviceType, TaskResult> getTotalResultMap() {
        return this.totalResultMap;
    }

    public void setTotalResultMap(Map<ITDeviceType, TaskResult> totalResultMap) {
        this.totalResultMap = totalResultMap;
    }
}

