/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.entity;

import com.huawei.ism.tool.base.utils.VerifyUtil;
import com.huawei.ism.tool.devicecenter.driver.model.ITDeviceType;
import com.huawei.ism.tool.devicecenter.entity.AbstractDevice;
import com.huawei.ism.tool.devicecenter.entity.ComputeNodePlate;
import com.huawei.ism.tool.devicecenter.entity.SwitchPlate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class HwServerDevice
extends AbstractDevice {
    public static final int DEFAULT_SNMP_PORT = 161;
    public static final int DEFAULT_SSH_PORT = 22;
    public static final int DEFAULT_IPMI_PORT = 623;
    public static final int DEFAULT_VMM_PORT = 8208;
    private String manageIp = "";
    private String startIPAddress = "";
    private String endIPAddress = "";
    private String userName = "";
    private String userPwd = "";
    private String snmpPrivPwd = "";
    private String rootPwd = "";
    private String community = "";
    private boolean onlySecurityAlgSupportedFlag = false;
    private int snmpPort = 161;
    private int sshPort = 22;
    private int ipmiPort = 623;
    private boolean isPortProxy = false;
    private int vmmPort = 8208;
    private String redFishPort = "";
    private String redFishUserName = "";
    private String redFishPwd = "";
    private boolean isSupportAccountSeparation;
    private Map<String, SwitchPlate> switchPlateMap = new HashMap<String, SwitchPlate>();
    private List<ComputeNodePlate> computeNodePlateList = new ArrayList<ComputeNodePlate>();
    private boolean applyToOtherNodes;
    private boolean isBatchImport = false;

    @Override
    public String toString() {
        return "HwServerDevice{manageIp='" + this.manageIp + '\'' + ", startIPAddress='" + this.startIPAddress + '\'' + ", endIPAddress='" + this.endIPAddress + '\'' + ", snmpPort=" + this.snmpPort + ", sshPort=" + this.sshPort + ", ipmiPort=" + this.ipmiPort + ", vmmPort=" + this.vmmPort + ", redFishPort='" + this.redFishPort + '\'' + ", applyToOtherNodes=" + this.applyToOtherNodes + ", isBatchImport=" + this.isBatchImport + '}';
    }

    public String buildHwServerDevInfo() {
        StringBuilder hwServerDevInfo = new StringBuilder();
        hwServerDevInfo.append(this.getStartIPAddress().trim());
        hwServerDevInfo.append(this.getEndIPAddress().trim());
        hwServerDevInfo.append(this.getUserName().trim());
        hwServerDevInfo.append(this.getUserPwd());
        hwServerDevInfo.append(this.getRootPwd());
        hwServerDevInfo.append(this.getSnmpPrivPwd());
        if (this.getItDeviceType() != ITDeviceType.SERVER_OS) {
            hwServerDevInfo.append(this.getSshPort());
            hwServerDevInfo.append(this.getIpmiPort());
            hwServerDevInfo.append(this.getVmmPort());
            hwServerDevInfo.append(this.getSnmpPort());
            hwServerDevInfo.append(this.getRedFishPort());
            hwServerDevInfo.append(this.getCommunity());
        }
        return hwServerDevInfo.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof HwServerDevice)) {
            return false;
        }
        HwServerDevice hw = (HwServerDevice)obj;
        if (!this.buildHwServerDevInfo().equals(hw.buildHwServerDevInfo())) {
            return false;
        }
        return this.isSwplateEqual(this, hw) && this.isComputeNodeListEqual(this, hw);
    }

    private boolean isSwplateEqual(HwServerDevice thisHw, HwServerDevice argHw) {
        if (VerifyUtil.isEmpty(this.switchPlateMap) && VerifyUtil.isEmpty(argHw.switchPlateMap)) {
            return true;
        }
        if (thisHw.switchPlateMap.size() == argHw.switchPlateMap.size()) {
            int size = thisHw.switchPlateMap.size();
            for (int i = 1; i <= size; ++i) {
                SwitchPlate hwSwPlate;
                SwitchPlate thisSwPlate = this.switchPlateMap.get("switch_plate" + i);
                if (thisSwPlate.equals(hwSwPlate = argHw.switchPlateMap.get("switch_plate" + i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isComputeNodeListEqual(HwServerDevice thisHw, HwServerDevice argHw) {
        List<ComputeNodePlate> objNodeList = argHw.getComputeNodePlateListByApplyToOtherFlag();
        List<ComputeNodePlate> thisNodeList = thisHw.getComputeNodePlateListByApplyToOtherFlag();
        if (VerifyUtil.isEmpty(objNodeList) && VerifyUtil.isEmpty(thisNodeList)) {
            return true;
        }
        if (objNodeList.size() != thisNodeList.size()) {
            return false;
        }
        for (ComputeNodePlate argNode : objNodeList) {
            Optional<ComputeNodePlate> objNodeOptional = this.getComputeNodePlateBySlotId(thisNodeList, argNode.getSlotId());
            if (!objNodeOptional.isPresent() || argNode.equals(objNodeOptional.get())) continue;
            return false;
        }
        return true;
    }

    private Optional<ComputeNodePlate> getComputeNodePlateBySlotId(List<ComputeNodePlate> computeNodes, String slotId) {
        return computeNodes.stream().filter(obj -> obj.getSlotId().trim().equals(slotId)).findAny();
    }

    private List<ComputeNodePlate> getComputeNodePlateListByApplyToOtherFlag() {
        ArrayList<ComputeNodePlate> allComputeNodes = new ArrayList<ComputeNodePlate>();
        if (this.applyToOtherNodes) {
            for (int count = 32; count > 0 && !VerifyUtil.isEmpty(this.computeNodePlateList); --count) {
                allComputeNodes.add(this.computeNodePlateList.get(0));
            }
        } else {
            allComputeNodes.addAll(this.computeNodePlateList);
        }
        return allComputeNodes;
    }

    @Override
    public int hashCode() {
        return this.buildHwServerDevInfo().hashCode();
    }

    public String getManageIp() {
        return this.manageIp;
    }

    public void setManageIp(String manageIp) {
        this.manageIp = manageIp;
    }

    public String getStartIPAddress() {
        return this.startIPAddress;
    }

    public void setStartIPAddress(String startIPAddress) {
        this.startIPAddress = startIPAddress;
    }

    public String getEndIPAddress() {
        return this.endIPAddress;
    }

    public void setEndIPAddress(String endIPAddress) {
        this.endIPAddress = endIPAddress;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserPwd() {
        return this.userPwd;
    }

    public void setUserPwd(String userPwd) {
        this.userPwd = userPwd;
    }

    public String getRootPwd() {
        return this.rootPwd;
    }

    public void setRootPwd(String rootPwd) {
        this.rootPwd = rootPwd;
    }

    public String getCommunity() {
        return this.community;
    }

    public void setCommunity(String community) {
        this.community = community;
    }

    public int getSnmpPort() {
        return this.snmpPort;
    }

    public void setSnmpPort(int snmpPort) {
        this.snmpPort = snmpPort;
    }

    public int getSshPort() {
        return this.sshPort;
    }

    public void setSshPort(int sshPort) {
        this.sshPort = sshPort;
    }

    public int getIpmiPort() {
        return this.ipmiPort;
    }

    public void setIpmiPort(int ipmiPort) {
        this.ipmiPort = ipmiPort;
    }

    public Map<String, SwitchPlate> getSwitchPlateMap() {
        return this.switchPlateMap;
    }

    public void setSwitchPlateMap(Map<String, SwitchPlate> switchPlateMap) {
        this.switchPlateMap = switchPlateMap;
    }

    public List<ComputeNodePlate> getComputeNodePlateList() {
        return this.computeNodePlateList;
    }

    public void setComputeNodePlateList(List<ComputeNodePlate> computeNodePlateList) {
        this.computeNodePlateList = computeNodePlateList;
    }

    public int getVmmPort() {
        return this.vmmPort;
    }

    public void setVmmPort(int vmmPort) {
        this.vmmPort = vmmPort;
    }

    public String getRedFishPort() {
        return this.redFishPort;
    }

    public void setRedFishPort(String redFishPort) {
        this.redFishPort = redFishPort;
    }

    public boolean isApplyToOtherNodes() {
        return this.applyToOtherNodes;
    }

    public void setApplyToOtherNodes(boolean applyToOtherNodes) {
        this.applyToOtherNodes = applyToOtherNodes;
    }

    @Override
    public String getDeviceSn() {
        return "";
    }

    public String getSnmpPrivPwd() {
        return this.snmpPrivPwd;
    }

    public void setSnmpPrivPwd(String snmpPrivPwd) {
        this.snmpPrivPwd = snmpPrivPwd;
    }

    public void clearComputeNodes() {
        this.computeNodePlateList.clear();
    }

    public void clearSwitchPlates() {
        this.switchPlateMap.clear();
    }

    public boolean isPortProxy() {
        return this.isPortProxy;
    }

    public void setPortProxy(boolean portProxy) {
        this.isPortProxy = portProxy;
    }

    public List<String> getAllUserNames() {
        ArrayList<String> allUserNames = new ArrayList<String>();
        allUserNames.add(this.getUserName());
        for (SwitchPlate switchPlate : this.getSwitchPlateMap().values()) {
            allUserNames.add(switchPlate.getFabricUserName());
            allUserNames.add(switchPlate.getBaseUserName());
            allUserNames.add(switchPlate.getFcUserName());
            allUserNames.add(switchPlate.getBmcUserName());
        }
        for (ComputeNodePlate nodePlate : this.computeNodePlateList) {
            allUserNames.add(nodePlate.getSlotUser());
        }
        return allUserNames;
    }

    public List<String> getAllPwds() {
        ArrayList<String> allPwds = new ArrayList<String>();
        allPwds.add(this.getUserPwd());
        allPwds.add(this.getSnmpPrivPwd());
        allPwds.add(this.getRootPwd());
        for (SwitchPlate switchPlate : this.getSwitchPlateMap().values()) {
            allPwds.add(switchPlate.getFabricPwd());
            allPwds.add(switchPlate.getBasePwd());
            allPwds.add(switchPlate.getFcPwd());
            allPwds.add(switchPlate.getBmcPwd());
        }
        for (ComputeNodePlate nodePlate : this.computeNodePlateList) {
            allPwds.add(nodePlate.getSlotPasswd());
            allPwds.add(nodePlate.getSlotSnmpPrivPwd());
        }
        return allPwds;
    }

    public boolean isBatchImport() {
        return this.isBatchImport;
    }

    public void setBatchImport(boolean batchImport) {
        this.isBatchImport = batchImport;
    }

    public boolean isOnlySecurityAlgSupportedFlag() {
        return this.onlySecurityAlgSupportedFlag;
    }

    public void setOnlySecurityAlgSupportedFlag(boolean onlySecurityAlgSupportedFlag) {
        this.onlySecurityAlgSupportedFlag = onlySecurityAlgSupportedFlag;
    }

    public String getRedFishUserName() {
        return this.redFishUserName;
    }

    public void setRedFishUserName(String redFishUserName) {
        this.redFishUserName = redFishUserName;
    }

    public String getRedFishPwd() {
        return this.redFishPwd;
    }

    public void setRedFishPwd(String redFishPwd) {
        this.redFishPwd = redFishPwd;
    }

    public boolean isSupportAccountSeparation() {
        return this.isSupportAccountSeparation;
    }

    public void setSupportAccountSeparation(boolean isSupportAccountSeparation) {
        this.isSupportAccountSeparation = isSupportAccountSeparation;
    }
}

