/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.entity;

import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.devicecenter.entity.HwServerDevice;
import com.huawei.ism.tool.devicecenter.entity.SwitchDevice;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.obase.connection.ssh.SshKnownHostsManager;

public class SwitchDevice2Json {
    private String ip = "";
    private String type = "";
    private String productType = "";
    private String softwareVersion = "";
    private String username = "";
    private String password = "";
    private String rootPassword = "";
    private String sshPort = "";
    private String onlySecurityAlgorithms = "";
    private String sshHostKey = "";
    private String isVerifySshHostKey = "";
    private String redfishUserName = "";
    private String redfishPwd = "";
    private String isSupportAccountSeparation;

    public SwitchDevice2Json(SwitchDevice device) {
        HwServerDevice hwServerDev = device.getHwServerDev();
        this.ip = device.getIp();
        this.type = "switch";
        this.username = hwServerDev.getUserName();
        this.softwareVersion = device.getSoftwareVersion();
        this.productType = device.getProductName();
        this.password = AESEncrypt.encrypt((String)hwServerDev.getUserPwd());
        this.rootPassword = AESEncrypt.encrypt((String)hwServerDev.getRootPwd());
        this.sshPort = String.format("%s", hwServerDev.getSshPort());
        this.onlySecurityAlgorithms = Boolean.toString(hwServerDev.isOnlySecurityAlgSupportedFlag());
        if (ApplicationContext.getInstance().isVerifySshHostKey()) {
            this.sshHostKey = AESEncrypt.encrypt((String)SshKnownHostsManager.getHostKeyInfo(device.getIp()));
            this.isVerifySshHostKey = AESEncrypt.encrypt((String)String.format("%s", SshKnownHostsManager.isVerifySshHostKeyInfo(device.getIp())));
        }
        if (hwServerDev.isSupportAccountSeparation()) {
            this.redfishUserName = hwServerDev.getRedFishUserName();
            this.redfishPwd = AESEncrypt.encrypt((String)hwServerDev.getRedFishPwd());
        } else {
            this.redfishUserName = hwServerDev.getUserName();
            this.redfishPwd = AESEncrypt.encrypt((String)hwServerDev.getUserPwd());
        }
        this.isSupportAccountSeparation = Boolean.toString(hwServerDev.isSupportAccountSeparation());
    }

    public String toString() {
        return String.format("SwitchDevice2Json{ip='%s', type='%s', softwareVersion='%s', productType='%s', sshPort='%s'}", this.ip, this.type, this.softwareVersion, this.productType, this.sshPort);
    }

    public String getIp() {
        return this.ip;
    }

    public String getType() {
        return this.type;
    }

    public String getProductType() {
        return this.productType;
    }

    public String getSoftwareVersion() {
        return this.softwareVersion;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getRootPassword() {
        return this.rootPassword;
    }

    public String getSshPort() {
        return this.sshPort;
    }

    public String getOnlySecurityAlgorithms() {
        return this.onlySecurityAlgorithms;
    }

    public String getSshHostKey() {
        return this.sshHostKey;
    }

    public String getIsVerifySshHostKey() {
        return this.isVerifySshHostKey;
    }

    public String getRedfishUserName() {
        return this.redfishUserName;
    }

    public String getRedfishPwd() {
        return this.redfishPwd;
    }

    public String getIsSupportAccountSeparation() {
        return this.isSupportAccountSeparation;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setProductType(String productType) {
        this.productType = productType;
    }

    public void setSoftwareVersion(String softwareVersion) {
        this.softwareVersion = softwareVersion;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setRootPassword(String rootPassword) {
        this.rootPassword = rootPassword;
    }

    public void setSshPort(String sshPort) {
        this.sshPort = sshPort;
    }

    public void setOnlySecurityAlgorithms(String onlySecurityAlgorithms) {
        this.onlySecurityAlgorithms = onlySecurityAlgorithms;
    }

    public void setSshHostKey(String sshHostKey) {
        this.sshHostKey = sshHostKey;
    }

    public void setIsVerifySshHostKey(String isVerifySshHostKey) {
        this.isVerifySshHostKey = isVerifySshHostKey;
    }

    public void setRedfishUserName(String redfishUserName) {
        this.redfishUserName = redfishUserName;
    }

    public void setRedfishPwd(String redfishPwd) {
        this.redfishPwd = redfishPwd;
    }

    public void setIsSupportAccountSeparation(String isSupportAccountSeparation) {
        this.isSupportAccountSeparation = isSupportAccountSeparation;
    }
}

