/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.listener;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.devicecenter.context.DeviceCenterContext;
import com.huawei.ism.tool.devicecenter.driver.model.ITDeviceType;
import com.huawei.ism.tool.devicecenter.entity.AbstractDevice;
import com.huawei.ism.tool.devicecenter.ui.dialog.layout.ServerManagerLayout;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class SnWhiteListEnableListener
implements ActionListener {
    private static final List<ITDeviceType> snFilterDevType = Arrays.asList(ITDeviceType.IES, ITDeviceType.SERVER_OS, ITDeviceType.SERVER_IBMC);
    private ServerManagerLayout serverManagerLayout;

    @Override
    public void actionPerformed(ActionEvent e) {
        List<AbstractDevice> devs = DeviceCenterContext.getInstance().getIbmcHmmOsDevs();
        if (this.serverManagerLayout.getSnWhiteListEnableBox().isSelected()) {
            if (devs.stream().noneMatch(dev -> snFilterDevType.contains((Object)dev.getItDeviceType()))) {
                DialogUtils.showInfoDialog((Frame)DeviceCenterContext.getInstance().getParent(), (String)ResourceUtil.getString((String)"devicecenter.ismtable.header.white.checkbox.tip1"));
                this.serverManagerLayout.getSnWhiteListEnableBox().setSelected(false);
                return;
            }
            if (devs.stream().anyMatch(dev -> StringUtils.isEmpty((CharSequence)dev.getDeviceSn()))) {
                DialogUtils.showInfoDialog((Frame)DeviceCenterContext.getInstance().getParent(), (String)ResourceUtil.getString((String)"devicecenter.ismtable.header.white.checkbox.tip2"));
            }
        }
        DeviceCenterContext.setEnableWhiteList(this.serverManagerLayout.getSnWhiteListEnableBox().isSelected());
        this.serverManagerLayout.getDevWhiteListDialog().saveSn();
        this.serverManagerLayout.refreshDevice();
    }

    public SnWhiteListEnableListener(ServerManagerLayout serverManagerLayout) {
        this.serverManagerLayout = serverManagerLayout;
    }
}

