/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.thread;

import com.huawei.ism.tool.devicecenter.context.SshForwardContext;
import com.huawei.ism.tool.devicecenter.driver.model.CommonStatus;
import com.huawei.ism.tool.devicecenter.driver.model.DeviceProgress;
import com.huawei.ism.tool.devicecenter.driver.model.DriverResult;
import com.huawei.ism.tool.devicecenter.entity.AbstractDevice;
import com.huawei.ism.tool.devicecenter.entity.HwServerDevice;
import com.huawei.ism.tool.devicecenter.utils.ImportDeviceInfoUtil;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.connection.CustomDefaultSshJudge;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.SshConnection;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.connection.mina.SshUtils;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.Base64EncodeUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportBySshForwardThread
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ImportBySshForwardThread.class);
    private static final CustomDefaultSshJudge DEFAULT_SSH_JUDGE = new CustomDefaultSshJudge();
    private ExecutorService executorImport = new ThreadPoolExecutor(20, 20, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    private List<AbstractDevice> abstratDeviceList;
    private List<DevNode> importNodes;
    private String taskId;

    public ImportBySshForwardThread(List<AbstractDevice> abstratDeviceList, String taskId) {
        this.abstratDeviceList = abstratDeviceList;
        this.taskId = taskId;
        this.initConnectNode();
        this.initResult();
    }

    private void initConnectNode() {
        this.importNodes = this.abstratDeviceList.stream().filter(device -> device instanceof HwServerDevice).map(HwServerDevice.class::cast).map(this::parseToDevNode).collect(Collectors.toList());
    }

    private DevNode parseToDevNode(HwServerDevice device) {
        DevNode node = new DevNode();
        node.setLoginUser(new User(device.getUserName(), device.getUserPwd()));
        if (ImportDeviceInfoUtil.isUpgradePrepare() && !StringUtils.isNULLStr(device.getRootPwd())) {
            node.setRootUser(new User("root", Base64EncodeUtils.encode(device.getRootPwd())));
        }
        node.setIp(device.getIp());
        node.setItDeviceType(ItDeviceType.Host);
        node.setDeviceType(DeviceType.HOST);
        node.setSshForwardList(device.getSshForwardList());
        return node;
    }

    private void initResult() {
        List<DeviceProgress> deviceProgressList = this.abstratDeviceList.stream().map(AbstractDevice::getIp).map(this::initDeviceProgress).collect(Collectors.toList());
        DriverResult driverResult = new DriverResult();
        driverResult.setOverTime(TimeUnit.MINUTES.toMillis(10L));
        driverResult.setDeviceProgressList(deviceProgressList);
        SshForwardContext.getInstance().initTotalDriverResult(this.taskId, driverResult);
    }

    @Override
    public void run() {
        this.importNodes.forEach(node -> CompletableFuture.runAsync(() -> this.checkConnection((DevNode)node), this.executorImport));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkConnection(DevNode devNode) {
        try {
            ICliConnection con = SshConnectionManager.getSshConnection(devNode, DEFAULT_SSH_JUDGE);
            String fingerPrint = "";
            String hostKey = null;
            if (con instanceof SshConnection) {
                SshConnection sshConnection = (SshConnection)SshConnection.class.cast(con);
                fingerPrint = sshConnection.getFingerPrint();
                hostKey = SshUtils.getKnownHostsInfo(sshConnection.getSession(), devNode.getIp());
                SshForwardContext.getInstance().saveSshRoute(devNode.getIp(), devNode.getSshForwardList());
            }
            log.info("connect to {} success", (Object)devNode.getIp());
            SshForwardContext.getInstance().updateDriverResult(this.taskId, devNode, true, fingerPrint, hostKey);
        }
        catch (ToolException e) {
            if (this.isAddressUse(e)) {
                SshForwardContext.getInstance().updateErrorMsg(this.taskId, devNode, false, null, null);
                return;
            }
            log.error("connect error", (Throwable)e);
            SshForwardContext.getInstance().updateDriverResult(this.taskId, devNode, false, null, null);
        }
        finally {
            SshConnectionManager.releaseConnection(devNode);
        }
    }

    /*
     * Exception decompiling
     */
    private boolean isAddressUse(Throwable exception) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private DeviceProgress initDeviceProgress(String ip) {
        DeviceProgress deviceProgress = new DeviceProgress();
        deviceProgress.setIp(ip);
        deviceProgress.setStatus(CommonStatus.RUNNING);
        deviceProgress.setUpdateTime(new Date(System.currentTimeMillis()));
        return deviceProgress;
    }
}

