/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.ui.dialog;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.devicecenter.context.DeviceCenterContext;
import com.huawei.ism.tool.devicecenter.driver.model.CommonStatus;
import com.huawei.ism.tool.devicecenter.driver.model.DeviceProgress;
import com.huawei.ism.tool.devicecenter.driver.model.DeviceResult;
import com.huawei.ism.tool.devicecenter.driver.model.DriverResult;
import com.huawei.ism.tool.devicecenter.driver.model.ITDeviceType;
import com.huawei.ism.tool.devicecenter.driver.model.TotalDriverResult;
import com.huawei.ism.tool.devicecenter.entity.AbstractDevice;
import com.huawei.ism.tool.devicecenter.service.IImportListener;
import com.huawei.ism.tool.devicecenter.ui.dialog.layout.BatchImportInfoLayout;
import com.huawei.ism.tool.devicecenter.utils.LayUtil;
import com.huawei.ism.tool.devicecenter.utils.LogUtils;
import com.huawei.ism.tool.devicecenter.utils.SmartkitUtils;
import com.huawei.ism.tool.devicemanager.ui.action.support.MultiInfoDialogParams;
import com.huawei.ism.tool.devicemanager.ui.action.support.SubDialogUtils;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.SecurityConfigUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.SwingUtil;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONException;
import com.huawei.json.JSONObject;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JDialog;
import org.slf4j.Logger;
import utils.GifAssistant;

public class BatchImportInfoDialog
extends JDialog
implements IImportListener,
GifAssistant.IGifUiObserver {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(BatchImportInfoDialog.class);
    private static final long serialVersionUID = 4661940807854890761L;
    private static final String RESULT_DETAIL = "resultDetail";
    private static final IsmTableCell.HyperlinkCell HYPERL_INKCELL_COMPUTE_UPGRADE = new IsmTableCell.HyperlinkCell(ResourceUtil.getString((String)"dsfwupgrade.wizard.selectdevice.modify"), e -> FileUtils.openHelpFile("ComputeUpgrade", null, ".chm"));
    private static final IsmTableCell.HyperlinkCell HYPERL_INKCELL_UPGRADE = new IsmTableCell.HyperlinkCell(ResourceUtil.getString((String)"dsfwupgrade.wizard.selectdevice.modify"), e -> FileUtils.openHelpFile("BundleUpgrade", null, ".chm"));
    private static final String SEMICOLON = ";";
    private static final String KEY_UNSUPPORT = "devicecenter.batchimport.errMsg.onlyEnglish.unSupport";
    private static final String KEY_RESULT_ERROR = "devicecenter.device.user.error";
    private static final String KEY_RESULT_ERROR_DISTRIBUTED_UPGRADE = "devicecenter.distributed.upgrade.device.user.error";
    private static final String SNMPV3_PASSWORD_ERROR = "devicecenter.device.snmp.error";
    private static final String ALGORITHM_NOT_MATCH_MSG = "Unable to negotiate key exchange for server host key algorithms";
    private static final String ALGORITHM_NOT_MATCH = "devicecenter.device.algorithm.nonmatching";
    private static final String FIRST_LOGIN_ERROR = "devicecenter.device.firstlogin.error";
    private static final String FIRST_LOGIN_MSG = "first login";
    private static final String SNMPV3_ERROR_MSG = "snmp error";
    private static final String KEY_RESULT_UNSUPPORT = "devicecenter.device.unsupport";
    private Dimension chSize = new Dimension(600, 380);
    private Dimension enSize = new Dimension(700, 400);
    private BatchImportInfoLayout layout = null;
    private GifAssistant gifAssistant = GifAssistant.getInstance();
    private int pro = 0;
    private int ibmcNum = 0;
    private int hmmNum = 0;
    private int osNum = 0;
    private int cmcNum = 0;
    private int iesNum = 0;
    private int tceNum = 0;
    private int swiNum = 0;
    private boolean isFsStorage = false;
    private List<String> unSupportList;
    List<DeviceProgress> deviceProgressList;

    public BatchImportInfoDialog(Window parent, String title) {
        super(parent);
        this.setTitle(title);
        this.layout = new BatchImportInfoLayout();
        if (title.equalsIgnoreCase(ResourceUtil.getString((String)"smartkit.devicemanager.layout.device.refresh.dialogTitle"))) {
            this.layout.getHasDevLabel().setText("");
        }
        this.add(this.layout);
        this.setModal(true);
        this.setResizable(false);
        if (LanguageManager.getInstance().getCurrentLanguage().equals(Locale.CHINESE) || LanguageManager.getInstance().getCurrentLanguage().equals(Locale.CHINA)) {
            this.setSize(this.chSize);
        } else {
            this.setSize(this.enSize);
        }
        SwingUtil.putScreenCenter((Window)this);
        this.initListener();
        this.gifAssistant.setObserver(this);
    }

    public int getPro() {
        return this.pro;
    }

    public void setPro(int pro) {
        this.pro = pro;
    }

    private void initListener() {
        this.layout.getCancelBtn().addActionListener(e -> this.cancelAction());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                BatchImportInfoDialog.this.closeAction();
            }
        });
    }

    private void closeAction() {
        if (this.pro < 100) {
            DeviceCenterContext.getInstance().setBatchisCancel(true);
        }
        if (null != this.gifAssistant && this.gifAssistant.isStart()) {
            this.gifAssistant.stopGifLoading();
        }
        SmartkitUtils.killDriverProcess();
        this.setVisible(false);
        this.dispose();
    }

    private void cancelAction() {
        if (this.pro < 100) {
            DeviceCenterContext.getInstance().setBatchisCancel(true);
        }
        if (null != this.gifAssistant && this.gifAssistant.isStart()) {
            this.gifAssistant.stopGifLoading();
        }
        SmartkitUtils.killDriverProcess();
        this.setVisible(false);
        this.dispose();
    }

    private List<TableRow<DriverResult, String>> initRowsByIps(List<String> serverIpList) {
        ArrayList<TableRow<DriverResult, String>> rows = new ArrayList<TableRow<DriverResult, String>>();
        for (String ip : serverIpList) {
            DriverResult result = new DriverResult();
            DefaultTableRow row = new DefaultTableRow(5, (Object)result, (Object)ip);
            row.setValueAt(0, (Object)ip);
            row.setValueAt(1, (Object)new IsmTableCell.IconCell((Icon)ResourceUtil.getImage((String)"wait.png"), CommonStatus.WAITING.getTitle()));
            row.setValueAt(2, (Object)"    0%");
            row.setValueAt(3, (Object)"");
            row.setValueAt(4, (Object)ResourceUtil.getString((String)"not.involved"));
            rows.add((TableRow<DriverResult, String>)row);
        }
        return rows;
    }

    private Object showHelp() {
        try {
            String jsonSceneArgsList = System.getenv("jsonSceneArgsList");
            if (StringUtils.isNULLStr(jsonSceneArgsList)) {
                return ResourceUtil.getString((String)"not.involved");
            }
            JSONObject jsonScenes = new JSONObject(jsonSceneArgsList);
            String scene = jsonScenes.getStringOrDefault("toolDescription", "");
            if ("ComputeNodePrepare".equals(scene)) {
                return HYPERL_INKCELL_COMPUTE_UPGRADE;
            }
            if ("UpgradePrepare".equals(scene)) {
                return HYPERL_INKCELL_UPGRADE;
            }
            return ResourceUtil.getString((String)"not.involved");
        }
        catch (JSONException e) {
            LOGGER.error("Failed to obtain the help document link.", (Throwable)e);
            return ResourceUtil.getString((String)"not.involved");
        }
    }

    @Override
    public void finishedImport(TotalDriverResult totalDriverResult) {
    }

    @Override
    public void startCheckImportDevice(List<String> serverIpList) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("startCheckImportDevice devPro batchDialog hashCode is : " + this.hashCode());
        }
        List<TableRow<DriverResult, String>> rows = this.initRowsByIps(serverIpList);
        for (TableRow<DriverResult, String> row : rows) {
            this.getModel().addRow(new TableRow[]{row});
        }
    }

    private boolean hasDevInContext(List<String> ips) {
        List<AbstractDevice> contextDevs = DeviceCenterContext.getInstance().getIbmcHmmOsDevs();
        for (AbstractDevice dev : contextDevs) {
            if (!ips.contains(dev.getIp())) continue;
            return true;
        }
        return false;
    }

    private DefaultTableModel getModel() {
        return this.layout.getTableModel();
    }

    @Override
    public void refreshProcess(TotalDriverResult totalDriverResult) {
        if (null == totalDriverResult || null == totalDriverResult.getDriverResultByDeviceType(ITDeviceType.SERVER_IBMC)) {
            LOGGER.warn("Result is null, skip refreshing cycle once.");
            return;
        }
        DriverResult result = totalDriverResult.getDriverResultByDeviceType(ITDeviceType.SERVER_IBMC);
        this.deviceProgressList = result.getDeviceProgressList();
        this.pro = result.getProgress();
        if (100 == this.pro) {
            this.layout.getCancelBtn().setText(ResourceUtil.getString((String)"device.import.impaddexp.install"));
            this.gifAssistant.stopGifLoading();
        }
        this.layout.getProgressBar().setValue(this.pro);
        boolean isAllFinish = this.isAllFinish();
        if (!this.deviceProgressList.isEmpty() && this.deviceProgressList.size() > 0 && isAllFinish && 100 != this.pro) {
            this.layout.getCancelBtn().setText(ResourceUtil.getString((String)"device.import.impaddexp.install"));
            this.gifAssistant.stopGifLoading();
            this.layout.getProgressBar().setValue(100);
        }
        this.repaint();
    }

    private boolean isAllFinish() {
        boolean allFinishedFlag = true;
        block6: for (DeviceProgress deviceProgress : this.deviceProgressList) {
            int currentRowIndex = this.getModel().getRowIndex((Object)deviceProgress.getIp());
            if (-1 == currentRowIndex) continue;
            TableRow row = this.getModel().getRow(currentRowIndex);
            if (100 == deviceProgress.getPassRate() && CommonStatus.FINISHED != deviceProgress.getStatus()) {
                deviceProgress.setStatus(CommonStatus.FINISHED);
            }
            switch (deviceProgress.getStatus()) {
                case RUNNING: {
                    this.startGifSwitch();
                    row.setValueAt(2, (Object)("   " + deviceProgress.getPassRate() + " %"));
                    allFinishedFlag = false;
                    continue block6;
                }
                case WAITING: {
                    row.setValueAt(1, (Object)new IsmTableCell.IconCell((Icon)ResourceUtil.getImage((String)"wait.png"), CommonStatus.WAITING.getTitle()));
                    allFinishedFlag = false;
                    continue block6;
                }
                case FINISHED: {
                    this.refreshFinishedState(deviceProgress, (TableRow<DriverResult, String>)row);
                    continue block6;
                }
                case ERROR: {
                    row.setValueAt(1, (Object)new IsmTableCell.IconCell((Icon)ResourceUtil.getImage((String)"wait.png"), CommonStatus.ERROR.getTitle()));
                    allFinishedFlag = false;
                    continue block6;
                }
            }
            allFinishedFlag = false;
        }
        return allFinishedFlag;
    }

    private void refreshFinishedState(DeviceProgress deviceProgress, TableRow<DriverResult, String> row) {
        if (deviceProgress.getResult().equals((Object)DeviceResult.FAILED)) {
            this.setErrorMessageByLang(deviceProgress);
            row.setValueAt(1, (Object)new IsmTableCell.IconCell((Icon)ResourceUtil.getImage((String)"dev_failed.png"), DeviceResult.FAILED.getTitle()));
            row.setValueAt(2, (Object)("   " + deviceProgress.getPassRate() + " %"));
            row.setValueAt(3, (Object)deviceProgress.getErrMsg());
            if (deviceProgress.isPortUsage() || deviceProgress.isConnectError()) {
                row.setValueAt(4, this.showHelp());
            }
        } else {
            row.setValueAt(1, (Object)new IsmTableCell.IconCell((Icon)ResourceUtil.getImage((String)"success.png"), CommonStatus.FINISHED.getTitle()));
            row.setValueAt(2, (Object)("   " + deviceProgress.getPassRate() + " %"));
        }
        if (this.hasNodeResultDetail(deviceProgress)) {
            this.nodeResultHandle(deviceProgress, row);
            try {
                this.getTableModel().fireTableDataChanged();
            }
            catch (Exception e) {
                LOGGER.error("Batch import dialog table repainting failed", (Throwable)e);
            }
        }
        this.nodeSnRepeatHandle(deviceProgress, row);
    }

    private void nodeSnRepeatHandle(DeviceProgress deviceProgress, TableRow<DriverResult, String> row) {
        if (deviceProgress.isSnRepeatFlag()) {
            row.setValueAt(1, (Object)new IsmTableCell.IconCell((Icon)ResourceUtil.getImage((String)"dev_failed.png"), ResourceUtil.getString((String)"smartkit.devicecenter.sn.repeat")));
        }
    }

    private void nodeResultHandle(DeviceProgress deviceProgress, TableRow<DriverResult, String> row) {
        JSONObject resultDetail = (JSONObject)deviceProgress.getExternalResult().get(RESULT_DETAIL);
        String nodeResult = resultDetail.getString("result");
        if ("success".equals(nodeResult)) {
            row.setValueAt(1, (Object)new IsmTableCell.IconCell((Icon)ResourceUtil.getImage((String)"success.png"), CommonStatus.FINISHED.getTitle()));
            this.setDetail(row, resultDetail, deviceProgress.getIp());
        } else if ("partSuccess".equals(nodeResult)) {
            this.refreshTableForPartSuccess(row, resultDetail, deviceProgress.getIp());
        } else {
            row.setValueAt(1, (Object)new IsmTableCell.IconCell((Icon)ResourceUtil.getImage((String)"dev_failed.png"), resultDetail.getString("errMsg")));
        }
    }

    private void refreshTableForPartSuccess(TableRow<DriverResult, String> row, JSONObject resultDetail, String ip) {
        String partSuccessTip = ResourceUtil.getString((String)"smartkit.devicemanager.layout.manage.info.batchimport.dialog.part.success");
        row.setValueAt(1, (Object)new IsmTableCell.IconCell((Icon)ResourceUtil.getImage((String)"partSuccess.png"), partSuccessTip));
        this.setDetail(row, resultDetail, ip);
    }

    private void setDetail(TableRow<DriverResult, String> row, JSONObject resultDetail, String ip) {
        if (!resultDetail.has("msgType") || "simple".equals(resultDetail.getString("msgType"))) {
            this.setSimpleErrMsg(row, resultDetail, ip);
        } else if ("table".equals(resultDetail.getString("msgType"))) {
            this.refreshDetailsOfFailedSlots(row, resultDetail);
        } else {
            LOGGER.warn("Unsupported error message type:" + resultDetail.getString("msgType") + ", raw message: " + resultDetail.get("errMsg"));
        }
    }

    private void setSimpleErrMsg(TableRow<DriverResult, String> row, JSONObject resultDetail, String ip) {
        String errMsg = "";
        if (resultDetail.has("errMsgZH") && resultDetail.has("errMsgEN")) {
            errMsg = LanguageManager.getInstance().getCurrentLanguage().equals(Locale.CHINESE) || LanguageManager.getInstance().getCurrentLanguage().equals(Locale.CHINA) ? resultDetail.getString("errMsgZH") : resultDetail.getString("errMsgEN");
            LOGGER.warn("device {} discover is part successful, cause:{}", (Object)ip, (Object)errMsg);
        } else {
            LOGGER.error("Incompatible json key, require:{} or {}", (Object)"errMsgZH", (Object)"errMsgEN");
        }
        row.setValueAt(3, (Object)errMsg);
    }

    private void refreshDetailsOfFailedSlots(TableRow<DriverResult, String> row, JSONObject resultDetail) {
        JSONArray errMsgs = resultDetail.getJSONArray("errMsg");
        ArrayList<ArrayList<Object>> tableRows = new ArrayList<ArrayList<Object>>();
        this.addErrMsg(errMsgs, tableRows);
        this.refreshHyperLinkOnDetailLine(row, tableRows);
    }

    private void addErrMsg(JSONArray errMsgs, List<ArrayList<Object>> tableRows) {
        for (int i = 0; i < errMsgs.length(); ++i) {
            Object slotDetailObj = errMsgs.get(i);
            JSONObject slotDetail = new JSONObject();
            if (slotDetailObj instanceof JSONObject) {
                slotDetail = (JSONObject)slotDetailObj;
            }
            ArrayList<String> tableRow = new ArrayList<String>();
            if (slotDetail.has("objectIdZH") && slotDetail.has("objectIdEN")) {
                tableRow.add(LanguageManager.getInstance().getCurrentLanguage().equals(Locale.CHINESE) || LanguageManager.getInstance().getCurrentLanguage().equals(Locale.CHINA) ? slotDetail.getString("objectIdZH") : slotDetail.getString("objectIdEN"));
            } else {
                LOGGER.error("Incompatible json key, require:{} or {}", (Object)"objectIdZH", (Object)"objectIdEN");
            }
            if (slotDetail.has("errMsgZH") && slotDetail.has("errMsgEN")) {
                tableRow.add(LanguageManager.getInstance().getCurrentLanguage().equals(Locale.CHINESE) || LanguageManager.getInstance().getCurrentLanguage().equals(Locale.CHINA) ? slotDetail.getString("errMsgZH") : slotDetail.getString("errMsgEN"));
            } else {
                LOGGER.error("Incompatible json key, require:{} or {}", (Object)"errMsgZH", (Object)"errMsgEN");
            }
            tableRows.add(tableRow);
        }
    }

    private void refreshHyperLinkOnDetailLine(TableRow<DriverResult, String> row, List<ArrayList<Object>> tableRows) {
        IsmTableCell.HyperlinkCell viewDetails = new IsmTableCell.HyperlinkCell(ResourceUtil.getString((String)"smartkit.devicemanager.layout.manage.info.batchimport.dialog.viewdetail"), event -> {
            String[] headers = new String[]{ResourceUtil.getString((String)"partsuccess.header.slot"), ResourceUtil.getString((String)"partsuccess.header.suggestion")};
            int[] tableWidth = new int[]{15, 300};
            SubDialogUtils.showMultiInfoDialog((List)tableRows, (MultiInfoDialogParams)MultiInfoDialogParams.getNewBuilder().setParent((Window)this).setInfoMsg(ResourceUtil.getString((String)"smartkit.devicemanager.layout.manage.info.batchimport.dialog.viewdetail.desc")).setTitles(headers).setPreferredDimension(new Dimension(550, 250)).setTableLinesWidth(tableWidth).build());
        });
        row.setValueAt(3, (Object)viewDetails);
    }

    private boolean hasNodeResultDetail(DeviceProgress deviceProgress) {
        return deviceProgress.getExternalResult() instanceof JSONObject && deviceProgress.getExternalResult().has(RESULT_DETAIL);
    }

    private boolean isNodeResultPartSuccess(DeviceProgress deviceProgress) {
        JSONObject resultDetail = (JSONObject)deviceProgress.getExternalResult().get(RESULT_DETAIL);
        String nodeResult = resultDetail.getString("result");
        return "partSuccess".equals(nodeResult);
    }

    private void setErrorMessageByLang(DeviceProgress deviceProgress) {
        if (deviceProgress.isPortUsage()) {
            return;
        }
        if (CollectionUtil.isEmpty(this.unSupportList)) {
            String unSupport = ResourceUtil.getString((String)KEY_UNSUPPORT, (Locale)Locale.ENGLISH);
            this.unSupportList = Arrays.asList(unSupport.split(SEMICOLON));
        }
        if (this.unSupportList.contains(deviceProgress.getErrMsg())) {
            this.setOnlyEnglishErrorMsg(deviceProgress, KEY_RESULT_UNSUPPORT);
        } else {
            boolean onlySecurityAlgorithms = SecurityConfigUtil.isOnlySecurityAlgorithm();
            if (onlySecurityAlgorithms && deviceProgress.getErrMsg().contains(ALGORITHM_NOT_MATCH_MSG)) {
                deviceProgress.setErrMsg(ResourceUtil.getString((String)ALGORITHM_NOT_MATCH));
            } else if (deviceProgress.getErrMsg().contains(FIRST_LOGIN_MSG)) {
                String errMsg = deviceProgress.getErrMsg();
                errMsg = errMsg.substring(errMsg.indexOf(FIRST_LOGIN_MSG) + FIRST_LOGIN_MSG.length());
                deviceProgress.setErrMsg(ResourceUtil.getStringWithParams((String)FIRST_LOGIN_ERROR, (Object[])new Object[]{errMsg}));
            } else if (deviceProgress.getErrMsg().contains(SNMPV3_ERROR_MSG)) {
                deviceProgress.setErrMsg(ResourceUtil.getString((String)SNMPV3_PASSWORD_ERROR));
            } else {
                deviceProgress.setErrMsg(ResourceUtil.getString((String)KEY_RESULT_ERROR));
                if (LogUtils.isShowOperationButton()) {
                    deviceProgress.setErrMsg(ResourceUtil.getString((String)KEY_RESULT_ERROR_DISTRIBUTED_UPGRADE));
                }
                deviceProgress.setConnectError(true);
            }
        }
    }

    private void setOnlyEnglishErrorMsg(DeviceProgress deviceProgress, String key) {
        if (LanguageManager.getInstance().getCurrentLanguage().equals(Locale.CHINESE) || LanguageManager.getInstance().getCurrentLanguage().equals(Locale.CHINA)) {
            deviceProgress.setErrMsg(ResourceUtil.getString((String)key));
        }
    }

    @Override
    public void dealWithException(String mesage) {
    }

    @Override
    public void refreshTable(List<AbstractDevice> progressList) {
        int successNum = 0;
        int partSuccessNum = 0;
        int failedNum = 0;
        for (DeviceProgress devProgress : this.deviceProgressList) {
            if (devProgress.isSnRepeatFlag()) {
                ++failedNum;
                continue;
            }
            if (devProgress.getResult().equals((Object)DeviceResult.SUCCESS)) {
                if (this.hasNodeResultDetail(devProgress) && this.isNodeResultPartSuccess(devProgress)) {
                    ++partSuccessNum;
                } else {
                    ++successNum;
                }
            } else {
                ++failedNum;
            }
            if (!this.isModifyDevice()) continue;
            LogUtils.addImportLog("operalog.devicecenter.modify.device", devProgress.getIp(), devProgress.getResult().equals((Object)DeviceResult.SUCCESS), "");
        }
        this.countServerDeviceByType(progressList);
        this.refreshExecutionResult(successNum, partSuccessNum, failedNum);
        if (LayUtil.hasExistDevice(progressList) && this.shouldShowRefreshInfo()) {
            this.layout.getHasDevLabel().setText(ResourceUtil.getString((String)"devicecenter.ismtable.header.batchimport.status.hasDev"));
        }
    }

    private boolean isModifyDevice() {
        return this.getTitle().equalsIgnoreCase(ResourceUtil.getString((String)"smartkit.devicemanager.layout.modifyDev.title"));
    }

    private boolean shouldShowRefreshInfo() {
        String addDev = ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.title");
        String batchImport = ResourceUtil.getString((String)"devicecenter.batchimport.btn.batchimport");
        return addDev.equalsIgnoreCase(this.getTitle()) || batchImport.equalsIgnoreCase(this.getTitle());
    }

    private void refreshExecutionResult(int successNum, int partSuccessNum, int failedNum) {
        if (this.getTitle().equalsIgnoreCase(ResourceUtil.getString((String)"smartkit.devicemanager.layout.device.refresh.dialogTitle"))) {
            this.layout.getImportStatusLabel().setText(ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.refresh.complete"));
        } else if (this.isModifyDevice() && failedNum > 0) {
            if (this.isFsStorage()) {
                this.layout.getHasDevLabel().setText(ResourceUtil.getStringWithParams((String)"smartkit.devicemanager.layout.manage.info.modify.dev.tips", (Object[])new Object[]{successNum + "", failedNum + ""}));
            }
            if (ApplicationContext.getInstance().isEnglishEnv()) {
                this.layout.getImportStatusLabel().setText(ResourceUtil.getString((String)"smartkit.devicemanager.layout.modifyDev.result"));
                this.layout.getImportStatusLabel().setToolTipText(ResourceUtil.getString((String)"smartkit.devicemanager.layout.modifyDev.result.tips"));
            } else {
                this.layout.getImportStatusLabel().setText(ResourceUtil.getString((String)"smartkit.devicemanager.layout.modifyDev.result"));
            }
        } else {
            this.importStatusLabel(successNum, partSuccessNum, failedNum);
        }
    }

    private void countServerDeviceByType(List<AbstractDevice> progressList) {
        for (AbstractDevice dev : progressList) {
            if (ITDeviceType.SERVER_IBMC.equals((Object)dev.getItDeviceType())) {
                ++this.ibmcNum;
                continue;
            }
            if (ITDeviceType.SERVER_HMM.equals((Object)dev.getItDeviceType())) {
                ++this.hmmNum;
                continue;
            }
            if (ITDeviceType.SERVER_OS.equals((Object)dev.getItDeviceType())) {
                ++this.osNum;
                continue;
            }
            if (ITDeviceType.SERVER_CMC.equals((Object)dev.getItDeviceType())) {
                ++this.cmcNum;
                continue;
            }
            if (ITDeviceType.IES.equals((Object)dev.getItDeviceType())) {
                ++this.iesNum;
                continue;
            }
            if (ITDeviceType.TCE.equals((Object)dev.getItDeviceType())) {
                ++this.tceNum;
                continue;
            }
            if (ITDeviceType.SWITCH.equals((Object)dev.getItDeviceType())) {
                ++this.swiNum;
                continue;
            }
            LOGGER.error("has error server type.");
        }
    }

    private void importStatusLabel(int successNum, int partSuccessNum, int failedNum) {
        String sucPartFailedTip;
        String sucFailedTip;
        if (this.isModifyDevice()) {
            sucFailedTip = ResourceUtil.getStringWithParams((String)"devicecenter.ismtable.header.batchmodify.status.count", (Object[])new Object[]{String.valueOf(this.ibmcNum), String.valueOf(this.hmmNum), String.valueOf(this.osNum), this.cmcNum + "", this.iesNum + "", this.tceNum + "", this.swiNum + "", successNum + "", failedNum + ""});
            sucPartFailedTip = ResourceUtil.getStringWithParams((String)"devicecenter.ismtable.header.batchmodify.status.count.part.success", (Object[])new Object[]{String.valueOf(this.ibmcNum), String.valueOf(this.hmmNum), String.valueOf(this.osNum), this.cmcNum + "", this.iesNum + "", this.tceNum + "", this.swiNum + "", successNum + "", partSuccessNum + "", failedNum + ""});
        } else {
            sucFailedTip = ResourceUtil.getStringWithParams((String)"devicecenter.ismtable.header.batchimport.status.count", (Object[])new Object[]{String.valueOf(this.ibmcNum), String.valueOf(this.hmmNum), String.valueOf(this.osNum), this.cmcNum + "", this.iesNum + "", this.tceNum + "", this.swiNum + "", successNum + "", failedNum + ""});
            sucPartFailedTip = ResourceUtil.getStringWithParams((String)"devicecenter.ismtable.header.batchimport.status.count.part.success", (Object[])new Object[]{String.valueOf(this.ibmcNum), String.valueOf(this.hmmNum), String.valueOf(this.osNum), this.cmcNum + "", this.iesNum + "", this.tceNum + "", this.swiNum + "", successNum + "", partSuccessNum + "", failedNum + ""});
        }
        this.layout.getImportStatusLabel().setText(partSuccessNum == 0 ? sucFailedTip : sucPartFailedTip);
    }

    @Override
    public void refreshLoadingPic() {
        for (DeviceProgress deviceProgress : this.deviceProgressList) {
            int currentRowIndex = this.getModel().getRowIndex((Object)deviceProgress.getIp());
            if (-1 == currentRowIndex) continue;
            TableRow row = this.getModel().getRow(currentRowIndex);
            if (CommonStatus.RUNNING != deviceProgress.getStatus()) continue;
            row.setValueAt(1, (Object)new IsmTableCell.IconCell((Icon)this.gifAssistant.getProcessingImage(), CommonStatus.RUNNING.getTitle()));
            this.repaint();
        }
    }

    private void startGifSwitch() {
        if (!this.gifAssistant.isStart()) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("BatchImportInfoDialog this hashCode = " + this.hashCode());
            }
            this.gifAssistant.start();
        }
    }

    @Override
    public String getName() {
        return "batchImportDialog";
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    @Override
    public DefaultTableModel getTableModel() {
        return this.layout.getTableModel();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public boolean isFsStorage() {
        return this.isFsStorage;
    }

    public void setFsStorage(boolean fsStorage) {
        this.isFsStorage = fsStorage;
    }
}

