/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.ui.dialog;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.devicecenter.context.DeviceCenterContext;
import com.huawei.ism.tool.devicecenter.driver.model.ITDeviceType;
import com.huawei.ism.tool.devicecenter.entity.AbstractDevice;
import com.huawei.ism.tool.devicecenter.entity.HwServerDevice;
import com.huawei.ism.tool.devicecenter.service.DeviceControl;
import com.huawei.ism.tool.devicecenter.service.IImportListener;
import com.huawei.ism.tool.devicecenter.service.SingleDeviceAddInterface;
import com.huawei.ism.tool.devicecenter.ui.dialog.BatchImportInfoDialog;
import com.huawei.ism.tool.devicecenter.ui.dialog.layout.IbmcDeviceAddLayout;
import com.huawei.ism.tool.devicecenter.utils.LayUtil;
import com.huawei.ism.tool.devicecenter.utils.SmartkitUtils;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.JDialog;
import org.slf4j.Logger;

public class IbmcDeviceAddDialog
extends JDialog
implements SingleDeviceAddInterface {
    private static final long serialVersionUID = -8334293159432286599L;
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(IbmcDeviceAddDialog.class);
    private IbmcDeviceAddLayout layout;
    private Dimension size = new Dimension(600, 330);
    private List<IImportListener> listenerTables = DeviceCenterContext.getInstance().getDeviceTables().get("deviceTables");
    private List<AbstractDevice> hwServerDevs = new ArrayList<AbstractDevice>();
    private TaskResult exportResult = null;
    private HwServerDevice devInitHwServer;
    private Map<String, String> fsIpMap = new HashMap<String, String>();
    private boolean isFsStorage = false;

    public IbmcDeviceAddDialog(IbmcDeviceAddLayout lay) {
        this.layout = lay;
        this.add(this.layout);
        this.setTitle(ResourceUtil.getString((String)"smartkit.devicemanager.layout.modifyDev.title"));
        this.initDialog();
    }

    public IbmcDeviceAddDialog() {
        this.layout = new IbmcDeviceAddLayout();
        this.add(this.layout);
        this.initDialog();
        this.setTitle(ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.title"));
        this.layout.getSnmpPortField().setText("161");
        this.layout.getIpmiField().setText("623");
        this.layout.getSshSfipField().setText("22");
        this.layout.getVmField().setText("8208");
        this.layout.getRedfishField().setText("443");
    }

    public IbmcDeviceAddDialog(IbmcDeviceAddLayout lay, Map<String, String> fsIpMap) {
        this.layout = lay;
        this.add(this.layout);
        this.setTitle(ResourceUtil.getString((String)"smartkit.devicemanager.layout.modifyDev.title"));
        this.initDialog();
        this.fsIpMap = fsIpMap;
        this.isFsStorage = true;
    }

    private void initDialog() {
        this.setBackground(Color.WHITE);
        this.setForeground(Color.WHITE);
        this.setSize(this.size);
        this.setModal(true);
        this.setResizable(false);
        this.initListener();
    }

    private void initListener() {
        this.layout.getHighCheckLabel().addClickListener(new ToolHyperLinkLabel.ClickListener(){
            private static final long serialVersionUID = -5870151946136294514L;

            @Override
            public void clickLink(MouseEvent me) {
                if (IbmcDeviceAddDialog.this.layout.isShowHighPanelFlag()) {
                    IbmcDeviceAddDialog.this.layout.getHighInfoPanel().setVisible(true);
                    IbmcDeviceAddDialog.this.layout.getHighCheckLabel().setIcon(ResourceUtil.getImage((String)"icon-arrow-lg-top.png"));
                    IbmcDeviceAddDialog.this.layout.setShowHighPanelFlag(false);
                    IbmcDeviceAddDialog.this.setSize(new Dimension(600, 320));
                } else {
                    IbmcDeviceAddDialog.this.layout.getHighInfoPanel().setVisible(false);
                    IbmcDeviceAddDialog.this.layout.getHighCheckLabel().setIcon(ResourceUtil.getImage((String)"icon-arrow-lg-down.png"));
                    IbmcDeviceAddDialog.this.layout.setShowHighPanelFlag(true);
                    IbmcDeviceAddDialog.this.setSize(new Dimension(600, 230));
                }
            }
        });
        this.layout.getCancelBtn().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IbmcDeviceAddDialog.this.cancelAction();
            }
        });
        this.layout.getConfirmBtn().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!StringUtils.isNULLStr((String)IbmcDeviceAddDialog.this.checkFieldValue())) {
                    IbmcDeviceAddDialog.this.layout.getErrorTipLabel().setText(IbmcDeviceAddDialog.this.checkFieldValue());
                    IbmcDeviceAddDialog.this.layout.getErrorTipLabel().setForeground(Color.RED);
                    IbmcDeviceAddDialog.this.layout.repaint();
                    return;
                }
                IbmcDeviceAddDialog.this.findDevice();
            }
        });
    }

    private void cancelAction() {
        this.setVisible(false);
        this.dispose();
    }

    private String checkFieldValue() {
        String mustMessage = this.checkNullField();
        if (!StringUtils.isNULLStr((String)mustMessage)) {
            return mustMessage;
        }
        String ipMessage = LayUtil.checkIpAddress(this.layout);
        if (!StringUtils.isNULLStr((String)ipMessage)) {
            return ipMessage;
        }
        String portMessage = LayUtil.checkPort(this.layout);
        if (!StringUtils.isNULLStr((String)portMessage)) {
            return portMessage;
        }
        return "";
    }

    private String checkNullField() {
        String nullCheckTips = "";
        nullCheckTips = this.checkNullBMCIpField();
        if (!StringUtils.isNULLStr((String)nullCheckTips)) {
            return nullCheckTips;
        }
        if (this.fsIpMap.size() < 1) {
            if (StringUtils.isNULLStr((String)this.layout.getStartIpAddress().getText())) {
                nullCheckTips = ResourceUtil.getStringWithParams((String)"smartkit.devicemanager.layout.addDev.mustfill", (Object[])new Object[]{ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.startIp")});
                return nullCheckTips;
            }
            if (StringUtils.isNULLStr((String)this.layout.getEndIpField().getText())) {
                nullCheckTips = ResourceUtil.getStringWithParams((String)"smartkit.devicemanager.layout.addDev.mustfill", (Object[])new Object[]{ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.endIp")});
                return nullCheckTips;
            }
        }
        if (StringUtils.isNULLStr((String)this.layout.getUserNameField().getText())) {
            nullCheckTips = ResourceUtil.getStringWithParams((String)"smartkit.devicemanager.layout.addDev.mustfill", (Object[])new Object[]{ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.userName")});
            return nullCheckTips;
        }
        String pwd = String.valueOf(this.layout.getKeypwdField().getPassword());
        if (null == pwd || "".equals(pwd)) {
            nullCheckTips = ResourceUtil.getStringWithParams((String)"smartkit.devicemanager.layout.addDev.mustfill", (Object[])new Object[]{ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.pwd")});
            return nullCheckTips;
        }
        nullCheckTips = this.portNullCheck();
        return nullCheckTips;
    }

    private String portNullCheck() {
        String portNullCheckTips = "";
        if (StringUtils.isNULLStr((String)this.layout.getSnmpPortField().getText())) {
            portNullCheckTips = ResourceUtil.getStringWithParams((String)"smartkit.devicemanager.layout.addDev.mustfill", (Object[])new Object[]{ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.snmpPort")});
            return portNullCheckTips;
        }
        if (StringUtils.isNULLStr((String)this.layout.getIpmiField().getText())) {
            portNullCheckTips = ResourceUtil.getStringWithParams((String)"smartkit.devicemanager.layout.addDev.mustfill", (Object[])new Object[]{ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.ipmiPort")});
            return portNullCheckTips;
        }
        if (StringUtils.isNULLStr((String)this.layout.getSshSfipField().getText())) {
            portNullCheckTips = ResourceUtil.getStringWithParams((String)"smartkit.devicemanager.layout.addDev.mustfill", (Object[])new Object[]{ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.sshSfipPort")});
            return portNullCheckTips;
        }
        if (StringUtils.isNULLStr((String)this.layout.getVmField().getText())) {
            portNullCheckTips = ResourceUtil.getStringWithParams((String)"smartkit.devicemanager.layout.addDev.mustfill", (Object[])new Object[]{ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.vmPort")});
            return portNullCheckTips;
        }
        if (StringUtils.isNULLStr((String)this.layout.getRedfishField().getText())) {
            portNullCheckTips = ResourceUtil.getStringWithParams((String)"smartkit.devicemanager.layout.addDev.mustfill", (Object[])new Object[]{ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.redfishPort")});
            return portNullCheckTips;
        }
        return portNullCheckTips;
    }

    private String checkNullBMCIpField() {
        if (!this.fsIpMap.isEmpty() || !this.isFsStorage) {
            return "";
        }
        String bmcIP = this.layout.getBmcIpField().getText();
        if (!StringUtils.isNULLStr((String)bmcIP)) {
            this.layout.getStartIpAddress().setText(bmcIP);
            this.layout.getEndIpField().setText(bmcIP);
            return "";
        }
        return ResourceUtil.getStringWithParams((String)"smartkit.devicemanager.layout.addDev.mustfill", (Object[])new Object[]{ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.bmcIp")});
    }

    @Override
    public void findDevice() {
        this.setVisible(false);
        this.dispose();
        if (this.fsIpMap.size() >= 1) {
            for (Map.Entry<String, String> entry : this.fsIpMap.entrySet()) {
                HwServerDevice serverDev = this.createHwServerDevice(entry.getValue(), entry.getValue());
                serverDev.setManageIp(entry.getKey());
                this.hwServerDevs.add(serverDev);
            }
        } else {
            HwServerDevice serverDev = this.createHwServerDevice();
            serverDev.setManageIp(this.layout.getManageIpField().getText());
            if (null != this.getDevInitHwServer()) {
                this.devInitHwServer.clearComputeNodes();
                this.devInitHwServer.clearSwitchPlates();
                if (serverDev.equals(this.getDevInitHwServer())) {
                    return;
                }
            }
            this.hwServerDevs.add(serverDev);
        }
        this.handleBatchImportDialog();
        Runnable findIbmc = new Runnable(){

            @Override
            public void run() {
                DeviceControl.getInstance().setSupportSshForward(false);
                DeviceControl.getInstance().initDriverFile();
                IbmcDeviceAddDialog.this.exportResult = IbmcDeviceAddDialog.this.isFsStorage || IbmcDeviceAddDialog.this.layout.isIsfs() ? DeviceControl.getInstance().importFusionStorageDevice(IbmcDeviceAddDialog.this.hwServerDevs, IbmcDeviceAddDialog.this.listenerTables) : DeviceControl.getInstance().importDevices(IbmcDeviceAddDialog.this.hwServerDevs, IbmcDeviceAddDialog.this.listenerTables);
                DeviceControl.getInstance().refreshFile();
                if (TaskResult.Result.SUCCESS.equals((Object)IbmcDeviceAddDialog.this.exportResult.getResult())) {
                    LOGGER.info("find the device success.");
                } else {
                    LOGGER.info("find the device failed.");
                }
            }
        };
        Future<?> future = Executors.newSingleThreadExecutor().submit(findIbmc);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("the result of the task is: " + future.isDone());
        }
    }

    private void handleBatchImportDialog() {
        BatchImportInfoDialog importDialog = null;
        if (this.getTitle().equalsIgnoreCase(ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.title"))) {
            importDialog = new BatchImportInfoDialog((Window)DeviceCenterContext.getInstance().getParent(), ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.title"));
        } else if (this.getTitle().equalsIgnoreCase(ResourceUtil.getString((String)"smartkit.devicemanager.layout.modifyDev.title"))) {
            importDialog = new BatchImportInfoDialog((Window)DeviceCenterContext.getInstance().getParent(), ResourceUtil.getString((String)"smartkit.devicemanager.layout.modifyDev.title"));
        } else if (this.getTitle().equalsIgnoreCase(ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.authenticate.bmc"))) {
            importDialog = new BatchImportInfoDialog((Window)DeviceCenterContext.getInstance().getParent(), ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.authenticate.bmc"));
        }
        if (null != importDialog) {
            importDialog.setFsStorage(this.isFsStorage);
            SmartkitUtils.addBatchImportDialog(importDialog, this.listenerTables);
        }
    }

    private HwServerDevice createHwServerDevice() {
        String startIp = this.layout.getStartIpAddress().getText();
        String endIp = this.layout.getEndIpField().getText();
        if (this.isFsStorage) {
            endIp = startIp = this.layout.getBmcIpField().getText();
        }
        return this.createHwServerDevice(startIp, endIp);
    }

    private HwServerDevice createHwServerDevice(String startIp, String endIp) {
        HwServerDevice serverDev = new HwServerDevice();
        serverDev.setStartIPAddress(startIp);
        serverDev.setEndIPAddress(endIp);
        serverDev.setUserName(this.layout.getUserNameField().getText());
        String userPwd = String.valueOf(this.layout.getKeypwdField().getPassword());
        serverDev.setUserPwd(userPwd);
        serverDev.setSnmpPrivPwd(String.valueOf(this.layout.getSnmpv3PwdField().getPassword()));
        serverDev.setSnmpPort(Integer.valueOf(this.layout.getSnmpPortField().getText()));
        serverDev.setSshPort(Integer.valueOf(this.layout.getSshSfipField().getText()));
        serverDev.setIpmiPort(Integer.valueOf(this.layout.getIpmiField().getText()));
        serverDev.setVmmPort(Integer.valueOf(this.layout.getVmField().getText()));
        serverDev.setRedFishPort(this.layout.getRedfishField().getText());
        serverDev.setItDeviceType(ITDeviceType.SERVER_IBMC);
        return serverDev;
    }

    public HwServerDevice getDevInitHwServer() {
        return this.devInitHwServer;
    }

    public void setDevInitHwServer(HwServerDevice devInitHwServer) {
        this.devInitHwServer = devInitHwServer;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }
}

