/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.ui.dialog;

import com.huawei.ism.thread.ThreadPoolManager;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.devicecenter.context.DeviceCenterContext;
import com.huawei.ism.tool.devicecenter.driver.model.ITDeviceType;
import com.huawei.ism.tool.devicecenter.entity.AbstractDevice;
import com.huawei.ism.tool.devicecenter.entity.HwServerDevice;
import com.huawei.ism.tool.devicecenter.service.DeviceControl;
import com.huawei.ism.tool.devicecenter.service.IImportListener;
import com.huawei.ism.tool.devicecenter.service.SingleDeviceAddInterface;
import com.huawei.ism.tool.devicecenter.ui.dialog.BatchImportInfoDialog;
import com.huawei.ism.tool.devicecenter.ui.dialog.layout.SwitchDeviceAddLayOut;
import com.huawei.ism.tool.devicecenter.utils.LayUtil;
import com.huawei.ism.tool.devicecenter.utils.SmartkitUtils;
import com.huawei.ism.tool.devicemanager.service.SettingService;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchAddDialog
extends JDialog
implements SingleDeviceAddInterface {
    private static final Logger log = LoggerFactory.getLogger(SwitchAddDialog.class);
    private static final long serialVersionUID = -4681591031642203629L;
    private static final String TIPS = "The first two IP network segments of the start IP address are different fr...";
    private Dimension size = new Dimension(420, 270);
    private Dimension sizeModify = new Dimension(420, 250);
    private SwitchDeviceAddLayOut layout;
    private List<IImportListener> listenerTables = DeviceCenterContext.getInstance().getDeviceTables().get("deviceTables");
    private List<AbstractDevice> hwServerDevs = new ArrayList<AbstractDevice>();
    private TaskResult exportResult = null;
    private HwServerDevice devInitHwServer;
    private boolean isIesModifyFlag;
    private Map<String, String> fsIpMap = new HashMap<String, String>();
    private boolean isFusionStorage;
    private boolean isExcelImport;
    private boolean isSupportSshForward;

    public SwitchAddDialog(SwitchDeviceAddLayOut lay) {
        this.layout = lay;
        this.setTitle(ResourceUtil.getString((String)"smartkit.devicemanager.layout.modifyDev.title"));
        this.setSize(this.sizeModify);
        this.initDialog();
    }

    private void initDialog() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.layout, "Center");
        this.setModal(true);
        this.setResizable(false);
        this.initListener();
    }

    private void initListener() {
        this.cancelBtnActionListener();
        this.confirmBtnActionListener();
        this.startIpAddressMouseListener();
        this.endIpFieldMouseListener();
        this.userNameFieldMouseListener();
        this.layout.getPwdField().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                SwitchAddDialog.this.showNotRootTipJudge();
            }
        });
        this.initUserNameFieldKeyListener();
    }

    private void initUserNameFieldKeyListener() {
        this.layout.getUserNameField().addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                SwitchAddDialog.this.showNotRootTipJudge();
            }

            @Override
            public void keyPressed(KeyEvent e) {
                SwitchAddDialog.this.showNotRootTipJudge();
            }

            @Override
            public void keyReleased(KeyEvent e) {
                SwitchAddDialog.this.showNotRootTipJudge();
            }
        });
    }

    private void userNameFieldMouseListener() {
        this.layout.getUserNameField().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                SwitchAddDialog.this.showNotRootTipJudge();
            }
        });
    }

    private void endIpFieldMouseListener() {
        this.layout.getEndIpField().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                if (StringUtils.isNULLStr((String)LayUtil.checkIpAddress(SwitchAddDialog.this.layout))) {
                    SwitchAddDialog.this.clearErrorTip();
                }
            }
        });
    }

    private void startIpAddressMouseListener() {
        this.layout.getStartIpAddress().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                String startIp = SwitchAddDialog.this.layout.getStartIpAddress().getText();
                if (LayUtil.checkIpForServer(startIp) && ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.startIp.invalid").equals(SwitchAddDialog.this.layout.getErrorTipLabel().getText())) {
                    SwitchAddDialog.this.clearErrorTip();
                }
            }
        });
    }

    private void confirmBtnActionListener() {
        this.layout.getConfirmBtn().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!StringUtils.isNULLStr((String)SwitchAddDialog.this.checkFieldValue())) {
                    SwitchAddDialog.this.layout.getErrorTipLabel().setText(SwitchAddDialog.this.checkFieldValue());
                    if (SwitchAddDialog.this.layout.getErrorTipLabel().getText().length() > 103) {
                        SwitchAddDialog.this.layout.getErrorTipLabel().setText(SwitchAddDialog.TIPS);
                        SwitchAddDialog.this.layout.getErrorTipLabel().setToolTipText(SwitchAddDialog.this.checkFieldValue());
                    }
                    SwitchAddDialog.this.layout.getErrorTipLabel().setForeground(Color.RED);
                    SwitchAddDialog.this.layout.repaint();
                    return;
                }
                SwitchAddDialog.this.findDevice();
            }
        });
    }

    private void cancelBtnActionListener() {
        this.layout.getCancelBtn().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwitchAddDialog.this.cancelAction();
            }
        });
    }

    private void showNotRootTipJudge() {
        if (this.isIesModifyFlag) {
            return;
        }
    }

    private void clearErrorTip() {
        this.layout.getErrorTipLabel().setText("");
    }

    private String checkFieldValue() {
        String ipMessage;
        String mustMessage = this.checkNullField();
        if (!StringUtils.isNULLStr((String)mustMessage)) {
            return mustMessage;
        }
        if (!this.isFusionStorage && !StringUtils.isNULLStr((String)(ipMessage = LayUtil.checkIpAddress(this.layout)))) {
            return ipMessage;
        }
        return "";
    }

    private String checkNullField() {
        if (!this.isFusionStorage && StringUtils.isNULLStr((String)this.layout.getStartIpAddress().getText())) {
            return ResourceUtil.getStringWithParams((String)"smartkit.devicemanager.layout.addDev.mustfill", (Object[])new Object[]{ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.startIp")});
        }
        if (!this.isFusionStorage && StringUtils.isNULLStr((String)this.layout.getEndIpField().getText())) {
            return ResourceUtil.getStringWithParams((String)"smartkit.devicemanager.layout.addDev.mustfill", (Object[])new Object[]{ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.endIp")});
        }
        if (StringUtils.isNULLStr((String)this.layout.getUserNameField().getText())) {
            return ResourceUtil.getStringWithParams((String)"smartkit.devicemanager.layout.addDev.mustfill", (Object[])new Object[]{ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.userName")});
        }
        String pwd = String.valueOf(this.layout.getPwdField().getPassword());
        if (StringUtils.isNULLStr((String)pwd)) {
            return ResourceUtil.getStringWithParams((String)"smartkit.devicemanager.layout.addDev.mustfill", (Object[])new Object[]{ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.pwd")});
        }
        return "";
    }

    private void cancelAction() {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void findDevice() {
        this.setVisible(false);
        this.dispose();
        if (this.isFusionStorage) {
            this.setServersFromFsIpMap();
        } else if (!this.setServersFromLayout()) {
            log.info("not modify, no need to run");
            return;
        }
        this.initImportDialog();
        Callable<String> findDevThread = () -> {
            DeviceControl.getInstance().setSupportSshForward(this.isSupportSshForward);
            DeviceControl.getInstance().initDriverFile();
            this.exportResult = this.isFusionStorage || this.layout.isFusionStorage() ? DeviceControl.getInstance().importFusionStorageDevice(this.hwServerDevs, this.listenerTables) : DeviceControl.getInstance().importDevices(this.hwServerDevs, this.listenerTables);
            DeviceControl.getInstance().refreshFile();
            if (TaskResult.Result.SUCCESS.equals((Object)this.exportResult.getResult())) {
                log.info("find the device success.");
                return "find the device success.";
            }
            log.error("find the device failed.");
            return "find the device failed.";
        };
        ThreadPoolManager.getInstance().submit(findDevThread);
    }

    private void initImportDialog() {
        BatchImportInfoDialog importDialog = null;
        if (this.getTitle().equalsIgnoreCase(ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.title"))) {
            importDialog = new BatchImportInfoDialog((Window)DeviceCenterContext.getInstance().getParent(), ResourceUtil.getString((String)"smartkit.devicemanager.layout.addDev.title"));
        } else if (this.getTitle().equalsIgnoreCase(ResourceUtil.getString((String)"smartkit.devicemanager.layout.modifyDev.title"))) {
            importDialog = new BatchImportInfoDialog((Window)DeviceCenterContext.getInstance().getParent(), ResourceUtil.getString((String)"smartkit.devicemanager.layout.modifyDev.title"));
        } else if (this.getTitle().equalsIgnoreCase(ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.authenticate.os"))) {
            importDialog = new BatchImportInfoDialog((Window)DeviceCenterContext.getInstance().getParent(), ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.authenticate.os"));
        }
        if (importDialog != null) {
            importDialog.setFsStorage(this.isFusionStorage);
            SmartkitUtils.addBatchImportDialog(importDialog, this.listenerTables);
        }
    }

    private void setServersFromFsIpMap() {
        if (this.isExcelImport) {
            return;
        }
        String routeName = this.layout.getSshRouteList().getSelectedItem().toString();
        for (String managementIp : this.fsIpMap.keySet()) {
            HwServerDevice serverDev = new HwServerDevice();
            serverDev.setStartIPAddress(managementIp);
            serverDev.setEndIPAddress(managementIp);
            serverDev.setUserName(this.layout.getUserNameField().getText());
            String userPwd = String.valueOf(this.layout.getPwdField().getPassword());
            serverDev.setUserPwd(userPwd);
            serverDev.setItDeviceType(ITDeviceType.SERVER_OS);
            serverDev.setIp(managementIp);
            serverDev.setSshForwardList(SettingService.getSshForwards().getOrDefault(routeName, new ArrayList()));
            this.hwServerDevs.add(serverDev);
        }
    }

    private boolean setServersFromLayout() {
        HwServerDevice serverDev = new HwServerDevice();
        serverDev.setStartIPAddress(this.layout.getStartIpAddress().getText());
        serverDev.setEndIPAddress(this.layout.getEndIpField().getText());
        serverDev.setUserName(this.layout.getUserNameField().getText());
        String userPwd = String.valueOf(this.layout.getPwdField().getPassword());
        serverDev.setUserPwd(userPwd);
        serverDev.setItDeviceType(ITDeviceType.SWITCH);
        if (this.getDevInitHwServer() != null && serverDev.equals(this.getDevInitHwServer())) {
            return false;
        }
        this.hwServerDevs.add(serverDev);
        return true;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void setHwServerDevs(List<AbstractDevice> hwServerDevs) {
        this.hwServerDevs = hwServerDevs;
    }

    public void setDevInitHwServer(HwServerDevice devInitHwServer) {
        this.devInitHwServer = devInitHwServer;
    }

    public HwServerDevice getDevInitHwServer() {
        return this.devInitHwServer;
    }

    public void setIesModifyFlag(boolean isIesModifyFlag) {
        this.isIesModifyFlag = isIesModifyFlag;
    }

    public void setExcelImport(boolean isExcelImport) {
        this.isExcelImport = isExcelImport;
    }
}

