/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.ui.dialog.detail;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.devicecenter.context.DeviceCenterContext;
import com.huawei.ism.tool.devicecenter.driver.model.ITDeviceType;
import com.huawei.ism.tool.devicecenter.entity.AbstractDevice;
import com.huawei.ism.tool.devicecenter.entity.HMMDevice;
import com.huawei.ism.tool.devicecenter.entity.TceDevice;
import com.huawei.ism.tool.devicecenter.ui.dialog.detail.layout.DeviceDetailInfoDialogLayout;
import com.huawei.ism.tool.devicecenter.ui.dialog.detail.layout.HmmDeviceDetailInfoLayout;
import com.huawei.ism.tool.devicecenter.ui.dialog.detail.layout.IbmcDetailInfoLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;

public class DeviceDetailInfoDialog
extends JDialog {
    private static final long serialVersionUID = -3254432817878224381L;
    private static final Dimension DEVICE_DETIAL_DIALOG_SIZE_COMMON = new Dimension(860, 320);
    private DeviceDetailInfoDialogLayout detailInfoLayout;
    private transient AbstractDevice device;
    private HmmDeviceDetailInfoLayout e9000Panel;
    private boolean isTceDev = false;

    public DeviceDetailInfoDialog(AbstractDevice device) {
        super(DeviceCenterContext.getInstance().getParent());
        if (device instanceof TceDevice) {
            this.isTceDev = true;
            this.device = ((TceDevice)device).getDevice();
        } else {
            this.device = device;
        }
        this.initUI();
        this.initData();
        this.initListener();
    }

    private void initUI() {
        UiMethod.setComponentSize((Dimension)DEVICE_DETIAL_DIALOG_SIZE_COMMON, (Component[])new Component[]{this});
        this.setTitle(ResourceUtil.getString((String)"devicemanager.dc.layout.detail.dialog.title"));
        this.detailInfoLayout = new DeviceDetailInfoDialogLayout();
        this.add(this.detailInfoLayout);
        UiMethod.putScreenCenter((Window)this);
        this.setModal(true);
    }

    private void initListener() {
        this.detailInfoLayout.getCloseButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeviceDetailInfoDialog.this.closeDetailDialog();
            }
        });
    }

    private void closeDetailDialog() {
        this.dispose();
    }

    private void initData() {
        this.showDeviceDetail(this.device);
    }

    public void showDeviceDetail(AbstractDevice tepDevice) {
        if (tepDevice.getItDeviceType().equals((Object)ITDeviceType.SERVER_HMM)) {
            this.detailInfoLayout.getContentPanel().removeAll();
            if (tepDevice instanceof HMMDevice) {
                this.e9000Panel = new HmmDeviceDetailInfoLayout((HMMDevice)tepDevice, this, this.isTceDev);
                this.detailInfoLayout.addComp(this.e9000Panel);
                this.detailInfoLayout.getHmmTotalCheckBox().setSelected(((HMMDevice)tepDevice).isHmmTotalCollect());
                this.detailInfoLayout.getCloseButton().setVisible(false);
                this.detailInfoLayout.getConfirmButton().setVisible(false);
                this.detailInfoLayout.getHmmTotalCheckBox().setVisible(false);
                this.detailInfoLayout.getCloseButton().setVisible(true);
                this.detailInfoLayout.getCancelButton().setVisible(false);
            }
        } else {
            this.detailInfoLayout.getContentPanel().removeAll();
            this.detailInfoLayout.addComp(new IbmcDetailInfoLayout(tepDevice));
            this.detailInfoLayout.getHmmTotalCheckBox().setVisible(false);
            this.detailInfoLayout.getConfirmButton().setVisible(false);
            this.detailInfoLayout.getCancelButton().setVisible(false);
        }
    }
}

