/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.ui.dialog.detail;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.devicecenter.entity.ServerComputeNode;
import com.huawei.ism.tool.devicecenter.ui.dialog.action.CloseDetialDialogAction;
import com.huawei.ism.tool.devicecenter.ui.dialog.detail.layout.ServerDeviceDetailInfoPane;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.util.UCD;
import java.awt.Dimension;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class E9000ComputeNodeDetailDialog
extends JDialog {
    private static final long serialVersionUID = 2521369378246642468L;
    private static final Dimension DEVICE_DETIAL_DIALOG_SIZE_COMMON = new Dimension(720, 350);
    private static final Dimension LABEL_DIM_EN = new Dimension(80, 16);
    private static final Dimension LABEL_DIM_ZH = new Dimension(80, 16);
    private static final int MARGIN = 12;
    private transient ServerComputeNode device;

    public E9000ComputeNodeDetailDialog(ServerComputeNode device, JDialog parent) {
        super(parent);
        this.device = device;
        this.initUI();
        this.initData();
        Dimension dialogSize = this.getMaximumSize();
        if (null != dialogSize) {
            int enWidth = (int)dialogSize.getWidth() + 40;
            int enHeight = (int)dialogSize.getHeight();
            if (ApplicationContext.getInstance().isEnglishEnv()) {
                this.setSize(new Dimension(enWidth, enHeight));
            }
        }
    }

    private void initData() {
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        JPanel serverDeviceDetailPane = new JPanel();
        serverDeviceDetailPane.setLayout(new BoxLayout(serverDeviceDetailPane, 0));
        serverDeviceDetailPane.add(Box.createHorizontalStrut(12));
        serverDeviceDetailPane.add(new ServerDeviceDetailInfoPane(this.device));
        serverDeviceDetailPane.add(Box.createHorizontalStrut(12));
        contentPane.add(serverDeviceDetailPane);
        JPanel slotInfoPane = new JPanel();
        slotInfoPane.setLayout(new BoxLayout(slotInfoPane, 0));
        slotInfoPane.add(this.createItemPane(new JLabel(ResourceUtil.getString((String)"devicemanager.dc.layout.detail.key.server.e9000.compute.slotid.dot")), String.valueOf(this.device.getSlot())));
        slotInfoPane.add(Box.createHorizontalGlue());
        slotInfoPane.setBorder(UCD.createTitledBorder((String)ResourceUtil.getString((String)"devicemanager.dc.layout.detail.server.e9000.title.slot")));
        JPanel slotContainer = new JPanel();
        slotContainer.setLayout(new BoxLayout(slotContainer, 0));
        slotContainer.add(Box.createHorizontalStrut(12));
        slotContainer.add(slotInfoPane);
        slotContainer.add(Box.createHorizontalStrut(12));
        contentPane.add(slotContainer);
        contentPane.add(Box.createVerticalGlue());
        contentPane.add(new JSeparator(0));
        JButton closeBtn = UCD.createButton((String)ResourceUtil.getString((String)"devicemanager.dc.layout.detail.close"), (char)'C');
        JPanel closeBtnPanel = new JPanel();
        closeBtnPanel.setLayout(new BoxLayout(closeBtnPanel, 0));
        closeBtnPanel.add(Box.createHorizontalGlue());
        closeBtnPanel.add(closeBtn);
        closeBtnPanel.add(Box.createHorizontalStrut(12));
        closeBtn.addActionListener(new CloseDetialDialogAction(this));
        contentPane.add(Box.createVerticalStrut(6));
        contentPane.add(closeBtnPanel);
        contentPane.add(Box.createVerticalStrut(12));
        this.add(contentPane);
    }

    private void initUI() {
        UiMethod.setComponentSize(DEVICE_DETIAL_DIALOG_SIZE_COMMON, this);
        this.setTitle(ResourceUtil.getString((String)"devicemanager.dc.layout.detail.key.server.e9000.detail"));
        this.setModal(true);
        UiMethod.putScreenCenter(this);
    }

    private JPanel createItemPane(JLabel label, String value) {
        JPanel itemPane = new JPanel();
        itemPane.setLayout(new BoxLayout(itemPane, 0));
        if (Locale.ENGLISH.equals(LanguageManager.getInstance().getCurrentLanguage())) {
            UiMethod.setComponentSize(LABEL_DIM_EN, label);
        } else {
            UiMethod.setComponentSize(LABEL_DIM_ZH, label);
        }
        itemPane.add(label);
        itemPane.add(new JLabel(value));
        itemPane.add(Box.createHorizontalGlue());
        return itemPane;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
    }
}

