/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.ui.dialog.detail.layout;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.devicecenter.entity.HMMDevice;
import com.huawei.ism.tool.devicecenter.entity.ServerComputeNode;
import com.huawei.ism.tool.devicecenter.entity.ServerExchangeModule;
import com.huawei.ism.tool.devicecenter.ui.SerDeviTitleLabel;
import com.huawei.ism.tool.devicecenter.ui.dialog.action.ComputeNodeDetailActionListener;
import com.huawei.ism.tool.devicecenter.ui.dialog.detail.listener.DetailLabelListener;
import com.huawei.ism.tool.devicecenter.utils.LayUtil;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.obase.utils.ToolUCD;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.TableModel;

public class HmmDeviceDetailInfoLayout
extends JPanel {
    private static final long serialVersionUID = 8051202172852138864L;
    private static final Dimension LABEL_DIM_EN = new Dimension(95, 16);
    private static final Dimension LABEL_DIM_ZH = new Dimension(80, 16);
    private static final Color COLOR_GRAY = new Color(153, 153, 153);
    private static final Color COLOR_BLUE = new Color(73, 157, 242);
    private static final Dimension LABEL_SIZE = new Dimension(110, 35);
    private static final int MARGIN = 24;
    private transient HMMDevice device;
    private int computeNodesLength = 0;
    private int switchPlaneLength = 0;
    private JLabel hmmIPLabel;
    private JLabel hmmPorductNameLabel;
    private JLabel hmmSerialNumberLabel;
    private JLabel hmmCpldLabel;
    private JLabel hmmSoftwareLabel;
    private JLabel hmmUsernameLabel;
    private JLabel hmmSshPortLabel;
    private JLabel hmmSNMPPortLabel;
    private JLabel hmmVMMPortLabel;
    private JLabel hmmMasterHMMLabel;
    private JLabel hmmSlaveHMMLabel;
    private JLabel hmmNULLLabel;
    private DefaultTableModel computeNodeTableModel;
    private DefaultTableModel switchPlaneTableModel;
    private IsmTable switchPlaneTable;
    private IsmTable computeNodeTable;
    private TableScrollPane switchScollPane;
    private TableScrollPane computeScollPane;
    private JDialog parent;
    private CardLayout cardLayout = new CardLayout();
    private JPanel cardPanel = new JPanel();
    private List<JLabel> labelList = new ArrayList<JLabel>();
    private SerDeviTitleLabel hmmBoardLabel;
    private SerDeviTitleLabel computeNodeLabel = new SerDeviTitleLabel(ResourceUtil.getString((String)"devicecenter.server.manager.devdetail.hmm.computeNode"));
    private SerDeviTitleLabel switchPaneLabel = new SerDeviTitleLabel(ResourceUtil.getString((String)"devicecenter.server.manager.devdetail.hmm.switchPane"));
    private boolean isTceDev = false;
    private String hmmTceLabelTips;

    public HmmDeviceDetailInfoLayout(HMMDevice device, JDialog deviceDetailInfoDialog, boolean isTceDevFlag) {
        this.isTceDev = isTceDevFlag;
        this.device = device;
        this.parent = deviceDetailInfoDialog;
        this.initUI();
        this.initLayout();
        this.initData();
        this.initListener();
    }

    private void initUI() {
        this.hmmTceLabelTips = LayUtil.getHmmOrCmmTips("devicecenter.server.manager.devdetail.hmm.hmmBoard", "devicecenter.server.manager.devdetail.cmm.cmmBoard", this.isTceDev);
        this.hmmBoardLabel = new SerDeviTitleLabel(this.hmmTceLabelTips);
        this.initLabelList();
        this.initLabelSize(this.hmmBoardLabel, this.computeNodeLabel, this.switchPaneLabel);
        this.initHMMUI();
    }

    private void initData() {
        this.cardPanel.setLayout(this.cardLayout);
        JPanel hmmPane = this.initHmmPane();
        JPanel computePane = this.initComputeNodePane();
        JPanel switchPane = this.initSwitchPane();
        JComponent labelComp = UCD.buildHorizotalBox(null, (int)12, (Component[])new Component[]{this.hmmBoardLabel, this.computeNodeLabel, Box.createHorizontalGlue()});
        labelComp.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, COLOR_GRAY));
        JComponent verticalComp = UCD.buildVerticalBox(null, (int)12, (Component[])new Component[]{labelComp});
        this.cardPanel.add(this.hmmTceLabelTips, hmmPane);
        this.cardPanel.add(ResourceUtil.getString((String)"devicecenter.server.manager.devdetail.hmm.computeNode"), computePane);
        if (!this.isTceDev) {
            this.cardPanel.add(ResourceUtil.getString((String)"devicecenter.server.manager.devdetail.hmm.switchPane"), switchPane);
        }
        this.setLayout(new BorderLayout());
        this.add((Component)verticalComp, "North");
        this.add((Component)this.cardPanel, "Center");
    }

    private JPanel initSwitchPane() {
        JPanel switchPane = new JPanel();
        switchPane.setLayout(new BorderLayout());
        String[] tableHeader = this.initswitchPlaneHeader();
        this.switchPlaneTableModel = new DefaultTableModel(tableHeader, new int[0]);
        this.switchPlaneTable = new IsmTable((TableModel)this.switchPlaneTableModel);
        ToolUCD.setStandardFont(this.switchPlaneTable.getTableHeader());
        this.switchScollPane = new TableScrollPane(this.switchPlaneTable, true, true, true);
        switchPane.add((Component)this.switchScollPane, "Center");
        this.showSwitchPlaneData(this.device.getServerExchangeModules());
        return switchPane;
    }

    private void showSwitchPlaneData(List<ServerExchangeModule> deviceList) {
        ArrayList<TableRow<ServerExchangeModule, String>> tableRowList = new ArrayList<TableRow<ServerExchangeModule, String>>();
        for (ServerExchangeModule tempDevice : deviceList) {
            tableRowList.add(this.createSwitchPlaneTableRow(tempDevice, this.switchPlaneLength));
        }
        this.switchPlaneTableModel.addRow(tableRowList);
    }

    private TableRow<ServerExchangeModule, String> createSwitchPlaneTableRow(ServerExchangeModule switchNode, int length) {
        DefaultTableRow row = new DefaultTableRow(length, (Object)switchNode, (Object)(switchNode.getSn() + switchNode.getSlot()));
        int col = 0;
        row.setValueAt(col++, (Object)switchNode.getSlot());
        row.setValueAt(col++, (Object)switchNode.getProduceName());
        row.setValueAt(col++, (Object)switchNode.getSshPort());
        row.setValueAt(col++, (Object)switchNode.getMasterBMC());
        row.setValueAt(col++, (Object)switchNode.getSlaveBMC());
        this.switchPlaneTable.unmarkTableRow(new TableRow[]{row});
        return row;
    }

    private String[] initswitchPlaneHeader() {
        String[] tableHeader = new String[]{ResourceUtil.getString((String)"devicemanager.dc.layout.detail.key.server.e9000.switch.slotid"), ResourceUtil.getString((String)"devicemanager.dc.layout.detail.key.server.e9000.switch.productname"), ResourceUtil.getString((String)"devicemanager.dc.layout.detail.key.server.e9000.switch.sshport"), ResourceUtil.getString((String)"devicemanager.dc.layout.detail.key.server.e9000.switch.masterbmc"), ResourceUtil.getString((String)"devicemanager.dc.layout.detail.key.server.e9000.switch.slavebmc")};
        this.switchPlaneLength = tableHeader.length;
        return tableHeader;
    }

    private JPanel initComputeNodePane() {
        JPanel computeNodePane = new JPanel();
        computeNodePane.setLayout(new BorderLayout());
        String[] tableHeader = this.initComputeNodeHeader();
        this.computeNodeTableModel = new DefaultTableModel(tableHeader, new int[0]);
        this.computeNodeTable = new IsmTable((TableModel)this.computeNodeTableModel);
        ToolUCD.setStandardFont(this.computeNodeTable.getTableHeader());
        this.computeScollPane = new TableScrollPane(this.computeNodeTable, true, true, true);
        computeNodePane.add((Component)this.computeScollPane, "Center");
        this.showComputeNodesData(this.device.getServerComputeNodes());
        return computeNodePane;
    }

    private void showComputeNodesData(List<ServerComputeNode> deviceList) {
        ArrayList<TableRow<ServerComputeNode, String>> tableRowList = new ArrayList<TableRow<ServerComputeNode, String>>();
        for (ServerComputeNode tempDevice : deviceList) {
            tableRowList.add(this.createComputeNodesTableRow(tempDevice, this.computeNodesLength));
        }
        this.computeNodeTableModel.addRow(tableRowList);
    }

    private TableRow<ServerComputeNode, String> createComputeNodesTableRow(ServerComputeNode computeNode, int length) {
        DefaultTableRow row = new DefaultTableRow(length, (Object)computeNode, (Object)(computeNode.getDeviceSerialNumber() + computeNode.getSlot()));
        int col = 0;
        row.setValueAt(col++, (Object)computeNode.getDeviceSerialNumber());
        row.setValueAt(col++, (Object)new IsmTableCell.HyperlinkCell(computeNode.getIp(), (ActionListener)new ComputeNodeDetailActionListener(computeNode, this.parent)));
        row.setValueAt(col++, (Object)computeNode.getSlot());
        row.setValueAt(col++, (Object)computeNode.getProductName());
        this.computeNodeTable.unmarkTableRow(new TableRow[]{row});
        return row;
    }

    private String[] initComputeNodeHeader() {
        String[] tableHeader = new String[]{ResourceUtil.getString((String)"devicemanager.dc.layout.detail.key.server.e9000.compute.sn"), ResourceUtil.getString((String)"devicemanager.dc.layout.detail.key.server.e9000.compute.bmcip"), ResourceUtil.getString((String)"devicemanager.dc.layout.detail.key.server.e9000.compute.slotid"), ResourceUtil.getString((String)"devicemanager.dc.layout.detail.key.server.e9000.compute.productname")};
        this.computeNodesLength = tableHeader.length;
        return tableHeader;
    }

    private void initHMMUI() {
        String hmmIpTip = LayUtil.getHmmOrCmmTips("devicemanager.dc.layout.detail.key.server.e9000.hmm.ip", "devicemanager.dc.layout.detail.key.server.tce.cmm.ip", this.isTceDev);
        this.hmmIPLabel = new JLabel(hmmIpTip);
        this.hmmPorductNameLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.dc.layout.detail.key.server.e9000.hmm.productname"));
        this.hmmSerialNumberLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.dc.layout.detail.key.server.e9000.hmm.sn"));
        this.hmmCpldLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.dc.layout.detail.key.server.e9000.hmm.cpld"));
        this.hmmSoftwareLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.dc.layout.detail.key.server.e9000.hmm.software"));
        this.hmmUsernameLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.dc.layout.detail.key.server.e9000.hmm.username"));
        this.hmmSshPortLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.dc.layout.detail.key.server.e9000.hmm.sshport"));
        this.hmmSNMPPortLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.dc.layout.detail.key.server.e9000.hmm.snmpport"));
        this.hmmVMMPortLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.dc.layout.detail.key.server.e9000.hmm.vmmport"));
        String masterHmmCmmLabelTxt = LayUtil.getHmmOrCmmTips("devicemanager.dc.layout.detail.key.server.e9000.hmm.masterhmm", "devicemanager.dc.layout.detail.key.server.tce.cmm.masterhmm", this.isTceDev);
        String slaveHmmCmmVersion = LayUtil.getHmmOrCmmTips("devicemanager.dc.layout.detail.key.server.e9000.hmm.slavehmm", "devicemanager.dc.layout.detail.key.server.tce.cmm.slavecmm", this.isTceDev);
        this.hmmMasterHMMLabel = new JLabel(masterHmmCmmLabelTxt);
        this.hmmSlaveHMMLabel = new JLabel(slaveHmmCmmVersion);
        this.hmmNULLLabel = new JLabel(ResourceUtil.getString((String)"devicemanager.dc.layout.detail.key.server.e9000.hmm.null"));
        this.hmmBoardLabel.setBorder(BorderFactory.createMatteBorder(0, 0, 2, 0, COLOR_BLUE));
        this.hmmBoardLabel.setFont(new Font("switch_plate", 1, 16));
        this.hmmBoardLabel.setSelect(true);
        this.computeNodeLabel.setFont(new Font("switch_plate", 0, 16));
        this.switchPaneLabel.setFont(new Font("switch_plate", 0, 16));
    }

    private JPanel initHmmPane() {
        JPanel hmmPane = new JPanel();
        hmmPane.setLayout(new BoxLayout(hmmPane, 1));
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new GridLayout(5, 4, 0, 2));
        contentPane.add(this.createItemPane(this.hmmIPLabel, this.device.getIp()));
        contentPane.add(this.createItemPane(this.hmmPorductNameLabel, this.device.getProductName()));
        contentPane.add(this.createItemPane(this.hmmSerialNumberLabel, this.device.getDeviceSerialNumber()));
        contentPane.add(this.createItemPane(this.hmmCpldLabel, this.device.getDeviceCpld()));
        contentPane.add(this.createItemPane(this.hmmSoftwareLabel, this.device.getDeviceSW()));
        contentPane.add(this.createItemPane(this.hmmUsernameLabel, this.device.getAccount().getUserName()));
        contentPane.add(this.createItemPane(this.hmmSshPortLabel, String.valueOf(this.device.getSshPort())));
        contentPane.add(this.createItemPane(this.hmmSNMPPortLabel, String.valueOf(this.device.getSnmpPort())));
        contentPane.add(this.createItemPane(this.hmmVMMPortLabel, String.valueOf(this.device.getVmmPort())));
        contentPane.add(this.createItemPane(this.hmmMasterHMMLabel, String.valueOf(this.device.getMasterHMM())));
        contentPane.add(this.createItemPane(this.hmmSlaveHMMLabel, String.valueOf(this.device.getSlaveHMM())));
        contentPane.add(this.createItemPane(this.hmmNULLLabel, null));
        JComponent checkBox = UCD.buildHorizotalBox(null, (Component[])new Component[]{Box.createHorizontalStrut(12), Box.createHorizontalGlue()});
        contentPane.add(checkBox);
        hmmPane.add(contentPane);
        this.addVerticalGlue(hmmPane);
        return hmmPane;
    }

    private void addVerticalGlue(JPanel hmmPane) {
        hmmPane.add(Box.createVerticalGlue());
        hmmPane.add(Box.createVerticalGlue());
        hmmPane.add(Box.createVerticalGlue());
        hmmPane.add(Box.createVerticalGlue());
        hmmPane.add(Box.createVerticalGlue());
        hmmPane.add(Box.createVerticalGlue());
        hmmPane.add(Box.createVerticalGlue());
        hmmPane.add(Box.createVerticalGlue());
        hmmPane.add(Box.createVerticalGlue());
        hmmPane.add(Box.createVerticalGlue());
    }

    private JPanel createItemPane(JLabel label, String value) {
        JPanel itemPane = new JPanel();
        itemPane.setLayout(new BoxLayout(itemPane, 0));
        itemPane.add(Box.createHorizontalStrut(24));
        if (Locale.ENGLISH.equals(LanguageManager.getInstance().getCurrentLanguage())) {
            UiMethod.setComponentSize(LABEL_DIM_EN, label);
        } else {
            UiMethod.setComponentSize(LABEL_DIM_ZH, label);
        }
        itemPane.add(label);
        itemPane.add(new JLabel(value));
        itemPane.add(Box.createHorizontalGlue());
        return itemPane;
    }

    private void initLayout() {
        this.setLayout(new BoxLayout(this, 0));
    }

    private void initLabelSize(JLabel ... labels) {
        for (JLabel label : labels) {
            label.setPreferredSize(LABEL_SIZE);
            label.setMaximumSize(LABEL_SIZE);
            label.setMinimumSize(LABEL_SIZE);
            label.setHorizontalTextPosition(0);
            label.setHorizontalAlignment(0);
        }
    }

    private void initLabelList() {
        this.labelList.clear();
        this.labelList.add(this.hmmBoardLabel);
        this.labelList.add(this.computeNodeLabel);
        this.labelList.add(this.switchPaneLabel);
    }

    private void initListener() {
        this.hmmBoardLabel.addMouseListener(new DetailLabelListener(this.cardPanel, this.cardLayout, this.labelList, this.hmmTceLabelTips));
        this.computeNodeLabel.addMouseListener(new DetailLabelListener(this.cardPanel, this.cardLayout, this.labelList, ResourceUtil.getString((String)"devicecenter.server.manager.devdetail.hmm.computeNode")));
        this.switchPaneLabel.addMouseListener(new DetailLabelListener(this.cardPanel, this.cardLayout, this.labelList, ResourceUtil.getString((String)"devicecenter.server.manager.devdetail.hmm.switchPane")));
    }

    public IsmTable getSwitchPlaneTable() {
        return this.switchPlaneTable;
    }

    public void setSwitchPlaneTable(IsmTable switchPlaneTable) {
        this.switchPlaneTable = switchPlaneTable;
    }

    public IsmTable getComputeNodeTable() {
        return this.computeNodeTable;
    }

    public void setComputeNodeTable(IsmTable computeNodeTable) {
        this.computeNodeTable = computeNodeTable;
    }

    public HMMDevice getDevice() {
        return this.device;
    }

    public void setDevice(HMMDevice device) {
        this.device = device;
    }

    public TableScrollPane getSwitchScollPane() {
        return this.switchScollPane;
    }

    public void setSwitchScollPane(TableScrollPane switchScollPane) {
        this.switchScollPane = switchScollPane;
    }

    public TableScrollPane getComputeScollPane() {
        return this.computeScollPane;
    }

    public void setComputeScollPane(TableScrollPane computeScollPane) {
        this.computeScollPane = computeScollPane;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
    }
}

