/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.ui.dialog.layout;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.VerifyUtil;
import com.huawei.ism.tool.devicecenter.context.DeviceCenterContext;
import com.huawei.ism.tool.devicecenter.driver.model.TotalDriverResult;
import com.huawei.ism.tool.devicecenter.entity.AbstractDevice;
import com.huawei.ism.tool.devicecenter.entity.ComputeNodePlate;
import com.huawei.ism.tool.devicecenter.entity.HwServerDevice;
import com.huawei.ism.tool.devicecenter.entity.SwitchPlate;
import com.huawei.ism.tool.devicecenter.entity.TceDevice;
import com.huawei.ism.tool.devicecenter.service.IImportListener;
import com.huawei.ism.tool.devicecenter.service.UpdateBtnServiceInterface;
import com.huawei.ism.tool.devicecenter.ui.SerDeviTitleLabel;
import com.huawei.ism.tool.devicecenter.ui.dialog.layout.ComputeNodeEntity;
import com.huawei.ism.tool.devicecenter.ui.dialog.layout.HmmDeviceAddLayout;
import com.huawei.ism.tool.devicecenter.ui.dialog.layout.HmmSwitchChoosePanel;
import com.huawei.ism.tool.devicecenter.ui.dialog.layout.SwitchChooseContentLayout;
import com.huawei.ism.tool.devicecenter.utils.LayUtil;
import com.huawei.ism.tool.devicecenter.utils.LogUtils;
import com.huawei.ism.tool.devicecenter.utils.SmartkitUtils;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import org.slf4j.Logger;

public abstract class AbstractDeviceTablePanel<T>
extends JPanel
implements IImportListener,
UpdateBtnServiceInterface {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(AbstractDeviceTablePanel.class);
    private SerDeviTitleLabel titleLabel;
    List<AbstractDevice> hwXlsDevs;
    TaskResult result;
    List<IImportListener> listeners = null;
    public String[] tableHeaders;
    public IsmTable deviceTable;
    public DefaultTableModel tableModel;
    public TableScrollPane scrollPanel;

    void initTableLayout() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollPanel, "Center");
        this.setBackground(Color.WHITE);
    }

    @Override
    public void refreshTable(List<AbstractDevice> abstractDevices) {
        List<AbstractDevice> tableShouldRefreshDevices = LayUtil.getTableShouldRefreshDevices(this.tableModel, abstractDevices);
        DeviceCenterContext.getInstance().setIbmcHmmOsDevs(tableShouldRefreshDevices);
        LayUtil.getTableExistedDevices(this.tableModel);
        LayUtil.clearTable(this.tableModel);
        this.addTableRow2TableModel(tableShouldRefreshDevices);
        if (this.titleLabel != null) {
            this.titleLabel.setDevNum(this.getDeviceTable().getAllRows().size());
        }
    }

    private void addTableRow2TableModel(List<AbstractDevice> abstractDevices) {
        for (AbstractDevice device : abstractDevices) {
            TableRow<AbstractDevice, String> devRow = this.createTableRow(device);
            if (VerifyUtil.isEmpty((Object)devRow.getUserObject())) continue;
            this.tableModel.addRow(new TableRow[]{devRow});
        }
    }

    public abstract TableRow<AbstractDevice, String> createTableRow(AbstractDevice var1);

    @Override
    public void deleteServiceDev() {
        List rows = this.deviceTable.getMarkedRows();
        SmartkitUtils.deleteSceneAddDialogHasedDevices(rows, this);
        for (TableRow row : rows) {
            this.getTableModel().removeRow(new TableRow[]{row});
            if (row.getUserObject() instanceof AbstractDevice) {
                AbstractDevice dev = (AbstractDevice)row.getUserObject();
                LogUtils.addImportLog("devicemanager.server.manager.layout.remove", dev.getIp(), true, "");
            }
            DeviceCenterContext.getInstance().getIbmcHmmOsDevs().remove(row.getUserObject());
            if (!(row.getUserObject() instanceof AbstractDevice)) continue;
            LayUtil.removeDevFromAllTableDevs((AbstractDevice)row.getUserObject());
        }
        DeviceCenterContext.getInstance().notifyDeviceObserver();
        if (this.titleLabel != null) {
            this.titleLabel.setDevNum(this.getDeviceTable().getAllRows().size());
        }
        this.repaint();
    }

    public void refreshDevicesInfo() {
        List<T> hmmDevList = this.getSelectDevices();
        this.refresh(hmmDevList);
    }

    public abstract void refresh(List<T> var1);

    public abstract void modifyDeviceHandle(List<T> var1);

    public void modifyDevicesInfo() {
        List<T> tceDevices = this.getSelectDevices();
        if (tceDevices.isEmpty()) {
            return;
        }
        if (tceDevices.size() > 1) {
            DialogUtils.showInfoDialog((Frame)DeviceCenterContext.getInstance().getParent(), (String)ResourceUtil.getString((String)"smartkit.devicemanager.layout.device.modifiy.oneOnly"));
            return;
        }
        if (tceDevices.get(0) instanceof TceDevice) {
            this.modifyDeviceHandle(tceDevices);
        }
    }

    public List<T> getSelectDevices() {
        ArrayList<Object> devList = new ArrayList<Object>();
        List rows = this.getDeviceTable().getMarkedRows();
        for (TableRow row : rows) {
            devList.add(row.getUserObject());
        }
        return devList;
    }

    @Override
    public int getSelectNum() {
        return this.getDeviceTable().getSelectedRows().length;
    }

    IsmTable getDeviceTable() {
        return this.deviceTable;
    }

    public void setTitleLabel(SerDeviTitleLabel titleLabel) {
        this.titleLabel = titleLabel;
    }

    @Override
    public DefaultTableModel getTableModel() {
        return this.tableModel;
    }

    void initDeviceAddLayout(HwServerDevice hwServerDevice, HmmDeviceAddLayout lay) {
        if (!hwServerDevice.isApplyToOtherNodes()) {
            lay.getComputeNodePanel().getHmmComputeNodePanel().getComputeNodeApplyToOtherPanel().setVisible(false);
            lay.getComputeNodePanel().getHmmComputeNodePanel().getBottomCheckBoxFoldedComp().setVisible(false);
            lay.getComputeNodePanel().getHmmComputeNodePanel().getComputeNodeLayout().setVisible(true);
            lay.getComputeNodePanel().getHmmComputeNodePanel().getBottomCheckBoxUnFoldComp().setVisible(true);
            lay.getComputeNodePanel().getHmmComputeNodePanel().getUseSameAllNodeCbx().setSelected(false);
            lay.getComputeNodePanel().getHmmComputeNodePanel().getUseSameAllNodeCbox().setSelected(false);
        }
        lay.getStartIp().setText("IP:");
        lay.getSymbolLabel().setText("");
        lay.getStartIpAddress().setEnabled(false);
    }

    void initSwPlantContent(HwServerDevice hwXlsServer, HmmDeviceAddLayout lay) {
        Map<String, SwitchPlate> switchPlateMap = hwXlsServer.getSwitchPlateMap();
        for (Map.Entry<String, SwitchPlate> entry : switchPlateMap.entrySet()) {
            String key = entry.getKey().replace("switch_plate", "");
            SwitchPlate swPlate = entry.getValue();
            HmmSwitchChoosePanel swChooseContent = lay.getSwPanel();
            Class<?> swContentClazz = swChooseContent.getClass();
            String getSwContentMethodName = "getSwContent" + key;
            try {
                Method getSwContentMethod = swContentClazz.getMethod(getSwContentMethodName, new Class[0]);
                Object swPlane = getSwContentMethod.invoke((Object)swChooseContent, new Object[0]);
                SwitchChooseContentLayout swPlaneLay = null;
                if (swPlane instanceof SwitchChooseContentLayout) {
                    swPlaneLay = (SwitchChooseContentLayout)swPlane;
                    swPlaneLay.getFbsolUserNameField().setText(swPlate.getFabricUserName());
                    swPlaneLay.getBaseSolUserNameField().setText(swPlate.getBaseUserName());
                    swPlaneLay.getFcSolUserNameField().setText(swPlate.getFcUserName());
                    swPlaneLay.getBmcUserNameField().setText(swPlate.getBmcUserName());
                    continue;
                }
                LOGGER.error("invoke error.init swPlant");
            }
            catch (Exception e) {
                LOGGER.error("invoke error.init swPlant");
            }
        }
    }

    void initComputeContent(HwServerDevice hwServer, HmmDeviceAddLayout hmmDeviceAddLayout) {
        List<ComputeNodePlate> nodePlate = hwServer.getComputeNodePlateList();
        if (null == nodePlate || 0 == nodePlate.size()) {
            return;
        }
        if (hwServer.isApplyToOtherNodes()) {
            String port = nodePlate.get(0).getSlotSSHPort() + "/" + nodePlate.get(0).getSlotSNMPPort() + "/" + nodePlate.get(0).getSlotHttpsPort() + "/" + nodePlate.get(0).getSlotIPMIPort();
            hmmDeviceAddLayout.getComputeNodePanel().getHmmComputeNodePanel().getComputeNodeApplyToOtherPanel().getPort().setText(port);
            hmmDeviceAddLayout.getComputeNodePanel().getHmmComputeNodePanel().getComputeNodeApplyToOtherPanel().getUserName().setText(nodePlate.get(0).getSlotUser());
        } else {
            Map<Integer, ComputeNodeEntity> nodeMap = hmmDeviceAddLayout.getComputeNodePanel().getHmmComputeNodePanel().getComputeNodeLayout().getComputeNodeContentLayout().getNodeEntityMap();
            for (ComputeNodePlate plate : nodePlate) {
                int slot = Integer.valueOf(plate.getSlotId());
                nodeMap.get(slot).getPort().setText(plate.getSlotSSHPort() + "/" + plate.getSlotSNMPPort() + "/" + plate.getSlotHttpsPort() + "/" + plate.getSlotIPMIPort());
                nodeMap.get(slot).getUserName().setText(plate.getSlotUser());
            }
        }
    }

    @Override
    public void finishedImport(TotalDriverResult totalDriverResult) {
        LOGGER.info("finishedImport empty implements");
    }

    @Override
    public void startCheckImportDevice(List<String> serverIpList) {
        LOGGER.info("startCheckImportDevice empty implements");
    }

    @Override
    public void refreshProcess(TotalDriverResult totalDriverResult) {
        LOGGER.info("refreshProcess empty implements");
    }

    @Override
    public void dealWithException(String mesage) {
        LOGGER.info("dealWithException empty implements");
    }

    @Override
    public void updateBtn() {
        LOGGER.info("updateBtn empty implements");
    }
}

