/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.ui.dialog.layout;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.devicecenter.utils.LogUtils;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.table.TableModel;

public class BatchImportInfoLayout
extends JPanel {
    private static final long serialVersionUID = 1224682100464459151L;
    private IsmTable deviceTable;
    private JButton cancelBtn;
    private DefaultTableModel tableModel;
    private JProgressBar progressBar;
    private JLabel importStatusLabel;
    private JLabel hasDevLabel;
    private Dimension proSizeCh = new Dimension(570, 25);
    private Dimension proSizeEn = new Dimension(665, 25);
    private List<String> hmmTableHeader = new ArrayList<String>(){
        {
            this.add(ResourceUtil.getString((String)"devicecenter.ismtable.header.batchimport.object"));
            this.add(ResourceUtil.getString((String)"devicecenter.ismtable.header.batchimport.status"));
            this.add(ResourceUtil.getString((String)"devicecenter.ismtable.header.batchimport.singleProcess"));
            this.add(ResourceUtil.getString((String)"devicecenter.ismtable.header.batchimport.suggestion"));
        }
    };

    public BatchImportInfoLayout() {
        if (LogUtils.isShowOperationButton()) {
            this.hmmTableHeader.add(ResourceUtil.getString((String)"devicecenter.ismtable.header.hmm.operate"));
        }
        this.tableModel = new DefaultTableModel(this.hmmTableHeader.toArray(new String[0]), new int[0]);
        this.deviceTable = new IsmTable((TableModel)this.tableModel, false);
        this.initUI();
        this.initLayout();
    }

    public JButton getCancelBtn() {
        return this.cancelBtn;
    }

    public void setCancelBtn(JButton cancelBtn) {
        this.cancelBtn = cancelBtn;
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public void setProgressBar(JProgressBar progressBar) {
        this.progressBar = progressBar;
    }

    public DefaultTableModel getTableModel() {
        return this.tableModel;
    }

    public void setTableModel(DefaultTableModel tableModel) {
        this.tableModel = tableModel;
    }

    public JLabel getImportStatusLabel() {
        return this.importStatusLabel;
    }

    public void setImportStatusLabel(JLabel importStatusLabel) {
        this.importStatusLabel = importStatusLabel;
    }

    public JLabel getHasDevLabel() {
        return this.hasDevLabel;
    }

    public void setHasDevLabel(JLabel hasDevLabel) {
        this.hasDevLabel = hasDevLabel;
    }

    private void initUI() {
        this.cancelBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"devicecenter.ismtable.header.batchimport.btn.cancle"));
        this.importStatusLabel = new JLabel(ResourceUtil.getString((String)"devicecenter.layout.device.import.running.wait"));
        this.hasDevLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
        this.progressBar.setStringPainted(true);
        this.progressBar.setOrientation(0);
    }

    private void initLayout() {
        JComponent gap = (JComponent)Box.createVerticalStrut(12);
        TableScrollPane scrollPanel = new TableScrollPane(this.deviceTable);
        if (LanguageManager.getInstance().getCurrentLanguage().equals(Locale.CHINESE) || LanguageManager.getInstance().getCurrentLanguage().equals(Locale.CHINA)) {
            this.setComponentSize(this.progressBar, this.proSizeCh);
        } else {
            this.setComponentSize(this.progressBar, this.proSizeEn);
        }
        Box cancelComp = UCD.buildHBoxCentert((Component[])new Component[]{this.cancelBtn});
        Box vBox = UCD.buildVBoxTop((Component[])new Component[]{gap, cancelComp, gap});
        Box htipBox = UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(3), this.importStatusLabel});
        Box hDevtipBox = UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(3), this.hasDevLabel});
        htipBox.setBackground(Color.WHITE);
        this.setBackground(Color.WHITE);
        this.setLayout(new BorderLayout());
        this.add((Component)scrollPanel, "Center");
        this.add((Component)UCD.buildVBoxTop((Component[])new Component[]{gap, hDevtipBox, htipBox, this.progressBar}), "North");
        this.add(Box.createHorizontalStrut(10), "West");
        this.add(Box.createHorizontalStrut(10), "East");
        this.add((Component)vBox, "South");
    }

    private void setComponentSize(JComponent comp, Dimension size) {
        comp.setPreferredSize(size);
        comp.setMinimumSize(size);
        comp.setMaximumSize(size);
        comp.setSize(size);
    }
}

